package Toolforge::MixNMatch::Struct;

use strict;
use warnings;

our $VERSION = 0.04;

1;

__END__

=pod

=encoding utf8

=head1 NAME

Toolforge::MixNMatch::Struct - Toolforge Mix'n'match tool structures.

=head1 DESCRIPTION

This distributions is set of basic conversions from/to Toolforge Mix'n'match tool JSON structures.
(https://mix-n-match.toolforge.org/).

=head1 SEE ALSO

=over

=item L<Toolforge::MixNMatch::Struct::Catalog>

Mix'n'match catalog structure serialization.

=item L<Toolforge::MixNMatch::Struct::User>

Mix'n'match user structure serialization.

=item L<Toolforge::MixNMatch::Struct::YearMonth>

Mix'n'match year/month structure serialization.

=back

=head1 REPOSITORY

L<https://github.com/michal-josef-spacek/Toolforge-MixNMatch-Struct>

=head1 AUTHOR

Michal Josef Špaček L<mailto:skim@cpan.org>

L<http://skim.cz>

=head1 LICENSE AND COPYRIGHT

© Michal Josef Špaček 2020

BSD 2-Clause License

=head1 VERSION

0.04

=cut
