--
-- This file is part of TALER
-- Copyright (C) 2023 Taler Systems SA
--
-- TALER is free software; you can redistribute it and/or modify it under the
-- terms of the GNU General Public License as published by the Free Software
-- Foundation; either version 3, or (at your option) any later version.
--
-- TALER is distributed in the hope that it will be useful, but WITHOUT ANY
-- WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
-- A PARTICULAR PURPOSE.  See the GNU General Public License for more details.
--
-- You should have received a copy of the GNU General Public License along with
-- TALER; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
--

CREATE TABLE receipts_submitted
  (receipt_id BIGINT GENERATED BY DEFAULT AS IDENTITY UNIQUE
  ,h_tax_number BYTEA NOT NULL
  ,nonce BYTEA NOT NULL UNIQUE CHECK (LENGTH(nonce)=32)
  ,h_donation_unit_pub BYTEA NOT NULL REFERENCES donation_units (h_donation_unit_pub)
  ,donation_unit_sig BYTEA NOT NULL UNIQUE
  ,donation_year INT8 NOT NULL
  );
COMMENT ON TABLE receipts_submitted
  IS 'Table containing the donation receips submitted from the donor.';
COMMENT ON COLUMN receipts_submitted.h_tax_number
  IS 'The hash of the tax number and salt.';
COMMENT ON COLUMN receipts_submitted.nonce
  IS 'The nonce used in the Unique Donor Identifier.';
COMMENT ON COLUMN receipts_submitted.h_donation_unit_pub
  IS 'Reference to public key used to sign.';
COMMENT ON COLUMN receipts_submitted.donation_unit_sig
  IS 'The unblided signature the Donau made.';
