/* Data definitions for erfc implementation.

Copyright (c) 2022-2025 Alexei Sibidanov, Paul Zimmermann, Tom Hubrecht and
Claude-Pierre Jeannerod.

The original version of this file was copied from the CORE-MATH
project (file src/binary64/erf/erf.c, revision 384ed01d).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all
copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.
*/

#include "s_erfc_data.h"

/* the following contains polynomials generated by Sollya for
   erfc(1/x)*exp(1/x^2), over various ranges.
   Polynomials are of degree 23, with only odd coefficients, of type double
   except the degree-1 one which is a double-double.
   With p=T[i], the degree-1 coefficient is p[0] + p[1],
   the degree-3 coefficient is p[2], ...,
   the degree-23 coefficient is p[12]. In each line, the value is comment is
   the relative error bound given by Sollya. */
const double __erfc_data_T[6][13] = {
  { 0x1.20dd750429b6dp-1, 0x1.1a1feb75a48a8p-57, -0x1.20dd750429b6cp-2,
    0x1.b14c2f863e403p-2, -0x1.0ecf9db3af35dp+0, 0x1.d9eb53ca6eeedp+1,
    -0x1.0a945830d95c8p+4, 0x1.6e8a963e2f1f5p+6, -0x1.29b7ccc8f396fp+9,
    0x1.15e716e83c27ep+12, -0x1.1cfdcfbcaf22ap+15, 0x1.1986cc7a7e8fep+18,
    -0x1.71f7540590a91p+20 }, /* asympt0.sollya,
				 [0x1.2ce37fb080c7dp-5,0x1.d5p-4], 2^-74.788,
				 |p'/p| < 27.2 */
  { 0x1.20dd750429ae7p-1, 0x1.63da89e801fd4p-55, -0x1.20dd750400795p-2,
    0x1.b14c2f57c490cp-2, -0x1.0ecf95c8c9014p+0, 0x1.d9e981f2321efp+1,
    -0x1.0a81482de1506p+4, 0x1.6d662420a604bp+6, -0x1.233c96fff7772p+9,
    0x1.f5d62018d3e37p+11, -0x1.9ae55e955445p+14, 0x1.052901e10d139p+17,
    -0x1.66465df1385fp+18 }, /* asympt1.sollya,
				[0x1.d5p-4,0x1.59da6ca291ba6p-3], 2^-72.938,
				|p'/p| < 8.63 */
  { 0x1.20dd75041e3fcp-1, -0x1.c9b491c4920fcp-56, -0x1.20dd74e5f1526p-2,
    0x1.b14c1d35a40ep-2, -0x1.0ecdecd30e86bp+0, 0x1.d9b4e7f725263p+1,
    -0x1.0958b5ca8fb39p+4, 0x1.63e3179bf609cp+6, -0x1.06bbd1cd2d0fdp+9,
    0x1.7b66eb6d1d2f2p+11, -0x1.ce5a4b1afab75p+13, 0x1.8b5c6ae6f773cp+15,
    -0x1.5475860326f86p+16 }, /* asympt2.sollya,
				 [0x1.59da6ca291ba6p-3,0x1.bcp-3], 2^-72.15,
				 |p'/p| < 5.77 */
  { 0x1.20dd75025cfe9p-1, 0x1.5a92eef32fb2p-58, -0x1.20dd71eb9d4e7p-2,
    0x1.b14af4c25db28p-2, -0x1.0ebc78a22b3d8p+0, 0x1.d85287a0b3399p+1,
    -0x1.045f751e5ca1dp+4, 0x1.4a0d87ddea589p+6, -0x1.ac6a0981d1eeep+8,
    0x1.f44822f567956p+10, -0x1.cba372de71349p+12, 0x1.1a4a19f550ca4p+14,
    -0x1.52a580455ed79p+14 }, /* asympt3.sollya, [0x1.bcp-3,0x1.0cp-2],
				 2^-71.804, |p'/p| < 4.42 */
  { 0x1.20dd74eb31d84p-1, -0x1.39c4054b7c09p-59, -0x1.20dd561af98c4p-2,
    0x1.b1435165d9df1p-2, -0x1.0e6b60308e94p+0, 0x1.d3ce30c140882p+1,
    -0x1.f2083e404c299p+3, 0x1.20f113d89b42ap+6, -0x1.41433ebd89f19p+8,
    0x1.2f35b6a3154f6p+10, -0x1.b020a4313cf3bp+11, 0x1.90f07e92da7eep+12,
    -0x1.6565e1d7665c3p+12 }, /* asympt4.sollya, [0x1.0cp-2,0x1.38p-2],
				 2^-71.811, |p'/p| < 3.60 */
  { 0x1.20dd744b3517bp-1, -0x1.f77ab25e01ab4p-57, -0x1.20dcc62ec4024p-2,
    0x1.b125bfa4f66c1p-2, -0x1.0d80e6538197p+0, 0x1.ca11fbcfa65b2p+1,
    -0x1.cd9eaffb88315p+3, 0x1.e010db42e0da7p+5, -0x1.c5c85250ef6a3p+7,
    0x1.5e118d9c1eeafp+9, -0x1.8d74be13d3d3p+10, 0x1.211b1b2b5ac83p+11,
    -0x1.900be759fc663p+10 }, /* asympt5.sollya, [0x1.38p-2,0x1.63p-2],
				 2^-71.841, |p'/p| < 3.04 */
};

/* the following is a degree-19 polynomial approximating exp(x) for
   1/sqrt(2) <= x <= sqrt(2) with relative error bounded by 2^-104.311
   (see file exp_accurate.sollya).
   Coefficients of degree 0-7 are double-double and stored first,
   coefficients of degree 8-19 are double and follow. */
const double __erfc_data_E2[] = {
  0x1p+0,
  -0x1p-105, // degree 0
  0x1p+0,
  -0x1.e2p-100, // degree 1
  0x1p-1,
  0x1.3cp-95, // degree 2
  0x1.5555555555555p-3,
  0x1.55555555c78d9p-57, // degree 3
  0x1.5555555555555p-5,
  0x1.55555545616e2p-59, // degree 4
  0x1.1111111111111p-7,
  0x1.11110121fc314p-63, // degree 5
  0x1.6c16c16c16c17p-10,
  -0x1.f49e06ee3a56ep-65, // degree 6
  0x1.a01a01a01a01ap-13,
  0x1.b053e1eeab9cp-73,	 // degree 7
  0x1.a01a01a01a01ap-16, // degree 8
  0x1.71de3a556c733p-19, // degree 9
  0x1.27e4fb7789f66p-22, // degree 10
  0x1.ae64567f54abep-26, // degree 11
  0x1.1eed8eff8958bp-29, // degree 12
  0x1.6124613837216p-33, // degree 13
  0x1.93974aaf26a57p-37, // degree 14
  0x1.ae7f4fd6d0bd9p-41, // degree 15
  0x1.ae7e982620b25p-45, // degree 16
  0x1.94e4ca59460d8p-49, // degree 17
  0x1.69a2a4b7ef36dp-53, // degree 18
  0x1.abfe1602308c9p-57, // degree 19
};

/* The following are polynomial approximations for erfc(1/x)*exp(1/x^2)
   over various intervals covering [0x1.2ce37fb080c7dp-5,0x1.2b81f34bfce36p-1].
   Polynomials have only odd coefficients, with the first six coefficients
   (degree 1 to 11) being double-double, the remaining coefficients double.
*/
const double __erfc_data_Tacc[10][30]
    = {
	{ 0x1.20dd750429b6dp-1,	 0x1.1ae3a912b08fp-57,
	  -0x1.20dd750429b6dp-2, -0x1.1ae34c0606d68p-58,
	  0x1.b14c2f863e924p-2,	 -0x1.96c0f4c848fc8p-56,
	  -0x1.0ecf9db3e71b6p+0, 0x1.45d756bd288bp-57,
	  0x1.d9eb53fad4672p+1,	 -0x1.c61629de9adf2p-53,
	  -0x1.0a945f3d147eap+4, 0x1.8fec5ad7ece2p-52,
	  0x1.6e8c02f27ca6dp+6,	 -0x1.29d1c21c363ep+9,
	  0x1.17349b70be627p+12, -0x1.28a6bb4686182p+15,
	  0x1.602d1662523cap+18, -0x1.ccae7625c4111p+21,
	  0x1.4237d064f6e0dp+25, -0x1.b1e5466ca3a2fp+28,
	  0x1.90ae06a0f6cc1p+31 }, /* asympt_acc0.sollya:
				      [0x1.2ce37fb080c7dp-5,0x1.45p-4], degree
				      29, relerr <= 2^-107.71 */
	{ 0x1.20dd750429b6dp-1,	 0x1.1adaa62435c1p-57,
	  -0x1.20dd750429b6dp-2, -0x1.41516126827c8p-59,
	  0x1.b14c2f863e90bp-2,	 0x1.a535780ba5ed4p-56,
	  -0x1.0ecf9db3e65d6p+0, -0x1.089edde27ad07p-54,
	  0x1.d9eb53fa52f2p+1,	 -0x1.bc9737e9464acp-53,
	  -0x1.0a945f2cd7621p+4, -0x1.589f28b700332p-51,
	  0x1.6e8bffd7e194ep+6,	 -0x1.29d18716876e2p+9,
	  0x1.17312abe1825p+12,	 -0x1.287e73592805cp+15,
	  0x1.5ebf7394a39c1p+18, -0x1.c2f14d46d0cf9p+21,
	  0x1.2af3d256f955ep+25, -0x1.7041659ebd7aap+28,
	  0x1.6039c232e2f71p+31, -0x1.70ca15c5a07cbp+33 }, /* asympt_acc1.sollya:
							      [0x1.45p-4,0x1.e0p-4],
							      degree 31, relerr
							      <= 2^-106.203 */
	{ 0x1.20dd750429b6dp-1,	 0x1.d3c35b5d3741p-58,
	  -0x1.20dd750429b56p-2, -0x1.c028415f6f81bp-56,
	  0x1.b14c2f863c1cfp-2,	 0x1.1bb0de6470dbcp-58,
	  -0x1.0ecf9db33c363p+0, 0x1.0f8068459eb16p-55,
	  0x1.d9eb53b9ce57bp+1,	 0x1.20cce33e7d84ap-53,
	  -0x1.0a945aa2ec4fap+4, -0x1.f6e0fcd7c603p-50,
	  0x1.6e8b824d2bfaap+6,	 -0x1.29cc372a6d0bp+9,
	  0x1.1703a99ddd429p+12, -0x1.2749f9a267cc6p+15,
	  0x1.5856a17271849p+18, -0x1.a8bcb4ba9753fp+21,
	  0x1.035dcce88294p+25,	 -0x1.1e5d8c5e6e043p+28,
	  0x1.fe3b4f365386ep+30, -0x1.398fdef2b98fep+33,
	  0x1.84234d4f4ea12p+34 }, /* asympt_acc2.sollya:
				      [0x1.e0p-4,0x1.3fp-3], degree 33, relerr
				      <= 2^-105.859 */
	{ 0x1.20dd750429b6ap-1,	 0x1.ae622b765e9fdp-55,
	  -0x1.20dd750428f0ep-2, 0x1.03c6c67d69513p-56,
	  0x1.b14c2f8563e8ep-2,	 0x1.766a6bd7aa89cp-57,
	  -0x1.0ecf9d8dedd48p+0, 0x1.0af52e90336e3p-54,
	  0x1.d9eb4aad086fep+1,	 0x1.640d371d54a19p-53,
	  -0x1.0a93f1d01cfep+4,	 -0x1.68dbd8d9c522cp-51,
	  0x1.6e842e9fd5898p+6,	 -0x1.299886ef1fb8p+9,
	  0x1.15e0f0162c9ap+12,	 -0x1.222dbc6b04cd8p+15,
	  0x1.460268db1ebdfp+18, -0x1.74f53ce065fb3p+21,
	  0x1.961ca8553f87p+24,	 -0x1.8788395d13798p+27,
	  0x1.35e37b25d0e81p+30, -0x1.707b7457c8f5ep+32,
	  0x1.1ff852df1c023p+34, -0x1.b75d0ec56e2cdp+34 }, /* asympt_acc3.sollya:
							      [0x1.3fp-3,0x1.95p-3],
							      degree 35, relerr
							      <= 2^-105.557 */
	{ 0x1.20dd750429a8fp-1,	 -0x1.66d8dda59bceap-56,
	  -0x1.20dd7503fdbabp-2, 0x1.707bdffc2b3fep-57,
	  0x1.b14c2f6526025p-2,	 -0x1.7fa4bb954114p-61,
	  -0x1.0ecf99c417d45p+0, -0x1.748645ef7af94p-54,
	  0x1.d9eaa9c712a7dp+1,	 0x1.79e478994ebb4p-53,
	  -0x1.0a8ef11fbf141p+4, 0x1.b5c72d69f8954p-52,
	  0x1.6e4653e0455b1p+6,	 -0x1.286909448e6cfp+9,
	  0x1.113424ce76821p+12, -0x1.1346d859e76dep+15,
	  0x1.1f9f6cf2293bfp+18, -0x1.258e6e3b337dbp+21,
	  0x1.14029ecd465fbp+24, -0x1.c530df5337a6fp+26,
	  0x1.34bc4bbccd336p+29, -0x1.4a37c52641688p+31,
	  0x1.019707cec2974p+33, -0x1.031fe736ea169p+34,
	  0x1.f6b3003de3ddfp+33 }, /* asympt_acc4.sollya:
				      [0x1.95p-3,0x1.f5p-3], degree 37, relerr
				      <= 2^-105.539 */
	{ 0x1.20dd75042756bp-1,	 0x1.4ad9178b5691p-55,
	  -0x1.20dd74feda9e8p-2, -0x1.8141c70bbc8d6p-56,
	  0x1.b14c2cb128467p-2,	 -0x1.09aebaa106821p-56,
	  -0x1.0ecf603921a0bp+0, 0x1.7d3cb5bceaf0bp-54,
	  0x1.d9e3e1751ca59p+1,	 0x1.6622ae564267p-56,
	  -0x1.0a686af57f547p+4, 0x1.083b320aff6b6p-51,
	  0x1.6cf0b6c027326p+6,	 -0x1.23afcb69443d3p+9,
	  0x1.03ab450d9f1b9p+12, -0x1.e74cdb76bcab4p+14,
	  0x1.c671b60e607f1p+17, -0x1.8f1376d324ce4p+20,
	  0x1.3b64276234676p+23, -0x1.aff0ce13c5a8ep+25,
	  0x1.ef20247251e87p+27, -0x1.c9f5662f721f6p+29,
	  0x1.4687858e185e1p+31, -0x1.4fa507be073c2p+32,
	  0x1.b99ac35ee4accp+32, -0x1.16cb585ee3fa9p+32 }, /* asympt_acc5.sollya:
							      [0x1.f5p-3,0x1.31p-2],
							      degree 39, relerr
							      <= 2^-105.722 */
	{ 0x1.20dd7503e730dp-1,	 0x1.4e524a098a467p-55,
	  -0x1.20dd7498fa6b2p-2, 0x1.60a4e27751c8p-61,
	  0x1.b14c061bd2a0cp-2,	 0x1.95a8f847d2fc2p-57,
	  -0x1.0ecd0f11b8c7dp+0, -0x1.4126deea76061p-54,
	  0x1.d9b1344463548p+1,	 0x1.fe09a4eca9b0ep-53,
	  -0x1.0996ea52a87edp+4, -0x1.924f920db26cp-53,
	  0x1.67a2264b556bp+6,	 -0x1.15dfc2c86b6b5p+9,
	  0x1.ccc291b62efe4p+11, -0x1.81375a78e746ap+14,
	  0x1.33a6f15546329p+17, -0x1.c1e9dc121601p+19,
	  0x1.2397ea3d43fdap+22, -0x1.4661e5b2ea512p+24,
	  0x1.3412367ca5d45p+26, -0x1.de56b9d7f37c4p+27,
	  0x1.2851d9722146dp+29, -0x1.19027baf0c3fep+30,
	  0x1.7e7b8b6ab58acp+30, -0x1.4c446d56aaf22p+30,
	  0x1.1492190400505p+29 }, /* asympt_acc6.sollya:
				      [0x1.31p-2,0x1.71p-2], degree 41, relerr
				      <= 2^-105.433 */
	{ 0x1.20dd74ff10852p-1,	 0x1.a32f26deff875p-55,
	  -0x1.20dd6f06c491cp-2, 0x1.70c16e1793358p-56,
	  0x1.b14a7d5e7fd4ap-2,	 0x1.479998b54db5bp-56,
	  -0x1.0ebbdb3889c5fp+0, -0x1.59b853e11369cp-56,
	  0x1.d89dd249d7ef8p+1,	 -0x1.4b5edf0c8c314p-55,
	  -0x1.06526fb386114p+4, -0x1.40d04eed7c7ep-55,
	  0x1.57ff657e429cep+6,	 -0x1.ef63e90d3863p+8,
	  0x1.6d4f34c4ea3dap+11, -0x1.04542b9e36a54p+14,
	  0x1.577bf19097738p+16, -0x1.9702fe47c736dp+18,
	  0x1.a7ae12b54fdc6p+20, -0x1.7ca3f0f7c4fa9p+22,
	  0x1.225d983963cbfp+24, -0x1.71a6eac612f9ep+25,
	  0x1.8086324225e1ep+26, -0x1.3de68670a7716p+27,
	  0x1.91674de4dcbe9p+27, -0x1.6b44cc15b76c2p+27,
	  0x1.a36dae0f30d8p+26,	 -0x1.cffc1747ea3dcp+24 }, /* asympt_acc7.sollya:
							      [0x1.71p-2,0x1.bcp-2],
							      degree 43, relerr
							      <= 2^-105.629 */
	{ 0x1.20dd74ba8f3p-1,	 -0x1.9dd256871d21p-58,
	  -0x1.20dd3593675bcp-2, 0x1.ec0e7ffa91ad9p-56,
	  0x1.b13eef86a077ap-2,	 -0x1.4fb5d78d411b8p-56,
	  -0x1.0e5cf52a11f3ap+0, -0x1.51f36c779dc8cp-55,
	  0x1.d4417a08b39d5p+1,	 0x1.1be9fb5956638p-54,
	  -0x1.f91b9f6ce80c3p+3, -0x1.c9c99dd42829cp-51,
	  0x1.356439f45bb43p+6,	 -0x1.8c0ca12819b48p+8,
	  0x1.efcad2ecd6671p+10, -0x1.21b0af6fc1039p+13,
	  0x1.327d215ee30c9p+15, -0x1.1fabda96167bp+17,
	  0x1.d82e4373b315dp+18, -0x1.4ed9e2ff591e9p+20,
	  0x1.95c85dcd8eab5p+21, -0x1.9f016f0a3d62ap+22,
	  0x1.60e89d918b96fp+23, -0x1.e97be202cba64p+23,
	  0x1.0d8a081619793p+24, -0x1.c5422b4fcfc65p+23,
	  0x1.1131a9dc6aed1p+23, -0x1.a457d9dced257p+21,
	  0x1.3605e980e8b86p+19 }, /* asympt_acc8.sollya:
				      [0x1.bcp-2,0x1.0bp-1], degree 45, relerr
				      <= 2^-105.064 */
	{ 0x1.20dd7319d4d25p-1,	 0x1.2b02992c3b7abp-55,
	  -0x1.20dc29c13ab1bp-2, -0x1.d78d79b4ad767p-56,
	  0x1.b115a57b5ab13p-2,	 -0x1.aa8c45be0aa2ep-57,
	  -0x1.0d58ec437efd7p+0, -0x1.994f00a15e85p-58,
	  0x1.cb1742e229f23p+1,	 -0x1.8000471d54399p-53,
	  -0x1.d99a5edf7b946p+3, -0x1.af76ed7e35cdep-52,
	  0x1.0a8b71058eb28p+6,	 -0x1.2d88289da5bfcp+8,
	  0x1.43ddf24168edbp+10, -0x1.3e9dfc38b6d1ap+12,
	  0x1.18d4df97ab3dfp+14, -0x1.b550fc62dcab5p+15,
	  0x1.29cb71f116ed1p+17, -0x1.5fc9cc4e854e3p+18,
	  0x1.65915fd0567b1p+19, -0x1.35eb5fca0e46dp+20,
	  0x1.c5261ecc0d789p+20, -0x1.138932dc4eafcp+21,
	  0x1.117d4eb18facdp+21, -0x1.af96163e35ecap+20,
	  0x1.0454a3a63c766p+20, -0x1.c2ebc1d39b44ap+18,
	  0x1.f3327698e0e6bp+16, -0x1.094febc3dff35p+14 }, /* asympt_acc9.sollya:
							      [0x1.0bp-1,0x1.2b81f34bfce36p-1],
							      degree 47, relerr
							      <= 2^-117.075 */
      };

const double __erfc_data_exceptions[22][3] = {
  { 0x1.4a42b163f7a7dp+3, 0x1.183d60a1f7e3cp-158, -0x1.fffffffffffffp-212 },
  { 0x1.a631d4bc7f56bp+3, 0x1.3f07281bb43aep-256, -0x1p-309 },
  { 0x1.1b2588f5d972ep+4, 0x1.2923609150ffp-457, -0x1.ffffffffffffdp-511 },
  { 0x1.1d41cb671cad3p+4, 0x1.5c4d8d179be8cp-464, -0x1.fffffffffffffp-518 },
  { 0x1.48de452fb1a15p+4, 0x1.3c2a1264045adp-615, 0x1.fffffffffffffp-669 },
  { 0x1.bb1ef58eda44p+0, 0x1.d6d259cb81801p-7, 0x1.387cbdb500a5ep-114 },
  { 0x1.0ca37ce17afa6p+1, 0x1.88cc1284157f5p-9, 0x1.6fd53d489a2c1p-120 },
  { 0x1.1cb6b0f91a4ccp+1, 0x1.b2639c7a46899p-10, 0x1.f8111f4b0ab0fp-114 },
  { 0x1.d1e19af184c6ep+0, 0x1.49bf1937979edp-7, 0x1.c1b55587c1381p-112 },
  { 0x1.37994c710a4d2p+1, 0x1.2df150139d8eap-11, 0x1.d46afcc14563p-114 },
  { 0x1.8966f65d9a1a1p+1, 0x1.d01a8497b522dp-17, 0x1.c935c97d5bfe4p-121 },
  { 0x1.9f4a466c51bb5p+2, 0x1.a3d059f3770b9p-65, 0x1.3f16dde099b74p-167 },
  { 0x1.164f857d1749cp+3, 0x1.e35102e39e989p-114, 0x1.32b4c82bbb9e3p-219 },
  { 0x1.76957728f1f31p+1, 0x1.251dea1afe1adp-15, -0x1.155995aa5bae6p-119 },
  { 0x1.651c78cec84f6p+2, 0x1.af9d1df8b5e8p-49, -0x1.fe39e86292256p-153 },
  { 0x1.77d0f07e113dcp+3, 0x1.8b93f18b3cdc6p-204, 0x1.6ffd370fba52ap-307 },
  { 0x1.ef72633933d36p+2, 0x1.aee3861d8657ep-91, -0x1.00ca47f3ced2ap-194 },
  { 0x1.391f434b53d18p+4, 0x1.44e8c50fa25e9p-558, -0x1.15aa7b49bc597p-662 },
  { 0x1.b8940788b825dp+0, 0x1.e97eaf1080bffp-7, 0x1.38836346525eap-107 },
  { 0x1.16ffd71e2d8c6p+2, 0x1.834e2899c5506p-31, -0x1.b7516e4549528p-135 },
  { 0x1.7fa5439251a75p+1, 0x1.7923ec231992dp-16, -0x1.74f633ea13fecp-121 },
  { 0x1.a8fb2b7ef1f8p+2, 0x1.c1b9f4cda246bp-68, 0x1.6fce2e1cae1a5p-171 },
};

const double __erfc_data_exceptions_accurate[17][3] = {
  { -0x1.c5bf891b4ef6bp-54, 0x1.0000000000001p+0, -0x1.fffffffffffffp-54 },
  { -0x1.fe777a3eb8d58p-51, 0x1.0000000000005p+0, -0x1.fffffffffffffp-54 },
  { -0x1.d3ed8564296e6p-49, 0x1.0000000000011p+0, -0x1.fffffffffffffp-54 },
  { -0x1.29c5b1f9ebd1ep-49, 0x1.000000000000bp+0, -0x1.fffffffffffffp-54 },
  { -0x1.e9327fd17121fp-48, 0x1.0000000000023p+0, -0x1.fffffffffffffp-54 },
  { -0x1.941e961c5253bp-48, 0x1.000000000001dp+0, -0x1.fffffffffffffp-54 },
  { -0x1.3f0aac6733857p-48, 0x1.0000000000017p+0, -0x1.fffffffffffffp-54 },
  { -0x1.dc87cb831c792p-37, 0x1.0000000010cdbp+0, -0x1.fffffffffffffp-54 },
  { -0x1.b71f3a10691d9p-37, 0x1.000000000f7bfp+0, -0x1.fffffffffffffp-54 },
  { -0x1.cea935ba73f4cp-32, 0x1.000000020a0e9p+0, 0x1.fffffffffffffp-54 },
  { -0x1.abaf3b436049ep-25, 0x1.000000f14b8e3p+0, 0x1.fffffffffffffp-54 },
  { -0x1.d4c18d3599cbep-19, 0x1.0000421de806fp+0, -0x1.fffffffffffffp-54 },
  { -0x1.607b67e03b83bp-15, 0x1.00031b7780fe5p+0, -0x1.fffffffffffffp-54 },
  { -0x1.4a943c917ed26p-12, 0x1.0017504bc67c1p+0, 0x1.fffffffffffffp-54 },
  { -0x1.106c2cd5ea6c3p-9, 0x1.0099b29fab8cfp+0, 0x1.fffffffffffffp-54 },
  { -0x1.d4af8adb90116p-4, 0x1.20e8e5d1e73ffp+0, 0x1.ffffffffffffep-54 },
  { -0x1.f9a4a209ca0e4p+0, 0x1.feaa166e384c9p+0, 0x1.ffffffffffffep-54 },
};

const double __erfc_data_exceptions_accurate_2[29][3] = {
  { 0x1.c5bf891b4ef6bp-55, 0x1.fffffffffffffp-1, 0x1.ffffffffffffep-55 },
  { 0x1.fe777a3eb8d58p-52, 0x1.ffffffffffffbp-1, 0x1.ffffffffffffep-55 },
  { 0x1.29c5b1f9ebd1ep-50, 0x1.ffffffffffff5p-1, 0x1.ffffffffffffep-55 },
  { 0x1.d3ed8564296e6p-50, 0x1.fffffffffffefp-1, 0x1.ffffffffffffep-55 },
  { 0x1.3f0aac6733857p-49, 0x1.fffffffffffe9p-1, 0x1.fffffffffffffp-55 },
  { 0x1.941e961c5253bp-49, 0x1.fffffffffffe3p-1, 0x1.fffffffffffffp-55 },
  { 0x1.e9327fd17121fp-49, 0x1.fffffffffffddp-1, 0x1.fffffffffffffp-55 },
  { 0x1.b71f3a10691d9p-38, 0x1.fffffffff0841p-1, -0x1.ffffffffffffep-55 },
  { 0x1.dc87cb831c792p-38, 0x1.ffffffffef325p-1, 0x1.fffffffffffffp-55 },
  { 0x1.52b18fe8fbad1p-36, 0x1.ffffffffd03a7p-1, -0x1.ffffffffffffep-55 },
  { 0x1.cf0ed5959b276p-28, 0x1.ffffffbeafd79p-1, -0x1.fffffffffffffp-55 },
  { 0x1.6af79a30bbf3cp-27, 0x1.ffffff999bdd3p-1, 0x1.fffffffffffffp-55 },
  { 0x1.dd48360dd7824p-26, 0x1.fffffef2b8f0dp-1, 0x1.fffffffffffffp-55 },
  { 0x1.40757fba82477p-24, 0x1.fffffd2ccd30dp-1, -0x1.fffffffffffffp-55 },
  { 0x1.8bc46e0d85524p-9, 0x1.fe416cffa803dp-1, -0x1.fffffffffffffp-55 },
  { 0x1.d4af8adb90116p-4, 0x1.be2e345c31801p-1, 0x1.ea7fa18173ab8p-106 },
  { 0x1.3229110bf9d66p-2, 0x1.5847806aef94bp-1, 0x1.fffffffffffffp-55 },
  { 0x1.a93059aabe4bcp-1, 0x1.ebfa1229d0dcep-3, 0x1.99b4b80fd9415p-107 },
  { 0x1.bc466342a2296p-1, 0x1.c2153a8529156p-3, -0x1.088fb70829f71p-107 },
  { 0x1.eef77c6caae18p-1, 0x1.5f61e96f60783p-3, -0x1.ffffffffffffdp-57 },
  { 0x1.fd5d9d8c9ef66p-1, 0x1.468ba052c2fep-3, -0x1.03fa708a553b3p-105 },
  { 0x1.23c67ff8b8a0ap+0, 0x1.b640be5efa2e3p-4, -0x1.b9a66b42d916p-107 },
  { 0x1.3a013a3c71e92p+0, 0x1.5329743c2c15cp-4, 0x1.7766eb5263404p-109 },
  { 0x1.589bbd3ae5489p+0, 0x1.d2847b1409248p-5, 0x1.57b4a906bc605p-107 },
  { 0x1.757fe152a87c9p+0, 0x1.402acce35d833p-5, 0x1.d38ccfa0c1d6bp-108 },
  { 0x1.7749479e598d3p+0, 0x1.3891521afe3e3p-5, 0x1.8b8423c82ad72p-108 },
  { 0x1.9a3a5f5f28f3p+0, 0x1.80040c25bab9p-6, -0x1.a8686704bdb14p-108 },
  { 0x1.a44869b34ea46p+0, 0x1.4bb609c105c2dp-6, -0x1.9182dae766fc4p-109 },
  { 0x1.af08ae30c9364p+0, 0x1.1ac47852096cbp-6, -0x1.fffffffffffdap-60 },
};
