<center>
<img src="logo/final-logo-complete.svg" alt="artanis logo"/>
</center>

GNU Artanis aims to be a web application framework for Scheme. The philosophy of
Artanis is to be very radical, and to try cutting-edge things. So use it at
your own risk...however, playing with it may result in some cool experiences!

https://artanis.dev

## Features:

* GPLv3+ & LGPLv3+
* Very lightweight - easy to hack and learn for newbies.
* Support JSON/CSV/XML/SXML.
* A complete web-server implementation, including an error page handler.
* High concurrent async non-blocking server core based on delimited
continuations.
* Has a Sinatra-like style route, hence the name "Artanis" ;-)
* Supported databases (through guile-dbi): MySQL/SQLite/PostgreSQL.
* Nice and easy web cache control.
* Efficient HTML template parsing.
* Efficient static file downloading/uploading.

## Prerequisite

- GNU Guile-3.0+
- guile-json
- guile-csv
- NSS (Network Security Services)
- guile-redis
- guile-dbi

## Install

* Compile and install
See the manual below

* Get docker image
[Install GNU Artanis with Docker](https://nalaginrut.com/archives/2019/09/18/install%20gnu%20artanis%20with%20docker)

## Manual:
http://gnu.org/software/artanis/manual

## Research paper:
* ICFP Schemeworkshop 2016
[Multi-purpose web-framework design based on websockets over HTTP Gateway](https://gitlab.com/NalaGinrut/artanis/raw/gh-pages/research/scheme16/art2016.pdf)

## How to contribute:

* Contributing to the website:

The source to the website is here:
https://gitlab.com/NalaGinrut/artanis-org-site

* Contributing to the manual:

Please **do not** modify the manual.texi and manual.html files directly, as they
are generated by org-mode. The file to be edited is 'docs/manual.org':

* Contributing to the Artanis framework:

Thank you very much for contributing!

Bug reports are appreciated contributions. Please don't hesitate to report bugs
in a manner that allows them to be reproduced.

Please read the manual carefully, and ask questions to know more about GNU
Artanis. The preferred way to discuss internals of Artanis is to send mail to
[artanis@gnu.org](https://lists.gnu.org/mailman/listinfo/artanis) because it's
good for archive. And you could discuss the bugs in issues for better tracking
than mails.

GNU Artanis is aiming for production quality, since it's going to be used in a
real product. So we need high quality contributions.  Small and/or obvious fixes
are likely to be easily applied. Larger contributions should be discussed first during the planning phase as they will require strict review.

Artwork and document are also important contributions and greatly appreciated bythe GNU Artanis community. Advocating on GNU Artanis on your blogs, wikis, and
webcast tutorials are good ways to help grow the GNU Artanis community.

If you're using GNU Artanis in your project, please share your experiences. GNU
Artanis wants to be a friendly community to help people learn about free
software and increase use of functional programming in industry.

* Blog

https://artanis.dev/blog.html
