﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/clouddirectory/model/AddFacetToObjectRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CloudDirectory::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String AddFacetToObjectRequest::SerializePayload() const {
  JsonValue payload;

  if (m_schemaFacetHasBeenSet) {
    payload.WithObject("SchemaFacet", m_schemaFacet.Jsonize());
  }

  if (m_objectAttributeListHasBeenSet) {
    Aws::Utils::Array<JsonValue> objectAttributeListJsonList(m_objectAttributeList.size());
    for (unsigned objectAttributeListIndex = 0; objectAttributeListIndex < objectAttributeListJsonList.GetLength();
         ++objectAttributeListIndex) {
      objectAttributeListJsonList[objectAttributeListIndex].AsObject(m_objectAttributeList[objectAttributeListIndex].Jsonize());
    }
    payload.WithArray("ObjectAttributeList", std::move(objectAttributeListJsonList));
  }

  if (m_objectReferenceHasBeenSet) {
    payload.WithObject("ObjectReference", m_objectReference.Jsonize());
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection AddFacetToObjectRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  Aws::StringStream ss;
  if (m_directoryArnHasBeenSet) {
    ss << m_directoryArn;
    headers.emplace("x-amz-data-partition", ss.str());
    ss.str("");
  }

  return headers;
}
