/*
 * Decompiled with CFR 0.152.
 */
package org.apache.groovy.parser.antlr4;

import org.apache.groovy.parser.antlr4.AstBuilder;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.EmptyStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;

public class TryWithResourcesASTTransformation {
    private AstBuilder astBuilder;
    private int resourceCount;
    private int throwableCount;
    private int primaryExCount;
    private int suppressedExCount;

    public TryWithResourcesASTTransformation(AstBuilder astBuilder) {
        this.astBuilder = astBuilder;
    }

    private String nextResourceName() {
        return "__$$resource" + this.resourceCount++;
    }

    private String nextThrowableName() {
        return "__$$t" + this.throwableCount++;
    }

    private String nextPrimaryExName() {
        return "__$$primaryExc" + this.primaryExCount++;
    }

    private String nextSuppressedExName() {
        return "__$$suppressedExc" + this.suppressedExCount++;
    }

    public Statement transform(TryCatchStatement tryCatchStatement) {
        if (!DefaultGroovyMethods.asBoolean(tryCatchStatement.getResourceStatements())) {
            return tryCatchStatement;
        }
        if (this.isBasicTryWithResourcesStatement(tryCatchStatement)) {
            return this.transformBasicTryWithResourcesStatement(tryCatchStatement);
        }
        return this.transformExtendedTryWithResourcesStatement(tryCatchStatement);
    }

    private boolean isBasicTryWithResourcesStatement(TryCatchStatement tryCatchStatement) {
        return !DefaultGroovyMethods.asBoolean(tryCatchStatement.getCatchStatements()) && tryCatchStatement.getFinallyStatement() instanceof EmptyStatement;
    }

    private Statement makeVariableDeclarationFinal(ExpressionStatement variableDeclaration) {
        if (!DefaultGroovyMethods.asBoolean(variableDeclaration)) {
            return variableDeclaration;
        }
        if (!(variableDeclaration.getExpression() instanceof DeclarationExpression)) {
            throw new IllegalArgumentException("variableDeclaration is not a declaration statement");
        }
        Expression targetExpression = ((DeclarationExpression)variableDeclaration.getExpression()).getLeftExpression();
        if (!(targetExpression instanceof VariableExpression)) {
            throw this.astBuilder.createParsingFailedException("The expression statement is not a variable delcaration statement", variableDeclaration);
        }
        VariableExpression variableExpression = (VariableExpression)targetExpression;
        variableExpression.setModifiers(variableExpression.getModifiers() | 0x10);
        return variableDeclaration;
    }

    private Statement transformExtendedTryWithResourcesStatement(TryCatchStatement tryCatchFinally) {
        TryCatchStatement newTryWithResources = GeneralUtils.tryCatchS(tryCatchFinally.getTryStatement());
        tryCatchFinally.getResourceStatements().forEach(newTryWithResources::addResource);
        TryCatchStatement newTryCatchFinally = GeneralUtils.tryCatchS(GeneralUtils.block(this.transform(newTryWithResources)), tryCatchFinally.getFinallyStatement());
        tryCatchFinally.getCatchStatements().forEach(newTryCatchFinally::addCatch);
        return newTryCatchFinally;
    }

    private Statement transformBasicTryWithResourcesStatement(TryCatchStatement tryWithResources) {
        BlockStatement blockStatement = new BlockStatement();
        ExpressionStatement firstResourceDeclaration = tryWithResources.getResourceStatement(0);
        blockStatement.addStatement(this.makeVariableDeclarationFinal(firstResourceDeclaration));
        String primaryExceptionName = this.nextPrimaryExName();
        blockStatement.addStatement(GeneralUtils.declS(GeneralUtils.localVarX(primaryExceptionName, ClassHelper.THROWABLE_TYPE.getPlainNodeReference()), GeneralUtils.nullX()));
        String firstResourceIdentifier = ((DeclarationExpression)firstResourceDeclaration.getExpression()).getLeftExpression().getText();
        TryCatchStatement newTryCatchFinally = GeneralUtils.tryCatchS(tryWithResources.getTryStatement(), this.createFinallyBlockForNewTryCatchStatement(primaryExceptionName, firstResourceIdentifier));
        tryWithResources.getResourceStatements().stream().skip(1L).forEach(newTryCatchFinally::addResource);
        newTryCatchFinally.addCatch(this.createCatchBlockForOuterNewTryCatchStatement(primaryExceptionName));
        blockStatement.addStatement(this.transform(newTryCatchFinally));
        return blockStatement;
    }

    private CatchStatement createCatchBlockForOuterNewTryCatchStatement(String primaryExceptionName) {
        String throwableName = this.nextThrowableName();
        Parameter catchParameter = new Parameter(ClassHelper.THROWABLE_TYPE.getPlainNodeReference(), throwableName);
        return GeneralUtils.catchS(catchParameter, GeneralUtils.block(GeneralUtils.assignS(GeneralUtils.varX(primaryExceptionName), GeneralUtils.varX(throwableName)), GeneralUtils.throwS(GeneralUtils.varX(throwableName))));
    }

    private Statement createFinallyBlockForNewTryCatchStatement(String primaryExceptionName, String firstResourceIdentifierName) {
        String suppressedExceptionName = this.nextSuppressedExName();
        TryCatchStatement newTryCatch = GeneralUtils.tryCatchS(GeneralUtils.block(TryWithResourcesASTTransformation.createCloseResourceStatement(firstResourceIdentifierName)));
        newTryCatch.addCatch(GeneralUtils.catchS(new Parameter(ClassHelper.THROWABLE_TYPE.getPlainNodeReference(), suppressedExceptionName), GeneralUtils.block(TryWithResourcesASTTransformation.createAddSuppressedStatement(primaryExceptionName, suppressedExceptionName))));
        return GeneralUtils.block(GeneralUtils.ifElseS(GeneralUtils.notNullX(GeneralUtils.varX(primaryExceptionName)), newTryCatch, TryWithResourcesASTTransformation.createCloseResourceStatement(firstResourceIdentifierName)));
    }

    private static Statement createCloseResourceStatement(String resourceIdentifierName) {
        MethodCallExpression closeMethodCallExpression = GeneralUtils.callX(GeneralUtils.varX(resourceIdentifierName), "close");
        closeMethodCallExpression.setImplicitThis(false);
        closeMethodCallExpression.setSafe(true);
        return GeneralUtils.stmt(closeMethodCallExpression);
    }

    private static Statement createAddSuppressedStatement(String primaryException, String suppressedException) {
        MethodCallExpression addSuppressedMethodCallExpression = GeneralUtils.callX((Expression)GeneralUtils.varX(primaryException), "addSuppressed", (Expression)GeneralUtils.varX(suppressedException));
        addSuppressedMethodCallExpression.setImplicitThis(false);
        addSuppressedMethodCallExpression.setSafe(true);
        return GeneralUtils.stmt(addSuppressedMethodCallExpression);
    }

    public BinaryExpression transformResourceAccess(Expression variableExpression) {
        return GeneralUtils.binX(GeneralUtils.varX(this.nextResourceName()), GeneralUtils.ASSIGN, variableExpression);
    }
}

