.SS "OPENVSWITCH TUNNELING COMMANDS"
These commands query and modify OVS tunnel components.
.
.IP "\fBovs/route/add\fR \fIip\fR/\fIplen\fR \fIoutput_bridge\fR \
[\fIgw\fR] [\fBpkt_mark\fR=\fImark\fR] [\fBsrc\fR=\fIsrc_ip\fR] \
[\fBtable\fR=\fIid\fR]"
Adds \fIip\fR/\fIplen\fR route to vswitchd routing table. \fIoutput_bridge\fR
needs to be OVS bridge name.  This command is useful if OVS cached
routes does not look right. A non-standard table ID can be specified, in which
case the route is added to that routing table. The table is created if it
doesn't exist.
.
.IP "\fBovs/route/show\fR [\fBtable\fR=\fBall\fR|\fIid\fR]"
Print routes in OVS routing table. This includes routes cached from
system routing table and user configured routes. By default, the
contents of all the default tables (local, main, default) is displayed,
unless requested otherwise with \fItable\fR parameter. In this case the
contents of a specific table ID or of all routing tables is printed.
.
.IP "\fBovs/route/del\fR \fIip\fR/\fIplen\fR [\fBpkt_mark\fR=\fImark\fR] \
[\fBtable\fR=\fIid\fR]"
Delete ip/plen route from OVS routing table. The standard routing table is used
by default, or a specific custom table when ID is provided via \fItable\fR
parameter.
.
.IP "\fBovs/route/lookup\fR \fIip_addr\fR [\fBpkt_mark\fR=\fImark\fR] \
[\fBsrc\fR=\fIsrc_ip\fR]"
Perform route lookup for specified destination IP address in OVS routing tables
and print the matching route information. The lookup may be more selective when
additional parameters are used: \fIpkt_mark\fR and \fIsrc\fR.
.
.IP "\fBovs/route/rule/show\fR [\fB-6\fR]"
Print routing rules in OVS. This includes routing rules cached from the system
routing policy database and user configured routing rules. By default only IPv4
rules are displayed. For displaying IPv6 rules \fB-6\fR option is required.
.
.IP "\fBovs/route/rule/add\fR [\fB-6\fR] [\fBnot\fR] \
\fBfrom\fR=\fBall\fR|\fIip/plen\fR [\fBprio\fR=\fInum\fR] \
\fBtable\fR=\fBlocal\fR|\fBmain\fR|\fBdefault\fR|\fIid\fR"
Add user-configured routing rule to vswitchd. It can be useful to reference
non-standard routing tables for configuring advanced routing policies, for
example matching on the source IP address. If priority is not specified, the
lowest unused priority will be selected automatically. Multiple rules with the
same priority may exist. User-configured rules and system cached rules co-exist
together.
.
.IP "\fBovs/route/rule/del\fR [\fB-6\fR] [\fBnot\fR] \
\fBfrom\fR=\fBall\fR|\fIip/plen\fR [\fBprio\fR=\fInum\fR] \
\fBtable\fR=\fBlocal\fR|\fBmain\fR|\fBdefault\fR|\fIid\fR"
Delete user-configured routing rule from vswitchd. If priority is not specified
the first matching rule will be selected for deletion.
.
.IP "\fBtnl/neigh/show\fR"
.IP "\fBtnl/arp/show\fR"
OVS builds ARP cache by snooping are messages. This command shows
ARP cache table.
.
.IP "\fBtnl/neigh/set\fR \fIbridge\fR \fIip\fR \fImac\fR"
.IP "\fBtnl/arp/set\fR \fIbridge\fR \fIip\fR \fImac\fR"
Adds or modifies an ARP cache entry in \fIbridge\fR, mapping \fIip\fR
to \fImac\fR.
.
.IP "\fBtnl/neigh/flush\fR"
.IP "\fBtnl/arp/flush\fR"
Flush ARP table.
.
.IP "\fBtnl/neigh/aging\fR [\fIseconds\fR]"
.IP "\fBtnl/arp/aging\fR [\fIseconds\fR]"
Changes the aging time. The accepted values of \fIseconds\fR are
between 1 and 3600. The new entries will get the value as specified in
\fIseconds\fR. For the existing entries, the aging time is updated
only if the current expiration is greater than \fIseconds\fR.
.IP
If used without arguments, it prints the current aging value.
.
.IP "\fBtnl/egress_port_range\fR [\fInum1\fR] [\fInum2\fR]"
Set range for UDP source port used for UDP based Tunnels. For
example VxLAN. If case of zero arguments this command prints
current range in use.
