/*
 * Copyright (C) 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 */

#pragma once

#include "meta/display.h"
#include "meta/common.h"

#define META_TYPE_KEY_BINDING               (meta_key_binding_get_type ())

META_EXPORT
const char          *meta_key_binding_get_name      (MetaKeyBinding *binding);

META_EXPORT
ClutterModifierType  meta_key_binding_get_modifiers (MetaKeyBinding *binding);

META_EXPORT
guint                meta_key_binding_get_mask      (MetaKeyBinding *binding);

META_EXPORT
gboolean             meta_key_binding_is_builtin    (MetaKeyBinding *binding);

META_EXPORT
gboolean             meta_key_binding_is_reversed   (MetaKeyBinding *binding);

META_EXPORT
gboolean meta_keybindings_set_custom_handler (const gchar        *name,
					      MetaKeyHandlerFunc  handler,
					      gpointer            user_data,
					      GDestroyNotify      free_data);
