set(CACHE{VAR1} VALUE v1 v2)
if(NOT DEFINED CACHE{VAR1})
  message(SEND_ERROR "CACHE{VAR1} not defined")
endif()
get_property(type CACHE VAR1 PROPERTY TYPE)
if(NOT type STREQUAL "STRING")
  message(SEND_ERROR "CACHE{VAR1} TYPE should be \"STRING\", not \"${type}\"")
endif()
set(CACHE{VAR1} VALUE v3 v4)
if(NOT "$CACHE{VAR1}" STREQUAL "v1;v2")
  message(SEND_ERROR "CACHE{VAR1} value should be \"v1;v2\", not \"$CACHE{VAR1}\"")
endif()
set(CACHE{VAR1} FORCE VALUE v3 v4)
if(NOT "$CACHE{VAR1}" STREQUAL "v3;v4")
  message(SEND_ERROR "CACHE{VAR1} value should be \"v3;v4\", not \"$CACHE{VAR1}\"")
endif()
set(CACHE{VAR1} FORCE VALUE)
if(NOT DEFINED CACHE{VAR1})
  message(SEND_ERROR "CACHE{VAR1} not defined")
endif()
if(NOT "$CACHE{VAR1}" STREQUAL "")
  message(SEND_ERROR "CACHE{VAR1} value should be \"\", not \"$CACHE{VAR1}\"")
endif()
unset(CACHE{VAR1})
if(DEFINED CACHE{VAR1})
  message(SEND_ERROR "CACHE{VAR1} defined")
endif()

set(CACHE{VAR2} TYPE PATH HELP "help1 " "help2" VALUE v1 v2)
if(NOT DEFINED CACHE{VAR2})
  message(SEND_ERROR "CACHE{VAR2} not defined")
endif()
get_property(type CACHE VAR2 PROPERTY TYPE)
if(NOT type STREQUAL "PATH")
  message(SEND_ERROR "CACHE{VAR2} TYPE should be \"PATH\", not \"${type}\"")
endif()
get_property(help CACHE VAR2 PROPERTY HELPSTRING)
if(NOT help STREQUAL "help1 help2")
  message(SEND_ERROR "CACHE{VAR2} HELP should be \"help1 help2\", not \"${help}\"")
endif()
if(NOT "$CACHE{VAR2}" STREQUAL "v1;v2")
  message(SEND_ERROR "CACHE{VAR2} value should be \"v1;v2\", not \"$CACHE{VAR2}\"")
endif()
set(CACHE{VAR2} FORCE VALUE v3 v4)
if(NOT "$CACHE{VAR2}" STREQUAL "v3;v4")
  message(SEND_ERROR "CACHE{VAR2} value should be \"v3;v4\", not \"$CACHE{VAR2}\"")
endif()
get_property(type CACHE VAR2 PROPERTY TYPE)
if(NOT type STREQUAL "PATH")
  message(SEND_ERROR "CACHE{VAR2} TYPE should be \"PATH\", not \"${type}\"")
endif()
get_property(help CACHE VAR2 PROPERTY HELPSTRING)
if(NOT help STREQUAL "help1 help2")
  message(SEND_ERROR "CACHE{VAR2} HELP should be \"help1 help2\", not \"${help}\"")
endif()
unset(CACHE{VAR2})
if(DEFINED CACHE{VAR2})
  message(SEND_ERROR "CACHE{VAR2} defined")
endif()


set(CACHE{VAR3} TYPE INTERNAL HELP "help" VALUE v1 v2)
if(NOT DEFINED CACHE{VAR3})
  message(SEND_ERROR "CACHE{VAR3} not defined")
endif()
set(CACHE{VAR3} VALUE v3 v4)
if(NOT "$CACHE{VAR3}" STREQUAL "v3;v4")
  message(SEND_ERROR "CACHE{VAR3} value should be \"v3;v4\", not \"$CACHE{VAR3}\"")
endif()
get_property(type CACHE VAR3 PROPERTY TYPE)
if(NOT type STREQUAL "INTERNAL")
  message(SEND_ERROR "CACHE{VAR3} TYPE should be \"INTERNAL\", not \"${type}\"")
endif()
