/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of Zstd.xs. Do not edit this file, edit Zstd.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "lib/Compress/Stream/Zstd.xs"
#ifdef __cplusplus
extern "C" {
#endif
#define PERL_NO_GET_CONTEXT
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

#define NEED_sv_2pvbyte
#define NEED_newCONSTSUB
#include "ppport.h"
#include "zstd.h"

typedef struct Compress__Stream__Zstd__Compressor_s {
    ZSTD_CStream* stream;
    char* buf;
    size_t bufsize;
    size_t status ;
}* Compress__Stream__Zstd__Compressor;

typedef struct Compress__Stream__Zstd__Decompressor_s {
    ZSTD_DStream* stream;
    char* buf;
    size_t bufsize;
    size_t status ;
}* Compress__Stream__Zstd__Decompressor;

typedef ZSTD_CCtx* Compress__Stream__Zstd__CompressionContext;

typedef ZSTD_DCtx* Compress__Stream__Zstd__DecompressionContext;

typedef ZSTD_CDict* Compress__Stream__Zstd__CompressionDictionary;

typedef ZSTD_DDict* Compress__Stream__Zstd__DecompressionDictionary;

static SV*
decompress_using_streaming(pTHX_ const char* src, size_t srcSize)
{
    char* buf;
    size_t bufsize;
    SV* output;
    ZSTD_inBuffer inbuf = { src, srcSize, 0 };
    int iserror = 0;

    ZSTD_DStream* stream = ZSTD_createDStream();
    if (stream == NULL) {
        croak("Failed to call ZSTD_createDStream()");
    }
    ZSTD_initDStream(stream);

    bufsize = ZSTD_DStreamOutSize();
    Newx(buf, bufsize, char);

    output = newSVpv("", 0);
    while (inbuf.pos < inbuf.size) {
        ZSTD_outBuffer outbuf = { buf, bufsize, 0 };
        size_t ret = ZSTD_decompressStream(stream, &outbuf, &inbuf);
        if (ZSTD_isError(ret)) {
            iserror = 1;
            break;
        }
        sv_catpvn(output, outbuf.dst, outbuf.pos);
    }
    Safefree(buf);
    ZSTD_freeDStream(stream);
    if (iserror != 0) {
        SvREFCNT_dec(output);
        return NULL;
    }
    return output;
}

#line 86 "lib/Compress/Stream/Zstd.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 230 "lib/Compress/Stream/Zstd.c"

XS_EUPXS(XS_Compress__Stream__Zstd_compress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd_compress)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "source, level = 1");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	source = ST(0)
;
	int	level;
#line 94 "lib/Compress/Stream/Zstd.xs"
    const char* src;
    STRLEN src_len;
    SV* dest;
    char* dst;
    size_t bound, ret;
#line 250 "lib/Compress/Stream/Zstd.c"

	if (items < 2)
	    level = 1;
	else {
	    level = (int)SvIV(ST(1))
;
	}
#line 100 "lib/Compress/Stream/Zstd.xs"
    if (SvROK(source)) {
        source = SvRV(source);
    }
    if (!SvOK(source)) {
        XSRETURN_UNDEF;
    }
    src = SvPVbyte(source, src_len);
    bound = ZSTD_compressBound(src_len);
    dest = sv_2mortal(newSV(bound + 1));
    dst = SvPVX(dest);
    ret = ZSTD_compress(dst, bound + 1, src, src_len, level);
    if (ZSTD_isError(ret)) {
        XSRETURN_UNDEF;
    }
    dst[ret] = '\0';
    SvCUR_set(dest, ret);
    SvPOK_on(dest);
    EXTEND(SP, 1);
    PUSHs(dest);
#line 278 "lib/Compress/Stream/Zstd.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Stream__Zstd_decompress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd_decompress)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "source");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	SV*	source = ST(0)
;
#line 128 "lib/Compress/Stream/Zstd.xs"
    const char* src;
    STRLEN src_len;
    unsigned long long dest_len;
    SV* dest;
    char* dst;
    size_t ret;
#line 304 "lib/Compress/Stream/Zstd.c"
#line 135 "lib/Compress/Stream/Zstd.xs"
    if (SvROK(source)) {
        source = SvRV(source);
    }
    if (!SvOK(source)) {
        XSRETURN_UNDEF;
    }
    src = SvPVbyte(source, src_len);
    dest_len = ZSTD_getFrameContentSize(src, src_len);
    if (dest_len == ZSTD_CONTENTSIZE_UNKNOWN) {
        SV* output = decompress_using_streaming(aTHX_ src, src_len);
        if (output == NULL) {
            XSRETURN_UNDEF;
        }
        EXTEND(SP, 1);
        mPUSHs(output);
        XSRETURN(1);
    }
    if (dest_len == ULLONG_MAX || ZSTD_isError(dest_len)) {
        XSRETURN_UNDEF;
    }
    dest = sv_2mortal(newSV(dest_len + 1));
    dst = SvPVX(dest);
    ret = ZSTD_decompress(dst, dest_len + 1, src, src_len);
    if (ZSTD_isError(ret)) {
        XSRETURN_UNDEF;
    }
    dst[ret] = '\0';
    SvCUR_set(dest, ret);
    SvPOK_on(dest);
    EXTEND(SP, 1);
    PUSHs(dest);
    XSRETURN(1);
#line 338 "lib/Compress/Stream/Zstd.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "klass, level = 1");
    {
	const char*	klass = (const char *)SvPV_nolen(ST(0))
;
	int	level;
#line 184 "lib/Compress/Stream/Zstd.xs"
    Compress__Stream__Zstd__Compressor self;
    char* buf;
    size_t bufsize;
#line 359 "lib/Compress/Stream/Zstd.c"
	Compress__Stream__Zstd__Compressor	RETVAL;

	if (items < 2)
	    level = 1;
	else {
	    level = (int)SvIV(ST(1))
;
	}
#line 188 "lib/Compress/Stream/Zstd.xs"
    ZSTD_CStream* stream = ZSTD_createCStream();
    if (stream == NULL) {
        croak("Failed to call ZSTD_createCStream()");
    }
    ZSTD_initCStream(stream, level);

    Newx(self, sizeof(struct Compress__Stream__Zstd__Compressor_s), struct Compress__Stream__Zstd__Compressor_s);
    self->stream = stream;
    bufsize = ZSTD_CStreamOutSize();
    Newx(buf, bufsize, char);
    self->buf = buf;
    self->bufsize = bufsize;
    RETVAL = self;
#line 382 "lib/Compress/Stream/Zstd.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Compress::Stream::Zstd::Compressor", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_init)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "self, level = 1");
    {
	Compress__Stream__Zstd__Compressor	self;
	int	level;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Compressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Compressor::init",
			"self", "Compress::Stream::Zstd::Compressor",
			refstr, ST(0)
		);
	}
;

	if (items < 2)
	    level = 1;
	else {
	    level = (int)SvIV(ST(1))
;
	}
#line 209 "lib/Compress/Stream/Zstd.xs"
    ZSTD_initCStream(self->stream, level);
#line 426 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_set_parameter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_set_parameter)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, cParam, value");
    {
	Compress__Stream__Zstd__Compressor	self;
	unsigned long	cParam = (unsigned long)SvUV(ST(1))
;
	int	value = (int)SvIV(ST(2))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Compressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Compressor::set_parameter",
			"self", "Compress::Stream::Zstd::Compressor",
			refstr, ST(0)
		);
	}
;
#line 217 "lib/Compress/Stream/Zstd.xs"
    size_t ret = ZSTD_CCtx_setParameter( self->stream, (ZSTD_cParameter)cParam, value );
    if (ZSTD_isError(ret)) {
        croak("%s", ZSTD_getErrorName(ret));
    }
#line 463 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_compress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_compress)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, input");
    {
	Compress__Stream__Zstd__Compressor	self;
	SV*	input = ST(1)
;
#line 227 "lib/Compress/Stream/Zstd.xs"
    STRLEN len;
    SV* output;
#line 482 "lib/Compress/Stream/Zstd.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Compressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Compressor::compress",
			"self", "Compress::Stream::Zstd::Compressor",
			refstr, ST(0)
		);
	}
;
#line 230 "lib/Compress/Stream/Zstd.xs"
    const char* in = SvPVbyte(input, len);
    ZSTD_inBuffer inbuf = { in, len, 0 };
    output = newSVpv("", 0);
    while (inbuf.pos < inbuf.size) {
        ZSTD_outBuffer outbuf = { self->buf, self->bufsize, 0 };
        size_t toread = self->status = ZSTD_compressStream(self->stream, &outbuf, &inbuf);
        if (ZSTD_isError(toread)) {
            croak("%s", ZSTD_getErrorName(toread));
        }
        sv_catpvn(output, outbuf.dst, outbuf.pos);
    }
    RETVAL = output;
#line 511 "lib/Compress/Stream/Zstd.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_flush); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_flush)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Compressor	self;
#line 249 "lib/Compress/Stream/Zstd.xs"
    SV* output;
    size_t ret;
#line 530 "lib/Compress/Stream/Zstd.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Compressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Compressor::flush",
			"self", "Compress::Stream::Zstd::Compressor",
			refstr, ST(0)
		);
	}
;
#line 252 "lib/Compress/Stream/Zstd.xs"
    output = newSVpv("", 0);
    do {
        ZSTD_outBuffer outbuf = { self->buf, self->bufsize, 0 };
        ret = self->status = ZSTD_flushStream(self->stream, &outbuf);
        if (ZSTD_isError(ret)) {
            croak("%s", ZSTD_getErrorName(ret));
        }
        sv_catpvn(output, outbuf.dst, outbuf.pos);
    } while (ret > 0);
    RETVAL = output;
#line 557 "lib/Compress/Stream/Zstd.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_end); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_end)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Compressor	self;
#line 269 "lib/Compress/Stream/Zstd.xs"
    SV* output;
    size_t ret;
#line 576 "lib/Compress/Stream/Zstd.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Compressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Compressor::end",
			"self", "Compress::Stream::Zstd::Compressor",
			refstr, ST(0)
		);
	}
;
#line 272 "lib/Compress/Stream/Zstd.xs"
    output = newSVpv("", 0);
    do {
        ZSTD_outBuffer outbuf = { self->buf, self->bufsize, 0 };
        ret = self->status = ZSTD_endStream(self->stream, &outbuf);
        if (ZSTD_isError(ret)) {
            croak("%s", ZSTD_getErrorName(ret));
        }
        sv_catpvn(output, outbuf.dst, outbuf.pos);
    } while (ret > 0);
    RETVAL = output;
#line 603 "lib/Compress/Stream/Zstd.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_status); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_status)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Compressor	self;
	size_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Compressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Compressor::status",
			"self", "Compress::Stream::Zstd::Compressor",
			refstr, ST(0)
		);
	}
;
#line 290 "lib/Compress/Stream/Zstd.xs"
    RETVAL = self->status;
#line 637 "lib/Compress/Stream/Zstd.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_isError); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_isError)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Compressor	self;
	unsigned	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Compressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Compressor::isError",
			"self", "Compress::Stream::Zstd::Compressor",
			refstr, ST(0)
		);
	}
;
#line 298 "lib/Compress/Stream/Zstd.xs"
    RETVAL = ZSTD_isError(self->status);
#line 671 "lib/Compress/Stream/Zstd.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_getErrorName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_getErrorName)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Compressor	self;
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Compressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Compressor::getErrorName",
			"self", "Compress::Stream::Zstd::Compressor",
			refstr, ST(0)
		);
	}
;
#line 307 "lib/Compress/Stream/Zstd.xs"
    RETVAL = ZSTD_getErrorName(self->status);
#line 705 "lib/Compress/Stream/Zstd.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Compressor_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Compressor	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Compressor,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Stream::Zstd::Compressor::DESTROY",
			"self")
;
#line 315 "lib/Compress/Stream/Zstd.xs"
    ZSTD_freeCStream(self->stream);
    Safefree(self->buf);
    Safefree(self);
#line 736 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "klass");
    {
	const char*	klass = (const char *)SvPV_nolen(ST(0))
;
#line 334 "lib/Compress/Stream/Zstd.xs"
    Compress__Stream__Zstd__Decompressor self;
    char* buf;
    size_t bufsize;
#line 755 "lib/Compress/Stream/Zstd.c"
	Compress__Stream__Zstd__Decompressor	RETVAL;
#line 338 "lib/Compress/Stream/Zstd.xs"
    ZSTD_DStream* stream = ZSTD_createDStream();
    if (stream == NULL) {
        croak("Failed to call ZSTD_createDStream()");
    }
    ZSTD_initDStream(stream);

    Newx(self, sizeof(struct Compress__Stream__Zstd__Decompressor_s), struct Compress__Stream__Zstd__Decompressor_s);
    self->stream = stream;
    bufsize = ZSTD_DStreamOutSize();
    Newx(buf, bufsize, char);
    self->buf = buf;
    self->bufsize = bufsize;
    RETVAL = self;
#line 771 "lib/Compress/Stream/Zstd.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Compress::Stream::Zstd::Decompressor", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_init); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_init)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Decompressor	self;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Decompressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Decompressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Decompressor::init",
			"self", "Compress::Stream::Zstd::Decompressor",
			refstr, ST(0)
		);
	}
;
#line 358 "lib/Compress/Stream/Zstd.xs"
    ZSTD_initDStream(self->stream);
#line 807 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_set_parameter); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_set_parameter)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, dParam, value");
    {
	Compress__Stream__Zstd__Decompressor	self;
	unsigned long	dParam = (unsigned long)SvUV(ST(1))
;
	int	value = (int)SvIV(ST(2))
;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Decompressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Decompressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Decompressor::set_parameter",
			"self", "Compress::Stream::Zstd::Decompressor",
			refstr, ST(0)
		);
	}
;
#line 366 "lib/Compress/Stream/Zstd.xs"
    size_t ret = ZSTD_DCtx_setParameter( self->stream, (ZSTD_dParameter)dParam, value );
    if (ZSTD_isError(ret)) {
        croak("%s", ZSTD_getErrorName(ret));
    }
#line 844 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_decompress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_decompress)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "self, input");
    {
	Compress__Stream__Zstd__Decompressor	self;
	SV*	input = ST(1)
;
#line 376 "lib/Compress/Stream/Zstd.xs"
    STRLEN len;
    SV* output;
#line 863 "lib/Compress/Stream/Zstd.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Decompressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Decompressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Decompressor::decompress",
			"self", "Compress::Stream::Zstd::Decompressor",
			refstr, ST(0)
		);
	}
;
#line 379 "lib/Compress/Stream/Zstd.xs"
    const char* in = SvPVbyte(input, len);
    ZSTD_inBuffer inbuf = { in, len, 0 };
    output = newSVpv("", 0);
    while (inbuf.pos < inbuf.size) {
        ZSTD_outBuffer outbuf = { self->buf, self->bufsize, 0 };
        size_t ret = self->status = ZSTD_decompressStream(self->stream, &outbuf, &inbuf);
        if (ZSTD_isError(ret)) {
            croak("%s", ZSTD_getErrorName(ret));
        }
        sv_catpvn(output, outbuf.dst, outbuf.pos);
    }
    RETVAL = output;
#line 892 "lib/Compress/Stream/Zstd.c"
	RETVAL = sv_2mortal(RETVAL);
	ST(0) = RETVAL;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_status); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_status)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Decompressor	self;
	size_t	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Decompressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Decompressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Decompressor::status",
			"self", "Compress::Stream::Zstd::Decompressor",
			refstr, ST(0)
		);
	}
;
#line 398 "lib/Compress/Stream/Zstd.xs"
    RETVAL = self->status;
#line 926 "lib/Compress/Stream/Zstd.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_isError); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_isError)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Decompressor	self;
	unsigned	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Decompressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Decompressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Decompressor::isError",
			"self", "Compress::Stream::Zstd::Decompressor",
			refstr, ST(0)
		);
	}
;
#line 406 "lib/Compress/Stream/Zstd.xs"
    RETVAL = ZSTD_isError(self->status);
#line 960 "lib/Compress/Stream/Zstd.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_isEndFrame); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_isEndFrame)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Decompressor	self;
	unsigned	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Decompressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Decompressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Decompressor::isEndFrame",
			"self", "Compress::Stream::Zstd::Decompressor",
			refstr, ST(0)
		);
	}
;
#line 414 "lib/Compress/Stream/Zstd.xs"
    RETVAL = self->status == 0;
#line 994 "lib/Compress/Stream/Zstd.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_getErrorName); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_getErrorName)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Decompressor	self;
	const char *	RETVAL;
	dXSTARG;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::Decompressor")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Decompressor,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::Decompressor::getErrorName",
			"self", "Compress::Stream::Zstd::Decompressor",
			refstr, ST(0)
		);
	}
;
#line 422 "lib/Compress/Stream/Zstd.xs"
    RETVAL = ZSTD_getErrorName(self->status);
#line 1028 "lib/Compress/Stream/Zstd.c"
	sv_setpv(TARG, RETVAL);
	XSprePUSH;
	PUSHTARG;
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__Decompressor_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__Decompressor	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__Decompressor,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Stream::Zstd::Decompressor::DESTROY",
			"self")
;
#line 430 "lib/Compress/Stream/Zstd.xs"
    ZSTD_freeDStream(self->stream);
    Safefree(self->buf);
    Safefree(self);
#line 1059 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__CompressionContext_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__CompressionContext_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "klass");
    {
	const char*	klass = (const char *)SvPV_nolen(ST(0))
;
	Compress__Stream__Zstd__CompressionContext	RETVAL;
#line 443 "lib/Compress/Stream/Zstd.xs"
    ZSTD_CCtx* cctx = ZSTD_createCCtx();
    if (cctx == NULL) {
        croak("Failed to call ZSTD_createCCtx()");
    }
    RETVAL = (Compress__Stream__Zstd__CompressionContext) cctx;
#line 1081 "lib/Compress/Stream/Zstd.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Compress::Stream::Zstd::CompressionContext", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__CompressionContext_compress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__CompressionContext_compress)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "self, source, level = 1");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Compress__Stream__Zstd__CompressionContext	self;
	SV*	source = ST(1)
;
	int	level;
#line 457 "lib/Compress/Stream/Zstd.xs"
    const char* src;
    STRLEN src_len;
    SV* dest;
    char* dst;
    size_t bound, ret;
#line 1112 "lib/Compress/Stream/Zstd.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::CompressionContext")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__CompressionContext,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::CompressionContext::compress",
			"self", "Compress::Stream::Zstd::CompressionContext",
			refstr, ST(0)
		);
	}
;

	if (items < 3)
	    level = 1;
	else {
	    level = (int)SvIV(ST(2))
;
	}
#line 463 "lib/Compress/Stream/Zstd.xs"
    if (!SvOK(source)) {
        XSRETURN_UNDEF;
    }
    src = SvPVbyte(source, src_len);
    bound = ZSTD_compressBound(src_len);
    dest = sv_2mortal(newSV(bound + 1));
    dst = SvPVX(dest);
    ret = ZSTD_compressCCtx((ZSTD_CCtx*) self, dst, bound + 1, src, src_len, level);
    if (ZSTD_isError(ret)) {
        XSRETURN_UNDEF;
    }
    dst[ret] = '\0';
    SvCUR_set(dest, ret);
    SvPOK_on(dest);
    EXTEND(SP, 1);
    PUSHs(dest);
#line 1152 "lib/Compress/Stream/Zstd.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Stream__Zstd__CompressionContext_compress_using_dict); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__CompressionContext_compress_using_dict)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, source, dict");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Compress__Stream__Zstd__CompressionContext	self;
	SV*	source = ST(1)
;
	Compress__Stream__Zstd__CompressionDictionary	dict;
#line 486 "lib/Compress/Stream/Zstd.xs"
    const char* src;
    STRLEN src_len;
    SV* dest;
    char* dst;
    size_t bound, ret;
#line 1178 "lib/Compress/Stream/Zstd.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::CompressionContext")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__CompressionContext,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::CompressionContext::compress_using_dict",
			"self", "Compress::Stream::Zstd::CompressionContext",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Compress::Stream::Zstd::CompressionDictionary")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    dict = INT2PTR(Compress__Stream__Zstd__CompressionDictionary,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::CompressionContext::compress_using_dict",
			"dict", "Compress::Stream::Zstd::CompressionDictionary",
			refstr, ST(2)
		);
	}
;
#line 492 "lib/Compress/Stream/Zstd.xs"
    if (!SvOK(source)) {
        XSRETURN_UNDEF;
    }
    src = SvPVbyte(source, src_len);
    bound = ZSTD_compressBound(src_len);
    dest = sv_2mortal(newSV(bound + 1));
    dst = SvPVX(dest);
    ret = ZSTD_compress_usingCDict((ZSTD_CCtx*) self, dst, bound + 1, src, src_len, (ZSTD_CDict*) dict);
    if (ZSTD_isError(ret)) {
        XSRETURN_UNDEF;
    }
    dst[ret] = '\0';
    SvCUR_set(dest, ret);
    SvPOK_on(dest);
    EXTEND(SP, 1);
    PUSHs(dest);
#line 1225 "lib/Compress/Stream/Zstd.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Stream__Zstd__CompressionContext_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__CompressionContext_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__CompressionContext	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__CompressionContext,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Stream::Zstd::CompressionContext::DESTROY",
			"self")
;
#line 513 "lib/Compress/Stream/Zstd.xs"
    ZSTD_freeCCtx((ZSTD_CCtx*) self);
#line 1252 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionContext_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionContext_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "klass");
    {
	const char*	klass = (const char *)SvPV_nolen(ST(0))
;
	Compress__Stream__Zstd__DecompressionContext	RETVAL;
#line 524 "lib/Compress/Stream/Zstd.xs"
    ZSTD_DCtx* dctx = ZSTD_createDCtx();
    if (dctx == NULL) {
        croak("Failed to call ZSTD_createDCtx()");
    }
    RETVAL = (Compress__Stream__Zstd__DecompressionContext) dctx;
#line 1274 "lib/Compress/Stream/Zstd.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Compress::Stream::Zstd::DecompressionContext", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionContext_decompress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionContext_decompress)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "self, source");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Compress__Stream__Zstd__DecompressionContext	self;
	SV*	source = ST(1)
;
#line 539 "lib/Compress/Stream/Zstd.xs"
    const char* src;
    STRLEN src_len;
    unsigned long long dest_len;
    SV* dest;
    char* dst;
    size_t ret;
#line 1306 "lib/Compress/Stream/Zstd.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::DecompressionContext")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__DecompressionContext,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			GvNAME(CvGV(cv)),
			"self", "Compress::Stream::Zstd::DecompressionContext",
			refstr, ST(0)
		);
	}
;
#line 546 "lib/Compress/Stream/Zstd.xs"
    if (!SvOK(source)) {
        XSRETURN_UNDEF;
    }
    src = SvPVbyte(source, src_len);
    dest_len = ZSTD_getFrameContentSize(src, src_len);
    if (dest_len == ZSTD_CONTENTSIZE_UNKNOWN || dest_len == ULLONG_MAX || ZSTD_isError(dest_len)) {
        /* TODO: Support ZSTD_CONTENTSIZE_UNKNOWN */
        XSRETURN_UNDEF;
    }
    dest = sv_2mortal(newSV(dest_len + 1));
    dst = SvPVX(dest);
    ret = ZSTD_decompressDCtx((ZSTD_DCtx*) self, dst, dest_len + 1, src, src_len);
    if (ZSTD_isError(ret)) {
        XSRETURN_UNDEF;
    }
    dst[ret] = '\0';
    SvCUR_set(dest, ret);
    SvPOK_on(dest);
    EXTEND(SP, 1);
    PUSHs(dest);
#line 1343 "lib/Compress/Stream/Zstd.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionContext_decompress_using_dict); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionContext_decompress_using_dict)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "self, source, dict");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	Compress__Stream__Zstd__DecompressionContext	self;
	SV*	source = ST(1)
;
	Compress__Stream__Zstd__DecompressionDictionary	dict;
#line 573 "lib/Compress/Stream/Zstd.xs"
    const char* src;
    STRLEN src_len;
    unsigned long long dest_len;
    SV* dest;
    char* dst;
    size_t ret;
#line 1370 "lib/Compress/Stream/Zstd.c"
	SV *	RETVAL;

	if (SvROK(ST(0)) && sv_derived_from(ST(0), "Compress::Stream::Zstd::DecompressionContext")) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__DecompressionContext,tmp);
	}
	else {
		const char* refstr = SvROK(ST(0)) ? "" : SvOK(ST(0)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::DecompressionContext::decompress_using_dict",
			"self", "Compress::Stream::Zstd::DecompressionContext",
			refstr, ST(0)
		);
	}
;

	if (SvROK(ST(2)) && sv_derived_from(ST(2), "Compress::Stream::Zstd::DecompressionDictionary")) {
	    IV tmp = SvIV((SV*)SvRV(ST(2)));
	    dict = INT2PTR(Compress__Stream__Zstd__DecompressionDictionary,tmp);
	}
	else {
		const char* refstr = SvROK(ST(2)) ? "" : SvOK(ST(2)) ? "scalar " : "undef";
	    Perl_croak_nocontext("%s: Expected %s to be of type %s; got %s%" SVf " instead",
			"Compress::Stream::Zstd::DecompressionContext::decompress_using_dict",
			"dict", "Compress::Stream::Zstd::DecompressionDictionary",
			refstr, ST(2)
		);
	}
;
#line 580 "lib/Compress/Stream/Zstd.xs"
    if (!SvOK(source)) {
        XSRETURN_UNDEF;
    }
    src = SvPVbyte(source, src_len);
    dest_len = ZSTD_getFrameContentSize(src, src_len);
    if (dest_len == ZSTD_CONTENTSIZE_UNKNOWN || dest_len == ULLONG_MAX || ZSTD_isError(dest_len)) {
        /* TODO: Support ZSTD_CONTENTSIZE_UNKNOWN */
        XSRETURN_UNDEF;
    }
    dest = sv_2mortal(newSV(dest_len + 1));
    dst = SvPVX(dest);
    ret = ZSTD_decompress_usingDDict((ZSTD_DCtx*) self, dst, dest_len + 1, src, src_len, (ZSTD_DDict*) dict);
    if (ZSTD_isError(ret)) {
        XSRETURN_UNDEF;
    }
    dst[ret] = '\0';
    SvCUR_set(dest, ret);
    SvPOK_on(dest);
    EXTEND(SP, 1);
    PUSHs(dest);
#line 1421 "lib/Compress/Stream/Zstd.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionContext_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionContext_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__DecompressionContext	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__DecompressionContext,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Stream::Zstd::DecompressionContext::DESTROY",
			"self")
;
#line 605 "lib/Compress/Stream/Zstd.xs"
    ZSTD_freeDCtx((ZSTD_DCtx*) self);
#line 1448 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__CompressionDictionary_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__CompressionDictionary_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "klass, dict, level = 1");
    {
	const char*	klass = (const char *)SvPV_nolen(ST(0))
;
	SV*	dict = ST(1)
;
	int	level;
#line 617 "lib/Compress/Stream/Zstd.xs"
    ZSTD_CDict* cdict;
    const char* dct;
    size_t dct_len;
#line 1470 "lib/Compress/Stream/Zstd.c"
	Compress__Stream__Zstd__CompressionDictionary	RETVAL;

	if (items < 3)
	    level = 1;
	else {
	    level = (int)SvIV(ST(2))
;
	}
#line 621 "lib/Compress/Stream/Zstd.xs"
    dct = SvPVbyte(dict, dct_len);
    cdict = ZSTD_createCDict(dct, dct_len, level);
    if (cdict == NULL) {
        croak("Failed to call ZSTD_createCDict()");
    }
    RETVAL = (Compress__Stream__Zstd__CompressionDictionary) cdict;
#line 1486 "lib/Compress/Stream/Zstd.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Compress::Stream::Zstd::CompressionDictionary", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__CompressionDictionary_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__CompressionDictionary_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__CompressionDictionary	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__CompressionDictionary,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Stream::Zstd::CompressionDictionary::DESTROY",
			"self")
;
#line 634 "lib/Compress/Stream/Zstd.xs"
    ZSTD_freeCDict((ZSTD_CDict*) self);
#line 1518 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionDictionary_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionDictionary_new)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "klass, dict");
    {
	const char*	klass = (const char *)SvPV_nolen(ST(0))
;
	SV*	dict = ST(1)
;
#line 645 "lib/Compress/Stream/Zstd.xs"
    ZSTD_DDict* ddict;
    const char* dct;
    size_t dct_len;
#line 1539 "lib/Compress/Stream/Zstd.c"
	Compress__Stream__Zstd__DecompressionDictionary	RETVAL;
#line 649 "lib/Compress/Stream/Zstd.xs"
    dct = SvPVbyte(dict, dct_len);
    ddict = ZSTD_createDDict(dct, dct_len);
    if (ddict == NULL) {
        croak("Failed to call ZSTD_createDDict()");
    }
    RETVAL = (Compress__Stream__Zstd__DecompressionDictionary) ddict;
#line 1548 "lib/Compress/Stream/Zstd.c"
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
	    sv_setref_pv(RETVALSV, "Compress::Stream::Zstd::DecompressionDictionary", (void*)RETVAL);
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionDictionary_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Compress__Stream__Zstd__DecompressionDictionary_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "self");
    {
	Compress__Stream__Zstd__DecompressionDictionary	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(Compress__Stream__Zstd__DecompressionDictionary,tmp);
	}
	else
	    Perl_croak_nocontext("%s: %s is not a reference",
			"Compress::Stream::Zstd::DecompressionDictionary::DESTROY",
			"self")
;
#line 662 "lib/Compress/Stream/Zstd.xs"
    ZSTD_freeDDict((ZSTD_DDict*) self);
#line 1580 "lib/Compress/Stream/Zstd.c"
    }
    XSRETURN_EMPTY;
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Compress__Stream__Zstd); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Compress__Stream__Zstd)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Compress::Stream::Zstd::compress", XS_Compress__Stream__Zstd_compress);
        cv = newXS_deffile("Compress::Stream::Zstd::decompress", XS_Compress__Stream__Zstd_decompress);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Compress::Stream::Zstd::uncompress", XS_Compress__Stream__Zstd_decompress);
        XSANY.any_i32 = 1;
        newXS_deffile("Compress::Stream::Zstd::Compressor::new", XS_Compress__Stream__Zstd__Compressor_new);
        newXS_deffile("Compress::Stream::Zstd::Compressor::init", XS_Compress__Stream__Zstd__Compressor_init);
        newXS_deffile("Compress::Stream::Zstd::Compressor::set_parameter", XS_Compress__Stream__Zstd__Compressor_set_parameter);
        newXS_deffile("Compress::Stream::Zstd::Compressor::compress", XS_Compress__Stream__Zstd__Compressor_compress);
        newXS_deffile("Compress::Stream::Zstd::Compressor::flush", XS_Compress__Stream__Zstd__Compressor_flush);
        newXS_deffile("Compress::Stream::Zstd::Compressor::end", XS_Compress__Stream__Zstd__Compressor_end);
        newXS_deffile("Compress::Stream::Zstd::Compressor::status", XS_Compress__Stream__Zstd__Compressor_status);
        newXS_deffile("Compress::Stream::Zstd::Compressor::isError", XS_Compress__Stream__Zstd__Compressor_isError);
        newXS_deffile("Compress::Stream::Zstd::Compressor::getErrorName", XS_Compress__Stream__Zstd__Compressor_getErrorName);
        newXS_deffile("Compress::Stream::Zstd::Compressor::DESTROY", XS_Compress__Stream__Zstd__Compressor_DESTROY);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::new", XS_Compress__Stream__Zstd__Decompressor_new);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::init", XS_Compress__Stream__Zstd__Decompressor_init);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::set_parameter", XS_Compress__Stream__Zstd__Decompressor_set_parameter);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::decompress", XS_Compress__Stream__Zstd__Decompressor_decompress);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::status", XS_Compress__Stream__Zstd__Decompressor_status);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::isError", XS_Compress__Stream__Zstd__Decompressor_isError);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::isEndFrame", XS_Compress__Stream__Zstd__Decompressor_isEndFrame);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::getErrorName", XS_Compress__Stream__Zstd__Decompressor_getErrorName);
        newXS_deffile("Compress::Stream::Zstd::Decompressor::DESTROY", XS_Compress__Stream__Zstd__Decompressor_DESTROY);
        newXS_deffile("Compress::Stream::Zstd::CompressionContext::new", XS_Compress__Stream__Zstd__CompressionContext_new);
        newXS_deffile("Compress::Stream::Zstd::CompressionContext::compress", XS_Compress__Stream__Zstd__CompressionContext_compress);
        newXS_deffile("Compress::Stream::Zstd::CompressionContext::compress_using_dict", XS_Compress__Stream__Zstd__CompressionContext_compress_using_dict);
        newXS_deffile("Compress::Stream::Zstd::CompressionContext::DESTROY", XS_Compress__Stream__Zstd__CompressionContext_DESTROY);
        newXS_deffile("Compress::Stream::Zstd::DecompressionContext::new", XS_Compress__Stream__Zstd__DecompressionContext_new);
        cv = newXS_deffile("Compress::Stream::Zstd::DecompressionContext::decompress", XS_Compress__Stream__Zstd__DecompressionContext_decompress);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Compress::Stream::Zstd::DecompressionContext::uncompress", XS_Compress__Stream__Zstd__DecompressionContext_decompress);
        XSANY.any_i32 = 1;
        newXS_deffile("Compress::Stream::Zstd::DecompressionContext::decompress_using_dict", XS_Compress__Stream__Zstd__DecompressionContext_decompress_using_dict);
        newXS_deffile("Compress::Stream::Zstd::DecompressionContext::DESTROY", XS_Compress__Stream__Zstd__DecompressionContext_DESTROY);
        newXS_deffile("Compress::Stream::Zstd::CompressionDictionary::new", XS_Compress__Stream__Zstd__CompressionDictionary_new);
        newXS_deffile("Compress::Stream::Zstd::CompressionDictionary::DESTROY", XS_Compress__Stream__Zstd__CompressionDictionary_DESTROY);
        newXS_deffile("Compress::Stream::Zstd::DecompressionDictionary::new", XS_Compress__Stream__Zstd__DecompressionDictionary_new);
        newXS_deffile("Compress::Stream::Zstd::DecompressionDictionary::DESTROY", XS_Compress__Stream__Zstd__DecompressionDictionary_DESTROY);

    /* Initialisation Section */

#line 79 "lib/Compress/Stream/Zstd.xs"
{
    HV* stash = gv_stashpv("Compress::Stream::Zstd", 1);
    newCONSTSUB(stash, "ZSTD_VERSION_NUMBER", newSViv(ZSTD_VERSION_NUMBER));
    newCONSTSUB(stash, "ZSTD_VERSION_STRING", newSVpvs(ZSTD_VERSION_STRING));
    newCONSTSUB(stash, "ZSTD_MIN_CLEVEL", newSViv(ZSTD_minCLevel()));
    newCONSTSUB(stash, "ZSTD_MAX_CLEVEL", newSViv(ZSTD_maxCLevel()));
}

#line 173 "lib/Compress/Stream/Zstd.xs"
{
    HV* stash = gv_stashpv("Compress::Stream::Zstd::Compressor", 1);
    newCONSTSUB(stash, "ZSTD_CSTREAM_IN_SIZE", newSViv(ZSTD_CStreamInSize()));
    newCONSTSUB(stash, "ZSTD_c_windowLog", newSVuv(ZSTD_c_windowLog));
}

#line 324 "lib/Compress/Stream/Zstd.xs"
{
    HV* stash = gv_stashpv("Compress::Stream::Zstd::Decompressor", 1);
    newCONSTSUB(stash, "ZSTD_DSTREAM_IN_SIZE", newSViv(ZSTD_DStreamInSize()));
    newCONSTSUB(stash, "ZSTD_d_windowLogMax", newSVuv(ZSTD_d_windowLogMax));
}

#line 1678 "lib/Compress/Stream/Zstd.c"

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
