use Mojo::Base -strict;

BEGIN {
  $ENV{MOJO_MODE}    = 'testing';
  $ENV{MOJO_REACTOR} = 'Mojo::Reactor::Poll';
}

use Test::More;

use Test::Mojo;
use Mojo::File qw(curfile);

my $t = Test::Mojo->new(curfile->sibling('external', 'myapp.pl'));

subtest 'Template from myapp.pl' => sub {
  $t->get_ok('/')->status_is(200)->content_is(<<'EOF');
myapp
works ♥!Insecure!Insecure!

too!works!!!Mojolicious::Plugin::Config::Sandbox
<a href="/">Test</a>
<form action="/%E2%98%83">
  <input type="submit" value="☃">
</form>
EOF
};

subtest 'Static file from myapp.pl' => sub {
  $t->get_ok('/index.html')->status_is(200)->content_is("External static file!\n");
};

subtest 'Echo from myapp.pl' => sub {
  $t->get_ok('/echo')->status_is(200)->content_is('echo: nothing!');
};

subtest 'Chunked response from myapp.pl' => sub {
  $t->get_ok('/stream')->status_is(200)->content_is('hello!');
};

subtest 'URL generated by myapp.pl' => sub {
  $t->get_ok('/url/☃')->status_is(200)->content_is('/url/%E2%98%83.json -> /%E2%98%83/stream!');
};

subtest 'Config value at startup time' => sub {
  $t->get_ok('/startup')->status_is(200)->content_is('Insecure!');
};

# Config override
$t = Test::Mojo->new(curfile->sibling('external', 'myapp.pl'),
  {one => 'override!', two => 'go!', just => 'yada', works => 'override two!'});

subtest 'Template from myapp.pl with config override' => sub {
  $t->get_ok('/')->status_is(200)->content_is(<<'EOF');
myapp
yadaoverride!go!

override two!*?
<a href="/">Test</a>
<form action="/%E2%98%83">
  <input type="submit" value="☃">
</form>
EOF
};

subtest 'Config override at startup time' => sub {
  $t->get_ok('/startup')->status_is(200)->content_is('override!');
};

done_testing();
