use 5.014;

use strict;
use warnings;
use routines;

use Test::Auto;
use Test::More;

=name

Pluto

=cut

=tagline

Functional Programming

=cut

=abstract

Functional Scripting for Perl 5

=cut

=synopsis

  package Cosmos;

  use Pluto;

  call(string('hello world'), 'titlecase');

  # Hello World

=cut

=libraries

Types::Standard

=cut

=description

This package enables functional programming for Perl 5 via indirect routine
dispatching and dependency injection, operating in a way that plays nicely with
third-party libraries without having to switch over to object-oriented
programming.

+=head1 WHY

Perl is a multi-paradigm programming language that supports functional
programming, but, Perl has an intentionally limited standard library with an
emphasis on providing library support via the CPAN which is overwhelmingly
object-oriented. This makes developing in a functional style difficult as
you'll eventually need to rely on a CPAN library that requires you to switch
over to object-oriented programming.

=cut

package main;

my $test = testauto(__FILE__);

my $subs = $test->standard;

$subs->synopsis(fun($tryable) {
  ok my $result = $tryable->result;
  is $result, 'Hello World';

  $result
});

ok 1 and done_testing;
