/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.hmef.Attachment;
import org.apache.poi.hmef.HMEFMessage;
import org.apache.poi.hmef.attribute.MAPIAttribute;
import org.apache.poi.hmef.attribute.MAPIRtfAttribute;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TNEFParser
extends AbstractParser {
    private static final long serialVersionUID = 4611820730372823452L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("vnd.ms-tnef"), MediaType.application("ms-tnef"), MediaType.application("x-tnef"))));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        MAPIAttribute attr;
        EmbeddedDocumentExtractor embeddedExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        HMEFMessage msg = new HMEFMessage(stream);
        String subject = msg.getSubject();
        if (subject != null && subject.length() > 0) {
            metadata.set(TikaCoreProperties.TRANSITION_SUBJECT_TO_DC_TITLE, subject);
        }
        if ((attr = msg.getMessageMAPIAttribute(MAPIProperty.RTF_COMPRESSED)) != null && attr instanceof MAPIRtfAttribute) {
            MAPIRtfAttribute rtf = (MAPIRtfAttribute)attr;
            this.handleEmbedded("message.rtf", "application/rtf", rtf.getData(), embeddedExtractor, handler);
        }
        for (Attachment attachment : msg.getAttachments()) {
            String ext;
            String name = attachment.getLongFilename();
            if (name == null || name.length() == 0) {
                name = attachment.getFilename();
            }
            if ((name == null || name.length() == 0) && (ext = attachment.getExtension()) != null) {
                name = "unknown" + ext;
            }
            this.handleEmbedded(name, null, attachment.getContents(), embeddedExtractor, handler);
        }
    }

    private void handleEmbedded(String name, String type, byte[] contents, EmbeddedDocumentExtractor embeddedExtractor, ContentHandler handler) throws IOException, SAXException, TikaException {
        Metadata metadata = new Metadata();
        if (name != null) {
            metadata.set("resourceName", name);
        }
        if (type != null) {
            metadata.set("Content-Type", type);
        }
        if (embeddedExtractor.shouldParseEmbedded(metadata)) {
            embeddedExtractor.parseEmbedded(TikaInputStream.get(contents), new EmbeddedContentHandler(handler), metadata, false);
        }
    }
}

