/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.javaocr.gui.characterTracer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.logging.Logger;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.sourceforge.javaocr.gui.GUIController;

public class CharacterTracerPanel
extends JPanel {
    public static final long serialVersionUID = 0L;
    private JTextField imageLoc;
    private final GUIController guiController;
    private static final Logger LOG = Logger.getLogger(CharacterTracerPanel.class.getName());

    public CharacterTracerPanel(GUIController guiController) {
        this.guiController = guiController;
        this.setLayout(new BorderLayout());
        this.add((Component)this.getDescription(), "North");
        this.add((Component)this.getControlPanel(), "Center");
        this.add((Component)this.getExtractButton(), "East");
    }

    private JTextArea getDescription() {
        TitledBorder border = new TitledBorder("Description");
        JTextArea textArea = new JTextArea();
        textArea.setBorder(border);
        textArea.setEditable(false);
        textArea.setBackground(this.getBackground());
        String desc = "This feature will isolate characters within an image and trace them in the GUI.";
        textArea.setText(desc);
        return textArea;
    }

    private JPanel getControlPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(2));
        panel.add(this.getImageSelectPanel());
        return panel;
    }

    private JPanel getExtractButton() {
        JPanel btnPanel = new JPanel();
        btnPanel.setLayout(new FlowLayout());
        JButton btn = new JButton("Trace Characters");
        btn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                File imageFile = new File(CharacterTracerPanel.this.imageLoc.getText());
                if (!imageFile.exists()) {
                    JOptionPane.showMessageDialog(null, "Source Image Does Not Exist!");
                } else {
                    CharacterTracerPanel.this.guiController.traceChars(imageFile);
                    JOptionPane.showMessageDialog(null, "Done!");
                }
            }
        });
        btnPanel.add(btn);
        return btnPanel;
    }

    private JPanel getImageSelectPanel() {
        JPanel imageSel = new JPanel();
        imageSel.setLayout(new BoxLayout(imageSel, 0));
        JLabel imgLable = new JLabel("Select Image: ");
        imageSel.add(imgLable);
        this.imageLoc = new JTextField(40);
        imageSel.add(this.imageLoc);
        JButton button = new JButton("Select");
        button.addActionListener(this.getImageSelectAction());
        imageSel.add(button);
        return imageSel;
    }

    private ActionListener getImageSelectAction() {
        return new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    CharacterTracerPanel.this.imageLoc.setText(chooser.getSelectedFile().getAbsolutePath());
                }
            }
        };
    }
}

