/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.crypt;

import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.crypt.EncryptionVerifier;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.util.LittleEndian;

public class AgileDecryptor
extends Decryptor {
    private final EncryptionInfo _info;
    private SecretKey _secretKey;
    private long _length = -1L;
    private static final byte[] kVerifierInputBlock = new byte[]{-2, -89, -46, 118, 59, 75, -98, 121};
    private static final byte[] kHashedVerifierBlock = new byte[]{-41, -86, 15, 109, 48, 97, 52, 78};
    private static final byte[] kCryptoKeyBlock = new byte[]{20, 110, 11, -25, -85, -84, -48, -42};

    public boolean verifyPassword(String password) throws GeneralSecurityException {
        EncryptionVerifier verifier = this._info.getVerifier();
        int algorithm = verifier.getAlgorithm();
        int mode = verifier.getCipherMode();
        byte[] pwHash = this.hashPassword(this._info, password);
        byte[] iv = this.generateIv(algorithm, verifier.getSalt(), null);
        SecretKeySpec skey = new SecretKeySpec(this.generateKey(pwHash, kVerifierInputBlock), "AES");
        Cipher cipher = this.getCipher(algorithm, mode, skey, iv);
        byte[] verifierHashInput = cipher.doFinal(verifier.getVerifier());
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        byte[] trimmed = new byte[verifier.getSalt().length];
        System.arraycopy(verifierHashInput, 0, trimmed, 0, trimmed.length);
        byte[] hashedVerifier = sha1.digest(trimmed);
        skey = new SecretKeySpec(this.generateKey(pwHash, kHashedVerifierBlock), "AES");
        iv = this.generateIv(algorithm, verifier.getSalt(), null);
        cipher = this.getCipher(algorithm, mode, skey, iv);
        byte[] verifierHash = cipher.doFinal(verifier.getVerifierHash());
        trimmed = new byte[hashedVerifier.length];
        System.arraycopy(verifierHash, 0, trimmed, 0, trimmed.length);
        if (Arrays.equals(trimmed, hashedVerifier)) {
            skey = new SecretKeySpec(this.generateKey(pwHash, kCryptoKeyBlock), "AES");
            iv = this.generateIv(algorithm, verifier.getSalt(), null);
            cipher = this.getCipher(algorithm, mode, skey, iv);
            byte[] inter = cipher.doFinal(verifier.getEncryptedKey());
            byte[] keyspec = new byte[this._info.getHeader().getKeySize() / 8];
            System.arraycopy(inter, 0, keyspec, 0, keyspec.length);
            this._secretKey = new SecretKeySpec(keyspec, "AES");
            return true;
        }
        return false;
    }

    public InputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        DocumentInputStream dis = dir.createDocumentInputStream("EncryptedPackage");
        this._length = dis.readLong();
        return new ChunkedCipherInputStream(dis, this._length);
    }

    public long getLength() {
        if (this._length == -1L) {
            throw new IllegalStateException("EcmaDecryptor.getDataStream() was not called");
        }
        return this._length;
    }

    protected AgileDecryptor(EncryptionInfo info) {
        this._info = info;
    }

    private Cipher getCipher(int algorithm, int mode, SecretKey key, byte[] vec) throws GeneralSecurityException {
        String name = null;
        String chain = null;
        if (algorithm == 26126 || algorithm == 26127 || algorithm == 26128) {
            name = "AES";
        }
        if (mode == 2) {
            chain = "CBC";
        } else if (mode == 3) {
            chain = "CFB";
        }
        Cipher cipher = Cipher.getInstance(name + "/" + chain + "/NoPadding");
        IvParameterSpec iv = new IvParameterSpec(vec);
        cipher.init(2, (Key)key, iv);
        return cipher;
    }

    private byte[] getBlock(int algorithm, byte[] hash) {
        byte[] result = new byte[AgileDecryptor.getBlockSize(algorithm)];
        Arrays.fill(result, (byte)54);
        System.arraycopy(hash, 0, result, 0, Math.min(result.length, hash.length));
        return result;
    }

    private byte[] generateKey(byte[] hash, byte[] blockKey) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        sha1.update(hash);
        return this.getBlock(this._info.getVerifier().getAlgorithm(), sha1.digest(blockKey));
    }

    protected byte[] generateIv(int algorithm, byte[] salt, byte[] blockKey) throws NoSuchAlgorithmException {
        if (blockKey == null) {
            return this.getBlock(algorithm, salt);
        }
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        sha1.update(salt);
        return this.getBlock(algorithm, sha1.digest(blockKey));
    }

    private class ChunkedCipherInputStream
    extends InputStream {
        private int _lastIndex = 0;
        private long _pos = 0L;
        private final long _size;
        private final DocumentInputStream _stream;
        private byte[] _chunk;
        private Cipher _cipher;

        public ChunkedCipherInputStream(DocumentInputStream stream, long size) throws GeneralSecurityException {
            this._size = size;
            this._stream = stream;
            this._cipher = AgileDecryptor.this.getCipher(AgileDecryptor.this._info.getHeader().getAlgorithm(), AgileDecryptor.this._info.getHeader().getCipherMode(), AgileDecryptor.this._secretKey, AgileDecryptor.this._info.getHeader().getKeySalt());
        }

        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b) == 1) {
                return b[0];
            }
            return -1;
        }

        public int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int total = 0;
            while (len > 0) {
                if (this._chunk == null) {
                    try {
                        this._chunk = this.nextChunk();
                    }
                    catch (GeneralSecurityException e) {
                        throw new EncryptedDocumentException(e.getMessage());
                    }
                }
                int count = (int)(4096L - (this._pos & 0xFFFL));
                count = Math.min(this.available(), Math.min(count, len));
                System.arraycopy(this._chunk, (int)(this._pos & 0xFFFL), b, off, count);
                off += count;
                len -= count;
                this._pos += (long)count;
                if ((this._pos & 0xFFFL) == 0L) {
                    this._chunk = null;
                }
                total += count;
            }
            return total;
        }

        public long skip(long n) throws IOException {
            long start = this._pos;
            long skip = Math.min((long)this.available(), n);
            if (((this._pos + skip ^ start) & 0xFFFFFFFFFFFFF000L) != 0L) {
                this._chunk = null;
            }
            this._pos += skip;
            return skip;
        }

        public int available() throws IOException {
            return (int)(this._size - this._pos);
        }

        public void close() throws IOException {
            this._stream.close();
        }

        public boolean markSupported() {
            return false;
        }

        private byte[] nextChunk() throws GeneralSecurityException, IOException {
            int index = (int)(this._pos >> 12);
            byte[] blockKey = new byte[4];
            LittleEndian.putInt(blockKey, 0, index);
            byte[] iv = AgileDecryptor.this.generateIv(AgileDecryptor.this._info.getHeader().getAlgorithm(), AgileDecryptor.this._info.getHeader().getKeySalt(), blockKey);
            this._cipher.init(2, (Key)AgileDecryptor.this._secretKey, new IvParameterSpec(iv));
            if (this._lastIndex != index) {
                this._stream.skip(index - this._lastIndex << 12);
            }
            byte[] block = new byte[Math.min(this._stream.available(), 4096)];
            this._stream.readFully(block);
            this._lastIndex = index + 1;
            return this._cipher.doFinal(block);
        }
    }
}

