/*
 * Decompiled with CFR 0.152.
 */
package com.coremedia.iso.boxes;

import com.coremedia.iso.BoxParser;
import com.coremedia.iso.ChannelHelper;
import com.coremedia.iso.IsoFile;
import com.coremedia.iso.IsoTypeWriter;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.CastUtils;
import com.coremedia.iso.boxes.ContainerBox;
import com.googlecode.mp4parser.DoNotParseDetail;
import com.googlecode.mp4parser.RequiresParseDetailAspect;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.logging.Logger;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractBox
implements Box {
    private ByteBuffer content;
    private static Logger LOG;
    protected String type;
    private byte[] userType;
    private ContainerBox parent;
    protected ByteBuffer deadBytes = null;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        AbstractBox.ajc$preClinit();
        LOG = Logger.getLogger(AbstractBox.class.getName());
    }

    public long getSize() {
        long size = this.content == null ? this.getContentSize() : (long)this.content.limit();
        size += (long)(8 + (size >= 0xFFFFFFF8L ? 8 : 0) + ("uuid".equals(this.getType()) ? 16 : 0));
        return size += (long)(this.deadBytes == null ? 0 : this.deadBytes.limit());
    }

    public boolean isParsed() {
        return this.content == null;
    }

    protected abstract long getContentSize();

    protected AbstractBox(String type) {
        this.type = type;
    }

    @DoNotParseDetail
    public String getType() {
        return this.type;
    }

    @DoNotParseDetail
    public byte[] getUserType() {
        return this.userType;
    }

    @DoNotParseDetail
    public void setUserType(byte[] userType) {
        this.userType = userType;
    }

    @DoNotParseDetail
    public ContainerBox getParent() {
        return this.parent;
    }

    @DoNotParseDetail
    public void setParent(ContainerBox parent) {
        this.parent = parent;
    }

    @DoNotParseDetail
    public IsoFile getIsoFile() {
        return this.parent.getIsoFile();
    }

    @DoNotParseDetail
    public void parse(ReadableByteChannel in, ByteBuffer header, long contentSize, BoxParser boxParser) throws IOException {
        if (in instanceof FileChannel && contentSize > 0x100000L) {
            this.content = ((FileChannel)in).map(FileChannel.MapMode.READ_ONLY, ((FileChannel)in).position(), contentSize);
            ((FileChannel)in).position(((FileChannel)in).position() + contentSize);
        } else {
            assert (contentSize < Integer.MAX_VALUE);
            this.content = ChannelHelper.readFully(in, contentSize);
        }
    }

    public final synchronized void parseDetails() {
        if (this.content != null) {
            ByteBuffer content = this.content;
            this.content = null;
            content.rewind();
            this._parseDetails(content);
            if (content.remaining() > 0) {
                this.deadBytes = content.slice();
            }
            assert (this.verify(content));
        }
    }

    private boolean verify(ByteBuffer content) {
        ByteBuffer bb;
        block7: {
            bb = ByteBuffer.allocate(CastUtils.l2i(this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0)));
            try {
                this.getContent(bb);
                if (this.deadBytes != null) {
                    this.deadBytes.rewind();
                    while (this.deadBytes.remaining() > 0) {
                        bb.put(this.deadBytes);
                    }
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError((Object)e.getMessage());
            }
        }
        content.rewind();
        bb.rewind();
        if (content.remaining() != bb.remaining()) {
            LOG.severe("remaining differs " + content.remaining() + " vs. " + bb.remaining());
            return false;
        }
        int p = content.position();
        int i = content.limit() - 1;
        int j = bb.limit() - 1;
        while (i >= p) {
            byte v2;
            byte v1 = content.get(i);
            if (v1 != (v2 = bb.get(j)) && (v1 == v1 || v2 == v2)) {
                LOG.severe("buffers differ at " + i + "/" + j);
                return false;
            }
            --i;
            --j;
        }
        return true;
    }

    public abstract void _parseDetails(ByteBuffer var1);

    public ByteBuffer getDeadBytes() {
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_0, this, this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.deadBytes;
    }

    /*
     * WARNING - void declaration
     */
    public void setDeadBytes(ByteBuffer byteBuffer) {
        void newDeadBytes;
        ByteBuffer byteBuffer2 = byteBuffer;
        JoinPoint joinPoint = Factory.makeJP(ajc$tjp_1, (Object)this, (Object)this, byteBuffer2);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.deadBytes = newDeadBytes;
    }

    public void getHeader(ByteBuffer byteBuffer) {
        if (this.isSmallBox()) {
            IsoTypeWriter.writeUInt32(byteBuffer, this.getSize());
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
        } else {
            IsoTypeWriter.writeUInt32(byteBuffer, 1L);
            byteBuffer.put(IsoFile.fourCCtoBytes(this.getType()));
            IsoTypeWriter.writeUInt64(byteBuffer, this.getSize());
        }
        if ("uuid".equals(this.getType())) {
            byteBuffer.put(this.getUserType());
        }
    }

    private boolean isSmallBox() {
        return (this.content == null ? this.getContentSize() + (long)(this.deadBytes != null ? this.deadBytes.limit() : 0) + 8L : (long)this.content.limit()) < 0x100000000L;
    }

    public void getBox(WritableByteChannel os) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(CastUtils.l2i(this.getSize()));
        this.getHeader(bb);
        if (this.content == null) {
            this.getContent(bb);
            if (this.deadBytes != null) {
                this.deadBytes.rewind();
                while (this.deadBytes.remaining() > 0) {
                    bb.put(this.deadBytes);
                }
            }
        } else {
            this.content.rewind();
            bb.put(this.content);
        }
        bb.rewind();
        os.write(bb);
    }

    protected abstract void getContent(ByteBuffer var1) throws IOException;

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractBox.java", AbstractBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getDeadBytes", "com.coremedia.iso.boxes.AbstractBox", "", "", "", "java.nio.ByteBuffer"), 193);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setDeadBytes", "com.coremedia.iso.boxes.AbstractBox", "java.nio.ByteBuffer", "newDeadBytes", "", "void"), 197);
    }
}

