/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog2.Catalog;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.simpleImpl.ThreddsBuilderFactoryImpl;
import thredds.catalog2.xml.parser.ThreddsXmlParser;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.CatalogElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

public class StaxThreddsXmlParser
implements ThreddsXmlParser {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private CatalogElementParser.Factory catElemParserFactory = new CatalogElementParser.Factory();

    public static StaxThreddsXmlParser newInstance() {
        return new StaxThreddsXmlParser();
    }

    private StaxThreddsXmlParser() {
    }

    private XMLInputFactory getFactory() {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.FALSE);
        return factory;
    }

    private CatalogBuilder readCatalogXML(Source source) throws ThreddsXmlParserException {
        try {
            XMLInputFactory factory = this.getFactory();
            XMLEventReader eventReader = factory.createXMLEventReader(source);
            ThreddsBuilderFactoryImpl catBuilderFac = new ThreddsBuilderFactoryImpl();
            ThreddsBuilder threddsBuilder = null;
            while (eventReader.hasNext()) {
                XMLEvent event = eventReader.peek();
                if (event.isEndDocument()) {
                    eventReader.next();
                    break;
                }
                if (event.isStartDocument()) {
                    eventReader.next();
                    continue;
                }
                if (event.isStartElement()) {
                    if (this.catElemParserFactory.isEventMyStartElement(event.asStartElement())) {
                        CatalogElementParser catElemParser = this.catElemParserFactory.getNewParser(source.getSystemId(), eventReader, catBuilderFac);
                        threddsBuilder = catElemParser.parse();
                        continue;
                    }
                    StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(eventReader);
                    this.log.warn("readCatalogXML(): Unrecognized start element [" + event.asStartElement().getName() + "].");
                    continue;
                }
                if (event.isEndElement()) {
                    this.log.error("readCatalogXML(): Unrecognized end element [" + event.asEndElement().getName() + "].");
                    break;
                }
                this.log.debug("readCatalogXML(): Unhandled event [" + event.getLocation() + "--" + event + "].");
                eventReader.next();
            }
            eventReader.close();
            if (threddsBuilder == null) {
                return null;
            }
            return (CatalogBuilder)threddsBuilder;
        }
        catch (XMLStreamException e) {
            this.log.error("readCatalogXML(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    @Override
    public Catalog parse(URI documentUri) throws ThreddsXmlParserException {
        Source s = StaxThreddsXmlParserUtils.getSourceFromUri(documentUri);
        try {
            return this.readCatalogXML(s).build();
        }
        catch (BuilderException e) {
            this.log.error("parse(): Failed to parse catalog document.", e);
            throw new ThreddsXmlParserException("Failed to parse catalog document.", e);
        }
    }

    @Override
    public Catalog parse(File file, URI docBaseUri) throws ThreddsXmlParserException {
        try {
            return this.parseIntoBuilder(file, docBaseUri).build();
        }
        catch (BuilderException e) {
            this.log.error("parse(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    @Override
    public Catalog parse(Reader reader, URI docBaseUri) throws ThreddsXmlParserException {
        try {
            return this.parseIntoBuilder(reader, docBaseUri).build();
        }
        catch (BuilderException e) {
            this.log.error("parse(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    @Override
    public Catalog parse(InputStream is, URI docBaseUri) throws ThreddsXmlParserException {
        try {
            return this.parseIntoBuilder(is, docBaseUri).build();
        }
        catch (BuilderException e) {
            this.log.error("parse(): Failed to parse catalog document: " + e.getMessage(), e);
            throw new ThreddsXmlParserException("Failed to parse catalog document: " + e.getMessage(), e);
        }
    }

    @Override
    public CatalogBuilder parseIntoBuilder(URI documentUri) throws ThreddsXmlParserException {
        Source s = StaxThreddsXmlParserUtils.getSourceFromUri(documentUri);
        return this.readCatalogXML(s);
    }

    @Override
    public CatalogBuilder parseIntoBuilder(File file, URI docBaseUri) throws ThreddsXmlParserException {
        Source s = StaxThreddsXmlParserUtils.getSourceFromFile(file, docBaseUri);
        return this.readCatalogXML(s);
    }

    @Override
    public CatalogBuilder parseIntoBuilder(Reader reader, URI docBaseUri) throws ThreddsXmlParserException {
        StreamSource source = new StreamSource(reader, docBaseUri.toString());
        return this.readCatalogXML(source);
    }

    @Override
    public CatalogBuilder parseIntoBuilder(InputStream is, URI docBaseUri) throws ThreddsXmlParserException {
        StreamSource source = new StreamSource(is, docBaseUri.toString());
        return this.readCatalogXML(source);
    }
}

