/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso.quality;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.sis.metadata.iso.quality.AbstractResult;
import org.apache.sis.util.iso.Types;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.quality.ConformanceResult;
import org.opengis.util.InternationalString;

@XmlType(name="DQ_ConformanceResult_Type", propOrder={"specification", "explanation", "pass"})
@XmlRootElement(name="DQ_ConformanceResult")
public class DefaultConformanceResult
extends AbstractResult
implements ConformanceResult {
    private static final long serialVersionUID = -2958690684356371311L;
    private Citation specification;
    private InternationalString explanation;
    @XmlElement(name="pass", required=true)
    private Boolean pass;

    public DefaultConformanceResult() {
    }

    public DefaultConformanceResult(Citation citation, CharSequence charSequence, boolean bl) {
        this.specification = citation;
        this.explanation = Types.toInternationalString(charSequence);
        this.pass = bl;
    }

    public DefaultConformanceResult(ConformanceResult conformanceResult) {
        super(conformanceResult);
        if (conformanceResult != null) {
            this.specification = conformanceResult.getSpecification();
            this.explanation = conformanceResult.getExplanation();
            this.pass = conformanceResult.pass();
        }
    }

    public static DefaultConformanceResult castOrCopy(ConformanceResult conformanceResult) {
        if (conformanceResult == null || conformanceResult instanceof DefaultConformanceResult) {
            return (DefaultConformanceResult)conformanceResult;
        }
        return new DefaultConformanceResult(conformanceResult);
    }

    @Override
    @XmlElement(name="specification", required=true)
    public Citation getSpecification() {
        return this.specification;
    }

    public void setSpecification(Citation citation) {
        this.checkWritePermission();
        this.specification = citation;
    }

    @Override
    @XmlElement(name="explanation", required=true)
    public InternationalString getExplanation() {
        return this.explanation;
    }

    public void setExplanation(InternationalString internationalString) {
        this.checkWritePermission();
        this.explanation = internationalString;
    }

    @Override
    public Boolean pass() {
        return this.pass;
    }

    public void setPass(Boolean bl) {
        this.checkWritePermission();
        this.pass = bl;
    }
}

