/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintService;
import javax.print.attribute.standard.OrientationRequested;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class PDPageable
implements Pageable,
Printable {
    private final List<PDPage> pages = new ArrayList<PDPage>();
    private final PrinterJob job;

    public PDPageable(PDDocument document, PrinterJob job) throws IllegalArgumentException, PrinterException {
        if (document == null || job == null) {
            throw new IllegalArgumentException("PDPageable(" + document + ", " + job + ")");
        }
        if (!document.getCurrentAccessPermission().canPrint()) {
            throw new PrinterException("You do not have permission to print this document");
        }
        document.getDocumentCatalog().getPages().getAllKids(this.pages);
        this.job = job;
    }

    public PDPageable(PDDocument document) throws IllegalArgumentException, PrinterException {
        this(document, PrinterJob.getPrinterJob());
    }

    public PrinterJob getPrinterJob() {
        return this.job;
    }

    public int getNumberOfPages() {
        return this.pages.size();
    }

    public PageFormat getPageFormat(int i) throws IndexOutOfBoundsException {
        PageFormat format = this.job.defaultPage();
        PDPage page = this.pages.get(i);
        Dimension media = page.findMediaBox().createDimension();
        Dimension crop = page.findCropBox().createDimension();
        double diffWidth = 0.0;
        double diffHeight = 0.0;
        if (!media.equals(crop)) {
            diffWidth = (media.getWidth() - crop.getWidth()) / 2.0;
            diffHeight = (media.getHeight() - crop.getHeight()) / 2.0;
        }
        Paper paper = format.getPaper();
        PrintService service = this.job.getPrintService();
        Class<OrientationRequested> orientation = OrientationRequested.class;
        if (service != null && service.getDefaultAttributeValue(orientation) == OrientationRequested.LANDSCAPE) {
            format.setOrientation(0);
            paper.setImageableArea(diffHeight, diffWidth, crop.getHeight(), crop.getWidth());
            paper.setSize(media.getHeight(), media.getWidth());
        } else {
            format.setOrientation(1);
            paper.setImageableArea(diffWidth, diffHeight, crop.getWidth(), crop.getHeight());
            paper.setSize(media.getWidth(), media.getHeight());
        }
        format.setPaper(paper);
        return format;
    }

    public Printable getPrintable(int i) throws IndexOutOfBoundsException {
        return this.pages.get(i);
    }

    public int print(Graphics graphics, PageFormat format, int i) throws PrinterException {
        if (0 <= i && i < this.pages.size()) {
            return this.pages.get(i).print(graphics, format, i);
        }
        return 1;
    }
}

