/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.iter;

import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomizingIterator
implements SequenceIterator<AtomicValue> {
    private SequenceIterator base;
    private Value currentValue = null;
    private AtomicValue current = null;
    private int position = 0;
    private int currentValuePosition = 1;
    private int currentValueSize = 1;

    public AtomizingIterator(SequenceIterator base) {
        this.base = base;
    }

    @Override
    public AtomicValue next() throws XPathException {
        block5: {
            Object nextSource;
            while (true) {
                if (this.currentValue != null) {
                    if (this.currentValuePosition < this.currentValueSize) {
                        this.current = (AtomicValue)this.currentValue.itemAt(this.currentValuePosition++);
                        ++this.position;
                        return this.current;
                    }
                    this.currentValue = null;
                }
                if ((nextSource = this.base.next()) == null) break block5;
                if (!(nextSource instanceof NodeInfo)) break;
                Value v = ((NodeInfo)nextSource).atomize();
                if (v instanceof AtomicValue) {
                    this.current = (AtomicValue)v;
                    ++this.position;
                    return (AtomicValue)v;
                }
                this.currentValue = v;
                this.currentValuePosition = 0;
                this.currentValueSize = this.currentValue.getLength();
            }
            if (nextSource instanceof AtomicValue) {
                return (AtomicValue)nextSource;
            }
            throw new XPathException("The typed value of a function item is not defined", "FOTY0013");
        }
        this.currentValue = null;
        this.current = null;
        this.position = -1;
        return null;
    }

    @Override
    public AtomicValue current() {
        return this.current;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public void close() {
        this.base.close();
    }

    @Override
    public SequenceIterator<AtomicValue> getAnother() throws XPathException {
        return new AtomizingIterator(this.base.getAnother());
    }

    @Override
    public int getProperties() {
        return 0;
    }
}

