# $Id: 52-ECDSA-P384.t 1395 2015-09-14 21:16:13Z willem $	-*-perl-*-
#

use strict;
use Test::More;

my @prerequisite = qw(
		Crypt::OpenSSL::Bignum
		Crypt::OpenSSL::EC
		Crypt::OpenSSL::ECDSA
		Digest::SHA
		Net::DNS
		Net::DNS::RR::DNSKEY
		Net::DNS::SEC::Private
		);

foreach my $package (@prerequisite) {
	next if eval "require $package";
	plan skip_all => "$package not installed";
	exit;
}

plan tests => 7;

use_ok('Net::DNS');
use_ok('Net::DNS::SEC::Private');
use_ok('Net::DNS::SEC::ECDSA');


my $key = new Net::DNS::RR <<'END';
ECDSAP384SHA384.example.	IN	DNSKEY	256 3 14 (
	K4t0AhWiJcLZ25BlpvfxCi2KMlkBr14zECH3Y2imMYOzn5zcMpOh0iPbI9Hnfep8L+BBzQrRFNmc
	5r3r0l0y+snHIc/npdK/1Ks0ZG/aMB5r/PfJGeB5MLdtcanFir2S ; Key ID = 25812
	)
END

ok( $key, 'set up ECDSA public key' );


my $keyfile = $key->privatekeyname;

END { unlink($keyfile) }


open( KEY, ">$keyfile" ) or die "$keyfile $!";
print KEY <<'END';
Private-key-format: v1.3
Algorithm: 14 (ECDSAP384SHA384)
PrivateKey: mvuhyr+QDMqo4bpeREFRM2w8qZsBiLiCouR0sihdinvpRA3zA/dByohgH4CLI7Kr
Created: 20141209021155
Publish: 20141209021155
Activate: 20141209021155
END
close(KEY);

my $private = new Net::DNS::SEC::Private($keyfile);
ok( $private, 'set up ECDSA private key' );


my $sigdata = 'arbitrary data';

my $signature = Net::DNS::SEC::ECDSA->sign( $sigdata, $private );
ok( $signature, 'signature created using private key' );


my $validated = Net::DNS::SEC::ECDSA->verify( $sigdata, $key, $signature );
ok( $validated, 'signature validated using public key' );


exit;

__END__

