# Generated by default/object.tt
package Paws::AmplifyBackend::ImportBackendAuthReqObj;
  use Moose;
  has IdentityPoolId => (is => 'ro', isa => 'Str', request_name => 'identityPoolId', traits => ['NameInRequest']);
  has NativeClientId => (is => 'ro', isa => 'Str', request_name => 'nativeClientId', traits => ['NameInRequest'], required => 1);
  has UserPoolId => (is => 'ro', isa => 'Str', request_name => 'userPoolId', traits => ['NameInRequest'], required => 1);
  has WebClientId => (is => 'ro', isa => 'Str', request_name => 'webClientId', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::ImportBackendAuthReqObj

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::ImportBackendAuthReqObj object:

  $service_obj->Method(Att1 => { IdentityPoolId => $value, ..., WebClientId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::ImportBackendAuthReqObj object:

  $result = $service_obj->Method(...);
  $result->Att1->IdentityPoolId

=head1 DESCRIPTION

The request object for this operation.

=head1 ATTRIBUTES


=head2 IdentityPoolId => Str

The ID of the Amazon Cognito identity pool.


=head2 B<REQUIRED> NativeClientId => Str

The ID of the Amazon Cognito native client.


=head2 B<REQUIRED> UserPoolId => Str

The ID of the Amazon Cognito user pool.


=head2 B<REQUIRED> WebClientId => Str

The ID of the Amazon Cognito web client.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

