########################################################################
# test using module with no args (all defaults) for perl version values.
########################################################################
use 5.008;
use strict;
use version;

use Test::More;
use Test::Deep;

use File::Basename  qw( basename    );
use FindBin         qw( $Bin        );

use File::Spec::Functions
qw
(
    &catpath
);

use lib( "$Bin/../lib" );
use Test::KwikHaks;

my $madness = 'Module::FromPerlVer';
my $vers_d  = 't/version';
my $work_d  = eval { Test::KwikHaks::work_dir }
or BAIL_OUT "Failed create tmpdir: $@";

my ( $base, $perl_v )  
= eval
{
    Test::KwikHaks::perl_v_from_basename()
}
or BAIL_OUT "Missing Perl Version: $@";

local $ENV{ PERL_VERSION } = $perl_v;

eval
{
    use_ok $madness =>
    dest_dir    => $work_d,
    version_dir => $vers_d,
    ;

    1
}
or BAIL_OUT "Use failed: $@";

for my $found ( $madness->version_dir )
{
    # no telling what the path looks 
    # like on Windows. existing path
    # with a matching basename is
    # probably the best we can do.

    ok -e $found, "Existing directory: '$found'";

    my $base0   = basename $vers_d;
    my $base1   = basename $found;

    is $base1, $base0, "Source dir is: '$found' ($base)";
}

for my $found ( scalar $madness->source_paths )
{
    note "Source files:\n", explain $found;

    @$found
    ? pass 'Found source files in version directory'
    : fail 'Missing source files for cleanup'
    ;
}

for my $expect ( scalar $madness->dest_paths )
{
    note "Dest files:\n", explain $expect;

    for( @$expect )
    {
        ok -e, "Found: '$_' ($work_d)";
    }
}

eval
{
    $madness->cleanup;

    pass "Survived cleanup.";
}
or 
fail "Failed cleanup: $@";

done_testing;
__END__
