#!/usr/bin/env perl
package DRTestBasics;
use v5.24;
use warnings;
use experimental 'signatures';
use Exporter 'import';
our @EXPORT_OK = qw< child parent sibling >;
use File::Basename ();
use File::Spec ();

sub child ($parent, $name) {
   my @name = split m{/}mxs, $name;
   $name = pop @name;
   my ($v, $dirs) = File::Spec->splitpath($parent, 'no-file');
   $dirs = File::Spec->catdir(File::Spec->splitdir($dirs), @name);
   return File::Spec->catpath($v, $dirs, $name);
}

sub parent ($reference) { File::Basename::dirname($reference) }

sub sibling ($reference, $name) { child(parent($reference), $name) }

1;
