/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.wikibrowser;

import com.touchgraph.graphlayout.TGPanel;
import com.touchgraph.graphlayout.interaction.DragNodeUI;
import com.touchgraph.graphlayout.interaction.TGAbstractClickUI;
import com.touchgraph.graphlayout.interaction.TGAbstractDragUI;
import com.touchgraph.graphlayout.interaction.TGUserInterface;
import com.touchgraph.wikibrowser.TGWikiBrowser;
import com.touchgraph.wikibrowser.WikiEdge;
import com.touchgraph.wikibrowser.WikiNode;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class WikiNavigateUI
extends TGUserInterface {
    TGPanel tgPanel;
    TGWikiBrowser tgWikiBrowser;
    WikiNavigateMouseListener ml;
    WikiNavigateMouseMotionListener mml;
    TGAbstractDragUI hvDragUI;
    TGAbstractClickUI hvScrollToCenterUI;
    DragNodeUI dragNodeUI;
    JPopupMenu nodePopup;
    JPopupMenu edgePopup;
    WikiNode popupNode;
    WikiEdge popupEdge;

    public WikiNavigateUI(TGWikiBrowser tGWikiBrowser) {
        this.tgWikiBrowser = tGWikiBrowser;
        this.tgPanel = this.tgWikiBrowser.getTGPanel();
        this.hvDragUI = this.tgWikiBrowser.hvScroll.getHVDragUI();
        this.hvScrollToCenterUI = this.tgWikiBrowser.hvScroll.getHVScrollToCenterUI();
        this.dragNodeUI = new DragNodeUI(this.tgPanel);
        this.ml = new WikiNavigateMouseListener();
        this.mml = new WikiNavigateMouseMotionListener();
        this.setUpNodePopup();
        this.setUpEdgePopup();
    }

    public void activate() {
        this.tgPanel.addMouseListener(this.ml);
        this.tgPanel.addMouseMotionListener(this.mml);
    }

    public void deactivate() {
        this.tgPanel.removeMouseListener(this.ml);
        this.tgPanel.removeMouseMotionListener(this.mml);
    }

    private void setUpNodePopup() {
        this.nodePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Expand Node");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WikiNavigateUI.this.popupNode != null) {
                    WikiNavigateUI.this.tgPanel.expandNode(WikiNavigateUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.nodePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Collapse Node");
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WikiNavigateUI.this.popupNode != null) {
                    WikiNavigateUI.this.tgPanel.collapseNode(WikiNavigateUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener2);
        this.nodePopup.add(jMenuItem);
        jMenuItem = new JMenuItem("Hide Node");
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WikiNavigateUI.this.popupNode != null) {
                    WikiNavigateUI.this.tgPanel.hideNode(WikiNavigateUI.this.popupNode);
                }
            }
        };
        jMenuItem.addActionListener(actionListener3);
        this.nodePopup.add(jMenuItem);
        this.nodePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                WikiNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                WikiNavigateUI.this.tgPanel.setMouseOverN(null);
                WikiNavigateUI.this.tgPanel.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    private void setUpEdgePopup() {
        this.edgePopup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Hide Edge");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WikiNavigateUI.this.popupEdge != null) {
                    WikiNavigateUI.this.tgPanel.hideEdge(WikiNavigateUI.this.popupEdge);
                }
            }
        };
        jMenuItem.addActionListener(actionListener);
        this.edgePopup.add(jMenuItem);
        this.edgePopup.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                WikiNavigateUI.this.tgPanel.setMaintainMouseOver(false);
                WikiNavigateUI.this.tgPanel.setMouseOverE(null);
                WikiNavigateUI.this.tgPanel.repaint();
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }
        });
    }

    class WikiNavigateMouseMotionListener
    extends MouseMotionAdapter {
        WikiNavigateMouseMotionListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            WikiNode wikiNode = (WikiNode)WikiNavigateUI.this.tgPanel.getMouseOverN();
            if (wikiNode != null) {
                WikiNavigateUI.this.tgPanel.setCursor(new Cursor(12));
                WikiNavigateUI.this.tgWikiBrowser.statusButton.setText(wikiNode.getURL());
            } else {
                WikiNavigateUI.this.tgPanel.setCursor(null);
                WikiNavigateUI.this.tgWikiBrowser.statusButton.setText(WikiNavigateUI.this.tgWikiBrowser.textPaneURL);
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            WikiNode wikiNode = (WikiNode)WikiNavigateUI.this.tgPanel.getMouseOverN();
            if (wikiNode != null) {
                WikiNavigateUI.this.tgPanel.setCursor(new Cursor(0));
                WikiNavigateUI.this.tgWikiBrowser.statusButton.setText(wikiNode.getURL());
            } else {
                WikiNavigateUI.this.tgPanel.setCursor(new Cursor(13));
                WikiNavigateUI.this.tgWikiBrowser.statusButton.setText(WikiNavigateUI.this.tgWikiBrowser.textPaneURL);
            }
        }
    }

    class WikiNavigateMouseListener
    extends MouseAdapter {
        WikiNavigateMouseListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.triggerPopup(mouseEvent);
            } else {
                WikiNode wikiNode = (WikiNode)WikiNavigateUI.this.tgPanel.getMouseOverN();
                if (mouseEvent.getModifiers() == 16) {
                    if (wikiNode == null) {
                        WikiNavigateUI.this.hvDragUI.activate(mouseEvent);
                    } else {
                        WikiNavigateUI.this.dragNodeUI.activate(mouseEvent);
                    }
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            WikiNode wikiNode = (WikiNode)WikiNavigateUI.this.tgPanel.getMouseOverN();
            WikiNode wikiNode2 = (WikiNode)WikiNavigateUI.this.tgPanel.getSelect();
            if ((mouseEvent.getModifiers() & 0x10) != 0 && wikiNode != null) {
                if (mouseEvent.getClickCount() == 1) {
                    WikiNavigateUI.this.tgWikiBrowser.setWikiTextPane(wikiNode);
                    WikiNavigateUI.this.tgPanel.setSelect(wikiNode);
                } else {
                    WikiNavigateUI.this.tgPanel.setSelect(wikiNode);
                    WikiNavigateUI.this.tgWikiBrowser.setLocale(wikiNode);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                this.triggerPopup(mouseEvent);
            }
        }

        public void triggerPopup(MouseEvent mouseEvent) {
            WikiNavigateUI.this.popupNode = (WikiNode)WikiNavigateUI.this.tgPanel.getMouseOverN();
            WikiNavigateUI.this.popupEdge = (WikiEdge)WikiNavigateUI.this.tgPanel.getMouseOverE();
            if (WikiNavigateUI.this.popupNode != null) {
                WikiNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                WikiNavigateUI.this.nodePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (WikiNavigateUI.this.popupEdge != null) {
                WikiNavigateUI.this.tgPanel.setMaintainMouseOver(true);
                WikiNavigateUI.this.edgePopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else {
                WikiNavigateUI.this.tgWikiBrowser.wikiPopup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }
}

