# Generated by default/object.tt
package Paws::SageMaker::Endpoint;
  use Moose;
  has CreationTime => (is => 'ro', isa => 'Str', required => 1);
  has DataCaptureConfig => (is => 'ro', isa => 'Paws::SageMaker::DataCaptureConfigSummary');
  has EndpointArn => (is => 'ro', isa => 'Str', required => 1);
  has EndpointConfigName => (is => 'ro', isa => 'Str', required => 1);
  has EndpointName => (is => 'ro', isa => 'Str', required => 1);
  has EndpointStatus => (is => 'ro', isa => 'Str', required => 1);
  has FailureReason => (is => 'ro', isa => 'Str');
  has LastModifiedTime => (is => 'ro', isa => 'Str', required => 1);
  has MonitoringSchedules => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::MonitoringSchedule]');
  has ProductionVariants => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::ProductionVariantSummary]');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::SageMaker::Tag]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::Endpoint

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::Endpoint object:

  $service_obj->Method(Att1 => { CreationTime => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::Endpoint object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTime

=head1 DESCRIPTION

A hosted endpoint for real-time inference.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CreationTime => Str

The time that the endpoint was created.


=head2 DataCaptureConfig => L<Paws::SageMaker::DataCaptureConfigSummary>




=head2 B<REQUIRED> EndpointArn => Str

The Amazon Resource Name (ARN) of the endpoint.


=head2 B<REQUIRED> EndpointConfigName => Str

The endpoint configuration associated with the endpoint.


=head2 B<REQUIRED> EndpointName => Str

The name of the endpoint.


=head2 B<REQUIRED> EndpointStatus => Str

The status of the endpoint.


=head2 FailureReason => Str

If the endpoint failed, the reason it failed.


=head2 B<REQUIRED> LastModifiedTime => Str

The last time the endpoint was modified.


=head2 MonitoringSchedules => ArrayRef[L<Paws::SageMaker::MonitoringSchedule>]

A list of monitoring schedules for the endpoint. For information about
model monitoring, see Amazon SageMaker Model Monitor
(https://docs.aws.amazon.com/sagemaker/latest/dg/model-monitor.html).


=head2 ProductionVariants => ArrayRef[L<Paws::SageMaker::ProductionVariantSummary>]

A list of the production variants hosted on the endpoint. Each
production variant is a model.


=head2 Tags => ArrayRef[L<Paws::SageMaker::Tag>]

A list of the tags associated with the endpoint. For more information,
see Tagging Amazon Web Services resources
(https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html) in the
I<Amazon Web Services General Reference Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

