# Generated by default/object.tt
package Paws::Kendra::OneDriveConfiguration;
  use Moose;
  has DisableLocalGroups => (is => 'ro', isa => 'Bool');
  has ExclusionPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has FieldMappings => (is => 'ro', isa => 'ArrayRef[Paws::Kendra::DataSourceToIndexFieldMapping]');
  has InclusionPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has OneDriveUsers => (is => 'ro', isa => 'Paws::Kendra::OneDriveUsers', required => 1);
  has SecretArn => (is => 'ro', isa => 'Str', required => 1);
  has TenantDomain => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::OneDriveConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::OneDriveConfiguration object:

  $service_obj->Method(Att1 => { DisableLocalGroups => $value, ..., TenantDomain => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::OneDriveConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DisableLocalGroups

=head1 DESCRIPTION

Provides configuration information for data sources that connect to
OneDrive.

=head1 ATTRIBUTES


=head2 DisableLocalGroups => Bool

A Boolean value that specifies whether local groups are disabled
(C<True>) or enabled (C<False>).


=head2 ExclusionPatterns => ArrayRef[Str|Undef]

List of regular expressions applied to documents. Items that match the
exclusion pattern are not indexed. If you provide both an inclusion
pattern and an exclusion pattern, any item that matches the exclusion
pattern isn't indexed.

The exclusion pattern is applied to the file name.


=head2 FieldMappings => ArrayRef[L<Paws::Kendra::DataSourceToIndexFieldMapping>]

A list of C<DataSourceToIndexFieldMapping> objects that map Microsoft
OneDrive fields to custom fields in the Amazon Kendra index. You must
first create the index fields before you map OneDrive fields.


=head2 InclusionPatterns => ArrayRef[Str|Undef]

A list of regular expression patterns. Documents that match the pattern
are included in the index. Documents that don't match the pattern are
excluded from the index. If a document matches both an inclusion
pattern and an exclusion pattern, the document is not included in the
index.

The exclusion pattern is applied to the file name.


=head2 B<REQUIRED> OneDriveUsers => L<Paws::Kendra::OneDriveUsers>

A list of user accounts whose documents should be indexed.


=head2 B<REQUIRED> SecretArn => Str

The Amazon Resource Name (ARN) of an AWS Secrets Manager secret that
contains the user name and password to connect to OneDrive. The user
namd should be the application ID for the OneDrive application, and the
password is the application key for the OneDrive application.


=head2 B<REQUIRED> TenantDomain => Str

The Azure Active Directory domain of the organization.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

