# Generated by default/object.tt
package Paws::CloudFront::QueryStringNames;
  use Moose;
  has Items => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'Name', traits => ['NameInRequest']);
  has Quantity => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::QueryStringNames

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::QueryStringNames object:

  $service_obj->Method(Att1 => { Items => $value, ..., Quantity => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::QueryStringNames object:

  $result = $service_obj->Method(...);
  $result->Att1->Items

=head1 DESCRIPTION

Contains a list of query string names.

=head1 ATTRIBUTES


=head2 Items => ArrayRef[Str|Undef]

A list of query string names.


=head2 B<REQUIRED> Quantity => Int

The number of query string names in the C<Items> list.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

