use ExtUtils::MakeMaker;

die "This module requires OpenVMS" unless $^O =~ /VMS/;

die "This module requires DEC CMS" unless -f 'sys$share:cmsshr.exe';

WriteMakefile(
    NAME              => 'VMS::CMS',
    LICENSE	      => 'Artistic_2',
    VERSION_FROM      => 'lib/VMS/CMS.pm', # finds $VERSION
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/VMS/CMS.pm', # retrieve abstract from module
       AUTHOR         => 'Thomas Pfau <tfpfau@gmail.com>') : ()),
    LIBS              => [''], # e.g., '-lm'
    DEFINE            => '', # e.g., '-DHAVE_SOMETHING'
    INC               => '-I.', # e.g., '-I. -I/usr/include/other'
	# Un-comment this if you add C files to link with later:
    # OBJECT            => '$(O_FILES)', # link all the C files too
    CCFLAGS           => "/include=[]/standard=relaxed_ansi/prefix=all/obj=.obj/noshare_globals"
);
if  (eval {require ExtUtils::Constant; 1}) {
  # If you edit these definitions to change the constants used by this module,
  # you will need to use the generated const-c.inc and const-xs.inc
  # files to replace their "fallback" counterparts before distributing your
  # changes.
  my @names = (
            { name=>'CMS_K_ACCEPT',         value=>'CMS$K_ACCEPT',
              macro=>'CMS$K_ACCEPT' },
            { name=>'CMS_K_ACL_CLASS',      value=>'CMS$K_ACL_CLASS',
              macro=>'CMS$K_ACL_CLASS' },
            { name=>'CMS_K_ACL_COMMAND',    value=>'CMS$K_ACL_COMMAND',
              macro=>'CMS$K_ACL_COMMAND' },
            { name=>'CMS_K_ACL_ELEMENT',    value=>'CMS$K_ACL_ELEMENT',
              macro=>'CMS$K_ACL_ELEMENT' },
            { name=>'CMS_K_ACL_GROUP',      value=>'CMS$K_ACL_GROUP',
              macro=>'CMS$K_ACL_GROUP' },
            { name=>'CMS_K_ACL_LIBRARY',    value=>'CMS$K_ACL_LIBRARY',
              macro=>'CMS$K_ACL_LIBRARY' },
            { name=>'CMS_M_ASCII',          value=>'CMS$K_ASCII',
	      macro=>'CMS$K_ASCII' },
            { name=>'CMS_M_DECIMAL',        value=>'CMS$K_DECIMAL',
	      macro=>'CMS$K_DECIMAL' },
            { name=>'CMS_M_HEXADECIMAL',    value=>'CMS$K_HEXADECIMAL',
	      macro=>'CMS$K_HEXADECIMAL' },
            { name=>'CMS_M_OCTAL',          value=>'CMS$K_OCTAL',
	      macro=>'CMS$K_OCTAL' },
            { name=>'CMS_M_BYTE',           value=>'CMS$K_BYTE',
	      macro=>'CMS$K_BYTE' },
            { name=>'CMS_M_LONGWORD',       value=>'CMS$K_LONGWORD',
	      macro=>'CMS$K_LONGWORD' },
            { name=>'CMS_M_RECORDS',        value=>'CMS$K_RECORDS',
	      macro=>'CMS$K_RECORDS' },
            { name=>'CMS_M_WORD',           value=>'CMS$K_WORD',
	      macro=>'CMS$K_WORD' },
            { name=>'CMS_M_GENERATION_DIF', value=>'CMS$K_GENERATION_DIF',
	      macro=>'CMS$K_GENERATION_DIF' },
            { name=>'CMS_M_CMD_COPY',       value=>'CMS$K_CMD_COPY',
	      macro=>'CMS$K_CMD_COPY' },
            { name=>'CMS_M_CMD_CREATE',     value=>'CMS$K_CMD_CREATE',
	      macro=>'CMS$K_CMD_CREATE' },
            { name=>'CMS_M_CMD_DELETE',     value=>'CMS$K_CMD_DELETE',
	      macro=>'CMS$K_CMD_DELETE' },
            { name=>'CMS_M_CMD_FETCH',      value=>'CMS$K_CMD_FETCH',
	      macro=>'CMS$K_CMD_FETCH' },
            { name=>'CMS_M_CMD_INSERT',     value=>'CMS$K_CMD_INSERT',
	      macro=>'CMS$K_CMD_INSERT' },
            { name=>'CMS_M_CMD_MODIFY',     value=>'CMS$K_CMD_MODIFY',
	      macro=>'CMS$K_CMD_MODIFY' },
            { name=>'CMS_M_CMD_REMARK',     value=>'CMS$K_CMD_REMARK',
	      macro=>'CMS$K_CMD_REMARK' },
            { name=>'CMS_M_CMD_REMOVE',     value=>'CMS$K_CMD_REMOVE',
	      macro=>'CMS$K_CMD_REMOVE' },
            { name=>'CMS_M_CMD_REPLACE',    value=>'CMS$K_CMD_REPLACE',
	      macro=>'CMS$K_CMD_REPLACE' },
            { name=>'CMS_M_CMD_RESERVE',    value=>'CMS$K_CMD_RESERVE',
	      macro=>'CMS$K_CMD_RESERVE' },
            { name=>'CMS_M_CMD_UNRESERVE',  value=>'CMS$K_CMD_UNRESERVE',
	      macro=>'CMS$K_CMD_UNRESERVE' },
            { name=>'CMS_M_CMD_VERIFY',     value=>'CMS$K_CMD_VERIFY',
	      macro=>'CMS$K_CMD_VERIFY' },
            { name=>'CMS_M_CMD_SET',        value=>'CMS$K_CMD_SET',
	      macro=>'CMS$K_CMD_SET' },
            { name=>'CMS_M_CMD_ACCEPT',     value=>'CMS$K_CMD_ACCEPT',
	      macro=>'CMS$K_CMD_ACCEPT' },
            { name=>'CMS_M_CMD_CANCEL',     value=>'CMS$K_CMD_CANCEL',
	      macro=>'CMS$K_CMD_CANCEL' },
            { name=>'CMS_M_CMD_MARK',       value=>'CMS$K_CMD_MARK',
	      macro=>'CMS$K_CMD_MARK' },
            { name=>'CMS_M_CMD_REJECT',     value=>'CMS$K_CMD_REJECT',
	      macro=>'CMS$K_CMD_REJECT' },
            { name=>'CMS_M_CMD_REVIEW_',    value=>'CMS$K_CMD_REVIEW',
	      macro=>'CMS$K_CMD_REVIEW' },
            { name=>'CMS_K_AFTER',          value=>'CMS$K_AFTER',
              macro=>'CMS$K_AFTER' },
            { name=>'CMS_K_BEFORE',         value=>'CMS$K_BEFORE',
              macro=>'CMS$K_BEFORE' },
            { name=>'CMS_K_CANCEL',         value=>'CMS$K_CANCEL',
              macro=>'CMS$K_CANCEL' },
            { name=>'CMS_K_MARK',           value=>'CMS$K_MARK',
              macro=>'CMS$K_MARK' },
            { name=>'CMS_K_REJECT',         value=>'CMS$K_REJECT',
              macro=>'CMS$K_REJECT' },
            { name=>'CMS_K_REVIEW',         value=>'CMS$K_REVIEW',
              macro=>'CMS$K_REVIEW' },
            { name=>'CMS_K_SUPERSEDE',      value=>'CMS$K_SUPERSEDE',
              macro=>'CMS$K_SUPERSEDE' },
            { name=>'CMS_M_ELEMENT_DIF',    value=>'CMS$M_ELEMENT_DIF',
              macro=>'CMS$M_ELEMENT_DIF' },
            { name=>'CMS_M_GENERATIONAL_DIF', value=>'CMS$M_GENERATIONAL_DIF',
              macro=>'CMS$M_GENERATIONAL_DIF' },
            { name=>'CMS_M_IGNORE_CASE',    value=>'CMS$M_IGNORE_CASE',
              macro=>'CMS$M_IGNORE_CASE' },
            { name=>'CMS_M_IGNORE_FIRST_VARIANT', value=>'CMS$M_IGNORE_FIRST_VARIANT',
              macro=>'CMS$M_IGNORE_FIRST_VARIANT' },
            { name=>'CMS_M_IGNORE_FORM',    value=>'CMS$M_IGNORE_FORM',
              macro=>'CMS$M_IGNORE_FORM' },
            { name=>'CMS_M_IGNORE_HISTORY', value=>'CMS$M_IGNORE_HISTORY',
              macro=>'CMS$M_IGNORE_HISTORY' },
            { name=>'CMS_M_IGNORE_LEAD',    value=>'CMS$M_IGNORE_LEAD',
              macro=>'CMS$M_IGNORE_LEAD' },
            { name=>'CMS_M_IGNORE_NOTES',   value=>'CMS$M_IGNORE_NOTES',
              macro=>'CMS$M_IGNORE_NOTES' },
            { name=>'CMS_M_IGNORE_SPACE',   value=>'CMS$M_IGNORE_SPACE',
              macro=>'CMS$M_IGNORE_SPACE' },
            { name=>'CMS_M_IGNORE_TRAIL',   value=>'CMS$M_IGNORE_TRAIL',
              macro=>'CMS$M_IGNORE_TRAIL' },
            { name=>'CMS_M_VARIANT_DIF',    value=>'CMS$M_VARIANT_DIF',
              macro=>'CMS$M_VARIANT_DIF' },
            { name=>'CMS__ABSTIM',          value=>'CMS$_ABSTIM',
              macro=>'CMS$_ABSTIM' },
            { name=>'CMS__ACCEPTANCES',     value=>'CMS$_ACCEPTANCES',
              macro=>'CMS$_ACCEPTANCES' },
            { name=>'CMS__ACCEPTED',        value=>'CMS$_ACCEPTED',
              macro=>'CMS$_ACCEPTED' },
            { name=>'CMS__ACCVIORD',        value=>'CMS$_ACCVIORD',
              macro=>'CMS$_ACCVIORD' },
            { name=>'CMS__ACCVIOWT',        value=>'CMS$_ACCVIOWT',
              macro=>'CMS$_ACCVIOWT' },
            { name=>'CMS__ALL',             value=>'CMS$_ALL',
              macro=>'CMS$_ALL' },
            { name=>'CMS__ALPHACHAR',       value=>'CMS$_ALPHACHAR',
              macro=>'CMS$_ALPHACHAR' },
            { name=>'CMS__ALRDYEXISTS',     value=>'CMS$_ALRDYEXISTS',
              macro=>'CMS$_ALRDYEXISTS' },
            { name=>'CMS__ALRDYINCLS',      value=>'CMS$_ALRDYINCLS',
              macro=>'CMS$_ALRDYINCLS' },
            { name=>'CMS__ALRDYINGRP',      value=>'CMS$_ALRDYINGRP',
              macro=>'CMS$_ALRDYINGRP' },
            { name=>'CMS__ALRDYMARKED',     value=>'CMS$_ALRDYMARKED',
              macro=>'CMS$_ALRDYMARKED' },
            { name=>'CMS__ANNOTATED',       value=>'CMS$_ANNOTATED',
              macro=>'CMS$_ANNOTATED' },
            { name=>'CMS__ANNOTATIONS',     value=>'CMS$_ANNOTATIONS',
              macro=>'CMS$_ANNOTATIONS' },
            { name=>'CMS__ANNSIGNAL',       value=>'CMS$_ANNSIGNAL',
              macro=>'CMS$_ANNSIGNAL' },
            { name=>'CMS__ARGCONFLICT',     value=>'CMS$_ARGCONFLICT',
              macro=>'CMS$_ARGCONFLICT' },
            { name=>'CMS__ARGCOUNTERR',     value=>'CMS$_ARGCOUNTERR',
              macro=>'CMS$_ARGCOUNTERR' },
            { name=>'CMS__AUTOREC',         value=>'CMS$_AUTOREC',
              macro=>'CMS$_AUTOREC' },
            { name=>'CMS__AUTORECSUC',      value=>'CMS$_AUTORECSUC',
              macro=>'CMS$_AUTORECSUC' },
            { name=>'CMS__BADBUG',          value=>'CMS$_BADBUG',
              macro=>'CMS$_BADBUG' },
            { name=>'CMS__BADCALL',         value=>'CMS$_BADCALL',
              macro=>'CMS$_BADCALL' },
            { name=>'CMS__BADCRC',          value=>'CMS$_BADCRC',
              macro=>'CMS$_BADCRC' },
            { name=>'CMS__BADCRETIME',      value=>'CMS$_BADCRETIME',
              macro=>'CMS$_BADCRETIME' },
            { name=>'CMS__BADFORMAT',       value=>'CMS$_BADFORMAT',
              macro=>'CMS$_BADFORMAT' },
            { name=>'CMS__BADLENSTR',       value=>'CMS$_BADLENSTR',
              macro=>'CMS$_BADLENSTR' },
            { name=>'CMS__BADLIB',          value=>'CMS$_BADLIB',
              macro=>'CMS$_BADLIB' },
            { name=>'CMS__BADLST',          value=>'CMS$_BADLST',
              macro=>'CMS$_BADLST' },
            { name=>'CMS__BADLSTSTR',       value=>'CMS$_BADLSTSTR',
              macro=>'CMS$_BADLSTSTR' },
            { name=>'CMS__BADORDSTR',       value=>'CMS$_BADORDSTR',
              macro=>'CMS$_BADORDSTR' },
            { name=>'CMS__BADPTR',          value=>'CMS$_BADPTR',
              macro=>'CMS$_BADPTR' },
            { name=>'CMS__BADREF',          value=>'CMS$_BADREF',
              macro=>'CMS$_BADREF' },
            { name=>'CMS__BADREFHDR',       value=>'CMS$_BADREFHDR',
              macro=>'CMS$_BADREFHDR' },
            { name=>'CMS__BADSTRING',       value=>'CMS$_BADSTRING',
              macro=>'CMS$_BADSTRING' },
            { name=>'CMS__BADTYPSTR',       value=>'CMS$_BADTYPSTR',
              macro=>'CMS$_BADTYPSTR' },
            { name=>'CMS__BADVERSION',      value=>'CMS$_BADVERSION',
              macro=>'CMS$_BADVERSION' },
            { name=>'CMS__BADVERSTR',       value=>'CMS$_BADVERSTR',
              macro=>'CMS$_BADVERSTR' },
            { name=>'CMS__BCKPTRSTR',       value=>'CMS$_BCKPTRSTR',
              macro=>'CMS$_BCKPTRSTR' },
            { name=>'CMS__BUG',             value=>'CMS$_BUG',
              macro=>'CMS$_BUG' },
            { name=>'CMS__CANCELATIONS',    value=>'CMS$_CANCELATIONS',
              macro=>'CMS$_CANCELATIONS' },
            { name=>'CMS__CANCELED',        value=>'CMS$_CANCELED',
              macro=>'CMS$_CANCELED' },
            { name=>'CMS__CLASSGENEXP',     value=>'CMS$_CLASSGENEXP',
              macro=>'CMS$_CLASSGENEXP' },
            { name=>'CMS__CMPSIGNAL',       value=>'CMS$_CMPSIGNAL',
              macro=>'CMS$_CMPSIGNAL' },
            { name=>'CMS__CNTSTR',          value=>'CMS$_CNTSTR',
              macro=>'CMS$_CNTSTR' },
            { name=>'CMS__COMPARED',        value=>'CMS$_COMPARED',
              macro=>'CMS$_COMPARED' },
            { name=>'CMS__CONCLS',          value=>'CMS$_CONCLS',
              macro=>'CMS$_CONCLS' },
            { name=>'CMS__CONCURRENT',      value=>'CMS$_CONCURRENT',
              macro=>'CMS$_CONCURRENT' },
            { name=>'CMS__CONELE',          value=>'CMS$_CONELE',
              macro=>'CMS$_CONELE' },
            { name=>'CMS__CONFIRM',         value=>'CMS$_CONFIRM',
              macro=>'CMS$_CONFIRM' },
            { name=>'CMS__CONFLICTS',       value=>'CMS$_CONFLICTS',
              macro=>'CMS$_CONFLICTS' },
            { name=>'CMS__CONGRP',          value=>'CMS$_CONGRP',
              macro=>'CMS$_CONGRP' },
            { name=>'CMS__CONHIS',          value=>'CMS$_CONHIS',
              macro=>'CMS$_CONHIS' },
            { name=>'CMS__CONRES',          value=>'CMS$_CONRES',
              macro=>'CMS$_CONRES' },
            { name=>'CMS__CONTROLC',        value=>'CMS$_CONTROLC',
              macro=>'CMS$_CONTROLC' },
            { name=>'CMS__CONVERTED',       value=>'CMS$_CONVERTED',
              macro=>'CMS$_CONVERTED' },
            { name=>'CMS__CONVERTLIB',      value=>'CMS$_CONVERTLIB',
              macro=>'CMS$_CONVERTLIB' },
            { name=>'CMS__CONVNOTNEC',      value=>'CMS$_CONVNOTNEC',
              macro=>'CMS$_CONVNOTNEC' },
            { name=>'CMS__COPIED',          value=>'CMS$_COPIED',
              macro=>'CMS$_COPIED' },
            { name=>'CMS__COPIES',          value=>'CMS$_COPIES',
              macro=>'CMS$_COPIES' },
            { name=>'CMS__CREATED',         value=>'CMS$_CREATED',
              macro=>'CMS$_CREATED' },
            { name=>'CMS__CREATES',         value=>'CMS$_CREATES',
              macro=>'CMS$_CREATES' },
            { name=>'CMS__DEFAULTDIR',      value=>'CMS$_DEFAULTDIR',
              macro=>'CMS$_DEFAULTDIR' },
            { name=>'CMS__DELETED',         value=>'CMS$_DELETED',
              macro=>'CMS$_DELETED' },
            { name=>'CMS__DELETIONS',       value=>'CMS$_DELETIONS',
              macro=>'CMS$_DELETIONS' },
            { name=>'CMS__DIFFCLASS',       value=>'CMS$_DIFFCLASS',
              macro=>'CMS$_DIFFCLASS' },
            { name=>'CMS__DIFFERENT',       value=>'CMS$_DIFFERENT',
              macro=>'CMS$_DIFFERENT' },
            { name=>'CMS__DUPEDF',          value=>'CMS$_DUPEDF',
              macro=>'CMS$_DUPEDF' },
            { name=>'CMS__DUPREF',          value=>'CMS$_DUPREF',
              macro=>'CMS$_DUPREF' },
            { name=>'CMS__EDFINWRONGDIR',   value=>'CMS$_EDFINWRONGDIR',
              macro=>'CMS$_EDFINWRONGDIR' },
            { name=>'CMS__EDFMISS',         value=>'CMS$_EDFMISS',
              macro=>'CMS$_EDFMISS' },
            { name=>'CMS__ELEEXISTS',       value=>'CMS$_ELEEXISTS',
              macro=>'CMS$_ELEEXISTS' },
            { name=>'CMS__ELEEXP',          value=>'CMS$_ELEEXP',
              macro=>'CMS$_ELEEXP' },
            { name=>'CMS__ELEMULTRES',      value=>'CMS$_ELEMULTRES',
              macro=>'CMS$_ELEMULTRES' },
            { name=>'CMS__ELEXPIGN',        value=>'CMS$_ELEXPIGN',
              macro=>'CMS$_ELEXPIGN' },
            { name=>'CMS__ENDOFLIST',       value=>'CMS$_ENDOFLIST',
              macro=>'CMS$_ENDOFLIST' },
            { name=>'CMS__ENDPTRSTR',       value=>'CMS$_ENDPTRSTR',
              macro=>'CMS$_ENDPTRSTR' },
            { name=>'CMS__EOF',             value=>'CMS$_EOF',
              macro=>'CMS$_EOF' },
            { name=>'CMS__ERRACCEPTANCES',  value=>'CMS$_ERRACCEPTANCES',
              macro=>'CMS$_ERRACCEPTANCES' },
            { name=>'CMS__ERRANNOTATIONS',  value=>'CMS$_ERRANNOTATIONS',
              macro=>'CMS$_ERRANNOTATIONS' },
            { name=>'CMS__ERRCANCELATIONS', value=>'CMS$_ERRCANCELATIONS',
              macro=>'CMS$_ERRCANCELATIONS' },
            { name=>'CMS__ERRCLOSE',        value=>'CMS$_ERRCLOSE',
              macro=>'CMS$_ERRCLOSE' },
            { name=>'CMS__ERRCOPIES',       value=>'CMS$_ERRCOPIES',
              macro=>'CMS$_ERRCOPIES' },
            { name=>'CMS__ERRCREATES',      value=>'CMS$_ERRCREATES',
              macro=>'CMS$_ERRCREATES' },
            { name=>'CMS__ERRDELETIONS',    value=>'CMS$_ERRDELETIONS',
              macro=>'CMS$_ERRDELETIONS' },
            { name=>'CMS__ERRELEHIS',       value=>'CMS$_ERRELEHIS',
              macro=>'CMS$_ERRELEHIS' },
            { name=>'CMS__ERREMOVALS',      value=>'CMS$_ERREMOVALS',
              macro=>'CMS$_ERREMOVALS' },
            { name=>'CMS__ERREPLACEMENTS',  value=>'CMS$_ERREPLACEMENTS',
              macro=>'CMS$_ERREPLACEMENTS' },
            { name=>'CMS__ERRESERVATIONS',  value=>'CMS$_ERRESERVATIONS',
              macro=>'CMS$_ERRESERVATIONS' },
            { name=>'CMS__ERRETRIEVALS',    value=>'CMS$_ERRETRIEVALS',
              macro=>'CMS$_ERRETRIEVALS' },
            { name=>'CMS__ERRFETCHES',      value=>'CMS$_ERRFETCHES',
              macro=>'CMS$_ERRFETCHES' },
            { name=>'CMS__ERRGENDELETIONS', value=>'CMS$_ERRGENDELETIONS',
              macro=>'CMS$_ERRGENDELETIONS' },
            { name=>'CMS__ERRHISLINE',      value=>'CMS$_ERRHISLINE',
              macro=>'CMS$_ERRHISLINE' },
            { name=>'CMS__ERRINSERTIONS',   value=>'CMS$_ERRINSERTIONS',
              macro=>'CMS$_ERRINSERTIONS' },
            { name=>'CMS__ERRMARKS',        value=>'CMS$_ERRMARKS',
              macro=>'CMS$_ERRMARKS' },
            { name=>'CMS__ERRMODACLS',      value=>'CMS$_ERRMODACLS',
              macro=>'CMS$_ERRMODACLS' },
            { name=>'CMS__ERRMODIFIES',     value=>'CMS$_ERRMODIFIES',
              macro=>'CMS$_ERRMODIFIES' },
            { name=>'CMS__ERRPAREXP',       value=>'CMS$_ERRPAREXP',
              macro=>'CMS$_ERRPAREXP' },
            { name=>'CMS__ERRREJECTIONS',   value=>'CMS$_ERRREJECTIONS',
              macro=>'CMS$_ERRREJECTIONS' },
            { name=>'CMS__ERRREVIEWS',      value=>'CMS$_ERRREVIEWS',
              macro=>'CMS$_ERRREVIEWS' },
            { name=>'CMS__ERRUNRESERVES',   value=>'CMS$_ERRUNRESERVES',
              macro=>'CMS$_ERRUNRESERVES' },
            { name=>'CMS__ERRVER2',         value=>'CMS$_ERRVER2',
              macro=>'CMS$_ERRVER2' },
            { name=>'CMS__ERRVERARC',       value=>'CMS$_ERRVERARC',
              macro=>'CMS$_ERRVERARC' },
            { name=>'CMS__ERRVERCLS',       value=>'CMS$_ERRVERCLS',
              macro=>'CMS$_ERRVERCLS' },
            { name=>'CMS__ERRVERCMD',       value=>'CMS$_ERRVERCMD',
              macro=>'CMS$_ERRVERCMD' },
            { name=>'CMS__ERRVERCON',       value=>'CMS$_ERRVERCON',
              macro=>'CMS$_ERRVERCON' },
            { name=>'CMS__ERRVEREDFS',      value=>'CMS$_ERRVEREDFS',
              macro=>'CMS$_ERRVEREDFS' },
            { name=>'CMS__ERRVERELE',       value=>'CMS$_ERRVERELE',
              macro=>'CMS$_ERRVERELE' },
            { name=>'CMS__ERRVERFRE',       value=>'CMS$_ERRVERFRE',
              macro=>'CMS$_ERRVERFRE' },
            { name=>'CMS__ERRVERGEN',       value=>'CMS$_ERRVERGEN',
              macro=>'CMS$_ERRVERGEN' },
            { name=>'CMS__ERRVERGRP',       value=>'CMS$_ERRVERGRP',
              macro=>'CMS$_ERRVERGRP' },
            { name=>'CMS__ERRVERREFS',      value=>'CMS$_ERRVERREFS',
              macro=>'CMS$_ERRVERREFS' },
            { name=>'CMS__ERRVERRES',       value=>'CMS$_ERRVERRES',
              macro=>'CMS$_ERRVERRES' },
            { name=>'CMS__ERRVERSTR',       value=>'CMS$_ERRVERSTR',
              macro=>'CMS$_ERRVERSTR' },
            { name=>'CMS__EXCLUDE',         value=>'CMS$_EXCLUDE',
              macro=>'CMS$_EXCLUDE' },
            { name=>'CMS__EXIT',            value=>'CMS$_EXIT',
              macro=>'CMS$_EXIT' },
            { name=>'CMS__EXTENDEDLIB',     value=>'CMS$_EXTENDEDLIB',
              macro=>'CMS$_EXTENDEDLIB' },
            { name=>'CMS__EXTFOUND',        value=>'CMS$_EXTFOUND',
              macro=>'CMS$_EXTFOUND' },
            { name=>'CMS__FACILITY',        value=>'CMS$_FACILITY',
              macro=>'CMS$_FACILITY' },
            { name=>'CMS__FETCHED',         value=>'CMS$_FETCHED',
              macro=>'CMS$_FETCHED' },
            { name=>'CMS__FETCHES',         value=>'CMS$_FETCHES',
              macro=>'CMS$_FETCHES' },
            { name=>'CMS__FILEXISTS',       value=>'CMS$_FILEXISTS',
              macro=>'CMS$_FILEXISTS' },
            { name=>'CMS__FILINUSE',        value=>'CMS$_FILINUSE',
              macro=>'CMS$_FILINUSE' },
            { name=>'CMS__FIXCRC',          value=>'CMS$_FIXCRC',
              macro=>'CMS$_FIXCRC' },
            { name=>'CMS__FIXHDR',          value=>'CMS$_FIXHDR',
              macro=>'CMS$_FIXHDR' },
            { name=>'CMS__FREBLKCON',       value=>'CMS$_FREBLKCON',
              macro=>'CMS$_FREBLKCON' },
            { name=>'CMS__GENCREATED',      value=>'CMS$_GENCREATED',
              macro=>'CMS$_GENCREATED' },
            { name=>'CMS__GENDELETED',      value=>'CMS$_GENDELETED',
              macro=>'CMS$_GENDELETED' },
            { name=>'CMS__GENDELETIONS',    value=>'CMS$_GENDELETIONS',
              macro=>'CMS$_GENDELETIONS' },
            { name=>'CMS__GENEXISTS',       value=>'CMS$_GENEXISTS',
              macro=>'CMS$_GENEXISTS' },
            { name=>'CMS__GENINSERTED',     value=>'CMS$_GENINSERTED',
              macro=>'CMS$_GENINSERTED' },
            { name=>'CMS__GENMULTRES',      value=>'CMS$_GENMULTRES',
              macro=>'CMS$_GENMULTRES' },
            { name=>'CMS__GENNOINSERT',     value=>'CMS$_GENNOINSERT',
              macro=>'CMS$_GENNOINSERT' },
            { name=>'CMS__GENNOREMOVE',     value=>'CMS$_GENNOREMOVE',
              macro=>'CMS$_GENNOREMOVE' },
            { name=>'CMS__GENNOTANC',       value=>'CMS$_GENNOTANC',
              macro=>'CMS$_GENNOTANC' },
            { name=>'CMS__GENNOTFOUND',     value=>'CMS$_GENNOTFOUND',
              macro=>'CMS$_GENNOTFOUND' },
            { name=>'CMS__GENNOTRES',       value=>'CMS$_GENNOTRES',
              macro=>'CMS$_GENNOTRES' },
            { name=>'CMS__GENRECSIZE',      value=>'CMS$_GENRECSIZE',
              macro=>'CMS$_GENRECSIZE' },
            { name=>'CMS__GENREMOVED',      value=>'CMS$_GENREMOVED',
              macro=>'CMS$_GENREMOVED' },
            { name=>'CMS__GENRESREV',       value=>'CMS$_GENRESREV',
              macro=>'CMS$_GENRESREV' },
            { name=>'CMS__GENTOODEEP',      value=>'CMS$_GENTOODEEP',
              macro=>'CMS$_GENTOODEEP' },
            { name=>'CMS__GROUPEXP',        value=>'CMS$_GROUPEXP',
              macro=>'CMS$_GROUPEXP' },
            { name=>'CMS__HASFILES',        value=>'CMS$_HASFILES',
              macro=>'CMS$_HASFILES' },
            { name=>'CMS__HASMEMBERS',      value=>'CMS$_HASMEMBERS',
              macro=>'CMS$_HASMEMBERS' },
            { name=>'CMS__HISNOTSTM',       value=>'CMS$_HISNOTSTM',
              macro=>'CMS$_HISNOTSTM' },
            { name=>'CMS__HISTDEL',         value=>'CMS$_HISTDEL',
              macro=>'CMS$_HISTDEL' },
            { name=>'CMS__IDENTCLASS',      value=>'CMS$_IDENTCLASS',
              macro=>'CMS$_IDENTCLASS' },
            { name=>'CMS__IDENTICAL',       value=>'CMS$_IDENTICAL',
              macro=>'CMS$_IDENTICAL' },
            { name=>'CMS__IDENTNOTRES',     value=>'CMS$_IDENTNOTRES',
              macro=>'CMS$_IDENTNOTRES' },
            { name=>'CMS__ILLACT',          value=>'CMS$_ILLACT',
              macro=>'CMS$_ILLACT' },
            { name=>'CMS__ILLARCREC',       value=>'CMS$_ILLARCREC',
              macro=>'CMS$_ILLARCREC' },
            { name=>'CMS__ILLCHAR',         value=>'CMS$_ILLCHAR',
              macro=>'CMS$_ILLCHAR' },
            { name=>'CMS__ILLCLSNAM',       value=>'CMS$_ILLCLSNAM',
              macro=>'CMS$_ILLCLSNAM' },
            { name=>'CMS__ILLCONREC',       value=>'CMS$_ILLCONREC',
              macro=>'CMS$_ILLCONREC' },
            { name=>'CMS__ILLDATREC',       value=>'CMS$_ILLDATREC',
              macro=>'CMS$_ILLDATREC' },
            { name=>'CMS__ILLEGALDEV',      value=>'CMS$_ILLEGALDEV',
              macro=>'CMS$_ILLEGALDEV' },
            { name=>'CMS__ILLELENAM',       value=>'CMS$_ILLELENAM',
              macro=>'CMS$_ILLELENAM' },
            { name=>'CMS__ILLELEXP',        value=>'CMS$_ILLELEXP',
              macro=>'CMS$_ILLELEXP' },
            { name=>'CMS__ILLFORMAT',       value=>'CMS$_ILLFORMAT',
              macro=>'CMS$_ILLFORMAT' },
            { name=>'CMS__ILLGEN',          value=>'CMS$_ILLGEN',
              macro=>'CMS$_ILLGEN' },
            { name=>'CMS__ILLGRPNAM',       value=>'CMS$_ILLGRPNAM',
              macro=>'CMS$_ILLGRPNAM' },
            { name=>'CMS__ILLHIST',         value=>'CMS$_ILLHIST',
              macro=>'CMS$_ILLHIST' },
            { name=>'CMS__ILLNAME',         value=>'CMS$_ILLNAME',
              macro=>'CMS$_ILLNAME' },
            { name=>'CMS__ILLNOTE',         value=>'CMS$_ILLNOTE',
              macro=>'CMS$_ILLNOTE' },
            { name=>'CMS__ILLOBJTYP',       value=>'CMS$_ILLOBJTYP',
              macro=>'CMS$_ILLOBJTYP' },
            { name=>'CMS__ILLPAR',          value=>'CMS$_ILLPAR',
              macro=>'CMS$_ILLPAR' },
            { name=>'CMS__ILLPOSVAL',       value=>'CMS$_ILLPOSVAL',
              macro=>'CMS$_ILLPOSVAL' },
            { name=>'CMS__ILLREFDIR',       value=>'CMS$_ILLREFDIR',
              macro=>'CMS$_ILLREFDIR' },
            { name=>'CMS__ILLRMK',          value=>'CMS$_ILLRMK',
              macro=>'CMS$_ILLRMK' },
            { name=>'CMS__ILLSEQ',          value=>'CMS$_ILLSEQ',
              macro=>'CMS$_ILLSEQ' },
            { name=>'CMS__ILLSUBTYP',       value=>'CMS$_ILLSUBTYP',
              macro=>'CMS$_ILLSUBTYP' },
            { name=>'CMS__ILLVAR',          value=>'CMS$_ILLVAR',
              macro=>'CMS$_ILLVAR' },
            { name=>'CMS__INCLIBVER',       value=>'CMS$_INCLIBVER',
              macro=>'CMS$_INCLIBVER' },
            { name=>'CMS__INCRANGSPEC',     value=>'CMS$_INCRANGSPEC',
              macro=>'CMS$_INCRANGSPEC' },
            { name=>'CMS__INSERTED',        value=>'CMS$_INSERTED',
              macro=>'CMS$_INSERTED' },
            { name=>'CMS__INSERTIONS',      value=>'CMS$_INSERTIONS',
              macro=>'CMS$_INSERTIONS' },
            { name=>'CMS__INUSE',           value=>'CMS$_INUSE',
              macro=>'CMS$_INUSE' },
            { name=>'CMS__INVFETDB',        value=>'CMS$_INVFETDB',
              macro=>'CMS$_INVFETDB' },
            { name=>'CMS__INVFIXMRS',       value=>'CMS$_INVFIXMRS',
              macro=>'CMS$_INVFIXMRS' },
            { name=>'CMS__INVGENLRL',       value=>'CMS$_INVGENLRL',
              macro=>'CMS$_INVGENLRL' },
            { name=>'CMS__INVLENGTH',       value=>'CMS$_INVLENGTH',
              macro=>'CMS$_INVLENGTH' },
            { name=>'CMS__INVLIBDB',        value=>'CMS$_INVLIBDB',
              macro=>'CMS$_INVLIBDB' },
            { name=>'CMS__INVOKERBK',       value=>'CMS$_INVOKERBK',
              macro=>'CMS$_INVOKERBK' },
            { name=>'CMS__INVSTRDES',       value=>'CMS$_INVSTRDES',
              macro=>'CMS$_INVSTRDES' },
            { name=>'CMS__ISMEMBER',        value=>'CMS$_ISMEMBER',
              macro=>'CMS$_ISMEMBER' },
            { name=>'CMS__ISRESERVED',      value=>'CMS$_ISRESERVED',
              macro=>'CMS$_ISRESERVED' },
            { name=>'CMS__LIBALRINLIS',     value=>'CMS$_LIBALRINLIS',
              macro=>'CMS$_LIBALRINLIS' },
            { name=>'CMS__LIBINSLIS',       value=>'CMS$_LIBINSLIS',
              macro=>'CMS$_LIBINSLIS' },
            { name=>'CMS__LIBIS',           value=>'CMS$_LIBIS',
              macro=>'CMS$_LIBIS' },
            { name=>'CMS__LIBLISMOD',       value=>'CMS$_LIBLISMOD',
              macro=>'CMS$_LIBLISMOD' },
            { name=>'CMS__LIBLISNOTMOD',    value=>'CMS$_LIBLISNOTMOD',
              macro=>'CMS$_LIBLISNOTMOD' },
            { name=>'CMS__LIBNOTINLIS',     value=>'CMS$_LIBNOTINLIS',
              macro=>'CMS$_LIBNOTINLIS' },
            { name=>'CMS__LIBREMLIS',       value=>'CMS$_LIBREMLIS',
              macro=>'CMS$_LIBREMLIS' },
            { name=>'CMS__LIBSET',          value=>'CMS$_LIBSET',
              macro=>'CMS$_LIBSET' },
            { name=>'CMS__LONGVARFOUND',    value=>'CMS$_LONGVARFOUND',
              macro=>'CMS$_LONGVARFOUND' },
            { name=>'CMS__MANCONLIB',       value=>'CMS$_MANCONLIB',
              macro=>'CMS$_MANCONLIB' },
            { name=>'CMS__MARKED',          value=>'CMS$_MARKED',
              macro=>'CMS$_MARKED' },
            { name=>'CMS__MARKS',           value=>'CMS$_MARKS',
              macro=>'CMS$_MARKS' },
            { name=>'CMS__MAXARG',          value=>'CMS$_MAXARG',
              macro=>'CMS$_MAXARG' },
            { name=>'CMS__MERGECONFLICT',   value=>'CMS$_MERGECONFLICT',
              macro=>'CMS$_MERGECONFLICT' },
            { name=>'CMS__MERGECOUNT',      value=>'CMS$_MERGECOUNT',
              macro=>'CMS$_MERGECOUNT' },
            { name=>'CMS__MERGED',          value=>'CMS$_MERGED',
              macro=>'CMS$_MERGED' },
            { name=>'CMS__MINARG',          value=>'CMS$_MINARG',
              macro=>'CMS$_MINARG' },
            { name=>'CMS__MISBLKSTR',       value=>'CMS$_MISBLKSTR',
              macro=>'CMS$_MISBLKSTR' },
            { name=>'CMS__MISMATCON',       value=>'CMS$_MISMATCON',
              macro=>'CMS$_MISMATCON' },
            { name=>'CMS__MODACL',          value=>'CMS$_MODACL',
              macro=>'CMS$_MODACL' },
            { name=>'CMS__MODACLS',         value=>'CMS$_MODACLS',
              macro=>'CMS$_MODACLS' },
            { name=>'CMS__MODIFICATIONS',   value=>'CMS$_MODIFICATIONS',
              macro=>'CMS$_MODIFICATIONS' },
            { name=>'CMS__MODIFIED',        value=>'CMS$_MODIFIED',
              macro=>'CMS$_MODIFIED' },
            { name=>'CMS__MSGBUILD',        value=>'CMS$_MSGBUILD',
              macro=>'CMS$_MSGBUILD' },
            { name=>'CMS__MSGCANCEL',       value=>'CMS$_MSGCANCEL',
              macro=>'CMS$_MSGCANCEL' },
            { name=>'CMS__MSGCONTINUE',     value=>'CMS$_MSGCONTINUE',
              macro=>'CMS$_MSGCONTINUE' },
            { name=>'CMS__MSGPOST',         value=>'CMS$_MSGPOST',
              macro=>'CMS$_MSGPOST' },
            { name=>'CMS__MSGUPDATE',       value=>'CMS$_MSGUPDATE',
              macro=>'CMS$_MSGUPDATE' },
            { name=>'CMS__MSSBLKSTR',       value=>'CMS$_MSSBLKSTR',
              macro=>'CMS$_MSSBLKSTR' },
            { name=>'CMS__MULTCALL',        value=>'CMS$_MULTCALL',
              macro=>'CMS$_MULTCALL' },
            { name=>'CMS__MULTPAR',         value=>'CMS$_MULTPAR',
              macro=>'CMS$_MULTPAR' },
            { name=>'CMS__MUSTBEDIR',       value=>'CMS$_MUSTBEDIR',
              macro=>'CMS$_MUSTBEDIR' },
            { name=>'CMS__MUSTBEFIL',       value=>'CMS$_MUSTBEFIL',
              macro=>'CMS$_MUSTBEFIL' },
            { name=>'CMS__MUSTBEPOS',       value=>'CMS$_MUSTBEPOS',
              macro=>'CMS$_MUSTBEPOS' },
            { name=>'CMS__MUTEXC',          value=>'CMS$_MUTEXC',
              macro=>'CMS$_MUTEXC' },
            { name=>'CMS__NEEDNUMBER',      value=>'CMS$_NEEDNUMBER',
              macro=>'CMS$_NEEDNUMBER' },
            { name=>'CMS__NEEDPERIOD',      value=>'CMS$_NEEDPERIOD',
              macro=>'CMS$_NEEDPERIOD' },
            { name=>'CMS__NETNOTALL',       value=>'CMS$_NETNOTALL',
              macro=>'CMS$_NETNOTALL' },
            { name=>'CMS__NOACCEPT',        value=>'CMS$_NOACCEPT',
              macro=>'CMS$_NOACCEPT' },
            { name=>'CMS__NOACCESS',        value=>'CMS$_NOACCESS',
              macro=>'CMS$_NOACCESS' },
            { name=>'CMS__NOACE',           value=>'CMS$_NOACE',
              macro=>'CMS$_NOACE' },
            { name=>'CMS__NOALTDELETE',     value=>'CMS$_NOALTDELETE',
              macro=>'CMS$_NOALTDELETE' },
            { name=>'CMS__NOANNOTATE',      value=>'CMS$_NOANNOTATE',
              macro=>'CMS$_NOANNOTATE' },
            { name=>'CMS__NOBACKUP',        value=>'CMS$_NOBACKUP',
              macro=>'CMS$_NOBACKUP' },
            { name=>'CMS__NOBCKPTR',        value=>'CMS$_NOBCKPTR',
              macro=>'CMS$_NOBCKPTR' },
            { name=>'CMS__NOCANCEL',        value=>'CMS$_NOCANCEL',
              macro=>'CMS$_NOCANCEL' },
            { name=>'CMS__NOCHANGES',       value=>'CMS$_NOCHANGES',
              macro=>'CMS$_NOCHANGES' },
            { name=>'CMS__NOCLOSE',         value=>'CMS$_NOCLOSE',
              macro=>'CMS$_NOCLOSE' },
            { name=>'CMS__NOCLS',           value=>'CMS$_NOCLS',
              macro=>'CMS$_NOCLS' },
            { name=>'CMS__NOCMD',           value=>'CMS$_NOCMD',
              macro=>'CMS$_NOCMD' },
            { name=>'CMS__NOCOMMALIST',     value=>'CMS$_NOCOMMALIST',
              macro=>'CMS$_NOCOMMALIST' },
            { name=>'CMS__NOCOMPARE',       value=>'CMS$_NOCOMPARE',
              macro=>'CMS$_NOCOMPARE' },
            { name=>'CMS__NOCONCUR',        value=>'CMS$_NOCONCUR',
              macro=>'CMS$_NOCONCUR' },
            { name=>'CMS__NOCONFIRM',       value=>'CMS$_NOCONFIRM',
              macro=>'CMS$_NOCONFIRM' },
            { name=>'CMS__NOCONRES',        value=>'CMS$_NOCONRES',
              macro=>'CMS$_NOCONRES' },
            { name=>'CMS__NOCONVERT',       value=>'CMS$_NOCONVERT',
              macro=>'CMS$_NOCONVERT' },
            { name=>'CMS__NOCOPY',          value=>'CMS$_NOCOPY',
              macro=>'CMS$_NOCOPY' },
            { name=>'CMS__NOCREATE',        value=>'CMS$_NOCREATE',
              macro=>'CMS$_NOCREATE' },
            { name=>'CMS__NODEFACL',        value=>'CMS$_NODEFACL',
              macro=>'CMS$_NODEFACL' },
            { name=>'CMS__NODELACCESS',     value=>'CMS$_NODELACCESS',
              macro=>'CMS$_NODELACCESS' },
            { name=>'CMS__NODELETE',        value=>'CMS$_NODELETE',
              macro=>'CMS$_NODELETE' },
            { name=>'CMS__NODELETIONS',     value=>'CMS$_NODELETIONS',
              macro=>'CMS$_NODELETIONS' },
            { name=>'CMS__NODELFUTURE',     value=>'CMS$_NODELFUTURE',
              macro=>'CMS$_NODELFUTURE' },
            { name=>'CMS__NODELGEN1',       value=>'CMS$_NODELGEN1',
              macro=>'CMS$_NODELGEN1' },
            { name=>'CMS__NOEDFIWDREPAIR',  value=>'CMS$_NOEDFIWDREPAIR',
              macro=>'CMS$_NOEDFIWDREPAIR' },
            { name=>'CMS__NOELE',           value=>'CMS$_NOELE',
              macro=>'CMS$_NOELE' },
            { name=>'CMS__NOELEENT',        value=>'CMS$_NOELEENT',
              macro=>'CMS$_NOELEENT' },
            { name=>'CMS__NOERRLOG',        value=>'CMS$_NOERRLOG',
              macro=>'CMS$_NOERRLOG' },
            { name=>'CMS__NOEXTENDED',      value=>'CMS$_NOEXTENDED',
              macro=>'CMS$_NOEXTENDED' },
            { name=>'CMS__NOEXTENDEDREF',   value=>'CMS$_NOEXTENDEDREF',
              macro=>'CMS$_NOEXTENDEDREF' },
            { name=>'CMS__NOFETCH',         value=>'CMS$_NOFETCH',
              macro=>'CMS$_NOFETCH' },
            { name=>'CMS__NOFILE',          value=>'CMS$_NOFILE',
              macro=>'CMS$_NOFILE' },
            { name=>'CMS__NOGENBEFORE',     value=>'CMS$_NOGENBEFORE',
              macro=>'CMS$_NOGENBEFORE' },
            { name=>'CMS__NOGENDELETED',    value=>'CMS$_NOGENDELETED',
              macro=>'CMS$_NOGENDELETED' },
            { name=>'CMS__NOGENS',          value=>'CMS$_NOGENS',
              macro=>'CMS$_NOGENS' },
            { name=>'CMS__NOGRP',           value=>'CMS$_NOGRP',
              macro=>'CMS$_NOGRP' },
            { name=>'CMS__NOHIS',           value=>'CMS$_NOHIS',
              macro=>'CMS$_NOHIS' },
            { name=>'CMS__NOHISNOTES',      value=>'CMS$_NOHISNOTES',
              macro=>'CMS$_NOHISNOTES' },
            { name=>'CMS__NOHISPAR',        value=>'CMS$_NOHISPAR',
              macro=>'CMS$_NOHISPAR' },
            { name=>'CMS__NOINPUT',         value=>'CMS$_NOINPUT',
              macro=>'CMS$_NOINPUT' },
            { name=>'CMS__NOINSERT',        value=>'CMS$_NOINSERT',
              macro=>'CMS$_NOINSERT' },
            { name=>'CMS__NOMARK',          value=>'CMS$_NOMARK',
              macro=>'CMS$_NOMARK' },
            { name=>'CMS__NOMATCH',         value=>'CMS$_NOMATCH',
              macro=>'CMS$_NOMATCH' },
            { name=>'CMS__NOMODACL',        value=>'CMS$_NOMODACL',
              macro=>'CMS$_NOMODACL' },
            { name=>'CMS__NOMODARG',        value=>'CMS$_NOMODARG',
              macro=>'CMS$_NOMODARG' },
            { name=>'CMS__NOMODIFY',        value=>'CMS$_NOMODIFY',
              macro=>'CMS$_NOMODIFY' },
            { name=>'CMS__NOMOREPARAM',     value=>'CMS$_NOMOREPARAM',
              macro=>'CMS$_NOMOREPARAM' },
            { name=>'CMS__NOOBJ',           value=>'CMS$_NOOBJ',
              macro=>'CMS$_NOOBJ' },
            { name=>'CMS__NOOBJTYP',        value=>'CMS$_NOOBJTYP',
              macro=>'CMS$_NOOBJTYP' },
            { name=>'CMS__NORECOVER',       value=>'CMS$_NORECOVER',
              macro=>'CMS$_NORECOVER' },
            { name=>'CMS__NOREF',           value=>'CMS$_NOREF',
              macro=>'CMS$_NOREF' },
            { name=>'CMS__NOREFDIR',        value=>'CMS$_NOREFDIR',
              macro=>'CMS$_NOREFDIR' },
            { name=>'CMS__NOREFELE',        value=>'CMS$_NOREFELE',
              macro=>'CMS$_NOREFELE' },
            { name=>'CMS__NOREJECT',        value=>'CMS$_NOREJECT',
              macro=>'CMS$_NOREJECT' },
            { name=>'CMS__NOREMARK',        value=>'CMS$_NOREMARK',
              macro=>'CMS$_NOREMARK' },
            { name=>'CMS__NOREMOVAL',       value=>'CMS$_NOREMOVAL',
              macro=>'CMS$_NOREMOVAL' },
            { name=>'CMS__NOREPAIR',        value=>'CMS$_NOREPAIR',
              macro=>'CMS$_NOREPAIR' },
            { name=>'CMS__NOREPBCKPTR',     value=>'CMS$_NOREPBCKPTR',
              macro=>'CMS$_NOREPBCKPTR' },
            { name=>'CMS__NOREPCMD',        value=>'CMS$_NOREPCMD',
              macro=>'CMS$_NOREPCMD' },
            { name=>'CMS__NOREPEDF',        value=>'CMS$_NOREPEDF',
              macro=>'CMS$_NOREPEDF' },
            { name=>'CMS__NOREPGENLRL',     value=>'CMS$_NOREPGENLRL',
              macro=>'CMS$_NOREPGENLRL' },
            { name=>'CMS__NOREPGENMRS',     value=>'CMS$_NOREPGENMRS',
              macro=>'CMS$_NOREPGENMRS' },
            { name=>'CMS__NOREPLACE',       value=>'CMS$_NOREPLACE',
              macro=>'CMS$_NOREPLACE' },
            { name=>'CMS__NOREPREF',        value=>'CMS$_NOREPREF',
              macro=>'CMS$_NOREPREF' },
            { name=>'CMS__NOREPRO',         value=>'CMS$_NOREPRO',
              macro=>'CMS$_NOREPRO' },
            { name=>'CMS__NOREPSEQDATA',    value=>'CMS$_NOREPSEQDATA',
              macro=>'CMS$_NOREPSEQDATA' },
            { name=>'CMS__NORES',           value=>'CMS$_NORES',
              macro=>'CMS$_NORES' },
            { name=>'CMS__NORESERVATION',   value=>'CMS$_NORESERVATION',
              macro=>'CMS$_NORESERVATION' },
            { name=>'CMS__NORESNOCON',      value=>'CMS$_NORESNOCON',
              macro=>'CMS$_NORESNOCON' },
            { name=>'CMS__NORESRO',         value=>'CMS$_NORESRO',
              macro=>'CMS$_NORESRO' },
            { name=>'CMS__NORETRIEVE',      value=>'CMS$_NORETRIEVE',
              macro=>'CMS$_NORETRIEVE' },
            { name=>'CMS__NOREV',           value=>'CMS$_NOREV',
              macro=>'CMS$_NOREV' },
            { name=>'CMS__NOREVIEW',        value=>'CMS$_NOREVIEW',
              macro=>'CMS$_NOREVIEW' },
            { name=>'CMS__NOREVPEND',       value=>'CMS$_NOREVPEND',
              macro=>'CMS$_NOREVPEND' },
            { name=>'CMS__NOREVSPEND',      value=>'CMS$_NOREVSPEND',
              macro=>'CMS$_NOREVSPEND' },
            { name=>'CMS__NORMAL',          value=>'CMS$_NORMAL',
              macro=>'CMS$_NORMAL' },
            { name=>'CMS__NOSINCE',         value=>'CMS$_NOSINCE',
              macro=>'CMS$_NOSINCE' },
            { name=>'CMS__NOSRCHLST',       value=>'CMS$_NOSRCHLST',
              macro=>'CMS$_NOSRCHLST' },
            { name=>'CMS__NOSUPERSEDE',     value=>'CMS$_NOSUPERSEDE',
              macro=>'CMS$_NOSUPERSEDE' },
            { name=>'CMS__NOTBYCMS',        value=>'CMS$_NOTBYCMS',
              macro=>'CMS$_NOTBYCMS' },
            { name=>'CMS__NOTCMSLIB',       value=>'CMS$_NOTCMSLIB',
              macro=>'CMS$_NOTCMSLIB' },
            { name=>'CMS__NOTCOMPLETED',    value=>'CMS$_NOTCOMPLETED',
              macro=>'CMS$_NOTCOMPLETED' },
            { name=>'CMS__NOTCRELIB',       value=>'CMS$_NOTCRELIB',
              macro=>'CMS$_NOTCRELIB' },
            { name=>'CMS__NOTDIRDES',       value=>'CMS$_NOTDIRDES',
              macro=>'CMS$_NOTDIRDES' },
            { name=>'CMS__NOTESVALREQ',     value=>'CMS$_NOTESVALREQ',
              macro=>'CMS$_NOTESVALREQ' },
            { name=>'CMS__NOTFOUND',        value=>'CMS$_NOTFOUND',
              macro=>'CMS$_NOTFOUND' },
            { name=>'CMS__NOTLOGGED',       value=>'CMS$_NOTLOGGED',
              macro=>'CMS$_NOTLOGGED' },
            { name=>'CMS__NOTNOREF',        value=>'CMS$_NOTNOREF',
              macro=>'CMS$_NOTNOREF' },
            { name=>'CMS__NOTRESBYOU',      value=>'CMS$_NOTRESBYOU',
              macro=>'CMS$_NOTRESBYOU' },
            { name=>'CMS__NOTSET',          value=>'CMS$_NOTSET',
              macro=>'CMS$_NOTSET' },
            { name=>'CMS__NOTTHERE',        value=>'CMS$_NOTTHERE',
              macro=>'CMS$_NOTTHERE' },
            { name=>'CMS__NOTWILD',         value=>'CMS$_NOTWILD',
              macro=>'CMS$_NOTWILD' },
            { name=>'CMS__NOUNRESERVE',     value=>'CMS$_NOUNRESERVE',
              macro=>'CMS$_NOUNRESERVE' },
            { name=>'CMS__NOVERIFY',        value=>'CMS$_NOVERIFY',
              macro=>'CMS$_NOVERIFY' },
            { name=>'CMS__NOWLDCARD',       value=>'CMS$_NOWLDCARD',
              macro=>'CMS$_NOWLDCARD' },
            { name=>'CMS__NULLARG',         value=>'CMS$_NULLARG',
              macro=>'CMS$_NULLARG' },
            { name=>'CMS__NULLSTR',         value=>'CMS$_NULLSTR',
              macro=>'CMS$_NULLSTR' },
            { name=>'CMS__NUMGENEXP',       value=>'CMS$_NUMGENEXP',
              macro=>'CMS$_NUMGENEXP' },
            { name=>'CMS__OLDSYNTAX',       value=>'CMS$_OLDSYNTAX',
              macro=>'CMS$_OLDSYNTAX' },
            { name=>'CMS__ONEPERIOD',       value=>'CMS$_ONEPERIOD',
              macro=>'CMS$_ONEPERIOD' },
            { name=>'CMS__OPENARC',         value=>'CMS$_OPENARC',
              macro=>'CMS$_OPENARC' },
            { name=>'CMS__OPENIN',          value=>'CMS$_OPENIN',
              macro=>'CMS$_OPENIN' },
            { name=>'CMS__OPENIN1',         value=>'CMS$_OPENIN1',
              macro=>'CMS$_OPENIN1' },
            { name=>'CMS__OPENIN2',         value=>'CMS$_OPENIN2',
              macro=>'CMS$_OPENIN2' },
            { name=>'CMS__OPENOUT',         value=>'CMS$_OPENOUT',
              macro=>'CMS$_OPENOUT' },
            { name=>'CMS__OVERDRAFT',       value=>'CMS$_OVERDRAFT',
              macro=>'CMS$_OVERDRAFT' },
            { name=>'CMS__POSVALREQ',       value=>'CMS$_POSVALREQ',
              macro=>'CMS$_POSVALREQ' },
            { name=>'CMS__PROCEEDING',      value=>'CMS$_PROCEEDING',
              macro=>'CMS$_PROCEEDING' },
            { name=>'CMS__QUALCONFLICT',    value=>'CMS$_QUALCONFLICT',
              macro=>'CMS$_QUALCONFLICT' },
            { name=>'CMS__READERR',         value=>'CMS$_READERR',
              macro=>'CMS$_READERR' },
            { name=>'CMS__READIN',          value=>'CMS$_READIN',
              macro=>'CMS$_READIN' },
            { name=>'CMS__READONLY',        value=>'CMS$_READONLY',
              macro=>'CMS$_READONLY' },
            { name=>'CMS__RECGRP',          value=>'CMS$_RECGRP',
              macro=>'CMS$_RECGRP' },
            { name=>'CMS__RECNOTNEC',       value=>'CMS$_RECNOTNEC',
              macro=>'CMS$_RECNOTNEC' },
            { name=>'CMS__RECOVERED',       value=>'CMS$_RECOVERED',
              macro=>'CMS$_RECOVERED' },
            { name=>'CMS__REFMISMAT',       value=>'CMS$_REFMISMAT',
              macro=>'CMS$_REFMISMAT' },
            { name=>'CMS__REFMISS',         value=>'CMS$_REFMISS',
              macro=>'CMS$_REFMISS' },
            { name=>'CMS__REFREPAIR',       value=>'CMS$_REFREPAIR',
              macro=>'CMS$_REFREPAIR' },
            { name=>'CMS__REJECTED',        value=>'CMS$_REJECTED',
              macro=>'CMS$_REJECTED' },
            { name=>'CMS__REJECTIONS',      value=>'CMS$_REJECTIONS',
              macro=>'CMS$_REJECTIONS' },
            { name=>'CMS__REMARK',          value=>'CMS$_REMARK',
              macro=>'CMS$_REMARK' },
            { name=>'CMS__REMOVALS',        value=>'CMS$_REMOVALS',
              macro=>'CMS$_REMOVALS' },
            { name=>'CMS__REMOVED',         value=>'CMS$_REMOVED',
              macro=>'CMS$_REMOVED' },
            { name=>'CMS__REPAIRED',        value=>'CMS$_REPAIRED',
              macro=>'CMS$_REPAIRED' },
            { name=>'CMS__REPBADLST',       value=>'CMS$_REPBADLST',
              macro=>'CMS$_REPBADLST' },
            { name=>'CMS__REPBADTYP',       value=>'CMS$_REPBADTYP',
              macro=>'CMS$_REPBADTYP' },
            { name=>'CMS__REPBCKPTR',       value=>'CMS$_REPBCKPTR',
              macro=>'CMS$_REPBCKPTR' },
            { name=>'CMS__REPCMD',          value=>'CMS$_REPCMD',
              macro=>'CMS$_REPCMD' },
            { name=>'CMS__REPCNTSTR',       value=>'CMS$_REPCNTSTR',
              macro=>'CMS$_REPCNTSTR' },
            { name=>'CMS__REPDEL',          value=>'CMS$_REPDEL',
              macro=>'CMS$_REPDEL' },
            { name=>'CMS__REPEDF',          value=>'CMS$_REPEDF',
              macro=>'CMS$_REPEDF' },
            { name=>'CMS__REPENDPTR',       value=>'CMS$_REPENDPTR',
              macro=>'CMS$_REPENDPTR' },
            { name=>'CMS__REPGENLRL',       value=>'CMS$_REPGENLRL',
              macro=>'CMS$_REPGENLRL' },
            { name=>'CMS__REPGENMRS',       value=>'CMS$_REPGENMRS',
              macro=>'CMS$_REPGENMRS' },
            { name=>'CMS__REPILLDATREC',    value=>'CMS$_REPILLDATREC',
              macro=>'CMS$_REPILLDATREC' },
            { name=>'CMS__REPLACEMENTS',    value=>'CMS$_REPLACEMENTS',
              macro=>'CMS$_REPLACEMENTS' },
            { name=>'CMS__REPMISBLK',       value=>'CMS$_REPMISBLK',
              macro=>'CMS$_REPMISBLK' },
            { name=>'CMS__REPREF',          value=>'CMS$_REPREF',
              macro=>'CMS$_REPREF' },
            { name=>'CMS__RESERVATIONS',    value=>'CMS$_RESERVATIONS',
              macro=>'CMS$_RESERVATIONS' },
            { name=>'CMS__RESERVED',        value=>'CMS$_RESERVED',
              macro=>'CMS$_RESERVED' },
            { name=>'CMS__RESERVEDBYYOU',   value=>'CMS$_RESERVEDBYYOU',
              macro=>'CMS$_RESERVEDBYYOU' },
            { name=>'CMS__RETRIEVALS',      value=>'CMS$_RETRIEVALS',
              macro=>'CMS$_RETRIEVALS' },
            { name=>'CMS__RETRIEVED',       value=>'CMS$_RETRIEVED',
              macro=>'CMS$_RETRIEVED' },
            { name=>'CMS__REVIEWED',        value=>'CMS$_REVIEWED',
              macro=>'CMS$_REVIEWED' },
            { name=>'CMS__REVIEWS',         value=>'CMS$_REVIEWS',
              macro=>'CMS$_REVIEWS' },
            { name=>'CMS__REVPENDING',      value=>'CMS$_REVPENDING',
              macro=>'CMS$_REVPENDING' },
            { name=>'CMS__SAMELINE',        value=>'CMS$_SAMELINE',
              macro=>'CMS$_SAMELINE' },
            { name=>'CMS__SEQFAIL',         value=>'CMS$_SEQFAIL',
              macro=>'CMS$_SEQFAIL' },
            { name=>'CMS__SEQMISMAT',       value=>'CMS$_SEQMISMAT',
              macro=>'CMS$_SEQMISMAT' },
            { name=>'CMS__SEQUENCED',       value=>'CMS$_SEQUENCED',
              macro=>'CMS$_SEQUENCED' },
            { name=>'CMS__SIZEMISMAT',      value=>'CMS$_SIZEMISMAT',
              macro=>'CMS$_SIZEMISMAT' },
            { name=>'CMS__STARTHIS',        value=>'CMS$_STARTHIS',
              macro=>'CMS$_STARTHIS' },
            { name=>'CMS__STOPPED',         value=>'CMS$_STOPPED',
              macro=>'CMS$_STOPPED' },
            { name=>'CMS__SUPERSEDE',       value=>'CMS$_SUPERSEDE',
              macro=>'CMS$_SUPERSEDE' },
            { name=>'CMS__SYSTIMDIF',       value=>'CMS$_SYSTIMDIF',
              macro=>'CMS$_SYSTIMDIF' },
            { name=>'CMS__SYSTIMERR',       value=>'CMS$_SYSTIMERR',
              macro=>'CMS$_SYSTIMERR' },
            { name=>'CMS__TIMEORDER',       value=>'CMS$_TIMEORDER',
              macro=>'CMS$_TIMEORDER' },
            { name=>'CMS__TOODEEP',         value=>'CMS$_TOODEEP',
              macro=>'CMS$_TOODEEP' },
            { name=>'CMS__TOOLONG',         value=>'CMS$_TOOLONG',
              macro=>'CMS$_TOOLONG' },
            { name=>'CMS__TOOMANYLIBS',     value=>'CMS$_TOOMANYLIBS',
              macro=>'CMS$_TOOMANYLIBS' },
            { name=>'CMS__TRUNCLST',        value=>'CMS$_TRUNCLST',
              macro=>'CMS$_TRUNCLST' },
            { name=>'CMS__TRYAGNLAT',       value=>'CMS$_TRYAGNLAT',
              macro=>'CMS$_TRYAGNLAT' },
            { name=>'CMS__UNDEFLIB',        value=>'CMS$_UNDEFLIB',
              macro=>'CMS$_UNDEFLIB' },
            { name=>'CMS__UNFOUT',          value=>'CMS$_UNFOUT',
              macro=>'CMS$_UNFOUT' },
            { name=>'CMS__UNRECTYPE',       value=>'CMS$_UNRECTYPE',
              macro=>'CMS$_UNRECTYPE' },
            { name=>'CMS__UNRESERVED',      value=>'CMS$_UNRESERVED',
              macro=>'CMS$_UNRESERVED' },
            { name=>'CMS__UNRESERVES',      value=>'CMS$_UNRESERVES',
              macro=>'CMS$_UNRESERVES' },
            { name=>'CMS__UNSUPFRMT',       value=>'CMS$_UNSUPFRMT',
              macro=>'CMS$_UNSUPFRMT' },
            { name=>'CMS__USERECOVER',      value=>'CMS$_USERECOVER',
              macro=>'CMS$_USERECOVER' },
            { name=>'CMS__USEREPAIR',       value=>'CMS$_USEREPAIR',
              macro=>'CMS$_USEREPAIR' },
            { name=>'CMS__USERERR',         value=>'CMS$_USERERR',
              macro=>'CMS$_USERERR' },
            { name=>'CMS__USESETLIB',       value=>'CMS$_USESETLIB',
              macro=>'CMS$_USESETLIB' },
            { name=>'CMS__VARINRANGE',      value=>'CMS$_VARINRANGE',
              macro=>'CMS$_VARINRANGE' },
            { name=>'CMS__VARLETTER',       value=>'CMS$_VARLETTER',
              macro=>'CMS$_VARLETTER' },
            { name=>'CMS__VER2',            value=>'CMS$_VER2',
              macro=>'CMS$_VER2' },
            { name=>'CMS__VERARC',          value=>'CMS$_VERARC',
              macro=>'CMS$_VERARC' },
            { name=>'CMS__VERCLS',          value=>'CMS$_VERCLS',
              macro=>'CMS$_VERCLS' },
            { name=>'CMS__VERCMD',          value=>'CMS$_VERCMD',
              macro=>'CMS$_VERCMD' },
            { name=>'CMS__VERCON',          value=>'CMS$_VERCON',
              macro=>'CMS$_VERCON' },
            { name=>'CMS__VEREDF',          value=>'CMS$_VEREDF',
              macro=>'CMS$_VEREDF' },
            { name=>'CMS__VEREDFERR',       value=>'CMS$_VEREDFERR',
              macro=>'CMS$_VEREDFERR' },
            { name=>'CMS__VEREDFS',         value=>'CMS$_VEREDFS',
              macro=>'CMS$_VEREDFS' },
            { name=>'CMS__VERELE',          value=>'CMS$_VERELE',
              macro=>'CMS$_VERELE' },
            { name=>'CMS__VERFRE',          value=>'CMS$_VERFRE',
              macro=>'CMS$_VERFRE' },
            { name=>'CMS__VERGRP',          value=>'CMS$_VERGRP',
              macro=>'CMS$_VERGRP' },
            { name=>'CMS__VERIFIED',        value=>'CMS$_VERIFIED',
              macro=>'CMS$_VERIFIED' },
            { name=>'CMS__VERILLDATREC',    value=>'CMS$_VERILLDATREC',
              macro=>'CMS$_VERILLDATREC' },
            { name=>'CMS__VERLMTERR',       value=>'CMS$_VERLMTERR',
              macro=>'CMS$_VERLMTERR' },
            { name=>'CMS__VERREF',          value=>'CMS$_VERREF',
              macro=>'CMS$_VERREF' },
            { name=>'CMS__VERREFERR',       value=>'CMS$_VERREFERR',
              macro=>'CMS$_VERREFERR' },
            { name=>'CMS__VERREFERRW',      value=>'CMS$_VERREFERRW',
              macro=>'CMS$_VERREFERRW' },
            { name=>'CMS__VERREFS',         value=>'CMS$_VERREFS',
              macro=>'CMS$_VERREFS' },
            { name=>'CMS__VERRES',          value=>'CMS$_VERRES',
              macro=>'CMS$_VERRES' },
            { name=>'CMS__VERSTR',          value=>'CMS$_VERSTR',
              macro=>'CMS$_VERSTR' },
            { name=>'CMS__WAITING',         value=>'CMS$_WAITING',
              macro=>'CMS$_WAITING' },
            { name=>'CMS__WILDCONFLICT',    value=>'CMS$_WILDCONFLICT',
              macro=>'CMS$_WILDCONFLICT' },
            { name=>'CMS__WILDMATCH',       value=>'CMS$_WILDMATCH',
              macro=>'CMS$_WILDMATCH' },
            { name=>'CMS__WILDNEEDED',      value=>'CMS$_WILDNEEDED',
              macro=>'CMS$_WILDNEEDED' },
            { name=>'CMS__WILDNOMATCH',     value=>'CMS$_WILDNOMATCH',
              macro=>'CMS$_WILDNOMATCH' },
            { name=>'CMS__WILDVER',         value=>'CMS$_WILDVER',
              macro=>'CMS$_WILDVER' },
            { name=>'CMS__WRITEERR',        value=>'CMS$_WRITEERR',
              macro=>'CMS$_WRITEERR' },
            { name=>'CMS__ZEROADD',         value=>'CMS$_ZEROADD',
              macro=>'CMS$_ZEROADD' },
            { name=>'CMS__ZLENBLK',         value=>'CMS$_ZLENBLK',
              macro=>'CMS$_ZLENBLK' });
  ExtUtils::Constant::WriteConstants(
                                     NAME         => 'VMS::CMS',
                                     NAMES        => \@names,
                                     DEFAULT_TYPE => 'IV',
                                     C_FILE       => 'const-c.inc',
                                     XS_FILE      => 'const-xs.inc',
                                  );

}
else {
  use File::Copy;
  use File::Spec;
  foreach my $file ('const-c.inc', 'const-xs.inc') {
    my $fallback = File::Spec->catfile('fallback', $file);
    copy ($fallback, $file) or die "Can't copy $fallback to $file: $!";
  }
}
