
use strict;
use warnings;

use 5.006;

use ExtUtils::MakeMaker 6.30;



my %WriteMakefileArgs = (
  "ABSTRACT" => "Run Kwalitee tests including optional indicators, especially, prereq_matches_use",
  "AUTHOR" => "Yasutaka ATARASHI <yakex\@cpan.org>",
  "BUILD_REQUIRES" => {},
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.30"
  },
  "DISTNAME" => "Test-Kwalitee-Extra",
  "EXE_FILES" => [],
  "LICENSE" => "perl",
  "NAME" => "Test::Kwalitee::Extra",
  "PREREQ_PM" => {
    "MetaCPAN::API::Tiny" => 0,
    "Module::CPANTS::Analyse" => "0.87",
    "Module::CoreList" => "2.31_01",
    "Module::Extract::Namespaces" => 0,
    "Test::Builder::Tester" => 0,
    "version" => "0.77"
  },
  "TEST_REQUIRES" => {
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Test::More" => 0
  },
  "VERSION" => "v0.2.1",
  "test" => {
    "TESTS" => "t/*.t"
  }
);


my %FallbackPrereqs = (
  "File::Spec" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "MetaCPAN::API::Tiny" => 0,
  "Module::CPANTS::Analyse" => "0.87",
  "Module::CoreList" => "2.31_01",
  "Module::Extract::Namespaces" => 0,
  "Test::Builder::Tester" => 0,
  "Test::More" => 0,
  "version" => "0.77"
);


unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);



