# NAME

DBIx::Handler - fork-safe and easy transaction handling DBI handler

# SYNOPSIS

    use DBIx::Handler;
    my $handler = DBIx::Handler->new($dsn, $user, $pass, $opts);
    my $dbh = $handler->dbh;
    $dbh->do(...);

# DESCRIPTION

DBIx::Handler is fork-safe and easy transaction handling DBI handler.

DBIx::Handler provide scope base transaction, fork safe dbh handling, simple.

# METHODS

- my $handler = DBIx::Handler->new($dsn, $user, $pass, $opts);

    get database handling instance.

- my $handler = DBIx::Handler->connect($dsn, $user, $pass, $opts);

    connect method is alias for new method.

- my $dbh = $handler->dbh;

    get fork safe DBI handle.

- $handler->disconnect;

    disconnect current database handle.

- my $txn\_guard = $handler->txn\_scope

    Creates a new transaction scope guard object.

        do {
            my $txn_guard = $handler->txn_scope;
                # some process
            $txn_guard->commit;
        }

    If an exception occurs, or the guard object otherwise leaves the scope
    before `$txn->commit` is called, the transaction will be rolled
    back by an explicit ["txn\_rollback"](#txn_rollback) call. In essence this is akin to
    using a ["txn\_begin"](#txn_begin)/["txn\_commit"](#txn_commit) pair, without having to worry
    about calling ["txn\_rollback"](#txn_rollback) at the right places. Note that since there
    is no defined code closure, there will be no retries and other magic upon
    database disconnection.

- $txn\_manager = $handler->txn\_manager

    Get the [DBIx::TransactionManager](https://metacpan.org/pod/DBIx::TransactionManager) instance.

- $handler->txn\_begin

    start new transaction.

- $handler->txn\_commit

    commit transaction.

- $handler->txn\_rollback

    rollback transaction.

- $handler->in\_txn

    are you in transaction?

- my @result = $handler->txn($coderef);

    execute $coderef in auto transaction scope.

    begin transaction before $coderef execute, do $coderef with database handle, after commit or rollback transaction.

        $handler->txn(sub {
            my $dbh = shift;
            $dbh->do(...);
        });

    equals to:

        $handler->txn_begin;
            my $dbh = $handler->dbh;
            $dbh->do(...);
        $handler->txn_rollback;

- my @result = $handler->run($coderef);

    execute $coderef.

        my $rs = $handler->run(sub {
            my $dbh = shift;
            $dbh->selectall_arrayref(...);
        });

    or

        my @result = $handler->run(sub {
            my $dbh = shift;
            $dbh->selectrow_array('...');
        });

- my $sth = $handler->query($sql, \[\\@bind | \\%bind\]);

    execute query. return database statement handler. 

- $handler->result\_class($result\_class\_name);

    set result\_class package name.

    this result\_class use to be create query method response object.

- $handler->trace\_query($flag);

    inject sql comment when trace\_query is true. 

- $handler->trace\_ignore\_if($callback);

    ignore to inject sql comment when trace\_ignore\_if's return value is true. 

# AUTHOR

Atsushi Kobayashi &lt;nekokak \_at\_ gmail \_dot\_ com>

# LICENSE

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.
