package Exception::NoException::_obj;
BEGIN {
  $Exception::NoException::_obj::VERSION = '0.07';
}
# ABSTRACT: Implementation for Exception::NoException object
use strict;

# Pretend to be an empty scalar.
use UNIVERSAL::ref;
sub ref {''}

use overload
    'fallback' => undef,
    '=' => sub { '' },

    '+' => sub { $_[2] ? ($_[1] + 0) : (0 + $_[0]) },
    '-' => sub { $_[2] ? ($_[1] - 0) : (0 - $_[0]) },
    '*' => sub { $_[2] ? ($_[1] * 0) : (0 * $_[0]) },
    '/' => sub { $_[2] ? ($_[1] / 0) : (0 / $_[0]) },
    '%' => sub { $_[2] ? ($_[1] % 0) : (0 % $_[0]) },
    '**' => sub { $_[2] ? ($_[1] ** 0) : (0 ** $_[0]) },
    '<<' => sub { $_[2] ? ($_[1] << 0) : (0 << $_[0]) },
    '>>' => sub { $_[2] ? ($_[1] >> 0) : (0 >> $_[0]) },
    'x' => sub { $_[2] ? ($_[1] x 0) : (0 x $_[0]) },
    '.' => sub { $_[2] ? ($_[1] . 0) : (0 . $_[0]) },
    '<=>' => sub { $_[2] ? ($_[1] <=> 0) : (0 <=> $_[0]) },
    'cmp' => sub { $_[2] ? ($_[1] cmp 0) : (0 cmp $_[0]) },
    '&' => sub { $_[2] ? ($_[1] & 0) : (0 & $_[0]) },
    '^' => sub { $_[2] ? ($_[1] ^ 0) : (0 ^ $_[0]) },
    '|' => sub { $_[2] ? ($_[1] | 0) : (0 | $_[0]) },
    '~' => sub { ~ '' },
    'atan2' => sub { $_[2] ? atan2( $_[1], $_[0] ) : atan2( $_[0], $_[1] ) },
    'cos'   => sub { 1 },
    'sin'   => sub { 0 },
    'exp'   => sub { 1 },
    'abs'   => sub { 0 },
    'sqrt'  => sub { 0 },
    'int'   => sub { 0 },

    # Autogenerated:
    # += -= *= /= %= **= <<= >>= x= .=
    # < <= > >= == != lt le gt ge eq ne
    # &= ^= |= neg !
    # ++ --
    # <>

    # Conversion
    '""'   => sub { '' },
    'bool' => sub { !1 },
    '0+'   => sub { 0 },
    'qr'   => sub { qr// },

    # Matching
    (
        $] >= 5.010
        ? ( '~~' => sub { '' } )
        : ()
    ),

    # Dereferencing
    '${}' => sub { '' },
    '@{}' => sub { '' },
    '%{}' => sub { '' },
    '&{}' => sub { '' },
    '*{}' => sub { '' },
;

q[ Hey, what does this switch labeled 'Pulsating Ejector' do?

   I don't know... I've always been too afraid to find out ];

__END__
=head1 DESCRIPTION

This object acts as if it were an empty string.

=head1 METHODS

=over

=item $obj-E<gt>ref

Returns C<"">.

=back

=head1 SEE ALSO

L<Exception::NoException>
