/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote.internal;

import com.google.common.base.Joiner;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.openqa.selenium.remote.http.HttpRequest;

class HttpUrlBuilder {
    private static final Function<String, String> QUERY_ENCODE = str -> {
        try {
            return URLEncoder.encode(str, StandardCharsets.US_ASCII.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new UncheckedIOException(e);
        }
    };

    private HttpUrlBuilder() {
    }

    static URL toUrl(URL base, HttpRequest request) throws MalformedURLException {
        StringBuilder queryString = new StringBuilder();
        Joiner parameters = Joiner.on("&");
        List allParams = StreamSupport.stream(request.getQueryParameterNames().spliterator(), false).map(name -> {
            String encoded = QUERY_ENCODE.apply((String)name);
            return parameters.join(StreamSupport.stream(request.getQueryParameters((String)name).spliterator(), false).map(value -> encoded + "=" + QUERY_ENCODE.apply((String)value)).collect(Collectors.toList()));
        }).collect(Collectors.toList());
        parameters.appendTo(queryString, (Iterable<?>)allParams);
        String baseUrl = request.getUri().startsWith("http://") || request.getUri().startsWith("https://") ? request.getUri() : base.toExternalForm().replaceAll("/$", "") + request.getUri();
        if (!queryString.toString().isEmpty()) {
            baseUrl = baseUrl + "?" + queryString.toString();
        }
        return new URL(baseUrl);
    }
}

