/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;

public class EdgeDriverInfo
implements WebDriverInfo {
    @Override
    public String getDisplayName() {
        return "Edge";
    }

    @Override
    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", "MicrosoftEdge");
    }

    @Override
    public boolean isSupporting(Capabilities capabilities) {
        return "MicrosoftEdge".equals(capabilities.getBrowserName()) || capabilities.getCapability("edgeOptions") != null;
    }

    @Override
    public boolean isAvailable() {
        try {
            EdgeDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    @Override
    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    @Override
    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        return Optional.of(new EdgeDriver(capabilities));
    }
}

