#!perl -T

use strict;
use Test::Base;
use Text::Trac;

delimiters('###');

plan tests => 1 * blocks;

my $p = Text::Trac->new();

sub parse {
    local $_ = shift;
    $p->parse($_);
    $p->html;
}

filters { input => 'parse', expected => 'chomp' };
run_is 'input' => 'expected';

__DATA__
### h1 test
--- input
= heading 1 =
--- expected
<h1 id="heading1">heading 1</h1>

### h2 test
--- input
== heading 2 ==
--- expected
<h2 id="heading2">heading 2</h2>

### h3 test
--- input
=== heading 3 ===
--- expected
<h3 id="heading3">heading 3</h3>

### h4 test
--- input
==== heading 4 ====
--- expected
<h4 id="heading4">heading 4</h4>

### h5 test
--- input
===== heading 5 =====
--- expected
<h5 id="heading5">heading 5</h5>

### bold test
--- input
'''bold''' '''bold'''
--- expected
<p>
<strong>bold</strong> <strong>bold</strong>
</p>

### italic test
--- input
''italic'' ''italic''
--- expected
<p>
<i>italic</i> <i>italic</i>
</p>

### bolditalic test
--- input
'''''bolditalic''''' '''''bolditalic'''''
--- expected
<p>
<strong><i>bolditalic</i></strong> <strong><i>bolditalic</i></strong>
</p>

### underline test
--- input
__underline__ __underline__
--- expected
<p>
<span class="underline">underline</span> <span class="underline">underline</span>
</p>

### monospace test
--- input
`monospace` {{{monospace}}}
--- expected
<p>
<tt>monospace</tt> <tt>monospace</tt>
</p>

### strike test
--- input
~~strike~~ ~~strike~~
--- expected
<p>
<del>strike</del> <del>strike</del>
</p>

### sup test
--- input
^sup^ ^sup^
--- expected
<p>
<sup>sup</sup> <sup>sup</sup>
</p>

### sub test
--- input
,,sub,, ,,sub,,
--- expected
<p>
<sub>sub</sub> <sub>sub</sub>
</p>

### br test
--- input
line1[[BR]]line2
--- expected
<p>
line1<br />line2
</p>

### p test
--- input
test
test
--- expected
<p>
test
test
</p>

### ul test
--- input
 * list 1-1
 * list 1-2
   * list 2-1
   * list 2-2
--- expected
<ul><li>list 1-1</li>
<li>list 1-2</li>
<ul><li>list 2-1</li>
<li>list 2-2</li></ul></ul>

### ol test
--- input
 1. list 1-1
 1. list 1-2
   a. list a-1
   a. list a-2
--- expected
<ol start="1"><li>list 1-1</li>
<li>list 1-2</li>
<ol class="loweralpha"><li>list a-1</li>
<li>list a-2</li></ol></ol>

### blockauote test
--- input
  This text is a quote from someone else.
--- expected
<blockquote>
<p>
  This text is a quote from someone else.
</p>
</blockquote>

### pre test
--- input
{{{
  This is pre-formatted text.
  This also pre-formatted text.
}}}
--- expected
<pre class="wiki">
  This is pre-formatted text.
  This also pre-formatted text.
</pre>

### table test
--- input
||Cell 1||Cell 2||Cell 3||
||Cell 4||Cell 5||Cell 6||
--- expected
<table>
<tr><td>Cell 1</td><td>Cell 2</td><td>Cell 3</td></tr>
<tr><td>Cell 4</td><td>Cell 5</td><td>Cell 6</td></tr>
</table>

### hr test
--- input
line1
====
line2
--- expected
<p>
line1
</p>
<hr />
<p>
line2
</p>

### dl test
--- input
 title1::
  content 1-1
  content 1-2
 title2::
  content 2-1
  content 2-2
  content 2-3
--- expected
<dl>
<dt>title1</dt>
<dd>
content 1-1
content 1-2
</dd>
<dt>title2</dt>
<dd>
content 2-1
content 2-2
content 2-3
</dd>
</dl>

### autolink test
--- input
http://mizzy.org/
[http://mizzy.org/ Title]
--- expected
<p>
<a class="ext-link" href="http://mizzy.org/">http://mizzy.org/</a>
<a class="ext-link" href="http://mizzy.org/">Title</a>
</p>

### auto image link test
--- input
http://mizzy.org/test.png
[http://mizzy.org/test.png Image]
--- expected
<p>
<img src="http://mizzy.org/test.png" alt="http://mizzy.org/test.png" />
<img src="http://mizzy.org/test.png" alt="Image" />
</p>

### ul node with single space
--- input
 * indent with
 * single space
   * sublist with
   * two spaces
--- expected
<ul><li>indent with</li>
<li>single space</li>
<ul><li>sublist with</li>
<li>two spaces</li></ul></ul>

### ul node with double space
--- input
  * indent with
  * two spaces
    * sublist with
    * two spaces
--- expected
<ul><li>indent with</li>
<li>two spaces</li>
<ul><li>sublist with</li>
<li>two spaces</li></ul></ul>

### ol node with single space
--- input
 1. indent with
 1. single space
   a. sublist with
   a. two spaces
--- expected
<ol start="1"><li>indent with</li>
<li>single space</li>
<ol class="loweralpha"><li>sublist with</li>
<li>two spaces</li></ol></ol>

### ol node with double space
--- input
  1. indent with
  1. two spaces
    a. sublist with
    a. two spaces
--- expected
<ol start="1"><li>indent with</li>
<li>two spaces</li>
<ol class="loweralpha"><li>sublist with</li>
<li>two spaces</li></ol></ol>

### dl node with single space
--- input
 title1::
   indent title
   single space
 title2::
   indent content
   double space
--- expected
<dl>
<dt>title1</dt>
<dd>
indent title
single space
</dd>
<dt>title2</dt>
<dd>
indent content
double space
</dd>
</dl>

### dl node with double space
--- input
  title1::
    indent title
    double space
  title2::
    indent content
    double space
--- expected
<dl>
<dt>title1</dt>
<dd>
indent title
double space
</dd>
<dt>title2</dt>
<dd>
indent content
double space
</dd>
</dl>
