/* -*- buffer-read-only: t -*-
 *
 *    opcode.h
 *
 *    Copyright (C) 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000,
 *    2001, 2002, 2003, 2004, 2005, 2006, 2007 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 *  This file is built by opcode.pl from its data.  Any changes made here
 *  will be lost!
 */

#ifndef PERL_GLOBAL_STRUCT_INIT

#define Perl_pp_i_preinc Perl_pp_preinc
#define Perl_pp_i_predec Perl_pp_predec
#define Perl_pp_i_postinc Perl_pp_postinc
#define Perl_pp_i_postdec Perl_pp_postdec

PERL_PPDEF(Perl_unimplemented_op)

START_EXTERN_C

#define OP_NAME(o) ((o)->op_type == OP_CUSTOM ? custom_op_name(o) : \
                    PL_op_name[(o)->op_type])
#define OP_DESC(o) ((o)->op_type == OP_CUSTOM ? custom_op_desc(o) : \
                    PL_op_desc[(o)->op_type])

#ifndef DOINIT
EXTCONST char* const PL_op_name[];
#else
EXTCONST char* const PL_op_name[] = {
	"null",
	"stub",
	"scalar",
	"pushmark",
	"wantarray",
	"const",
	"gvsv",
	"gv",
	"gelem",
	"padsv",
	"padav",
	"padhv",
	"padany",
	"pushre",
	"rv2gv",
	"rv2sv",
	"av2arylen",
	"rv2cv",
	"anoncode",
	"prototype",
	"refgen",
	"srefgen",
	"ref",
	"bless",
	"backtick",
	"glob",
	"readline",
	"rcatline",
	"regcmaybe",
	"regcreset",
	"regcomp",
	"match",
	"qr",
	"subst",
	"substcont",
	"trans",
	"sassign",
	"aassign",
	"chop",
	"schop",
	"chomp",
	"schomp",
	"defined",
	"undef",
	"study",
	"pos",
	"preinc",
	"i_preinc",
	"predec",
	"i_predec",
	"postinc",
	"i_postinc",
	"postdec",
	"i_postdec",
	"pow",
	"multiply",
	"i_multiply",
	"divide",
	"i_divide",
	"modulo",
	"i_modulo",
	"repeat",
	"add",
	"i_add",
	"subtract",
	"i_subtract",
	"concat",
	"stringify",
	"left_shift",
	"right_shift",
	"lt",
	"i_lt",
	"gt",
	"i_gt",
	"le",
	"i_le",
	"ge",
	"i_ge",
	"eq",
	"i_eq",
	"ne",
	"i_ne",
	"ncmp",
	"i_ncmp",
	"slt",
	"sgt",
	"sle",
	"sge",
	"seq",
	"sne",
	"scmp",
	"bit_and",
	"bit_xor",
	"bit_or",
	"negate",
	"i_negate",
	"not",
	"complement",
	"smartmatch",
	"atan2",
	"sin",
	"cos",
	"rand",
	"srand",
	"exp",
	"log",
	"sqrt",
	"int",
	"hex",
	"oct",
	"abs",
	"length",
	"substr",
	"vec",
	"index",
	"rindex",
	"sprintf",
	"formline",
	"ord",
	"chr",
	"crypt",
	"ucfirst",
	"lcfirst",
	"uc",
	"lc",
	"quotemeta",
	"rv2av",
	"aelemfast",
	"aelem",
	"aslice",
	"aeach",
	"akeys",
	"avalues",
	"each",
	"values",
	"keys",
	"delete",
	"exists",
	"rv2hv",
	"helem",
	"hslice",
	"unpack",
	"pack",
	"split",
	"join",
	"list",
	"lslice",
	"anonlist",
	"anonhash",
	"splice",
	"push",
	"pop",
	"shift",
	"unshift",
	"sort",
	"reverse",
	"grepstart",
	"grepwhile",
	"mapstart",
	"mapwhile",
	"range",
	"flip",
	"flop",
	"and",
	"or",
	"xor",
	"dor",
	"cond_expr",
	"andassign",
	"orassign",
	"dorassign",
	"method",
	"entersub",
	"leavesub",
	"leavesublv",
	"caller",
	"warn",
	"die",
	"reset",
	"lineseq",
	"nextstate",
	"dbstate",
	"unstack",
	"enter",
	"leave",
	"scope",
	"enteriter",
	"iter",
	"enterloop",
	"leaveloop",
	"return",
	"last",
	"next",
	"redo",
	"dump",
	"goto",
	"exit",
	"method_named",
	"entergiven",
	"leavegiven",
	"enterwhen",
	"leavewhen",
	"break",
	"continue",
	"open",
	"close",
	"pipe_op",
	"fileno",
	"umask",
	"binmode",
	"tie",
	"untie",
	"tied",
	"dbmopen",
	"dbmclose",
	"sselect",
	"select",
	"getc",
	"read",
	"enterwrite",
	"leavewrite",
	"prtf",
	"print",
	"say",
	"sysopen",
	"sysseek",
	"sysread",
	"syswrite",
	"eof",
	"tell",
	"seek",
	"truncate",
	"fcntl",
	"ioctl",
	"flock",
	"send",
	"recv",
	"socket",
	"sockpair",
	"bind",
	"connect",
	"listen",
	"accept",
	"shutdown",
	"gsockopt",
	"ssockopt",
	"getsockname",
	"getpeername",
	"lstat",
	"stat",
	"ftrread",
	"ftrwrite",
	"ftrexec",
	"fteread",
	"ftewrite",
	"fteexec",
	"ftis",
	"ftsize",
	"ftmtime",
	"ftatime",
	"ftctime",
	"ftrowned",
	"fteowned",
	"ftzero",
	"ftsock",
	"ftchr",
	"ftblk",
	"ftfile",
	"ftdir",
	"ftpipe",
	"ftsuid",
	"ftsgid",
	"ftsvtx",
	"ftlink",
	"fttty",
	"fttext",
	"ftbinary",
	"chdir",
	"chown",
	"chroot",
	"unlink",
	"chmod",
	"utime",
	"rename",
	"link",
	"symlink",
	"readlink",
	"mkdir",
	"rmdir",
	"open_dir",
	"readdir",
	"telldir",
	"seekdir",
	"rewinddir",
	"closedir",
	"fork",
	"wait",
	"waitpid",
	"system",
	"exec",
	"kill",
	"getppid",
	"getpgrp",
	"setpgrp",
	"getpriority",
	"setpriority",
	"time",
	"tms",
	"localtime",
	"gmtime",
	"alarm",
	"sleep",
	"shmget",
	"shmctl",
	"shmread",
	"shmwrite",
	"msgget",
	"msgctl",
	"msgsnd",
	"msgrcv",
	"semop",
	"semget",
	"semctl",
	"require",
	"dofile",
	"hintseval",
	"entereval",
	"leaveeval",
	"entertry",
	"leavetry",
	"ghbyname",
	"ghbyaddr",
	"ghostent",
	"gnbyname",
	"gnbyaddr",
	"gnetent",
	"gpbyname",
	"gpbynumber",
	"gprotoent",
	"gsbyname",
	"gsbyport",
	"gservent",
	"shostent",
	"snetent",
	"sprotoent",
	"sservent",
	"ehostent",
	"enetent",
	"eprotoent",
	"eservent",
	"gpwnam",
	"gpwuid",
	"gpwent",
	"spwent",
	"epwent",
	"ggrnam",
	"ggrgid",
	"ggrent",
	"sgrent",
	"egrent",
	"getlogin",
	"syscall",
	"lock",
	"once",
	"custom",
};
#endif

#ifndef DOINIT
EXTCONST char* const PL_op_desc[];
#else
EXTCONST char* const PL_op_desc[] = {
	"null operation",
	"stub",
	"scalar",
	"pushmark",
	"wantarray",
	"constant item",
	"scalar variable",
	"glob value",
	"glob elem",
	"private variable",
	"private array",
	"private hash",
	"private value",
	"push regexp",
	"ref-to-glob cast",
	"scalar dereference",
	"array length",
	"subroutine dereference",
	"anonymous subroutine",
	"subroutine prototype",
	"reference constructor",
	"single ref constructor",
	"reference-type operator",
	"bless",
	"quoted execution (``, qx)",
	"glob",
	"<HANDLE>",
	"append I/O operator",
	"regexp internal guard",
	"regexp internal reset",
	"regexp compilation",
	"pattern match (m//)",
	"pattern quote (qr//)",
	"substitution (s///)",
	"substitution iterator",
	"transliteration (tr///)",
	"scalar assignment",
	"list assignment",
	"chop",
	"scalar chop",
	"chomp",
	"scalar chomp",
	"defined operator",
	"undef operator",
	"study",
	"match position",
	"preincrement (++)",
	"integer preincrement (++)",
	"predecrement (--)",
	"integer predecrement (--)",
	"postincrement (++)",
	"integer postincrement (++)",
	"postdecrement (--)",
	"integer postdecrement (--)",
	"exponentiation (**)",
	"multiplication (*)",
	"integer multiplication (*)",
	"division (/)",
	"integer division (/)",
	"modulus (%)",
	"integer modulus (%)",
	"repeat (x)",
	"addition (+)",
	"integer addition (+)",
	"subtraction (-)",
	"integer subtraction (-)",
	"concatenation (.) or string",
	"string",
	"left bitshift (<<)",
	"right bitshift (>>)",
	"numeric lt (<)",
	"integer lt (<)",
	"numeric gt (>)",
	"integer gt (>)",
	"numeric le (<=)",
	"integer le (<=)",
	"numeric ge (>=)",
	"integer ge (>=)",
	"numeric eq (==)",
	"integer eq (==)",
	"numeric ne (!=)",
	"integer ne (!=)",
	"numeric comparison (<=>)",
	"integer comparison (<=>)",
	"string lt",
	"string gt",
	"string le",
	"string ge",
	"string eq",
	"string ne",
	"string comparison (cmp)",
	"bitwise and (&)",
	"bitwise xor (^)",
	"bitwise or (|)",
	"negation (-)",
	"integer negation (-)",
	"not",
	"1's complement (~)",
	"smart match",
	"atan2",
	"sin",
	"cos",
	"rand",
	"srand",
	"exp",
	"log",
	"sqrt",
	"int",
	"hex",
	"oct",
	"abs",
	"length",
	"substr",
	"vec",
	"index",
	"rindex",
	"sprintf",
	"formline",
	"ord",
	"chr",
	"crypt",
	"ucfirst",
	"lcfirst",
	"uc",
	"lc",
	"quotemeta",
	"array dereference",
	"constant array element",
	"array element",
	"array slice",
	"each on array",
	"keys on array",
	"values on array",
	"each",
	"values",
	"keys",
	"delete",
	"exists",
	"hash dereference",
	"hash element",
	"hash slice",
	"unpack",
	"pack",
	"split",
	"join or string",
	"list",
	"list slice",
	"anonymous list ([])",
	"anonymous hash ({})",
	"splice",
	"push",
	"pop",
	"shift",
	"unshift",
	"sort",
	"reverse",
	"grep",
	"grep iterator",
	"map",
	"map iterator",
	"flipflop",
	"range (or flip)",
	"range (or flop)",
	"logical and (&&)",
	"logical or (||)",
	"logical xor",
	"defined or (//)",
	"conditional expression",
	"logical and assignment (&&=)",
	"logical or assignment (||=)",
	"defined or assignment (//=)",
	"method lookup",
	"subroutine entry",
	"subroutine exit",
	"lvalue subroutine return",
	"caller",
	"warn",
	"die",
	"symbol reset",
	"line sequence",
	"next statement",
	"debug next statement",
	"iteration finalizer",
	"block entry",
	"block exit",
	"block",
	"foreach loop entry",
	"foreach loop iterator",
	"loop entry",
	"loop exit",
	"return",
	"last",
	"next",
	"redo",
	"dump",
	"goto",
	"exit",
	"method with known name",
	"given()",
	"leave given block",
	"when()",
	"leave when block",
	"break",
	"continue",
	"open",
	"close",
	"pipe",
	"fileno",
	"umask",
	"binmode",
	"tie",
	"untie",
	"tied",
	"dbmopen",
	"dbmclose",
	"select system call",
	"select",
	"getc",
	"read",
	"write",
	"write exit",
	"printf",
	"print",
	"say",
	"sysopen",
	"sysseek",
	"sysread",
	"syswrite",
	"eof",
	"tell",
	"seek",
	"truncate",
	"fcntl",
	"ioctl",
	"flock",
	"send",
	"recv",
	"socket",
	"socketpair",
	"bind",
	"connect",
	"listen",
	"accept",
	"shutdown",
	"getsockopt",
	"setsockopt",
	"getsockname",
	"getpeername",
	"lstat",
	"stat",
	"-R",
	"-W",
	"-X",
	"-r",
	"-w",
	"-x",
	"-e",
	"-s",
	"-M",
	"-A",
	"-C",
	"-O",
	"-o",
	"-z",
	"-S",
	"-c",
	"-b",
	"-f",
	"-d",
	"-p",
	"-u",
	"-g",
	"-k",
	"-l",
	"-t",
	"-T",
	"-B",
	"chdir",
	"chown",
	"chroot",
	"unlink",
	"chmod",
	"utime",
	"rename",
	"link",
	"symlink",
	"readlink",
	"mkdir",
	"rmdir",
	"opendir",
	"readdir",
	"telldir",
	"seekdir",
	"rewinddir",
	"closedir",
	"fork",
	"wait",
	"waitpid",
	"system",
	"exec",
	"kill",
	"getppid",
	"getpgrp",
	"setpgrp",
	"getpriority",
	"setpriority",
	"time",
	"times",
	"localtime",
	"gmtime",
	"alarm",
	"sleep",
	"shmget",
	"shmctl",
	"shmread",
	"shmwrite",
	"msgget",
	"msgctl",
	"msgsnd",
	"msgrcv",
	"semop",
	"semget",
	"semctl",
	"require",
	"do \"file\"",
	"eval hints",
	"eval \"string\"",
	"eval \"string\" exit",
	"eval {block}",
	"eval {block} exit",
	"gethostbyname",
	"gethostbyaddr",
	"gethostent",
	"getnetbyname",
	"getnetbyaddr",
	"getnetent",
	"getprotobyname",
	"getprotobynumber",
	"getprotoent",
	"getservbyname",
	"getservbyport",
	"getservent",
	"sethostent",
	"setnetent",
	"setprotoent",
	"setservent",
	"endhostent",
	"endnetent",
	"endprotoent",
	"endservent",
	"getpwnam",
	"getpwuid",
	"getpwent",
	"setpwent",
	"endpwent",
	"getgrnam",
	"getgrgid",
	"getgrent",
	"setgrent",
	"endgrent",
	"getlogin",
	"syscall",
	"lock",
	"once",
	"unknown custom operator",
};
#endif

END_EXTERN_C

#endif /* !PERL_GLOBAL_STRUCT_INIT */

START_EXTERN_C

#ifdef PERL_GLOBAL_STRUCT_INIT
#  define PERL_PPADDR_INITED
static const Perl_ppaddr_t Gppaddr[]
#else
#  ifndef PERL_GLOBAL_STRUCT
#    define PERL_PPADDR_INITED
EXT Perl_ppaddr_t PL_ppaddr[] /* or perlvars.h */
#  endif
#endif /* PERL_GLOBAL_STRUCT */
#if (defined(DOINIT) && !defined(PERL_GLOBAL_STRUCT)) || defined(PERL_GLOBAL_STRUCT_INIT)
#  define PERL_PPADDR_INITED
= {
	MEMBER_TO_FPTR(Perl_pp_null),
	MEMBER_TO_FPTR(Perl_pp_stub),
	MEMBER_TO_FPTR(Perl_pp_null),	/* Perl_pp_scalar */
	MEMBER_TO_FPTR(Perl_pp_pushmark),
	MEMBER_TO_FPTR(Perl_pp_wantarray),
	MEMBER_TO_FPTR(Perl_pp_const),
	MEMBER_TO_FPTR(Perl_pp_gvsv),
	MEMBER_TO_FPTR(Perl_pp_gv),
	MEMBER_TO_FPTR(Perl_pp_gelem),
	MEMBER_TO_FPTR(Perl_pp_padsv),
	MEMBER_TO_FPTR(Perl_pp_padav),
	MEMBER_TO_FPTR(Perl_pp_padhv),
	MEMBER_TO_FPTR(Perl_unimplemented_op),	/* Perl_pp_padany */
	MEMBER_TO_FPTR(Perl_pp_pushre),
	MEMBER_TO_FPTR(Perl_pp_rv2gv),
	MEMBER_TO_FPTR(Perl_pp_rv2sv),
	MEMBER_TO_FPTR(Perl_pp_av2arylen),
	MEMBER_TO_FPTR(Perl_pp_rv2cv),
	MEMBER_TO_FPTR(Perl_pp_anoncode),
	MEMBER_TO_FPTR(Perl_pp_prototype),
	MEMBER_TO_FPTR(Perl_pp_refgen),
	MEMBER_TO_FPTR(Perl_pp_srefgen),
	MEMBER_TO_FPTR(Perl_pp_ref),
	MEMBER_TO_FPTR(Perl_pp_bless),
	MEMBER_TO_FPTR(Perl_pp_backtick),
	MEMBER_TO_FPTR(Perl_pp_glob),
	MEMBER_TO_FPTR(Perl_pp_readline),
	MEMBER_TO_FPTR(Perl_pp_rcatline),
	MEMBER_TO_FPTR(Perl_pp_null),	/* Perl_pp_regcmaybe */
	MEMBER_TO_FPTR(Perl_pp_regcreset),
	MEMBER_TO_FPTR(Perl_pp_regcomp),
	MEMBER_TO_FPTR(Perl_pp_match),
	MEMBER_TO_FPTR(Perl_pp_qr),
	MEMBER_TO_FPTR(Perl_pp_subst),
	MEMBER_TO_FPTR(Perl_pp_substcont),
	MEMBER_TO_FPTR(Perl_pp_trans),
	MEMBER_TO_FPTR(Perl_pp_sassign),
	MEMBER_TO_FPTR(Perl_pp_aassign),
	MEMBER_TO_FPTR(Perl_pp_chop),
	MEMBER_TO_FPTR(Perl_pp_schop),
	MEMBER_TO_FPTR(Perl_pp_chomp),
	MEMBER_TO_FPTR(Perl_pp_schomp),
	MEMBER_TO_FPTR(Perl_pp_defined),
	MEMBER_TO_FPTR(Perl_pp_undef),
	MEMBER_TO_FPTR(Perl_pp_study),
	MEMBER_TO_FPTR(Perl_pp_pos),
	MEMBER_TO_FPTR(Perl_pp_preinc),
	MEMBER_TO_FPTR(Perl_pp_i_preinc),
	MEMBER_TO_FPTR(Perl_pp_predec),
	MEMBER_TO_FPTR(Perl_pp_i_predec),
	MEMBER_TO_FPTR(Perl_pp_postinc),
	MEMBER_TO_FPTR(Perl_pp_i_postinc),
	MEMBER_TO_FPTR(Perl_pp_postdec),
	MEMBER_TO_FPTR(Perl_pp_i_postdec),
	MEMBER_TO_FPTR(Perl_pp_pow),
	MEMBER_TO_FPTR(Perl_pp_multiply),
	MEMBER_TO_FPTR(Perl_pp_i_multiply),
	MEMBER_TO_FPTR(Perl_pp_divide),
	MEMBER_TO_FPTR(Perl_pp_i_divide),
	MEMBER_TO_FPTR(Perl_pp_modulo),
	MEMBER_TO_FPTR(Perl_pp_i_modulo),
	MEMBER_TO_FPTR(Perl_pp_repeat),
	MEMBER_TO_FPTR(Perl_pp_add),
	MEMBER_TO_FPTR(Perl_pp_i_add),
	MEMBER_TO_FPTR(Perl_pp_subtract),
	MEMBER_TO_FPTR(Perl_pp_i_subtract),
	MEMBER_TO_FPTR(Perl_pp_concat),
	MEMBER_TO_FPTR(Perl_pp_stringify),
	MEMBER_TO_FPTR(Perl_pp_left_shift),
	MEMBER_TO_FPTR(Perl_pp_right_shift),
	MEMBER_TO_FPTR(Perl_pp_lt),
	MEMBER_TO_FPTR(Perl_pp_i_lt),
	MEMBER_TO_FPTR(Perl_pp_gt),
	MEMBER_TO_FPTR(Perl_pp_i_gt),
	MEMBER_TO_FPTR(Perl_pp_le),
	MEMBER_TO_FPTR(Perl_pp_i_le),
	MEMBER_TO_FPTR(Perl_pp_ge),
	MEMBER_TO_FPTR(Perl_pp_i_ge),
	MEMBER_TO_FPTR(Perl_pp_eq),
	MEMBER_TO_FPTR(Perl_pp_i_eq),
	MEMBER_TO_FPTR(Perl_pp_ne),
	MEMBER_TO_FPTR(Perl_pp_i_ne),
	MEMBER_TO_FPTR(Perl_pp_ncmp),
	MEMBER_TO_FPTR(Perl_pp_i_ncmp),
	MEMBER_TO_FPTR(Perl_pp_sle),	/* Perl_pp_slt */
	MEMBER_TO_FPTR(Perl_pp_sle),	/* Perl_pp_sgt */
	MEMBER_TO_FPTR(Perl_pp_sle),
	MEMBER_TO_FPTR(Perl_pp_sle),	/* Perl_pp_sge */
	MEMBER_TO_FPTR(Perl_pp_seq),
	MEMBER_TO_FPTR(Perl_pp_sne),
	MEMBER_TO_FPTR(Perl_pp_scmp),
	MEMBER_TO_FPTR(Perl_pp_bit_and),
	MEMBER_TO_FPTR(Perl_pp_bit_or),	/* Perl_pp_bit_xor */
	MEMBER_TO_FPTR(Perl_pp_bit_or),
	MEMBER_TO_FPTR(Perl_pp_negate),
	MEMBER_TO_FPTR(Perl_pp_i_negate),
	MEMBER_TO_FPTR(Perl_pp_not),
	MEMBER_TO_FPTR(Perl_pp_complement),
	MEMBER_TO_FPTR(Perl_pp_smartmatch),
	MEMBER_TO_FPTR(Perl_pp_atan2),
	MEMBER_TO_FPTR(Perl_pp_sin),
	MEMBER_TO_FPTR(Perl_pp_sin),	/* Perl_pp_cos */
	MEMBER_TO_FPTR(Perl_pp_rand),
	MEMBER_TO_FPTR(Perl_pp_srand),
	MEMBER_TO_FPTR(Perl_pp_sin),	/* Perl_pp_exp */
	MEMBER_TO_FPTR(Perl_pp_sin),	/* Perl_pp_log */
	MEMBER_TO_FPTR(Perl_pp_sin),	/* Perl_pp_sqrt */
	MEMBER_TO_FPTR(Perl_pp_int),
	MEMBER_TO_FPTR(Perl_pp_oct),	/* Perl_pp_hex */
	MEMBER_TO_FPTR(Perl_pp_oct),
	MEMBER_TO_FPTR(Perl_pp_abs),
	MEMBER_TO_FPTR(Perl_pp_length),
	MEMBER_TO_FPTR(Perl_pp_substr),
	MEMBER_TO_FPTR(Perl_pp_vec),
	MEMBER_TO_FPTR(Perl_pp_index),
	MEMBER_TO_FPTR(Perl_pp_index),	/* Perl_pp_rindex */
	MEMBER_TO_FPTR(Perl_pp_sprintf),
	MEMBER_TO_FPTR(Perl_pp_formline),
	MEMBER_TO_FPTR(Perl_pp_ord),
	MEMBER_TO_FPTR(Perl_pp_chr),
	MEMBER_TO_FPTR(Perl_pp_crypt),
	MEMBER_TO_FPTR(Perl_pp_ucfirst),
	MEMBER_TO_FPTR(Perl_pp_ucfirst),	/* Perl_pp_lcfirst */
	MEMBER_TO_FPTR(Perl_pp_uc),
	MEMBER_TO_FPTR(Perl_pp_lc),
	MEMBER_TO_FPTR(Perl_pp_quotemeta),
	MEMBER_TO_FPTR(Perl_pp_rv2av),
	MEMBER_TO_FPTR(Perl_pp_aelemfast),
	MEMBER_TO_FPTR(Perl_pp_aelem),
	MEMBER_TO_FPTR(Perl_pp_aslice),
	MEMBER_TO_FPTR(Perl_pp_aeach),
	MEMBER_TO_FPTR(Perl_pp_akeys),
	MEMBER_TO_FPTR(Perl_pp_akeys),	/* Perl_pp_avalues */
	MEMBER_TO_FPTR(Perl_pp_each),
	MEMBER_TO_FPTR(Perl_do_kv),	/* Perl_pp_values */
	MEMBER_TO_FPTR(Perl_do_kv),	/* Perl_pp_keys */
	MEMBER_TO_FPTR(Perl_pp_delete),
	MEMBER_TO_FPTR(Perl_pp_exists),
	MEMBER_TO_FPTR(Perl_pp_rv2av),	/* Perl_pp_rv2hv */
	MEMBER_TO_FPTR(Perl_pp_helem),
	MEMBER_TO_FPTR(Perl_pp_hslice),
	MEMBER_TO_FPTR(Perl_pp_unpack),
	MEMBER_TO_FPTR(Perl_pp_pack),
	MEMBER_TO_FPTR(Perl_pp_split),
	MEMBER_TO_FPTR(Perl_pp_join),
	MEMBER_TO_FPTR(Perl_pp_list),
	MEMBER_TO_FPTR(Perl_pp_lslice),
	MEMBER_TO_FPTR(Perl_pp_anonlist),
	MEMBER_TO_FPTR(Perl_pp_anonhash),
	MEMBER_TO_FPTR(Perl_pp_splice),
	MEMBER_TO_FPTR(Perl_pp_push),
	MEMBER_TO_FPTR(Perl_pp_shift),	/* Perl_pp_pop */
	MEMBER_TO_FPTR(Perl_pp_shift),
	MEMBER_TO_FPTR(Perl_pp_unshift),
	MEMBER_TO_FPTR(Perl_pp_sort),
	MEMBER_TO_FPTR(Perl_pp_reverse),
	MEMBER_TO_FPTR(Perl_pp_grepstart),
	MEMBER_TO_FPTR(Perl_pp_grepwhile),
	MEMBER_TO_FPTR(Perl_unimplemented_op),	/* Perl_pp_mapstart */
	MEMBER_TO_FPTR(Perl_pp_mapwhile),
	MEMBER_TO_FPTR(Perl_pp_range),
	MEMBER_TO_FPTR(Perl_pp_flip),
	MEMBER_TO_FPTR(Perl_pp_flop),
	MEMBER_TO_FPTR(Perl_pp_and),
	MEMBER_TO_FPTR(Perl_pp_or),
	MEMBER_TO_FPTR(Perl_pp_xor),
	MEMBER_TO_FPTR(Perl_pp_defined),	/* Perl_pp_dor */
	MEMBER_TO_FPTR(Perl_pp_cond_expr),
	MEMBER_TO_FPTR(Perl_pp_and),	/* Perl_pp_andassign */
	MEMBER_TO_FPTR(Perl_pp_or),	/* Perl_pp_orassign */
	MEMBER_TO_FPTR(Perl_pp_defined),	/* Perl_pp_dorassign */
	MEMBER_TO_FPTR(Perl_pp_method),
	MEMBER_TO_FPTR(Perl_pp_entersub),
	MEMBER_TO_FPTR(Perl_pp_leavesub),
	MEMBER_TO_FPTR(Perl_pp_leavesublv),
	MEMBER_TO_FPTR(Perl_pp_caller),
	MEMBER_TO_FPTR(Perl_pp_warn),
	MEMBER_TO_FPTR(Perl_pp_die),
	MEMBER_TO_FPTR(Perl_pp_reset),
	MEMBER_TO_FPTR(Perl_pp_null),	/* Perl_pp_lineseq */
	MEMBER_TO_FPTR(Perl_pp_nextstate),
	MEMBER_TO_FPTR(Perl_pp_dbstate),
	MEMBER_TO_FPTR(Perl_pp_unstack),
	MEMBER_TO_FPTR(Perl_pp_enter),
	MEMBER_TO_FPTR(Perl_pp_leave),
	MEMBER_TO_FPTR(Perl_pp_null),	/* Perl_pp_scope */
	MEMBER_TO_FPTR(Perl_pp_enteriter),
	MEMBER_TO_FPTR(Perl_pp_iter),
	MEMBER_TO_FPTR(Perl_pp_enterloop),
	MEMBER_TO_FPTR(Perl_pp_leaveloop),
	MEMBER_TO_FPTR(Perl_pp_return),
	MEMBER_TO_FPTR(Perl_pp_last),
	MEMBER_TO_FPTR(Perl_pp_next),
	MEMBER_TO_FPTR(Perl_pp_redo),
	MEMBER_TO_FPTR(Perl_pp_goto),	/* Perl_pp_dump */
	MEMBER_TO_FPTR(Perl_pp_goto),
	MEMBER_TO_FPTR(Perl_pp_exit),
	MEMBER_TO_FPTR(Perl_pp_method_named),
	MEMBER_TO_FPTR(Perl_pp_entergiven),
	MEMBER_TO_FPTR(Perl_pp_leavegiven),
	MEMBER_TO_FPTR(Perl_pp_enterwhen),
	MEMBER_TO_FPTR(Perl_pp_leavewhen),
	MEMBER_TO_FPTR(Perl_pp_break),
	MEMBER_TO_FPTR(Perl_pp_continue),
	MEMBER_TO_FPTR(Perl_pp_open),
	MEMBER_TO_FPTR(Perl_pp_close),
	MEMBER_TO_FPTR(Perl_pp_pipe_op),
	MEMBER_TO_FPTR(Perl_pp_fileno),
	MEMBER_TO_FPTR(Perl_pp_umask),
	MEMBER_TO_FPTR(Perl_pp_binmode),
	MEMBER_TO_FPTR(Perl_pp_tie),
	MEMBER_TO_FPTR(Perl_pp_untie),
	MEMBER_TO_FPTR(Perl_pp_tied),
	MEMBER_TO_FPTR(Perl_pp_dbmopen),
	MEMBER_TO_FPTR(Perl_pp_untie),	/* Perl_pp_dbmclose */
	MEMBER_TO_FPTR(Perl_pp_sselect),
	MEMBER_TO_FPTR(Perl_pp_select),
	MEMBER_TO_FPTR(Perl_pp_getc),
	MEMBER_TO_FPTR(Perl_pp_sysread),	/* Perl_pp_read */
	MEMBER_TO_FPTR(Perl_pp_enterwrite),
	MEMBER_TO_FPTR(Perl_pp_leavewrite),
	MEMBER_TO_FPTR(Perl_pp_prtf),
	MEMBER_TO_FPTR(Perl_pp_print),
	MEMBER_TO_FPTR(Perl_pp_print),	/* Perl_pp_say */
	MEMBER_TO_FPTR(Perl_pp_sysopen),
	MEMBER_TO_FPTR(Perl_pp_sysseek),
	MEMBER_TO_FPTR(Perl_pp_sysread),
	MEMBER_TO_FPTR(Perl_pp_send),	/* Perl_pp_syswrite */
	MEMBER_TO_FPTR(Perl_pp_eof),
	MEMBER_TO_FPTR(Perl_pp_tell),
	MEMBER_TO_FPTR(Perl_pp_sysseek),	/* Perl_pp_seek */
	MEMBER_TO_FPTR(Perl_pp_truncate),
	MEMBER_TO_FPTR(Perl_pp_ioctl),	/* Perl_pp_fcntl */
	MEMBER_TO_FPTR(Perl_pp_ioctl),
	MEMBER_TO_FPTR(Perl_pp_flock),
	MEMBER_TO_FPTR(Perl_pp_send),
	MEMBER_TO_FPTR(Perl_pp_sysread),	/* Perl_pp_recv */
	MEMBER_TO_FPTR(Perl_pp_socket),
	MEMBER_TO_FPTR(Perl_pp_sockpair),
	MEMBER_TO_FPTR(Perl_pp_bind),
	MEMBER_TO_FPTR(Perl_pp_connect),
	MEMBER_TO_FPTR(Perl_pp_listen),
	MEMBER_TO_FPTR(Perl_pp_accept),
	MEMBER_TO_FPTR(Perl_pp_shutdown),
	MEMBER_TO_FPTR(Perl_pp_ssockopt),	/* Perl_pp_gsockopt */
	MEMBER_TO_FPTR(Perl_pp_ssockopt),
	MEMBER_TO_FPTR(Perl_pp_getpeername),	/* Perl_pp_getsockname */
	MEMBER_TO_FPTR(Perl_pp_getpeername),
	MEMBER_TO_FPTR(Perl_pp_stat),	/* Perl_pp_lstat */
	MEMBER_TO_FPTR(Perl_pp_stat),
	MEMBER_TO_FPTR(Perl_pp_ftrread),
	MEMBER_TO_FPTR(Perl_pp_ftrread),	/* Perl_pp_ftrwrite */
	MEMBER_TO_FPTR(Perl_pp_ftrread),	/* Perl_pp_ftrexec */
	MEMBER_TO_FPTR(Perl_pp_ftrread),	/* Perl_pp_fteread */
	MEMBER_TO_FPTR(Perl_pp_ftrread),	/* Perl_pp_ftewrite */
	MEMBER_TO_FPTR(Perl_pp_ftrread),	/* Perl_pp_fteexec */
	MEMBER_TO_FPTR(Perl_pp_ftis),
	MEMBER_TO_FPTR(Perl_pp_ftis),	/* Perl_pp_ftsize */
	MEMBER_TO_FPTR(Perl_pp_ftis),	/* Perl_pp_ftmtime */
	MEMBER_TO_FPTR(Perl_pp_ftis),	/* Perl_pp_ftatime */
	MEMBER_TO_FPTR(Perl_pp_ftis),	/* Perl_pp_ftctime */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_fteowned */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftzero */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftsock */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftchr */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftblk */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftfile */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftdir */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftpipe */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftsuid */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftsgid */
	MEMBER_TO_FPTR(Perl_pp_ftrowned),	/* Perl_pp_ftsvtx */
	MEMBER_TO_FPTR(Perl_pp_ftlink),
	MEMBER_TO_FPTR(Perl_pp_fttty),
	MEMBER_TO_FPTR(Perl_pp_fttext),
	MEMBER_TO_FPTR(Perl_pp_fttext),	/* Perl_pp_ftbinary */
	MEMBER_TO_FPTR(Perl_pp_chdir),
	MEMBER_TO_FPTR(Perl_pp_chown),
	MEMBER_TO_FPTR(Perl_pp_chroot),
	MEMBER_TO_FPTR(Perl_pp_chown),	/* Perl_pp_unlink */
	MEMBER_TO_FPTR(Perl_pp_chown),	/* Perl_pp_chmod */
	MEMBER_TO_FPTR(Perl_pp_chown),	/* Perl_pp_utime */
	MEMBER_TO_FPTR(Perl_pp_rename),
	MEMBER_TO_FPTR(Perl_pp_link),
	MEMBER_TO_FPTR(Perl_pp_link),	/* Perl_pp_symlink */
	MEMBER_TO_FPTR(Perl_pp_readlink),
	MEMBER_TO_FPTR(Perl_pp_mkdir),
	MEMBER_TO_FPTR(Perl_pp_rmdir),
	MEMBER_TO_FPTR(Perl_pp_open_dir),
	MEMBER_TO_FPTR(Perl_pp_readdir),
	MEMBER_TO_FPTR(Perl_pp_telldir),
	MEMBER_TO_FPTR(Perl_pp_seekdir),
	MEMBER_TO_FPTR(Perl_pp_rewinddir),
	MEMBER_TO_FPTR(Perl_pp_closedir),
	MEMBER_TO_FPTR(Perl_pp_fork),
	MEMBER_TO_FPTR(Perl_pp_wait),
	MEMBER_TO_FPTR(Perl_pp_waitpid),
	MEMBER_TO_FPTR(Perl_pp_system),
	MEMBER_TO_FPTR(Perl_pp_exec),
	MEMBER_TO_FPTR(Perl_pp_chown),	/* Perl_pp_kill */
	MEMBER_TO_FPTR(Perl_pp_getppid),
	MEMBER_TO_FPTR(Perl_pp_getpgrp),
	MEMBER_TO_FPTR(Perl_pp_setpgrp),
	MEMBER_TO_FPTR(Perl_pp_getpriority),
	MEMBER_TO_FPTR(Perl_pp_setpriority),
	MEMBER_TO_FPTR(Perl_pp_time),
	MEMBER_TO_FPTR(Perl_pp_tms),
	MEMBER_TO_FPTR(Perl_pp_gmtime),	/* Perl_pp_localtime */
	MEMBER_TO_FPTR(Perl_pp_gmtime),
	MEMBER_TO_FPTR(Perl_pp_alarm),
	MEMBER_TO_FPTR(Perl_pp_sleep),
	MEMBER_TO_FPTR(Perl_pp_semget),	/* Perl_pp_shmget */
	MEMBER_TO_FPTR(Perl_pp_semctl),	/* Perl_pp_shmctl */
	MEMBER_TO_FPTR(Perl_pp_shmwrite),	/* Perl_pp_shmread */
	MEMBER_TO_FPTR(Perl_pp_shmwrite),
	MEMBER_TO_FPTR(Perl_pp_semget),	/* Perl_pp_msgget */
	MEMBER_TO_FPTR(Perl_pp_semctl),	/* Perl_pp_msgctl */
	MEMBER_TO_FPTR(Perl_pp_shmwrite),	/* Perl_pp_msgsnd */
	MEMBER_TO_FPTR(Perl_pp_shmwrite),	/* Perl_pp_msgrcv */
	MEMBER_TO_FPTR(Perl_pp_shmwrite),	/* Perl_pp_semop */
	MEMBER_TO_FPTR(Perl_pp_semget),
	MEMBER_TO_FPTR(Perl_pp_semctl),
	MEMBER_TO_FPTR(Perl_pp_require),
	MEMBER_TO_FPTR(Perl_pp_require),	/* Perl_pp_dofile */
	MEMBER_TO_FPTR(Perl_pp_hintseval),
	MEMBER_TO_FPTR(Perl_pp_entereval),
	MEMBER_TO_FPTR(Perl_pp_leaveeval),
	MEMBER_TO_FPTR(Perl_pp_entertry),
	MEMBER_TO_FPTR(Perl_pp_leavetry),
	MEMBER_TO_FPTR(Perl_pp_ghostent),	/* Perl_pp_ghbyname */
	MEMBER_TO_FPTR(Perl_pp_ghostent),	/* Perl_pp_ghbyaddr */
	MEMBER_TO_FPTR(Perl_pp_ghostent),
	MEMBER_TO_FPTR(Perl_pp_gnetent),	/* Perl_pp_gnbyname */
	MEMBER_TO_FPTR(Perl_pp_gnetent),	/* Perl_pp_gnbyaddr */
	MEMBER_TO_FPTR(Perl_pp_gnetent),
	MEMBER_TO_FPTR(Perl_pp_gprotoent),	/* Perl_pp_gpbyname */
	MEMBER_TO_FPTR(Perl_pp_gprotoent),	/* Perl_pp_gpbynumber */
	MEMBER_TO_FPTR(Perl_pp_gprotoent),
	MEMBER_TO_FPTR(Perl_pp_gservent),	/* Perl_pp_gsbyname */
	MEMBER_TO_FPTR(Perl_pp_gservent),	/* Perl_pp_gsbyport */
	MEMBER_TO_FPTR(Perl_pp_gservent),
	MEMBER_TO_FPTR(Perl_pp_shostent),
	MEMBER_TO_FPTR(Perl_pp_snetent),
	MEMBER_TO_FPTR(Perl_pp_sprotoent),
	MEMBER_TO_FPTR(Perl_pp_sservent),
	MEMBER_TO_FPTR(Perl_pp_ehostent),
	MEMBER_TO_FPTR(Perl_pp_enetent),
	MEMBER_TO_FPTR(Perl_pp_eprotoent),
	MEMBER_TO_FPTR(Perl_pp_eservent),
	MEMBER_TO_FPTR(Perl_pp_gpwent),	/* Perl_pp_gpwnam */
	MEMBER_TO_FPTR(Perl_pp_gpwent),	/* Perl_pp_gpwuid */
	MEMBER_TO_FPTR(Perl_pp_gpwent),
	MEMBER_TO_FPTR(Perl_pp_spwent),
	MEMBER_TO_FPTR(Perl_pp_epwent),
	MEMBER_TO_FPTR(Perl_pp_ggrent),	/* Perl_pp_ggrnam */
	MEMBER_TO_FPTR(Perl_pp_ggrent),	/* Perl_pp_ggrgid */
	MEMBER_TO_FPTR(Perl_pp_ggrent),
	MEMBER_TO_FPTR(Perl_pp_sgrent),
	MEMBER_TO_FPTR(Perl_pp_egrent),
	MEMBER_TO_FPTR(Perl_pp_getlogin),
	MEMBER_TO_FPTR(Perl_pp_syscall),
	MEMBER_TO_FPTR(Perl_pp_lock),
	MEMBER_TO_FPTR(Perl_pp_once),
	MEMBER_TO_FPTR(Perl_unimplemented_op),	/* Perl_pp_custom */
}
#endif
#ifdef PERL_PPADDR_INITED
;
#endif

#ifdef PERL_GLOBAL_STRUCT_INIT
#  define PERL_CHECK_INITED
static const Perl_check_t Gcheck[]
#else
#  ifndef PERL_GLOBAL_STRUCT
#    define PERL_CHECK_INITED
EXT Perl_check_t PL_check[] /* or perlvars.h */
#  endif
#endif
#if (defined(DOINIT) && !defined(PERL_GLOBAL_STRUCT)) || defined(PERL_GLOBAL_STRUCT_INIT)
#  define PERL_CHECK_INITED
= {
	MEMBER_TO_FPTR(Perl_ck_null),	/* null */
	MEMBER_TO_FPTR(Perl_ck_null),	/* stub */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* scalar */
	MEMBER_TO_FPTR(Perl_ck_null),	/* pushmark */
	MEMBER_TO_FPTR(Perl_ck_null),	/* wantarray */
	MEMBER_TO_FPTR(Perl_ck_svconst),	/* const */
	MEMBER_TO_FPTR(Perl_ck_null),	/* gvsv */
	MEMBER_TO_FPTR(Perl_ck_null),	/* gv */
	MEMBER_TO_FPTR(Perl_ck_null),	/* gelem */
	MEMBER_TO_FPTR(Perl_ck_null),	/* padsv */
	MEMBER_TO_FPTR(Perl_ck_null),	/* padav */
	MEMBER_TO_FPTR(Perl_ck_null),	/* padhv */
	MEMBER_TO_FPTR(Perl_ck_null),	/* padany */
	MEMBER_TO_FPTR(Perl_ck_null),	/* pushre */
	MEMBER_TO_FPTR(Perl_ck_rvconst),	/* rv2gv */
	MEMBER_TO_FPTR(Perl_ck_rvconst),	/* rv2sv */
	MEMBER_TO_FPTR(Perl_ck_null),	/* av2arylen */
	MEMBER_TO_FPTR(Perl_ck_rvconst),	/* rv2cv */
	MEMBER_TO_FPTR(Perl_ck_anoncode),	/* anoncode */
	MEMBER_TO_FPTR(Perl_ck_null),	/* prototype */
	MEMBER_TO_FPTR(Perl_ck_spair),	/* refgen */
	MEMBER_TO_FPTR(Perl_ck_null),	/* srefgen */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ref */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* bless */
	MEMBER_TO_FPTR(Perl_ck_open),	/* backtick */
	MEMBER_TO_FPTR(Perl_ck_glob),	/* glob */
	MEMBER_TO_FPTR(Perl_ck_readline),	/* readline */
	MEMBER_TO_FPTR(Perl_ck_null),	/* rcatline */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* regcmaybe */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* regcreset */
	MEMBER_TO_FPTR(Perl_ck_null),	/* regcomp */
	MEMBER_TO_FPTR(Perl_ck_match),	/* match */
	MEMBER_TO_FPTR(Perl_ck_match),	/* qr */
	MEMBER_TO_FPTR(Perl_ck_match),	/* subst */
	MEMBER_TO_FPTR(Perl_ck_null),	/* substcont */
	MEMBER_TO_FPTR(Perl_ck_match),	/* trans */
	MEMBER_TO_FPTR(Perl_ck_sassign),	/* sassign */
	MEMBER_TO_FPTR(Perl_ck_null),	/* aassign */
	MEMBER_TO_FPTR(Perl_ck_spair),	/* chop */
	MEMBER_TO_FPTR(Perl_ck_null),	/* schop */
	MEMBER_TO_FPTR(Perl_ck_spair),	/* chomp */
	MEMBER_TO_FPTR(Perl_ck_null),	/* schomp */
	MEMBER_TO_FPTR(Perl_ck_defined),	/* defined */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* undef */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* study */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* pos */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* preinc */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* i_preinc */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* predec */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* i_predec */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* postinc */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* i_postinc */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* postdec */
	MEMBER_TO_FPTR(Perl_ck_lfun),	/* i_postdec */
	MEMBER_TO_FPTR(Perl_ck_null),	/* pow */
	MEMBER_TO_FPTR(Perl_ck_null),	/* multiply */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_multiply */
	MEMBER_TO_FPTR(Perl_ck_null),	/* divide */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_divide */
	MEMBER_TO_FPTR(Perl_ck_null),	/* modulo */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_modulo */
	MEMBER_TO_FPTR(Perl_ck_repeat),	/* repeat */
	MEMBER_TO_FPTR(Perl_ck_null),	/* add */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_add */
	MEMBER_TO_FPTR(Perl_ck_null),	/* subtract */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_subtract */
	MEMBER_TO_FPTR(Perl_ck_concat),	/* concat */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* stringify */
	MEMBER_TO_FPTR(Perl_ck_bitop),	/* left_shift */
	MEMBER_TO_FPTR(Perl_ck_bitop),	/* right_shift */
	MEMBER_TO_FPTR(Perl_ck_null),	/* lt */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_lt */
	MEMBER_TO_FPTR(Perl_ck_null),	/* gt */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_gt */
	MEMBER_TO_FPTR(Perl_ck_null),	/* le */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_le */
	MEMBER_TO_FPTR(Perl_ck_null),	/* ge */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_ge */
	MEMBER_TO_FPTR(Perl_ck_null),	/* eq */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_eq */
	MEMBER_TO_FPTR(Perl_ck_null),	/* ne */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_ne */
	MEMBER_TO_FPTR(Perl_ck_null),	/* ncmp */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_ncmp */
	MEMBER_TO_FPTR(Perl_ck_null),	/* slt */
	MEMBER_TO_FPTR(Perl_ck_null),	/* sgt */
	MEMBER_TO_FPTR(Perl_ck_null),	/* sle */
	MEMBER_TO_FPTR(Perl_ck_null),	/* sge */
	MEMBER_TO_FPTR(Perl_ck_null),	/* seq */
	MEMBER_TO_FPTR(Perl_ck_null),	/* sne */
	MEMBER_TO_FPTR(Perl_ck_null),	/* scmp */
	MEMBER_TO_FPTR(Perl_ck_bitop),	/* bit_and */
	MEMBER_TO_FPTR(Perl_ck_bitop),	/* bit_xor */
	MEMBER_TO_FPTR(Perl_ck_bitop),	/* bit_or */
	MEMBER_TO_FPTR(Perl_ck_null),	/* negate */
	MEMBER_TO_FPTR(Perl_ck_null),	/* i_negate */
	MEMBER_TO_FPTR(Perl_ck_null),	/* not */
	MEMBER_TO_FPTR(Perl_ck_bitop),	/* complement */
	MEMBER_TO_FPTR(Perl_ck_smartmatch),	/* smartmatch */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* atan2 */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sin */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* cos */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* rand */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* srand */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* exp */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* log */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sqrt */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* int */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* hex */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* oct */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* abs */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* length */
	MEMBER_TO_FPTR(Perl_ck_substr),	/* substr */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* vec */
	MEMBER_TO_FPTR(Perl_ck_index),	/* index */
	MEMBER_TO_FPTR(Perl_ck_index),	/* rindex */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sprintf */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* formline */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ord */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* chr */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* crypt */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ucfirst */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* lcfirst */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* uc */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* lc */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* quotemeta */
	MEMBER_TO_FPTR(Perl_ck_rvconst),	/* rv2av */
	MEMBER_TO_FPTR(Perl_ck_null),	/* aelemfast */
	MEMBER_TO_FPTR(Perl_ck_null),	/* aelem */
	MEMBER_TO_FPTR(Perl_ck_null),	/* aslice */
	MEMBER_TO_FPTR(Perl_ck_each),	/* aeach */
	MEMBER_TO_FPTR(Perl_ck_each),	/* akeys */
	MEMBER_TO_FPTR(Perl_ck_each),	/* avalues */
	MEMBER_TO_FPTR(Perl_ck_each),	/* each */
	MEMBER_TO_FPTR(Perl_ck_each),	/* values */
	MEMBER_TO_FPTR(Perl_ck_each),	/* keys */
	MEMBER_TO_FPTR(Perl_ck_delete),	/* delete */
	MEMBER_TO_FPTR(Perl_ck_exists),	/* exists */
	MEMBER_TO_FPTR(Perl_ck_rvconst),	/* rv2hv */
	MEMBER_TO_FPTR(Perl_ck_null),	/* helem */
	MEMBER_TO_FPTR(Perl_ck_null),	/* hslice */
	MEMBER_TO_FPTR(Perl_ck_unpack),	/* unpack */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* pack */
	MEMBER_TO_FPTR(Perl_ck_split),	/* split */
	MEMBER_TO_FPTR(Perl_ck_join),	/* join */
	MEMBER_TO_FPTR(Perl_ck_null),	/* list */
	MEMBER_TO_FPTR(Perl_ck_null),	/* lslice */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* anonlist */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* anonhash */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* splice */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* push */
	MEMBER_TO_FPTR(Perl_ck_shift),	/* pop */
	MEMBER_TO_FPTR(Perl_ck_shift),	/* shift */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* unshift */
	MEMBER_TO_FPTR(Perl_ck_sort),	/* sort */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* reverse */
	MEMBER_TO_FPTR(Perl_ck_grep),	/* grepstart */
	MEMBER_TO_FPTR(Perl_ck_null),	/* grepwhile */
	MEMBER_TO_FPTR(Perl_ck_grep),	/* mapstart */
	MEMBER_TO_FPTR(Perl_ck_null),	/* mapwhile */
	MEMBER_TO_FPTR(Perl_ck_null),	/* range */
	MEMBER_TO_FPTR(Perl_ck_null),	/* flip */
	MEMBER_TO_FPTR(Perl_ck_null),	/* flop */
	MEMBER_TO_FPTR(Perl_ck_null),	/* and */
	MEMBER_TO_FPTR(Perl_ck_null),	/* or */
	MEMBER_TO_FPTR(Perl_ck_null),	/* xor */
	MEMBER_TO_FPTR(Perl_ck_null),	/* dor */
	MEMBER_TO_FPTR(Perl_ck_null),	/* cond_expr */
	MEMBER_TO_FPTR(Perl_ck_null),	/* andassign */
	MEMBER_TO_FPTR(Perl_ck_null),	/* orassign */
	MEMBER_TO_FPTR(Perl_ck_null),	/* dorassign */
	MEMBER_TO_FPTR(Perl_ck_method),	/* method */
	MEMBER_TO_FPTR(Perl_ck_subr),	/* entersub */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leavesub */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leavesublv */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* caller */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* warn */
	MEMBER_TO_FPTR(Perl_ck_die),	/* die */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* reset */
	MEMBER_TO_FPTR(Perl_ck_null),	/* lineseq */
	MEMBER_TO_FPTR(Perl_ck_null),	/* nextstate */
	MEMBER_TO_FPTR(Perl_ck_null),	/* dbstate */
	MEMBER_TO_FPTR(Perl_ck_null),	/* unstack */
	MEMBER_TO_FPTR(Perl_ck_null),	/* enter */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leave */
	MEMBER_TO_FPTR(Perl_ck_null),	/* scope */
	MEMBER_TO_FPTR(Perl_ck_null),	/* enteriter */
	MEMBER_TO_FPTR(Perl_ck_null),	/* iter */
	MEMBER_TO_FPTR(Perl_ck_null),	/* enterloop */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leaveloop */
	MEMBER_TO_FPTR(Perl_ck_return),	/* return */
	MEMBER_TO_FPTR(Perl_ck_null),	/* last */
	MEMBER_TO_FPTR(Perl_ck_null),	/* next */
	MEMBER_TO_FPTR(Perl_ck_null),	/* redo */
	MEMBER_TO_FPTR(Perl_ck_null),	/* dump */
	MEMBER_TO_FPTR(Perl_ck_null),	/* goto */
	MEMBER_TO_FPTR(Perl_ck_exit),	/* exit */
	MEMBER_TO_FPTR(Perl_ck_null),	/* method_named */
	MEMBER_TO_FPTR(Perl_ck_null),	/* entergiven */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leavegiven */
	MEMBER_TO_FPTR(Perl_ck_null),	/* enterwhen */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leavewhen */
	MEMBER_TO_FPTR(Perl_ck_null),	/* break */
	MEMBER_TO_FPTR(Perl_ck_null),	/* continue */
	MEMBER_TO_FPTR(Perl_ck_open),	/* open */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* close */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* pipe_op */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* fileno */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* umask */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* binmode */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* tie */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* untie */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* tied */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* dbmopen */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* dbmclose */
	MEMBER_TO_FPTR(Perl_ck_select),	/* sselect */
	MEMBER_TO_FPTR(Perl_ck_select),	/* select */
	MEMBER_TO_FPTR(Perl_ck_eof),	/* getc */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* read */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* enterwrite */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leavewrite */
	MEMBER_TO_FPTR(Perl_ck_listiob),	/* prtf */
	MEMBER_TO_FPTR(Perl_ck_listiob),	/* print */
	MEMBER_TO_FPTR(Perl_ck_listiob),	/* say */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sysopen */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sysseek */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sysread */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* syswrite */
	MEMBER_TO_FPTR(Perl_ck_eof),	/* eof */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* tell */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* seek */
	MEMBER_TO_FPTR(Perl_ck_trunc),	/* truncate */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* fcntl */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ioctl */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* flock */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* send */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* recv */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* socket */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sockpair */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* bind */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* connect */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* listen */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* accept */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* shutdown */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gsockopt */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ssockopt */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* getsockname */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* getpeername */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* lstat */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* stat */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftrread */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftrwrite */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftrexec */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* fteread */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftewrite */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* fteexec */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftis */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftsize */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftmtime */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftatime */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftctime */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftrowned */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* fteowned */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftzero */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftsock */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftchr */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftblk */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftfile */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftdir */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftpipe */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftsuid */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftsgid */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftsvtx */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftlink */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* fttty */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* fttext */
	MEMBER_TO_FPTR(Perl_ck_ftst),	/* ftbinary */
	MEMBER_TO_FPTR(Perl_ck_chdir),	/* chdir */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* chown */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* chroot */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* unlink */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* chmod */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* utime */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* rename */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* link */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* symlink */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* readlink */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* mkdir */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* rmdir */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* open_dir */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* readdir */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* telldir */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* seekdir */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* rewinddir */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* closedir */
	MEMBER_TO_FPTR(Perl_ck_null),	/* fork */
	MEMBER_TO_FPTR(Perl_ck_null),	/* wait */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* waitpid */
	MEMBER_TO_FPTR(Perl_ck_exec),	/* system */
	MEMBER_TO_FPTR(Perl_ck_exec),	/* exec */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* kill */
	MEMBER_TO_FPTR(Perl_ck_null),	/* getppid */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* getpgrp */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* setpgrp */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* getpriority */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* setpriority */
	MEMBER_TO_FPTR(Perl_ck_null),	/* time */
	MEMBER_TO_FPTR(Perl_ck_null),	/* tms */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* localtime */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gmtime */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* alarm */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sleep */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* shmget */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* shmctl */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* shmread */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* shmwrite */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* msgget */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* msgctl */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* msgsnd */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* msgrcv */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* semop */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* semget */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* semctl */
	MEMBER_TO_FPTR(Perl_ck_require),	/* require */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* dofile */
	MEMBER_TO_FPTR(Perl_ck_svconst),	/* hintseval */
	MEMBER_TO_FPTR(Perl_ck_eval),	/* entereval */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leaveeval */
	MEMBER_TO_FPTR(Perl_ck_null),	/* entertry */
	MEMBER_TO_FPTR(Perl_ck_null),	/* leavetry */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ghbyname */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ghbyaddr */
	MEMBER_TO_FPTR(Perl_ck_null),	/* ghostent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gnbyname */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gnbyaddr */
	MEMBER_TO_FPTR(Perl_ck_null),	/* gnetent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gpbyname */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gpbynumber */
	MEMBER_TO_FPTR(Perl_ck_null),	/* gprotoent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gsbyname */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gsbyport */
	MEMBER_TO_FPTR(Perl_ck_null),	/* gservent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* shostent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* snetent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sprotoent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* sservent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* ehostent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* enetent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* eprotoent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* eservent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gpwnam */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* gpwuid */
	MEMBER_TO_FPTR(Perl_ck_null),	/* gpwent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* spwent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* epwent */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ggrnam */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* ggrgid */
	MEMBER_TO_FPTR(Perl_ck_null),	/* ggrent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* sgrent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* egrent */
	MEMBER_TO_FPTR(Perl_ck_null),	/* getlogin */
	MEMBER_TO_FPTR(Perl_ck_fun),	/* syscall */
	MEMBER_TO_FPTR(Perl_ck_rfun),	/* lock */
	MEMBER_TO_FPTR(Perl_ck_null),	/* once */
	MEMBER_TO_FPTR(Perl_ck_null),	/* custom */
}
#endif
#ifdef PERL_CHECK_INITED
;
#endif /* #ifdef PERL_CHECK_INITED */

#ifndef PERL_GLOBAL_STRUCT_INIT

#ifndef DOINIT
EXTCONST U32 PL_opargs[];
#else
EXTCONST U32 PL_opargs[] = {
	0x00000000,	/* null */
	0x00000000,	/* stub */
	0x00003604,	/* scalar */
	0x00000004,	/* pushmark */
	0x00000014,	/* wantarray */
	0x00000c04,	/* const */
	0x00000c44,	/* gvsv */
	0x00000c44,	/* gv */
	0x00022440,	/* gelem */
	0x00000044,	/* padsv */
	0x00000040,	/* padav */
	0x00000040,	/* padhv */
	0x00000040,	/* padany */
	0x00000a40,	/* pushre */
	0x00000244,	/* rv2gv */
	0x00000244,	/* rv2sv */
	0x00000214,	/* av2arylen */
	0x00000240,	/* rv2cv */
	0x00000c00,	/* anoncode */
	0x00003604,	/* prototype */
	0x00004201,	/* refgen */
	0x00002206,	/* srefgen */
	0x0001368c,	/* ref */
	0x00122804,	/* bless */
	0x00013688,	/* backtick */
	0x00012808,	/* glob */
	0x0001d608,	/* readline */
	0x00000c08,	/* rcatline */
	0x00002204,	/* regcmaybe */
	0x00002204,	/* regcreset */
	0x00002604,	/* regcomp */
	0x00000a40,	/* match */
	0x00000a04,	/* qr */
	0x00002a54,	/* subst */
	0x00000654,	/* substcont */
	0x00003014,	/* trans */
	0x00000004,	/* sassign */
	0x00044408,	/* aassign */
	0x0000560d,	/* chop */
	0x0001368c,	/* schop */
	0x0000570d,	/* chomp */
	0x0001378c,	/* schomp */
	0x00013694,	/* defined */
	0x00013604,	/* undef */
	0x00013684,	/* study */
	0x0001368c,	/* pos */
	0x00002264,	/* preinc */
	0x00002254,	/* i_preinc */
	0x00002264,	/* predec */
	0x00002254,	/* i_predec */
	0x0000226c,	/* postinc */
	0x0000235c,	/* i_postinc */
	0x0000226c,	/* postdec */
	0x0000235c,	/* i_postdec */
	0x0002250e,	/* pow */
	0x0002252e,	/* multiply */
	0x0002251e,	/* i_multiply */
	0x0002252e,	/* divide */
	0x0002251e,	/* i_divide */
	0x0002253e,	/* modulo */
	0x0002251e,	/* i_modulo */
	0x00024409,	/* repeat */
	0x0002252e,	/* add */
	0x0002251e,	/* i_add */
	0x0002252e,	/* subtract */
	0x0002251e,	/* i_subtract */
	0x0002250e,	/* concat */
	0x0000290e,	/* stringify */
	0x0002250e,	/* left_shift */
	0x0002250e,	/* right_shift */
	0x00022436,	/* lt */
	0x00022416,	/* i_lt */
	0x00022436,	/* gt */
	0x00022416,	/* i_gt */
	0x00022436,	/* le */
	0x00022416,	/* i_le */
	0x00022436,	/* ge */
	0x00022416,	/* i_ge */
	0x00022436,	/* eq */
	0x00022416,	/* i_eq */
	0x00022436,	/* ne */
	0x00022416,	/* i_ne */
	0x0002243e,	/* ncmp */
	0x0002241e,	/* i_ncmp */
	0x00022416,	/* slt */
	0x00022416,	/* sgt */
	0x00022416,	/* sle */
	0x00022416,	/* sge */
	0x00022416,	/* seq */
	0x00022416,	/* sne */
	0x0002241e,	/* scmp */
	0x0002240e,	/* bit_and */
	0x0002240e,	/* bit_xor */
	0x0002240e,	/* bit_or */
	0x0000222e,	/* negate */
	0x0000231e,	/* i_negate */
	0x00002216,	/* not */
	0x0000220e,	/* complement */
	0x00000404,	/* smartmatch */
	0x0002290e,	/* atan2 */
	0x0001378e,	/* sin */
	0x0001378e,	/* cos */
	0x0001370c,	/* rand */
	0x00013604,	/* srand */
	0x0001378e,	/* exp */
	0x0001378e,	/* log */
	0x0001378e,	/* sqrt */
	0x0001378e,	/* int */
	0x0001378e,	/* hex */
	0x0001378e,	/* oct */
	0x0001378e,	/* abs */
	0x0001379e,	/* length */
	0x1322280c,	/* substr */
	0x0022281c,	/* vec */
	0x0122291c,	/* index */
	0x0122291c,	/* rindex */
	0x0004280f,	/* sprintf */
	0x00042805,	/* formline */
	0x0001379e,	/* ord */
	0x0001378e,	/* chr */
	0x0002290e,	/* crypt */
	0x0001368e,	/* ucfirst */
	0x0001368e,	/* lcfirst */
	0x0001368e,	/* uc */
	0x0001368e,	/* lc */
	0x0001368e,	/* quotemeta */
	0x00000248,	/* rv2av */
	0x00026c04,	/* aelemfast */
	0x00026404,	/* aelem */
	0x00046801,	/* aslice */
	0x00007600,	/* aeach */
	0x00007608,	/* akeys */
	0x00007608,	/* avalues */
	0x00009600,	/* each */
	0x00009608,	/* values */
	0x00009608,	/* keys */
	0x00003600,	/* delete */
	0x00003614,	/* exists */
	0x00000248,	/* rv2hv */
	0x00028404,	/* helem */
	0x00048801,	/* hslice */
	0x00122800,	/* unpack */
	0x0004280d,	/* pack */
	0x00222808,	/* split */
	0x0004280d,	/* join */
	0x00004801,	/* list */
	0x00448400,	/* lslice */
	0x00004805,	/* anonlist */
	0x00004805,	/* anonhash */
	0x05326801,	/* splice */
	0x0004691d,	/* push */
	0x00017604,	/* pop */
	0x00017604,	/* shift */
	0x0004691d,	/* unshift */
	0x0005a841,	/* sort */
	0x00004809,	/* reverse */
	0x0004a841,	/* grepstart */
	0x00000648,	/* grepwhile */
	0x0004a841,	/* mapstart */
	0x00000648,	/* mapwhile */
	0x00022600,	/* range */
	0x00022200,	/* flip */
	0x00000200,	/* flop */
	0x00000600,	/* and */
	0x00000600,	/* or */
	0x00022406,	/* xor */
	0x00000600,	/* dor */
	0x00000640,	/* cond_expr */
	0x00000604,	/* andassign */
	0x00000604,	/* orassign */
	0x00000604,	/* dorassign */
	0x00000240,	/* method */
	0x00004249,	/* entersub */
	0x00000200,	/* leavesub */
	0x00000200,	/* leavesublv */
	0x00013608,	/* caller */
	0x0000481d,	/* warn */
	0x0000485d,	/* die */
	0x00013614,	/* reset */
	0x00000800,	/* lineseq */
	0x00001404,	/* nextstate */
	0x00001404,	/* dbstate */
	0x00000004,	/* unstack */
	0x00000000,	/* enter */
	0x00000800,	/* leave */
	0x00000800,	/* scope */
	0x00001240,	/* enteriter */
	0x00000000,	/* iter */
	0x00001240,	/* enterloop */
	0x00000400,	/* leaveloop */
	0x00004841,	/* return */
	0x00001a44,	/* last */
	0x00001a44,	/* next */
	0x00001a44,	/* redo */
	0x00001a44,	/* dump */
	0x00001a44,	/* goto */
	0x00013644,	/* exit */
	0x00000c40,	/* method_named */
	0x00000640,	/* entergiven */
	0x00000200,	/* leavegiven */
	0x00000640,	/* enterwhen */
	0x00000200,	/* leavewhen */
	0x00000000,	/* break */
	0x00000000,	/* continue */
	0x0052c81d,	/* open */
	0x0001d614,	/* close */
	0x000cc814,	/* pipe_op */
	0x0000d61c,	/* fileno */
	0x0001361c,	/* umask */
	0x0012c804,	/* binmode */
	0x0042e855,	/* tie */
	0x0000f614,	/* untie */
	0x0000f604,	/* tied */
	0x00228814,	/* dbmopen */
	0x00009614,	/* dbmclose */
	0x02222808,	/* sselect */
	0x0001c80c,	/* select */
	0x0001d60c,	/* getc */
	0x122ec81d,	/* read */
	0x0001d654,	/* enterwrite */
	0x00000200,	/* leavewrite */
	0x0005c815,	/* prtf */
	0x0005c815,	/* print */
	0x0005c815,	/* say */
	0x1222c804,	/* sysopen */
	0x0022c804,	/* sysseek */
	0x122ec81d,	/* sysread */
	0x1322c81d,	/* syswrite */
	0x0001d614,	/* eof */
	0x0001d60c,	/* tell */
	0x0022c804,	/* seek */
	0x00022814,	/* truncate */
	0x0022c80c,	/* fcntl */
	0x0022c80c,	/* ioctl */
	0x0002c91c,	/* flock */
	0x1222c81d,	/* send */
	0x022ec81d,	/* recv */
	0x0222c814,	/* socket */
	0x222cc814,	/* sockpair */
	0x0002c814,	/* bind */
	0x0002c814,	/* connect */
	0x0002c814,	/* listen */
	0x000cc81c,	/* accept */
	0x0002c81c,	/* shutdown */
	0x0022c814,	/* gsockopt */
	0x0222c814,	/* ssockopt */
	0x0000d614,	/* getsockname */
	0x0000d614,	/* getpeername */
	0x0000d880,	/* lstat */
	0x0000d880,	/* stat */
	0x0000d894,	/* ftrread */
	0x0000d894,	/* ftrwrite */
	0x0000d894,	/* ftrexec */
	0x0000d894,	/* fteread */
	0x0000d894,	/* ftewrite */
	0x0000d894,	/* fteexec */
	0x0000d894,	/* ftis */
	0x0000d89c,	/* ftsize */
	0x0000d88c,	/* ftmtime */
	0x0000d88c,	/* ftatime */
	0x0000d88c,	/* ftctime */
	0x0000d894,	/* ftrowned */
	0x0000d894,	/* fteowned */
	0x0000d894,	/* ftzero */
	0x0000d894,	/* ftsock */
	0x0000d894,	/* ftchr */
	0x0000d894,	/* ftblk */
	0x0000d894,	/* ftfile */
	0x0000d894,	/* ftdir */
	0x0000d894,	/* ftpipe */
	0x0000d894,	/* ftsuid */
	0x0000d894,	/* ftsgid */
	0x0000d894,	/* ftsvtx */
	0x0000d894,	/* ftlink */
	0x0000d814,	/* fttty */
	0x0000d894,	/* fttext */
	0x0000d894,	/* ftbinary */
	0x0001371c,	/* chdir */
	0x0000491d,	/* chown */
	0x0001379c,	/* chroot */
	0x0000499d,	/* unlink */
	0x0000491d,	/* chmod */
	0x0000491d,	/* utime */
	0x0002291c,	/* rename */
	0x0002291c,	/* link */
	0x0002291c,	/* symlink */
	0x0001368c,	/* readlink */
	0x0013299c,	/* mkdir */
	0x0001379c,	/* rmdir */
	0x0002c814,	/* open_dir */
	0x0000d600,	/* readdir */
	0x0000d60c,	/* telldir */
	0x0002c804,	/* seekdir */
	0x0000d604,	/* rewinddir */
	0x0000d614,	/* closedir */
	0x0000001c,	/* fork */
	0x0000011c,	/* wait */
	0x0002291c,	/* waitpid */
	0x0005291d,	/* system */
	0x0005295d,	/* exec */
	0x0000495d,	/* kill */
	0x0000011c,	/* getppid */
	0x0001371c,	/* getpgrp */
	0x0013291c,	/* setpgrp */
	0x0002291c,	/* getpriority */
	0x0022291c,	/* setpriority */
	0x0000011c,	/* time */
	0x00000000,	/* tms */
	0x00013608,	/* localtime */
	0x00013608,	/* gmtime */
	0x0001369c,	/* alarm */
	0x0001371c,	/* sleep */
	0x0022281d,	/* shmget */
	0x0022281d,	/* shmctl */
	0x0222281d,	/* shmread */
	0x0222281d,	/* shmwrite */
	0x0002281d,	/* msgget */
	0x0022281d,	/* msgctl */
	0x0022281d,	/* msgsnd */
	0x2222281d,	/* msgrcv */
	0x0002281d,	/* semop */
	0x0022281d,	/* semget */
	0x0222281d,	/* semctl */
	0x000136c0,	/* require */
	0x00002240,	/* dofile */
	0x00000c04,	/* hintseval */
	0x00003640,	/* entereval */
	0x00002200,	/* leaveeval */
	0x00000600,	/* entertry */
	0x00000800,	/* leavetry */
	0x00003600,	/* ghbyname */
	0x00022800,	/* ghbyaddr */
	0x00000000,	/* ghostent */
	0x00003600,	/* gnbyname */
	0x00022800,	/* gnbyaddr */
	0x00000000,	/* gnetent */
	0x00003600,	/* gpbyname */
	0x00002800,	/* gpbynumber */
	0x00000000,	/* gprotoent */
	0x00022800,	/* gsbyname */
	0x00022800,	/* gsbyport */
	0x00000000,	/* gservent */
	0x00003614,	/* shostent */
	0x00003614,	/* snetent */
	0x00003614,	/* sprotoent */
	0x00003614,	/* sservent */
	0x00000014,	/* ehostent */
	0x00000014,	/* enetent */
	0x00000014,	/* eprotoent */
	0x00000014,	/* eservent */
	0x00003600,	/* gpwnam */
	0x00003600,	/* gpwuid */
	0x00000000,	/* gpwent */
	0x00000014,	/* spwent */
	0x00000014,	/* epwent */
	0x00003600,	/* ggrnam */
	0x00003600,	/* ggrgid */
	0x00000000,	/* ggrent */
	0x00000014,	/* sgrent */
	0x00000014,	/* egrent */
	0x0000000c,	/* getlogin */
	0x0004281d,	/* syscall */
	0x0000f604,	/* lock */
	0x00000600,	/* once */
	0x00000000,	/* custom */
};
#endif

#endif /* !PERL_GLOBAL_STRUCT_INIT */

END_EXTERN_C

/* ex: set ro: */
