package Test::HTML::Tidy::Recursive::Strict;
$Test::HTML::Tidy::Recursive::Strict::VERSION = '0.6.1';
use strict;
use warnings;
use autodie;

use MooX qw/ late /;
use HTML::T5 ();

extends('Test::HTML::Tidy::Recursive');

sub calc_tidy
{
    my $self = shift;

    return HTML::T5->new( { output_xhtml => 1, } );
}

1;

__END__

=pod

=head1 NAME

Test::HTML::Tidy::Recursive::Strict - recursively check files in a directory
using HTML::T5 while not ignoring warnings.

=head1 VERSION

version 0.6.1

=head1 SYNOPSIS

    use Test::HTML::Tidy::Recursive::Strict;

    Test::HTML::Tidy::Recursive::Strict->new({
        targets => ['./dest-html', './dest-html-production'],
        })->run;

=head1 DESCRIPTION

This is a subclass of L<Test::HTML::Tidy::Recursive> that uses a stricter
configuration of L<HTML::T5> with no warnings ignored. Refer to the
L<Test::HTML::Tidy::Recursive> documentation for more usage information.

=head1 VERSION

version 0.6.1

=head1 METHODS

=head2 calc_tidy

Calculates the L<HTML::T5> object.

=head1 SEE ALSO

L<HTML::T5> , L<Test::HTML::Tidy::Recursive> .

=head1 AUTHOR

Shlomi Fish <shlomif@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2016 by Shlomi Fish.

This is free software, licensed under:

  The MIT (X11) License

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website
L<https://github.com/shlomif/test-html-tidy-recursive/issues>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=for :stopwords cpan testmatrix url annocpan anno bugtracker rt cpants kwalitee diff irc mailto metadata placeholders metacpan

=head1 SUPPORT

=head2 Perldoc

You can find documentation for this module with the perldoc command.

  perldoc Test::HTML::Tidy::Recursive::Strict

=head2 Websites

The following websites have more information about this module, and may be of help to you. As always,
in addition to those websites please use your favorite search engine to discover more resources.

=over 4

=item *

MetaCPAN

A modern, open-source CPAN search engine, useful to view POD in HTML format.

L<https://metacpan.org/release/Test-HTML-Tidy-Recursive>

=item *

Search CPAN

The default CPAN search engine, useful to view POD in HTML format.

L<http://search.cpan.org/dist/Test-HTML-Tidy-Recursive>

=item *

RT: CPAN's Bug Tracker

The RT ( Request Tracker ) website is the default bug/issue tracking system for CPAN.

L<https://rt.cpan.org/Public/Dist/Display.html?Name=Test-HTML-Tidy-Recursive>

=item *

AnnoCPAN

The AnnoCPAN is a website that allows community annotations of Perl module documentation.

L<http://annocpan.org/dist/Test-HTML-Tidy-Recursive>

=item *

CPAN Ratings

The CPAN Ratings is a website that allows community ratings and reviews of Perl modules.

L<http://cpanratings.perl.org/d/Test-HTML-Tidy-Recursive>

=item *

CPANTS

The CPANTS is a website that analyzes the Kwalitee ( code metrics ) of a distribution.

L<http://cpants.cpanauthors.org/dist/Test-HTML-Tidy-Recursive>

=item *

CPAN Testers

The CPAN Testers is a network of smoke testers who run automated tests on uploaded CPAN distributions.

L<http://www.cpantesters.org/distro/T/Test-HTML-Tidy-Recursive>

=item *

CPAN Testers Matrix

The CPAN Testers Matrix is a website that provides a visual overview of the test results for a distribution on various Perls/platforms.

L<http://matrix.cpantesters.org/?dist=Test-HTML-Tidy-Recursive>

=item *

CPAN Testers Dependencies

The CPAN Testers Dependencies is a website that shows a chart of the test results of all dependencies for a distribution.

L<http://deps.cpantesters.org/?module=Test::HTML::Tidy::Recursive>

=back

=head2 Bugs / Feature Requests

Please report any bugs or feature requests by email to C<bug-test-html-tidy-recursive at rt.cpan.org>, or through
the web interface at L<https://rt.cpan.org/Public/Bug/Report.html?Queue=Test-HTML-Tidy-Recursive>. You will be automatically notified of any
progress on the request by the system.

=head2 Source Code

The code is open to the world, and available for you to hack on. Please feel free to browse it and play
with it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<https://github.com/shlomif/perl-Test-HTML-Tidy-Recursive>

  git clone https://github.com/shlomif/perl-Test-HTML-Tidy-Recursive

=cut
