# Generated by default/object.tt
package Paws::SecurityHub::AwsEcsClusterDefaultCapacityProviderStrategyDetails;
  use Moose;
  has Base => (is => 'ro', isa => 'Int');
  has CapacityProvider => (is => 'ro', isa => 'Str');
  has Weight => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SecurityHub::AwsEcsClusterDefaultCapacityProviderStrategyDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SecurityHub::AwsEcsClusterDefaultCapacityProviderStrategyDetails object:

  $service_obj->Method(Att1 => { Base => $value, ..., Weight => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SecurityHub::AwsEcsClusterDefaultCapacityProviderStrategyDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->Base

=head1 DESCRIPTION

The default capacity provider strategy for the cluster. The default
capacity provider strategy is used when services or tasks are run
without a specified launch type or capacity provider strategy.

=head1 ATTRIBUTES


=head2 Base => Int

The minimum number of tasks to run on the specified capacity provider.


=head2 CapacityProvider => Str

The name of the capacity provider.


=head2 Weight => Int

The relative percentage of the total number of tasks launched that
should use the capacity provider.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SecurityHub>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

