# Generated by default/object.tt
package Paws::FinspaceData::ErrorInfo;
  use Moose;
  has ErrorCategory => (is => 'ro', isa => 'Str', request_name => 'errorCategory', traits => ['NameInRequest']);
  has ErrorMessage => (is => 'ro', isa => 'Str', request_name => 'errorMessage', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FinspaceData::ErrorInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FinspaceData::ErrorInfo object:

  $service_obj->Method(Att1 => { ErrorCategory => $value, ..., ErrorMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FinspaceData::ErrorInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ErrorCategory

=head1 DESCRIPTION

Error message.

=head1 ATTRIBUTES


=head2 ErrorCategory => Str

The category of the error.

=over

=item *

C<VALIDATION> -The inputs to this request are invalid.

=item *

C<SERVICE_QUOTA_EXCEEDED> - Service quotas have been exceeded. Please
contact AWS support to increase quotas.

=item *

C<ACCESS_DENIED> - Missing required permission to perform this request.

=item *

C<RESOURCE_NOT_FOUND> - One or more inputs to this request were not
found.

=item *

C<THROTTLING> - The system temporarily lacks sufficient resources to
process the request.

=item *

C<INTERNAL_SERVICE_EXCEPTION> - An internal service error has occurred.

=item *

C<CANCELLED> - A user recoverable error has occurred.

=back



=head2 ErrorMessage => Str

The text of the error message.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FinspaceData>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

