/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataDeserializer;
import org.apache.tika.metadata.serialization.JsonMetadataSerializer;
import org.apache.tika.metadata.serialization.PrettyMetadataKeyComparator;

public class JsonMetadataBase {
    static Gson defaultInit() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeHierarchyAdapter(Metadata.class, new JsonMetadataSerializer());
        builder.registerTypeHierarchyAdapter(Metadata.class, new JsonMetadataDeserializer());
        return builder.create();
    }

    static Gson prettyInit() {
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeHierarchyAdapter(Metadata.class, new SortedJsonMetadataSerializer());
        builder.registerTypeHierarchyAdapter(Metadata.class, new JsonMetadataDeserializer());
        builder.setPrettyPrinting();
        return builder.create();
    }

    private static class SortedJsonMetadataSerializer
    extends JsonMetadataSerializer {
        private SortedJsonMetadataSerializer() {
        }

        @Override
        public String[] getNames(Metadata m) {
            String[] names = m.names();
            Arrays.sort(names, new PrettyMetadataKeyComparator());
            return names;
        }
    }
}

