#!/usr/bin/perl
use Pod::Html;
use Cwd;

my $cwd = getcwd();
my $lib = "$cwd/lib";
# chdir "pages";

foreach my $module (qw(Table Query)) {
    my $outfile = "pages/lib/ServiceNow/SOAP/$module.html";
    print "generating $outfile\n";
    unlink $outfile;
    pod2html(
        "--htmldir=lib",
        "--podpath=$lib/ServiceNow/SOAP",
        "--infile=$lib/ServiceNow/SOAP/$module.pm",
        "--outfile=$outfile",
        "--title=ServiceNow::SOAP::$module",
        "--css=http://st.pimg.net/tucs/style.css?3");
};

