/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.application.snapshot;

import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.snapshot.ApplicationSnapshotsSupport;
import org.graalvm.visualvm.core.VisualVM;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.datasource.Storage;
import org.graalvm.visualvm.core.datasource.descriptor.DataSourceDescriptorFactory;
import org.graalvm.visualvm.core.datasupport.Utils;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public final class ApplicationSnapshot
extends Snapshot {
    private Storage storage;

    public ApplicationSnapshot(File directory, Storage storage) {
        super(directory, ApplicationSnapshotsSupport.getInstance().getCategory());
        this.storage = storage;
    }

    public void save(File directory) {
        this.saveArchive(new File(directory, this.getFile().getName()));
    }

    public boolean supportsSaveAs() {
        return this.getFile() != null;
    }

    public void saveAs() {
        JFileChooser chooser = new JFileChooser();
        chooser.setDialogTitle(NbBundle.getMessage(ApplicationSnapshot.class, (String)"LBL_Save_Application_Snapshot_As"));
        chooser.setSelectedFile(new File(this.getFile().getName()));
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(this.getCategory().getFileFilter());
        if (chooser.showSaveDialog(WindowManager.getDefault().getMainWindow()) == 0) {
            String categorySuffix = ".apps";
            String filePath = chooser.getSelectedFile().getAbsolutePath();
            if (!filePath.endsWith(categorySuffix)) {
                filePath = filePath + categorySuffix;
            }
            final File file = new File(filePath);
            VisualVM.getInstance().runTask(new Runnable(){

                @Override
                public void run() {
                    ProgressHandle pHandleF;
                    ProgressHandle pHandle = null;
                    try {
                        pHandle = ProgressHandle.createHandle((String)NbBundle.getMessage(ApplicationSnapshot.class, (String)"MSG_Saving", (Object)DataSourceDescriptorFactory.getDescriptor((DataSource)ApplicationSnapshot.this).getName()));
                        pHandle.setInitialDelay(0);
                        pHandle.start();
                        ApplicationSnapshot.this.saveArchive(file);
                        pHandleF = pHandle;
                    }
                    catch (Throwable throwable) {
                        ProgressHandle pHandleF2 = pHandle;
                        SwingUtilities.invokeLater(new Runnable(pHandleF2){
                            final /* synthetic */ ProgressHandle val$pHandleF;
                            {
                                this.val$pHandleF = progressHandle;
                            }

                            @Override
                            public void run() {
                                if (this.val$pHandleF != null) {
                                    this.val$pHandleF.finish();
                                }
                            }
                        });
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                }
            });
        }
    }

    protected Storage createStorage() {
        return this.storage;
    }

    private void saveArchive(File archive) {
        Utils.createArchive((File)this.getFile(), (File)archive);
    }
}

