/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.internal.util.ReflectHelper;
import org.hibernate.property.access.internal.PropertyAccessStrategyCompositeUserTypeImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class PropertyAccessCompositeUserTypeImpl
implements PropertyAccess,
Getter {
    private final PropertyAccessStrategyCompositeUserTypeImpl strategy;
    private final int propertyIndex;

    public PropertyAccessCompositeUserTypeImpl(PropertyAccessStrategyCompositeUserTypeImpl strategy, String property) {
        this.strategy = strategy;
        this.propertyIndex = strategy.sortedPropertyNames.indexOf(property);
    }

    @Override
    public PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public Getter getGetter() {
        return this;
    }

    @Override
    public @Nullable Setter getSetter() {
        return null;
    }

    @Override
    public @Nullable Object get(Object owner) {
        return this.strategy.compositeUserType.getPropertyValue(owner, this.propertyIndex);
    }

    @Override
    public @Nullable Object getForInsert(Object owner, Map<Object, Object> mergeMap, SharedSessionContractImplementor session) {
        return this.get(owner);
    }

    @Override
    public Class<?> getReturnTypeClass() {
        return ReflectHelper.getClass(this.strategy.sortedPropertyTypes.get(this.propertyIndex));
    }

    @Override
    public Type getReturnType() {
        return this.strategy.sortedPropertyTypes.get(this.propertyIndex);
    }

    @Override
    public @Nullable Member getMember() {
        return null;
    }

    @Override
    public @Nullable String getMethodName() {
        return null;
    }

    @Override
    public @Nullable Method getMethod() {
        return null;
    }
}

