#############################################################################
##
#W  growthsequences.g             GAP4 Package `RCWA'             Stefan Kohl
##
##  Data library of groups generated by 3 class transpositions which inter-
##  change residue classes with moduli <= 6: part containing lists of
##  initial parts of (word-)growth sequences.
##
##  For all i in [1..52394], growthsequences[i] is a list of sizes of spheres
##  of radii 0, 1, 2, ... about the identity in grps[i]. 
##
#############################################################################

local  growthset, growthpos, growthsequences;

growthset :=
[ [ 1,3,0 ],[ 1,3,2,0 ],[ 1,3,3,1,0 ],[ 1,3,4,3,1,0 ],
  [ 1,3,4,4,0 ],[ 1,3,4,4,3,1,0 ],[ 1,3,4,4,4,4,3,1,0 ],
  [ 1,3,4,4,4,4,4,4,4,4,4,4,3,1,0 ],
  [ 1,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 ],
  [ 1,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,3,1,0 ],
  [ 1,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
      4,4,4,4,4,4,3,1,0 ],
  [ 1,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
      4,4,4,4,4,4,4,4,4 ],
  [ 1,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 ],
  [ 1,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
      4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4 ],[ 1,3,5,3,0 ],
  [ 1,3,5,5,2,0 ],[ 1,3,5,5,4,4,2,0 ],
  [ 1,3,5,6,5,3,1,0 ],[ 1,3,5,7,8,0 ],
  [ 1,3,5,7,8,8,7,5,3,1,0 ],[ 1,3,5,7,9,8,3,0 ],
  [ 1,3,5,7,9,12,9,2,0 ],
  [ 1,3,5,7,9,12,15,17,19,21,20,12,3,0 ],
  [ 1,3,5,7,9,12,16,21,28,25,12,4,1,0 ],
  [ 1,3,5,7,9,12,16,21,28,37,45,50,54,60,65,59,49,39,16,0 ]
    ,[ 1,3,5,7,9,12,16,21,28,37,49,65,86,114,151,178,195,
      221,255,276,223,122,56,24,6,0 ],[ 1,3,5,8,9,5,1,0 ],
  [ 1,3,5,8,10,9,7,4,1,0 ],
  [ 1,3,5,8,10,9,8,8,8,8,8,8,7,4,1,0 ],
  [ 1,3,5,8,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8 ],
  [ 1,3,5,8,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,7,4,1,0 ],
  [ 1,3,5,8,10,9,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
      8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8 ],
  [ 1,3,5,8,11,8,0 ],[ 1,3,5,8,11,13,14,11,5,1,0 ],
  [ 1,3,5,8,11,13,15,15,13,12,12,12,11,8,4,1,0 ],
  [ 1,3,5,8,11,13,15,15,13,12,12,12,12,12,12,12,12,12,12,
      12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
      12,12,12,12 ],[ 1,3,5,8,11,13,16,19,19,16,11,5,1,0 ],
  [ 1,3,5,8,11,13,16,19,21,21,16,8,2,0 ],
  [ 1,3,5,8,11,13,16,19,21,24,25,21,16,11,5,1,0 ],
  [ 1,3,5,8,11,13,16,19,21,24,26,25,24,23,21,20,20,20,20,
      20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,
      20,20,20,20 ],
  [ 1,3,5,8,11,13,16,19,21,24,27,29,30,27,21,16,11,5,1,0 ],
  [ 1,3,5,8,11,13,16,19,21,24,27,29,31,31,29,28,27,25,24,
      24,24,24,24,24,24,24,24 ],
  [ 1,3,5,8,11,13,16,19,21,24,27,29,31,31,29,28,27,25,24,
      24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,
      24,24,24,24 ],
  [ 1,3,5,8,11,13,16,19,21,24,27,29,32,35,37,40,43,45,48,
      51,52,52,51,49,48,47,45,44,43,41,40,40,40,40,40,40,40,
      40,40,40,40 ],
  [ 1,3,5,8,11,13,16,19,21,24,27,29,32,35,37,40,43,45,48,
      51,53,56,59,61,64,67 ],
  [ 1,3,5,8,11,13,16,19,21,24,27,29,32,35,37,40,43,45,48,
      51,53,56,59,61,64,67,69 ],
  [ 1,3,5,8,11,13,16,19,21,24,27,29,32,35,37,40,43,45,48,
      51,53,56,59,61,64,67,69,72,75,77,79,79,77,76,75,73,72,
      71,69,68,67 ],
  [ 1,3,5,8,11,13,16,19,21,24,27,29,32,35,37,40,43,45,48,
      51,53,56,59,61,64,67,69,72,75,77,80,83,85,88,91,93,96,
      99,101,104,107 ],[ 1,3,5,8,12,9,7,3,0 ],
  [ 1,3,5,8,12,12,6,1,0 ],[ 1,3,5,8,12,17,21,5,0 ],
  [ 1,3,5,8,12,17,21,18,9,2,0 ],
  [ 1,3,5,8,12,17,22,23,20,17,16,16,15,11,5,1,0 ],
  [ 1,3,5,8,12,17,22,25,24,3,0 ],
  [ 1,3,5,8,12,17,22,25,29,32,28,22,18,12,5,1,0 ],
  [ 1,3,5,8,12,17,24,33,36,26,13,9,4,1,0 ],
  [ 1,3,5,8,12,17,24,33,36,28,16,7,2,0 ],
  [ 1,3,5,8,12,17,24,33,45,35,37,17,3,0 ],
  [ 1,3,5,8,12,17,24,33,45,61,71,78,85,85,72,56,45,17,2,0 ]
    ,[ 1,3,5,8,12,17,24,33,45,61,79,78,55,33,16,6,3,1,0 ],
  [ 1,3,5,8,12,17,24,33,45,61,83,114,144,168,184,187,164,
      106,49,21,9,2,0 ],
  [ 1,3,5,8,12,17,24,33,45,61,83,114,147,151,126,98,84,69,
      52,18,1,0 ],
  [ 1,3,5,8,12,17,24,33,45,61,83,114,153,202,269,357,436,
      427,330,187,72,28,9,3,1,0 ],
  [ 1,3,5,8,12,17,24,33,45,61,83,114,155,210,286,371,453,
      533,569,577,563,475,375,293,206,127 ],
  [ 1,3,5,8,12,17,24,33,45,61,83,114,155,210,286,371,453,
      533,569,577,563,475,375,293,206,127,68,37,23,15,9,5,3,
      1,0 ],[ 1,3,5,8,12,17,25,32,35,29,16,7,2,0 ],
  [ 1,3,5,8,12,17,25,37,48,51,47,41,36,29,17,6,1,0 ],
  [ 1,3,5,8,12,17,25,37,50,58,62,64,52,29,9,0 ],
  [ 1,3,5,8,12,17,25,37,52,59,52,42,34,24,11,2,0 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,668 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,668,900 
     ],[ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,
      668,900,1206 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,668,
      900,1206,1628 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,668,
      900,1206,1628,2204 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,668,
      900,1206,1628,2204,2962,3955,5289 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,668,
      900,1206,1628,2209 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,672,
      922,1263 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,194,262,355,488,672,
      922,1263,1730 ],[ 1,3,5,8,12,17,25,37,52,71,99,140,196 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,197,276,387,543,758,
      1050 ],
  [ 1,3,5,8,12,17,25,37,52,71,99,140,197,276,387,543,758,
      1050,1447,1994 ],
  [ 1,3,5,8,12,17,25,37,54,76,89,90,91,84,66,44,17,1,0 ],
  [ 1,3,5,8,12,17,25,37,54,79,112,157,174,133,77,42,20,4,0 ]
    ,[ 1,3,5,8,12,17,25,37,54,79,112,157,217 ],
  [ 1,3,5,8,12,17,25,37,54,79,115,166,235 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,151,187,243,320,420,540,
      685,827,915,939,941,869,636,359,164,59,21,7,0 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,231,289,352,399,392,
      314,201,107,47,17,4,0 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,232,297,378,470,522,
      494,425,368,326,294,274,261,251,244,242,243,244,243,241,
      240,240,240,240,240,240,240,240,240,240 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,237,308,386,448,492,
      509,448,332,128,22,3,0 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,244 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,244,343,484,689,982,
      1396 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,244,343,484,689,982,
      1396,1975,2786,3932,5530,7743,10833,15161 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,244,343,484,689,982,
      1396,1975,2786,3932,5530,7743,10833,15161,21219 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,244,343,484,689,982,
      1396,1975,2786,3932,5530,7743,10833,15161,21219,29673 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,244,343,484,689,982,
      1396,1975,2786,3932,5530,7743,10833,15161,21219,29673,41417 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,244,343,484,689,982,
      1396,1981 ],[ 1,3,5,8,12,17,25,37,54,79,116,170,246 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,247 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,247,357,518,754 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,247,357,518,754,1097 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,248 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,248,361,526,766,1116,
      1628,2368,3440,4994,7212,10312,14718,21073 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,248,361,526,766,1116,
      1628,2368,3440,4994,7212,10312,14718,21073,30203 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,248,361,526,766,1116,
      1628,2374,3461,5042,7314,10579,15305,22148 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,248,361,526,766,1116,
      1628,2374,3461,5042,7314,10579,15305,22148,32048 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,248,361,526,766,1116,
      1628,2374,3461,5042,7314,10579,15305,22148,32048,46334 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,249,365,535,784,1149,
      1684,2459,3580 ],
  [ 1,3,5,8,12,17,25,37,54,79,116,170,249,365,535,784,1149,
      1684,2468,3617 ],[ 1,3,5,8,13,13,5,0 ],
  [ 1,3,5,8,13,16,23,30,27,16,2,0 ],
  [ 1,3,5,8,13,17,15,8,2,0 ],
  [ 1,3,5,8,13,17,21,25,29,33,37,41,33,17,5,0 ],
  [ 1,3,5,8,13,17,21,25,29,33,37,41,45,49,53,57,61,65,69,
      73,77,81,85,89,93,97,101,105,109,113,117,121,125,129,
      133,137,141,145,149,153,157 ],
  [ 1,3,5,8,13,21,23,13,5,3,1,0 ],
  [ 1,3,5,8,13,21,27,30,34,28,14,6,2,0 ],
  [ 1,3,5,8,13,21,29,34,41,47,45,31,10,0 ],
  [ 1,3,5,8,13,21,30,38,50,67,85,102,111,121,137,128,108,87,
      36,1,0 ],[ 1,3,5,8,13,21,30,39,53,68,73,53,17,0 ],
  [ 1,3,5,8,13,21,30,39,53,68,77,76,63,49,38,23,8,1,0 ],
  [ 1,3,5,8,13,21,30,39,53,68,77,76,64,54,52,52,51,49,48,
      48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,
      48,48,48,48 ],
  [ 1,3,5,8,13,21,30,42,61,83,96,97,95,81,59,25,0 ],
  [ 1,3,5,8,13,21,31,43,62,88,118,153,184,218,261,269,256,
      245,176,92,44,12,1,0 ],
  [ 1,3,5,8,13,21,31,43,62,88,122,172,242,311,366,400,388,
      341,206,53,4,0 ],
  [ 1,3,5,8,13,21,31,46,70,70,50,41,21,3,1,0 ],
  [ 1,3,5,8,13,21,32,47,64,90,124,122,104,52,22,10,2,0 ],
  [ 1,3,5,8,13,21,32,47,71,108,147,144,95,42,14,8,5,3,1,0 ]
    ,[ 1,3,5,8,13,21,32,47,71,108,151,192,228,252,256,240,
      218,173,113,73,50,29,12,6,2,0 ],
  [ 1,3,5,8,13,21,32,47,71,108,155,183,144,62,11,0 ],
  [ 1,3,5,8,13,21,32,47,71,108,163,245,366 ],
  [ 1,3,5,8,13,21,33,41,46,52,58,57,44,30,16,4,0 ],
  [ 1,3,5,8,13,21,33,41,46,52,58,57,45,38,38,37,36,36,36,
      36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,
      36,36,36,36 ],[ 1,3,5,8,13,21,33,51,60,49,32,12,0 ],
  [ 1,3,5,8,13,21,33,51,67,74,76,70,59,48,32,13,2,0 ],
  [ 1,3,5,8,13,21,33,51,76,110,158,209,230,212,164,95,37,10,
      3,1,0 ],[ 1,3,5,8,13,21,33,51,78,118,180,273,408 ],
  [ 1,3,5,8,13,21,33,51,78,118,180,273,409,608,897,1327,1965,
      2891,4232 ],
  [ 1,3,5,8,13,21,33,51,78,118,180,273,409,608,897,1327,1965,
      2891,4232,6174 ],
  [ 1,3,5,8,13,21,33,51,78,118,180,273,409,608,897,1327,1965,
      2891,4232,6174,9008 ],
  [ 1,3,5,8,13,21,33,51,78,118,180,273,409,608,897,1327,1965,
      2891,4232,6174,9008,13142,19105,27691,40079 ],
  [ 1,3,5,8,13,21,33,51,78,118,180,273,411 ],
  [ 1,3,5,8,13,21,33,51,78,118,180,273,412,626,949,1435 ],
  [ 1,3,5,8,13,21,33,51,78,118,180,273,412,626,949,1435,2170,
      3278 ],[ 1,3,5,8,13,21,33,51,78,118,180,273,412,626,949,
      1435,2170,3278,4932 ],
  [ 1,3,5,8,13,21,33,51,78,118,180,273,412,626,949,1435,2170,
      3278,4932,7405 ],
  [ 1,3,5,8,13,21,33,51,80,99,103,89,49,17,4,0 ],
  [ 1,3,5,8,13,21,33,51,80,117,168,166,101,55,29,11,2,0 ],
  [ 1,3,5,8,13,21,33,51,80,120,177,259,359,479,642,863,1120 ],
  [ 1,3,5,8,13,21,33,51,80,123,189,292,445 ],
  [ 1,3,5,8,13,21,33,51,80,126,182,239,272,219,138,80,37,21,
      7,0 ],[ 1,3,5,8,13,21,33,51,80,126,186,258,334,406,480,
      540,572,545,407,245,152,88,37,13,4,0 ],
  [ 1,3,5,8,13,21,33,51,80,126,189,274,396,533,676,826,905,
      781,488,225,87,30,7,2,0 ],
  [ 1,3,5,8,13,21,33,51,80,126,190,251,274,252,194,121,68,
      31,6,0 ],
  [ 1,3,5,8,13,21,33,51,80,126,190,251,275,260,220,182,171,
      172,163,153,152,151,150,149,148,147,146,146,145,144,144,
      144,144,144,144,144,144,144,144,144,144 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,273,364,480,588,602,551,
      444,281,143,50,9,0 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,280,383,504,672,830,859,
      778,547,254,88,25,5,0 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,280,393,551,755,967,1177 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,282,388,533,720,909,1083 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,437 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,441 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,443 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1024,1535,
      2290,3418 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1024,1535,
      2290,3418,5100 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1024,1535,
      2290,3418,5100,7568 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1024,1535,
      2290,3418,5100,7568,11176 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1024,1535,
      2290,3418,5100,7568,11176,16504,24375,35918,52727 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1034 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1034,1587 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1034,1587,
      2430,3710 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1034,1587,
      2430,3710,5652 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1034,1587,
      2430,3710,5652,8614 ],
  [ 1,3,5,8,13,21,33,51,80,126,194,294,444,675,1034,1587,
      2430,3710,5652,8614,13138 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,266,300,330,374,410,427,
      416,293,97,4,0 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,295,405,534,691,848,1003 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,470 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,480 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,481 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,483 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,485 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,485,754,1176 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,486 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,486,758,1185 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,486,758,1185,1851,
      2883,4446 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,486,758,1185,1851,
      2883,4446,6745,10187 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,486,758,1185,1851,
      2890,4491 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,486,758,1185,1851,
      2890,4498,6920 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,486,758,1185,1851,
      2890,4498,6920,10540 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,487 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,487,762,1194,1871,
      2931,4517,6915 ],
  [ 1,3,5,8,13,21,33,51,80,126,198,311,488 ],
  [ 1,3,5,8,13,21,34,50,72,103,143,194,221,231,267,276,267,
      240,127,26,2,0 ],
  [ 1,3,5,8,13,21,34,55,73,93,122,136,143,157,147,91,38,12,
      0 ],[ 1,3,5,8,13,21,34,55,76,81,77,67,55,46,27,7,0 ],
  [ 1,3,5,8,13,21,34,55,83,118,172,253,366 ],
  [ 1,3,5,8,13,21,34,55,85,128,193,288,420 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,294,398 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,447 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,453 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,453,664,954,1384,1997,
      2872,4122,5888 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,453,664,954,1384,1997,
      2872,4122,5888,8436 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,454,670,976,1430 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,454,670,976,1430,2086,
      3025,4366,6263 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,454,682,1014 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,454,682,1014,1507,
      2238,3315,4895,7224 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,454,682,1014,1507,
      2238,3315,4895,7224,10664 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,454,682,1018 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,454,682,1018,1520,
      2271,3386,5036 ],
  [ 1,3,5,8,13,21,34,55,85,128,197,301,454,682,1018,1520,
      2271,3386,5036,7483 ],
  [ 1,3,5,8,13,21,34,55,89,120,145,165,151,120,93,63,38,21,
      7,0 ],[ 1,3,5,8,13,21,34,55,89,132,187,266,331,379,458,
      508,535,563,468,291,163,75,20,3,0 ],
  [ 1,3,5,8,13,21,34,55,89,132,187,266,332,387,483,561,625,
      697,664,565,509,479,464,460,442,425,418,409,402,398,393,
      388,385,384,384,384,384,384,384,384,384 ],
  [ 1,3,5,8,13,21,34,55,89,138,212,303,400 ],
  [ 1,3,5,8,13,21,34,55,89,141,220,345,544,850,1307,2008,3107 
     ],[ 1,3,5,8,13,21,34,55,89,141,220,345,544,850,1307,
      2008,3107,4785 ],
  [ 1,3,5,8,13,21,34,55,89,141,220,345,544,850,1307,2008,
      3107,4785,7271 ],
  [ 1,3,5,8,13,21,34,55,89,141,220,345,544,850,1307,2008,
      3107,4785,7271,11052 ],
  [ 1,3,5,8,13,21,34,55,89,141,220,345,544,850,1330 ],
  [ 1,3,5,8,13,21,34,55,89,141,224,358,570 ],
  [ 1,3,5,8,13,21,34,55,89,141,224,358,572 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,298,312,252,143,60,33,23,
      9,0 ],[ 1,3,5,8,13,21,34,55,89,144,225,323,396,423,339,
      193,92,30,6,0 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,323,405,453,424,355,328,
      323,296,268,270,268,234,160,76,19,0 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,323,405,453,424,355,328,
      323,296,268,270,268,257,253,252,246,242,242,242,242,242,
      242,242,243,243,242,242,241,240,240,240,240,240,240,240,
      240,240,240,240,240,240,240,240,240,240,240,240,240,240,
      240,240 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,323,412,467,457,391,340 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,323,412,467,457,391,340,
      266 ],[ 1,3,5,8,13,21,34,55,89,144,225,323,412,467,457,
      391,340,266,137 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,323,412,467,457,391,340,
      266,137,47,14,3,1,0 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,323,414,483,509,517,564,
      624,625,616,660,693,688,663,611,565,559,549,533,539,534,
      517,516,514,505,506,504,490,482,482,481,480,480,480,480,
      480,480,480,480,480,480,480,480,480,480,480,480,480,480,
      480,480 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,323,414,483,509,517,564,
      624,625,616,660,693,711,756,787,801,844,875,891,936,968,
      979,998,971,910,889,871,840,836,821,793,793,786,771,777,
      772,756,756,751,740,742,740,729,724,723,721,720,720,720,
      720,720 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,323,414,483,509,517,564,
      624,625,616,660,693,711,756,787,801,844,875,891,936,969,
      987,1032,1067,1085,1128,1161,1177,1220,1253,1271,1316,1349,
      1367,1412,1445,1463,1508,1541,1559,1604 ],
  [ 1,3,5,8,13,21,34,55,89,144,225,351,546 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,344,501,728,927,978,820,
      526,251,72,10,1,0 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,357,549 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,560 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,562 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,563,836,1248 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,563,836,1248,1853,
      2745,4066 ],[ 1,3,5,8,13,21,34,55,89,144,229,364,564 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,566 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,567 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,567,861,1315,2009,
      3062,4636 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,567,861,1315,2009,
      3062,4636,6953 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,567,861,1325 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,574 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,575 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,575,903,1416,2207,
      3438,5329,8238 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,575,903,1426 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,575,903,1426,2255,
      3554,5562 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,575,903,1426,2255,
      3562,5604,8810 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,575,903,1426,2255,
      3562,5604,8810,13857 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,582,931,1489 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,582,931,1489,2369,
      3754,5951 ],
  [ 1,3,5,8,13,21,34,55,89,144,229,364,582,931,1489,2369,
      3754,5951,9409 ],
  [ 1,3,5,8,13,21,34,55,89,144,231,369,587 ],
  [ 1,3,5,8,13,21,34,55,89,144,232,373,592 ],
  [ 1,3,5,8,13,21,34,55,89,144,232,373,599,961,1544,2460,
      3910,6237,9943 ],
  [ 1,3,5,8,13,21,34,55,89,144,232,373,599,961,1544,2460,
      3910,6237,9943,15827 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,337,433,546,677,773,835,
      875,795,550 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,337,433,546,677,773,835,
      875,795,550,291 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,337,433,546,677,773,835,
      875,795,550,291,135,50 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,337,433,546,677,773,835,
      875,795,550,291,135,50,9,0 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,337,434,554,703,837,952,
      1060 ],[ 1,3,5,8,13,21,34,55,89,144,233,363,536 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,363,541 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,364,560 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,367,532 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,585 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,586 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,586,877,1324 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,587 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,587,907,1419 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,587,907,1419,2143,
      3103,4423,5767 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,591 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,595 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,598 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,599,931,1444,2153,
      3080,4236 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,599,931,1444,2153,
      3080,4236,5272 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,599,931,1454 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,599,931,1454,2249,
      3429,5158 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,599,931,1454,2249,
      3429,5158,7640 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,600 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,601 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,602 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,602,951,1510,2410,
      3847,6133,9775 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,602,955,1515 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,602,955,1525 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,602,955,1525,2401,
      3736,5711,8542 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,602,955,1525,2432,
      3871,6137 ],[ 1,3,5,8,13,21,34,55,89,144,233,377,603 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,603,955,1519 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,605 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,606 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,607 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,607,975,1570 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,608 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,608,979,1579 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,608,979,1579,2530,
      4045,6487 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,608,979,1579,2530,
      4045,6487,10398 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,608,979,1579,2530,
      4045,6487,10398,16647 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,608,979,1579,2548,
      4111,6633,10690 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,967,1530 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,983,1578,2522,
      4031,6416 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,983,1588 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,983,1588,2566,
      4142,6657 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,983,1588,2566,
      4142,6657,10699 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,983,1588,2566,
      4142,6657,10702 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,983,1588,2566,
      4146,6625 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,983,1588,2566,
      4146,6680 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,609,983,1588,2566,
      4146,6680,10718 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610,971,1539 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610,987 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610,987,1597 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610,987,1597,2566,
      4115,6619 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610,987,1597,2568,
      4119,6623 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610,987,1597,2568,
      4119,6623,10662 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610,987,1597,2584,
      4177,6749,10904 ],
  [ 1,3,5,8,13,21,34,55,89,144,233,377,610,987,1597,2584,
      4181,6765,10934 ],[ 1,3,6,9,5,0 ],
  [ 1,3,6,10,16,26,41,64,99,154,240,374,582,885,1327 ],
  [ 1,3,6,10,16,26,41,64,99,154,240,374,582,885,1327,2002,
      3043,4617,6981,10516 ],
  [ 1,3,6,10,16,26,41,64,99,154,240,374,582,885,1327,2002,
      3043,4617,6981,10516,15760 ],
  [ 1,3,6,10,16,26,41,64,99,154,240,374,582,905,1408 ],
  [ 1,3,6,10,16,26,41,64,99,154,240,374,582,905,1408,2191,
      3410,5306 ],
  [ 1,3,6,10,16,26,41,64,99,154,240,374,582,905,1408,2191,
      3410,5306,8256 ],
  [ 1,3,6,10,16,26,42,68,110,178,288,466,746,1196 ],
  [ 1,3,6,10,16,26,42,68,110,178,288,466,746,1196,1924,3094,
      4940,7830,12448 ],
  [ 1,3,6,10,16,26,42,68,110,178,288,466,746,1196,1924,3094,
      4940,7830,12448,19801 ],
  [ 1,3,6,10,16,26,42,68,110,178,288,466,746,1196,1924,3094,
      4976 ],[ 1,3,6,11,3,0 ],[ 1,3,6,11,11,4,0 ],
  [ 1,3,6,11,13,9,4,1,0 ],[ 1,3,6,11,15,20,26,29,24,9,0 ],
  [ 1,3,6,11,15,20,28,40,52,58,66,78,82,67,38,11,0 ],
  [ 1,3,6,11,15,20,28,40,56,80,112,160,208,232,264,312,300,
      183,74,35,16,4,0 ],[ 1,3,6,11,16,17,12,5,1,0 ],
  [ 1,3,6,11,17,23,28,31,0 ],
  [ 1,3,6,11,17,23,28,31,31,27,21,16,12,8,4,1,0 ],
  [ 1,3,6,11,17,23,29,37,49,65,86,114,150,194,247,313,378,
      425,463,490,457,349,223,112,48,24,6,0 ],
  [ 1,3,6,11,18,29,24,23,4,1,0 ],
  [ 1,3,6,11,18,29,41,46,30,7,0 ],
  [ 1,3,6,11,18,29,44,61,75,69,47,19,1,0 ],
  [ 1,3,6,11,18,29,44,61,80,103,120,103,57,12,0 ],
  [ 1,3,6,11,18,29,44,61,80,103,132,163,187,185,140,80,36,
      12,4,1,0 ],
  [ 1,3,6,11,18,29,45,67,98,143,211,295,378,429,408,328,245,
      133,30,2,0 ],[ 1,3,6,11,18,29,45,67,98,143,211,311,456 ]
    ,[ 1,3,6,11,18,29,46,61,80,111,132,147,161,124,58,16,4,
      0 ],[ 1,3,6,11,18,29,46,73,70,59,16,3,1,0 ],
  [ 1,3,6,11,18,29,46,73,95,127,162,209,259,299,335,332,254,
      191,128,80,27,3,0 ],
  [ 1,3,6,11,18,29,46,73,110,159,236,351,502,689,870,1031 ],
  [ 1,3,6,11,18,29,46,73,111,150,164,130,80,36,6,0 ],
  [ 1,3,6,11,18,29,46,73,111,159,183,141,67,16,0 ],
  [ 1,3,6,11,18,29,46,73,116,183,280,423,637,959,1445,2175,
      3271,4903,7312,10833,15996 ],
  [ 1,3,6,11,18,29,46,73,116,183,282,408,562,686,716,601,249,
      42,0 ],
  [ 1,3,6,11,18,29,46,73,116,183,282,422,624,904,1237 ],
  [ 1,3,6,11,18,29,46,73,116,183,290,459,688,964,1220 ],
  [ 1,3,6,11,18,29,46,73,116,183,290,459,707 ],
  [ 1,3,6,11,18,29,46,73,116,183,290,459,719 ],
  [ 1,3,6,11,18,29,46,73,116,183,290,459,726 ],
  [ 1,3,6,11,18,29,46,73,116,183,290,459,726,1149,1818,2877,
      4548,7181,11315,17805 ],[ 1,3,6,11,19,33,27,18,2,0 ],
  [ 1,3,6,11,19,33,48,60,68,62,44,22,6,1,0 ],
  [ 1,3,6,11,19,33,51,78,119,163,180,130,56,14,0 ],
  [ 1,3,6,11,19,33,53,79,95,104,114,90,68,31,11,2,0 ],
  [ 1,3,6,11,19,33,54,77,92,100,95,64,21,0 ],
  [ 1,3,6,11,19,33,54,85,128,161,116,31,0 ],
  [ 1,3,6,11,19,33,54,85,128,177,215,211,172,115,49,12,4,1,
      0 ],[ 1,3,6,11,19,33,54,85,132,196,280,370,421,334,159,
      48,8,0 ],
  [ 1,3,6,11,19,33,54,85,133,202,290,410,580,804,1037 ],
  [ 1,3,6,11,19,33,55,81,94,96,92,64,21,0 ],
  [ 1,3,6,11,19,33,55,89,144,235,381,611,968 ],
  [ 1,3,6,11,19,33,55,89,144,235,386,627,1012 ],
  [ 1,3,6,11,19,33,55,89,144,235,386,633,1034 ],
  [ 1,3,6,11,19,33,55,89,144,235,386,633,1037 ],
  [ 1,3,6,11,19,33,56,83,81,31,12,0 ],
  [ 1,3,6,11,19,33,56,83,115,161,226,320,452,616,794,976,1089 
     ],[ 1,3,6,11,19,33,56,88,117,130,111,68,38,24,12,3,0 ],
  [ 1,3,6,11,19,33,56,88,127,134,99,64,40,24,12,3,0 ],
  [ 1,3,6,11,19,33,56,95,122,147,195,177,110,31,2,0 ],
  [ 1,3,6,11,19,33,56,95,131,165,225,307,352,374,336,252,154,
      92,51,18,6,1,0 ],
  [ 1,3,6,11,19,33,56,95,150,189,239,309,360,364,319,230,152,
      94,41,12,4,1,0 ],
  [ 1,3,6,11,19,33,56,95,156,253,411,657,1006 ],
  [ 1,3,6,11,19,33,56,95,156,253,416,668,985,1296 ],
  [ 1,3,6,11,19,33,56,95,157,252,407,644,984 ],
  [ 1,3,6,11,19,33,56,95,161,249,344,417,393,255,100,17,0 ],
  [ 1,3,6,11,19,33,56,95,161,252,358,468,548,497,279,78,12,
      3,0 ],[ 1,3,6,11,19,33,56,95,161,263,421,675,1037 ],
  [ 1,3,6,11,19,33,56,95,161,269,423,600,784,836,607,285,94,
      26,9,2,0 ],[ 1,3,6,11,19,33,56,95,161,272,456,759,1253 ]
    ,[ 1,3,6,11,19,33,56,95,161,272,461,755,1205 ],
  [ 1,3,6,11,19,33,56,95,161,272,461,768,1268 ],
  [ 1,3,6,11,19,33,56,95,161,272,461,781,1323 ],
  [ 1,3,6,11,19,33,56,95,161,272,461,781,1323,2240,3779,6372,
      10744,18118,30551 ],
  [ 1,3,6,11,19,33,57,92,136,194,259,335,439 ],
  [ 1,3,6,11,19,33,57,99,151,249,397,628,991 ],
  [ 1,3,6,11,19,33,57,99,151,252,417,696,1118 ],
  [ 1,3,6,11,19,33,57,99,151,252,417,696,1132 ],
  [ 1,3,6,11,19,33,57,99,163,252,386,572,701,723,576,319,100,
      11,0 ],[ 1,3,6,11,19,33,57,99,163,252,386,586,825,1055 ],
  [ 1,3,6,11,19,33,57,99,163,259,416,569,679,731,583,303,92,
      8,0 ],[ 1,3,6,11,19,33,57,99,163,259,416,637,925,1230 ],
  [ 1,3,6,11,19,33,57,99,167,279,462,749,1214,1970,3179,5119,
      8239,13258,21263 ],
  [ 1,3,6,11,19,33,57,99,167,279,467,773,1261,2052,3344,5413,
      8769,14215,22904 ],
  [ 1,3,6,11,19,33,57,99,167,279,472,797,1345,2261,3795,6385,
      10735,18036 ],[ 1,3,6,11,19,33,57,99,167,279,472,797,1347 
     ],[ 1,3,6,11,19,33,57,99,167,279,472,797,1348,2275,3835,
      6478,10926,18420 ],
  [ 1,3,6,11,19,33,57,99,170,288,488,830,1411 ],
  [ 1,3,6,11,19,33,57,99,170,288,488,830,1411,2386,4022,6784 ],
  [ 1,3,6,11,19,33,57,99,170,288,488,830,1411,2386,4022,6784,
      11456 ],
  [ 1,3,6,11,19,33,57,99,170,288,488,830,1411,2386,4022,6784,
      11456,19333 ],
  [ 1,3,6,11,19,33,57,99,170,288,488,830,1411,2386,4022,6784,
      11456,19333,32569 ],
  [ 1,3,6,11,19,33,57,99,170,288,488,830,1413 ],
  [ 1,3,6,11,19,33,57,99,170,288,488,830,1414 ],
  [ 1,3,6,11,19,33,57,99,172,284,464,766,1273 ],
  [ 1,3,6,11,19,33,57,99,172,285,449,690,980,1241 ],
  [ 1,3,6,11,19,33,57,99,172,290,483,769,1185 ],
  [ 1,3,6,11,19,33,57,99,172,298,507,865,1482 ],
  [ 1,3,6,11,19,33,57,99,172,298,509,852,1381 ],
  [ 1,3,6,11,19,33,57,99,172,298,509,866,1467 ],
  [ 1,3,6,11,19,33,57,99,172,298,509,866,1467,2471,4147,6915,
      11387 ],
  [ 1,3,6,11,19,33,57,99,172,298,509,866,1467,2471,4147,6915,
      11387,18636 ],[ 1,3,6,11,19,33,57,99,172,298,512,873,1482 
     ],[ 1,3,6,11,19,33,57,99,172,298,512,873,1482,2516,4270,
      7240,12268 ],
  [ 1,3,6,11,19,33,57,99,172,298,512,873,1482,2516,4270,7240,
      12268,20761 ],[ 1,3,6,11,19,33,57,99,172,298,512,875,1486 
     ],[ 1,3,6,11,19,33,57,99,172,298,512,875,1494 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,871,1448 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1534 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1537 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1548,2666,4597,7929,
      13683,23611 ],[ 1,3,6,11,19,33,57,99,172,298,517,897,1550 
     ],[ 1,3,6,11,19,33,57,99,172,298,517,897,1550,2678,4629,
      7962,13737,23684 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1550,2678,4629,8001,
      13823,23860 ],[ 1,3,6,11,19,33,57,99,172,298,517,897,1552 
     ],[ 1,3,6,11,19,33,57,99,172,298,517,897,1553 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1553,2685,4628,7939,
      13610 ],[ 1,3,6,11,19,33,57,99,172,298,517,897,1554 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1555 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1555,2682,4613,7933,
      13653 ],[ 1,3,6,11,19,33,57,99,172,298,517,897,1556 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1556,2699,4661,7996,
      13708 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1556,2699,4661,7996,
      13708,23515 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1556,2699,4675,8078,
      13959 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1556,2699,4675,8078,
      13959,24129 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1556,2699,4682,8122,
      14089 ],
  [ 1,3,6,11,19,33,57,99,172,298,517,897,1556,2699,4682,8122,
      14089,24440 ],[ 1,3,6,11,20,37,34,7,1,0 ],
  [ 1,3,6,11,20,37,52,49,33,18,8,2,0 ],
  [ 1,3,6,11,20,37,56,73,97,136,192,272,368,440,496,576,612,
      483,264,109,44,20,4,0 ],
  [ 1,3,6,11,20,37,58,84,125,182,249,322,371,382,378,347,223,
      72,9,0 ],[ 1,3,6,11,20,37,59,88,136,210,317,471,676 ],
  [ 1,3,6,11,20,37,59,88,136,210,321,489,743 ],
  [ 1,3,6,11,20,37,59,88,136,210,322,493,754 ],
  [ 1,3,6,11,20,37,61,88,117,129,82,20,1,0 ],
  [ 1,3,6,11,20,37,61,100,162,254,377,527,732,953,1105 ],
  [ 1,3,6,11,20,37,61,100,168,262,369,470,505,435,283,120,27,
      2,0 ],[ 1,3,6,11,20,37,61,100,168,276,445,717,1141 ],
  [ 1,3,6,11,20,37,62,99,143,190,242,269,222,110,24,1,0 ],
  [ 1,3,6,11,20,37,62,104,179,297,476,770,1195 ],
  [ 1,3,6,11,20,37,62,104,179,297,480,788,1277 ],
  [ 1,3,6,11,20,37,62,104,179,297,481,792,1285 ],
  [ 1,3,6,11,20,37,63,91,111,111,82,35,5,0 ],
  [ 1,3,6,11,20,37,63,103,137,159,134,46,0 ],
  [ 1,3,6,11,20,37,63,103,156,225,265,189,65,8,0 ],
  [ 1,3,6,11,20,37,63,103,156,231,309,352,349,282,196,116,47,
      16,5,1,0 ],
  [ 1,3,6,11,20,37,63,103,165,248,348,447,441,224,35,7,1,0 ],
  [ 1,3,6,11,20,37,63,108,189,324,556,945,1585 ],
  [ 1,3,6,11,20,37,63,108,189,324,556,945,1585,2655,4436,7411,
      12373 ],
  [ 1,3,6,11,20,37,63,108,189,324,556,945,1585,2655,4436,7411,
      12373,20478 ],
  [ 1,3,6,11,20,37,63,108,189,324,556,958,1633 ],
  [ 1,3,6,11,20,37,63,108,189,324,556,958,1633,2744,4614,7756,
      13023 ],
  [ 1,3,6,11,20,37,63,108,189,324,556,958,1633,2744,4614,7756,
      13023,21694 ],
  [ 1,3,6,11,20,37,63,108,189,324,556,958,1645 ],
  [ 1,3,6,11,20,37,63,108,189,324,556,958,1645,2828,4866,8365 ]
    ,[ 1,3,6,11,20,37,64,102,155,226,297,316,254,149,62,19,
      5,1,0 ],[ 1,3,6,11,20,37,64,107,181,305,514,847,1380 ],
  [ 1,3,6,11,20,37,64,109,157,164,105,35,7,1,0 ],
  [ 1,3,6,11,20,37,64,109,181,288,420,592,848,1106 ],
  [ 1,3,6,11,20,37,64,109,181,298,406,426,342,180,56,16,4,0 ]
    ,[ 1,3,6,11,20,37,64,109,182,293,453,654,887,1107 ],
  [ 1,3,6,11,20,37,64,109,186,285,387,436,359,183,55,16,2,0 ]
    ,[ 1,3,6,11,20,37,64,109,186,315,519,826,1301 ],
  [ 1,3,6,11,20,37,64,109,186,315,524,829,1232 ],
  [ 1,3,6,11,20,37,65,106,156,212,247,234,177,105,48,12,0 ],
  [ 1,3,6,11,20,37,65,111,186,309,512,835,1333 ],
  [ 1,3,6,11,20,37,65,113,197,334,542,850,1288 ],
  [ 1,3,6,11,20,37,65,113,197,338,561,936,1573 ],
  [ 1,3,6,11,20,37,65,113,197,338,566,958,1640 ],
  [ 1,3,6,11,20,37,65,113,197,343,588,989,1659 ],
  [ 1,3,6,11,20,37,65,113,197,343,593,1004,1683 ],
  [ 1,3,6,11,20,37,65,113,197,343,593,1015,1735 ],
  [ 1,3,6,11,20,37,66,117,194,266,315,313,236,115,26,2,0 ],
  [ 1,3,6,11,20,37,66,117,194,318,502,723,944,1099 ],
  [ 1,3,6,11,20,37,66,117,195,318,489,609,523,307,129,35,11,
      3,0 ],
  [ 1,3,6,11,20,37,66,117,203,351,591,859,949,683,289,88,32,
      10,3,1,0 ],[ 1,3,6,11,20,37,66,117,203,351,598,961,1446 
     ],[ 1,3,6,11,20,37,66,117,203,354,592,950,1362 ],
  [ 1,3,6,11,20,37,66,117,203,354,617,1040,1663 ],
  [ 1,3,6,11,20,37,66,117,203,354,622,1082,1856 ],
  [ 1,3,6,11,20,37,66,117,203,354,622,1082,1862 ],
  [ 1,3,6,11,20,37,66,117,208,368,612,964,1539 ],
  [ 1,3,6,11,20,37,66,117,208,368,643,1036,1553 ],
  [ 1,3,6,11,20,37,66,117,208,368,648,1102,1835 ],
  [ 1,3,6,11,20,37,66,117,208,368,648,1119,1899 ],
  [ 1,3,6,11,20,37,66,117,208,368,648,1141,2012 ],
  [ 1,3,6,11,20,37,66,117,208,371,647,1099,1815 ],
  [ 1,3,6,11,20,37,66,117,208,371,647,1110,1885 ],
  [ 1,3,6,11,20,37,66,117,208,371,650,1113,1883 ],
  [ 1,3,6,11,20,37,66,117,208,371,652,1135,1954 ],
  [ 1,3,6,11,20,37,66,117,208,371,654,1118,1907 ],
  [ 1,3,6,11,20,37,66,117,208,371,654,1131,1958 ],
  [ 1,3,6,11,20,37,66,117,208,371,656,1142,1966 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1112,1786 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1123,1866 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1126,1926 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1136,1936 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1137,1945 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1137,1961 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1146,1964 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1146,1974 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1146,1977 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1153,2016 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1154,2005 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1154,2031 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1154,2031,3552,6162,
      10652,18416 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1157,2033 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1157,2034 ],
  [ 1,3,6,11,20,37,66,117,208,371,657,1157,2040 ],
  [ 1,3,6,11,20,37,66,117,208,371,662,1162,2030 ],
  [ 1,3,6,11,20,37,66,117,208,371,662,1179,2077 ],
  [ 1,3,6,11,20,37,66,117,208,371,662,1179,2079 ],
  [ 1,3,6,11,20,37,66,117,208,371,662,1179,2094 ],
  [ 1,3,6,11,20,37,66,117,208,371,662,1179,2095 ],
  [ 1,3,6,11,20,37,66,117,208,371,662,1179,2100 ],
  [ 1,3,6,11,20,37,66,117,208,371,662,1179,2100,3741,6645,
      11798,20961 ],
  [ 1,3,6,11,20,37,67,109,163,247,384,594,891,1210 ],
  [ 1,3,6,11,20,37,67,109,178,292,478,784,1281 ],
  [ 1,3,6,11,20,37,67,109,178,292,478,784,1281,2092,3415,5566,
      9063,14752 ],[ 1,3,6,11,20,37,67,109,178,292,478,784,1282 
     ],[ 1,3,6,11,20,37,67,109,178,292,478,784,1282,2096,3426,
      5592,9126,14884 ],
  [ 1,3,6,11,20,37,67,112,169,213,224,208,167,119,65,17,1,0 ]
    ,[ 1,3,6,11,20,37,67,114,154,121,40,2,0 ],
  [ 1,3,6,11,20,37,67,114,179,280,443,700,1059 ],
  [ 1,3,6,11,20,37,67,114,189,275,358,416,378,212,61,12,0 ],
  [ 1,3,6,11,20,37,67,114,189,314,526,875,1408 ],
  [ 1,3,6,11,20,37,67,121,205,347,585,942,1475 ],
  [ 1,3,6,11,20,37,67,121,207,329,482,687,975,1248 ],
  [ 1,3,6,11,20,37,67,121,210,350,584,948,1495 ],
  [ 1,3,6,11,20,37,67,121,213,367,633,1069,1731 ],
  [ 1,3,6,11,20,37,67,121,213,371,613,1039,1724 ],
  [ 1,3,6,11,20,37,67,121,214,380,670,1166,1963 ],
  [ 1,3,6,11,20,37,67,121,214,380,680,1197,2103 ],
  [ 1,3,6,11,20,37,67,121,214,380,680,1210,2154 ],
  [ 1,3,6,11,20,37,67,121,214,380,680,1210,2155,3841,6829,
      12131,21551,38303 ],
  [ 1,3,6,11,20,37,67,121,215,377,660,1160,2036 ],
  [ 1,3,6,11,20,37,67,121,215,379,671,1161,1926 ],
  [ 1,3,6,11,20,37,67,121,215,379,671,1172,2034 ],
  [ 1,3,6,11,20,37,67,121,215,379,671,1174,2014 ],
  [ 1,3,6,11,20,37,67,121,217,389,698,1223,2133 ],
  [ 1,3,6,11,20,37,67,121,217,389,698,1238,2191 ],
  [ 1,3,6,11,20,37,67,121,219,365,582,874,1203 ],
  [ 1,3,6,11,20,37,67,121,219,383,650,1017,1419 ],
  [ 1,3,6,11,20,37,67,121,219,383,658,1100,1724 ],
  [ 1,3,6,11,20,37,67,121,219,383,658,1128,1887 ],
  [ 1,3,6,11,20,37,67,121,219,383,658,1128,1892 ],
  [ 1,3,6,11,20,37,67,121,219,383,658,1139,1985 ],
  [ 1,3,6,11,20,37,67,121,219,383,658,1139,1991 ],
  [ 1,3,6,11,20,37,67,121,219,384,658,1112,1849 ],
  [ 1,3,6,11,20,37,67,121,219,384,663,1112,1804 ],
  [ 1,3,6,11,20,37,67,121,219,385,659,1126,1942 ],
  [ 1,3,6,11,20,37,67,121,219,385,670,1057,1547 ],
  [ 1,3,6,11,20,37,67,121,219,385,670,1127,1834 ],
  [ 1,3,6,11,20,37,67,121,219,385,673,1166,2007 ],
  [ 1,3,6,11,20,37,67,121,219,385,673,1166,2008 ],
  [ 1,3,6,11,20,37,67,121,219,388,679,1165,1925 ],
  [ 1,3,6,11,20,37,67,121,219,388,679,1188,2063 ],
  [ 1,3,6,11,20,37,67,121,219,389,685,1205,2105 ],
  [ 1,3,6,11,20,37,67,121,219,392,692,1216,2074 ],
  [ 1,3,6,11,20,37,67,121,219,392,692,1216,2078 ],
  [ 1,3,6,11,20,37,67,121,219,392,696,1213,2077 ],
  [ 1,3,6,11,20,37,67,121,219,392,697,1217,2088 ],
  [ 1,3,6,11,20,37,67,121,219,392,697,1217,2108 ],
  [ 1,3,6,11,20,37,67,121,219,392,697,1238,2189 ],
  [ 1,3,6,11,20,37,67,121,219,392,697,1238,2193 ],
  [ 1,3,6,11,20,37,67,121,219,394,675,1102,1794 ],
  [ 1,3,6,11,20,37,67,121,219,394,675,1102,1801 ],
  [ 1,3,6,11,20,37,67,121,219,394,675,1102,1819 ],
  [ 1,3,6,11,20,37,67,121,219,394,675,1102,1824 ],
  [ 1,3,6,11,20,37,67,121,219,394,703,1250,2197 ],
  [ 1,3,6,11,20,37,67,121,219,394,706,1245,2149 ],
  [ 1,3,6,11,20,37,67,121,219,397,691,1186,2031 ],
  [ 1,3,6,11,20,37,67,121,219,397,691,1186,2031,3454,5864,9871 
     ],[ 1,3,6,11,20,37,67,121,219,397,691,1186,2032 ],
  [ 1,3,6,11,20,37,67,121,219,397,710,1261,2226 ],
  [ 1,3,6,11,20,37,67,121,219,397,710,1261,2230 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1147,1773 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1233,2075 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1255,2150 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1255,2183 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1279,2283 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1279,2288 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1283,2258 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1283,2290 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1283,2296 ],
  [ 1,3,6,11,20,37,67,121,219,397,715,1283,2297 ],
  [ 1,3,6,11,20,37,67,121,219,397,719,1301,2354 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1273,2220 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1277,2216 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1277,2225 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1288,2276 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1288,2280 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1288,2285 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2285 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2291 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2291,4072,7273 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2291,4072,7273,
      12951,22943 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2296 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2304 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2306 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2313 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1292,2314 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1294,2300 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1294,2306 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1294,2318 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2333 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2344 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2346 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2347 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2349 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2350 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2351 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2351,4220,7582,
      13584,24257 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2352 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2354 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2358 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2358,4261,7706,
      13930,25163 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2359 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2360 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2360,4269,7714,
      13921,25118 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2361 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2362 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2363 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2364 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2364,4269,7703,
      13895 ],[ 1,3,6,11,20,37,67,121,219,397,720,1305,2365 ],
  [ 1,3,6,11,20,37,67,121,219,397,720,1305,2365,4286,7768 ],
  [ 1,3,6,11,20,37,68,125,216,373,654,1123,1905 ],
  [ 1,3,6,11,20,37,68,125,220,375,642,1069,1703 ],
  [ 1,3,6,11,20,37,68,125,222,351,532,815,1211 ],
  [ 1,3,6,11,20,37,68,125,222,379,616,991,1579 ],
  [ 1,3,6,11,20,37,68,125,223,398,668,1139,1865 ],
  [ 1,3,6,11,20,37,68,125,223,398,668,1173,2041 ],
  [ 1,3,6,11,20,37,68,125,223,398,716,1286,2310 ],
  [ 1,3,6,11,20,37,68,125,224,396,698,1207,2052 ],
  [ 1,3,6,11,20,37,68,125,225,354,534,764,1036 ],
  [ 1,3,6,11,20,37,68,125,225,396,687,1206,2109 ],
  [ 1,3,6,11,20,37,68,125,225,396,692,1222,2161 ],
  [ 1,3,6,11,20,37,68,125,225,396,692,1228,2183 ],
  [ 1,3,6,11,20,37,68,125,225,406,680,1192,2078 ],
  [ 1,3,6,11,20,37,68,125,225,406,728,1254,2039 ],
  [ 1,3,6,11,20,37,68,125,225,406,730,1297,2305 ],
  [ 1,3,6,11,20,37,68,125,225,406,733,1316,2365 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2410 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2411 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2414 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2414,4345,7839,
      14157 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2414,4345,7839,
      14157,25523 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2417 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2419 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2423 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2424 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2425 ],
  [ 1,3,6,11,20,37,68,125,225,406,738,1338,2426 ],
  [ 1,3,6,11,20,37,68,125,226,393,671,1140,1924 ],
  [ 1,3,6,11,20,37,68,125,226,407,734,1327,2393 ],
  [ 1,3,6,11,20,37,68,125,228,410,738,1334,2361 ],
  [ 1,3,6,11,20,37,68,125,228,415,751,1357,2452 ],
  [ 1,3,6,11,20,37,68,125,228,415,756,1368,2448 ],
  [ 1,3,6,11,20,37,68,125,228,415,756,1379,2496 ],
  [ 1,3,6,11,20,37,68,125,228,415,756,1379,2506 ],
  [ 1,3,6,11,20,37,68,125,228,415,756,1379,2509 ],
  [ 1,3,6,11,20,37,68,125,228,415,756,1379,2511 ],
  [ 1,3,6,11,20,37,68,125,228,415,756,1379,2512 ],
  [ 1,3,6,11,20,37,68,125,228,415,756,1379,2515 ],
  [ 1,3,6,11,20,37,68,125,230,409,691,1138,1839 ],
  [ 1,3,6,11,20,37,68,125,230,413,737,1319,2336 ],
  [ 1,3,6,11,20,37,68,125,230,413,742,1341,2417 ],
  [ 1,3,6,11,20,37,68,125,230,415,746,1326,2330 ],
  [ 1,3,6,11,20,37,68,125,230,415,746,1348,2439 ],
  [ 1,3,6,11,20,37,68,125,230,417,754,1365,2429 ],
  [ 1,3,6,11,20,37,68,125,230,418,755,1364,2444 ],
  [ 1,3,6,11,20,37,68,125,230,418,758,1346,2364 ],
  [ 1,3,6,11,20,37,68,125,230,418,760,1386,2511 ],
  [ 1,3,6,11,20,37,68,125,230,418,760,1386,2516 ],
  [ 1,3,6,11,20,37,68,125,230,418,760,1386,2522 ],
  [ 1,3,6,11,20,37,68,125,230,418,760,1386,2525 ],
  [ 1,3,6,11,20,37,68,125,230,420,766,1398,2540 ],
  [ 1,3,6,11,20,37,68,125,230,423,756,1335,2382 ],
  [ 1,3,6,11,20,37,68,125,230,423,756,1335,2385 ],
  [ 1,3,6,11,20,37,68,125,230,423,768,1387,2503 ],
  [ 1,3,6,11,20,37,68,125,230,423,770,1400,2465 ],
  [ 1,3,6,11,20,37,68,125,230,423,770,1402,2555 ],
  [ 1,3,6,11,20,37,68,125,230,423,770,1402,2557 ],
  [ 1,3,6,11,20,37,68,125,230,423,773,1409,2506 ],
  [ 1,3,6,11,20,37,68,125,230,423,773,1409,2554 ],
  [ 1,3,6,11,20,37,68,125,230,423,773,1409,2564 ],
  [ 1,3,6,11,20,37,68,125,230,423,773,1409,2565 ],
  [ 1,3,6,11,20,37,68,125,230,423,777,1427,2616 ],
  [ 1,3,6,11,20,37,68,125,230,423,777,1427,2618 ],
  [ 1,3,6,11,20,37,68,125,230,423,777,1427,2621 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1409,2538 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1416,2559 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1420,2572 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1420,2576 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1420,2577 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1420,2580 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1420,2584 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1420,2585 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2555 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2568 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2601 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2611 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2612 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2614 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2614,4766,8709,
      15918 ],[ 1,3,6,11,20,37,68,125,230,423,778,1431,2616 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2617 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2618 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2619 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2620 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2622 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2623 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2624 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2625 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2626 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2627 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2627,4824 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2628 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2629 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2630 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2631 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2632 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2632,4841,8904 ],
  [ 1,3,6,11,20,37,68,125,230,423,778,1431,2632,4841,8904,
      16377 ],[ 1,3,6,12,8,8,7,3,0 ],[ 1,3,6,12,18,6,2,0 ],
  [ 1,3,6,12,18,20,18,12,5,1,0 ],[ 1,3,6,12,18,24,23,9,0 ],
  [ 1,3,6,12,19,24,25,20,12,5,1,0 ],
  [ 1,3,6,12,20,28,35,29,10,0 ],
  [ 1,3,6,12,20,28,35,40,41,36,28,20,12,5,1,0 ],
  [ 1,3,6,12,20,28,36,44,52,60,68,76,84,92,100,108,116,124,
      132,140,148,156,164,172,180,188,196,204 ],
  [ 1,3,6,12,20,28,36,44,52,60,68,76,84,92,100,108,116,124,
      132,140,148,156,164,172,180,188,196,204,212,220,228,236,
      244,252,260,268,276,284 ],
  [ 1,3,6,12,20,28,36,44,52,60,68,76,84,92,100,108,116,124,
      132,140,148,156,164,172,180,188,196,204,212,220,228,236,
      244,252,260,268,276,284,292,300,308 ],
  [ 1,3,6,12,20,30,43,45,27,5,0 ],
  [ 1,3,6,12,20,30,43,46,26,5,0 ],
  [ 1,3,6,12,20,30,44,45,25,6,0 ],
  [ 1,3,6,12,20,30,44,63,89,123,170,239,334,456,617,843,1156,
      1568,2106,2834 ],
  [ 1,3,6,12,20,30,44,63,89,123,170,239,334,456,617,843,1156,
      1568,2106,2834,3832 ],
  [ 1,3,6,12,20,30,44,63,89,123,170,239,334,456,617,843,1160,
      1594,2185 ],
  [ 1,3,6,12,20,30,44,63,89,123,170,239,337,473,663,930,1301 ]
    ,[ 1,3,6,12,20,30,44,63,89,123,170,239,337,473,663,930,
      1301,1808,2497 ],
  [ 1,3,6,12,20,30,44,63,91,133,195,286,414,587,827,1173 ],
  [ 1,3,6,12,20,30,44,63,91,133,195,286,414,587,827,1173,
      1671,2378,3377 ],
  [ 1,3,6,12,20,30,44,63,91,133,195,286,419,614,900,1319 ],
  [ 1,3,6,12,21,22,7,0 ],
  [ 1,3,6,12,21,34,51,67,79,78,54,22,4,0 ],
  [ 1,3,6,12,21,34,53,68,34,8,0 ],
  [ 1,3,6,12,21,34,53,68,73,70,52,34,26,17,8,2,0 ],
  [ 1,3,6,12,21,34,53,79,99,104,103,86,64,46,8,1,0 ],
  [ 1,3,6,12,21,34,53,79,111,136,142,139,118,72,28,5,0 ],
  [ 1,3,6,12,21,34,53,79,115,167,219,232,205,161,95,32,5,0 ],
  [ 1,3,6,12,21,34,54,83,126,193,296,413,514,618,729,759,654,
      495,351,213,103,47,21,9,4,1,0 ],
  [ 1,3,6,12,21,34,54,85,131,195,288,429,641,960,1433,2119,
      3111,4547,6634 ],
  [ 1,3,6,12,21,34,54,85,131,195,288,429,641,960,1433,2119,
      3111,4547,6634,9677 ],
  [ 1,3,6,12,21,34,54,85,131,195,288,429,641,960,1433,2119,
      3111,4547,6634,9677,14095 ],
  [ 1,3,6,12,21,34,54,85,131,195,288,429,641,960,1441 ],
  [ 1,3,6,12,21,34,54,85,133,207,305,435,608,682,601,444,196,
      13,0 ],[ 1,3,6,12,21,34,54,85,133,207,324,509,799,1254 ],
  [ 1,3,6,12,21,34,55,89,140,209,302,433,619,883,1250 ],
  [ 1,3,6,12,21,34,55,89,140,209,302,433,619,883,1250,1739,
      2343,3061,3915,4898 ],
  [ 1,3,6,12,21,34,55,89,140,209,302,433,619,883,1250,1739,
      2343,3061,3915,4898,5963 ],
  [ 1,3,6,12,21,34,55,89,144,233,377,610,980 ],
  [ 1,3,6,12,21,34,55,89,144,233,377,610,986,1591 ],
  [ 1,3,6,12,21,34,55,89,144,233,377,610,986,1591,2566,4129,
      6624,10626 ],
  [ 1,3,6,12,21,34,55,89,144,233,377,610,986,1591,2566,4141,
      6681,10745 ],
  [ 1,3,6,12,21,34,55,89,144,233,377,610,986,1591,2566,4141,
      6681,10745,17172 ],
  [ 1,3,6,12,21,36,57,82,96,91,69,32,6,0 ],
  [ 1,3,6,12,21,36,59,82,57,11,0 ],
  [ 1,3,6,12,21,36,59,89,105,88,45,11,3,1,0 ],
  [ 1,3,6,12,21,36,60,95,146,213,301,414,536,647,747,831,862,
      836,757,623,466,313,179,73,14,0 ],
  [ 1,3,6,12,21,36,60,95,146,213,301,414,537,658,778,843,695,
      318,47,0 ],[ 1,3,6,12,21,36,60,95,146,213,301,414,539 ],
  [ 1,3,6,12,21,36,60,95,148,225,332,470,600,699,702,585,396,
      177,38,2,0 ],[ 1,3,6,12,21,36,60,95,148,225,337,502,735 
     ],[ 1,3,6,12,21,36,61,96,140,169,114,45,16,0 ],
  [ 1,3,6,12,21,36,63,96,146,191,131,12,2,0 ],
  [ 1,3,6,12,21,36,63,108,186,321,547,923,1552 ],
  [ 1,3,6,12,22,33,43,43,24,5,0 ],
  [ 1,3,6,12,22,33,46,65,89,119,162,224,288,337,367,376,341,
      224,100,43,18,4,0 ],
  [ 1,3,6,12,22,33,47,69,100,140,194,273,383,522,705,967,
      1330,1798,2406 ],
  [ 1,3,6,12,22,33,47,69,100,140,194,273,383,522,705,967,
      1330,1798,2406,3245 ],[ 1,3,6,12,22,40,54,62,31,9,0 ],
  [ 1,3,6,12,22,40,54,69,75,55,29,12,5,1,0 ],
  [ 1,3,6,12,22,40,67,97,121,125,107,78,47,24,12,5,1,0 ],
  [ 1,3,6,12,22,40,69,112,143,155,120,35,2,0 ],
  [ 1,3,6,12,22,40,69,112,163,236,318,370,378,287,117,25,1,0 
     ],[ 1,3,6,12,22,40,69,112,175,243,259,217,153,86,35,7,0 
     ],[ 1,3,6,12,22,40,70,106,169,239,248,223,181,95,22,3,0 
     ],[ 1,3,6,12,22,40,70,114,150,177,94,30,1,0 ],
  [ 1,3,6,12,22,40,70,116,190,311,499,782,1186 ],
  [ 1,3,6,12,22,40,70,117,182,259,315,272,124,17,0 ],
  [ 1,3,6,12,22,40,70,118,179,245,258,164,31,3,0 ],
  [ 1,3,6,12,22,40,70,118,189,279,388,510,614,665,622,491,
      336,177,55,9,1,0 ],
  [ 1,3,6,12,22,40,70,118,193,294,400,515,683 ],
  [ 1,3,6,12,22,40,70,118,195,315,492,724,1008 ],
  [ 1,3,6,12,22,40,70,118,195,315,504,799,1252 ],
  [ 1,3,6,12,22,40,70,118,197,329,551,905,1434 ],
  [ 1,3,6,12,22,40,70,119,201,329,527,828,1237 ],
  [ 1,3,6,12,22,40,70,119,201,330,525,806,1207 ],
  [ 1,3,6,12,22,40,70,119,201,332,546,898,1380 ],
  [ 1,3,6,12,22,40,70,119,201,332,546,898,1467 ],
  [ 1,3,6,12,22,40,71,120,175,191,147,66,10,0 ],
  [ 1,3,6,12,22,40,71,120,199,323,521,840,1350,2152,3404,5352,
      8374,13034,20241 ],
  [ 1,3,6,12,22,40,71,122,204,331,522,806,1200 ],
  [ 1,3,6,12,22,40,71,122,206,343,560,902,1401 ],
  [ 1,3,6,12,22,40,71,122,206,343,565,924,1501 ],
  [ 1,3,6,12,22,40,71,122,208,357,607,1013,1656 ],
  [ 1,3,6,12,22,40,71,123,182,235,242,194,157,133,83,28,4,0 ]
    ,[ 1,3,6,12,22,40,71,123,210,328,484,671,824,722,287,35,
      1,0 ],[ 1,3,6,12,22,40,71,123,212,360,607,1017,1693 ],
  [ 1,3,6,12,22,40,71,123,212,360,612,1046,1781 ],
  [ 1,3,6,12,22,40,71,123,214,370,634,1087,1793 ],
  [ 1,3,6,12,22,40,71,123,214,370,639,1107,1881 ],
  [ 1,3,6,12,22,40,71,123,214,370,639,1107,1910 ],
  [ 1,3,6,12,22,40,71,123,214,370,639,1107,1914 ],
  [ 1,3,6,12,22,40,71,123,214,370,639,1107,1915 ],
  [ 1,3,6,12,22,40,71,123,214,370,639,1107,1917 ],
  [ 1,3,6,12,22,40,71,123,216,380,666,1168,2049 ],
  [ 1,3,6,12,22,40,72,115,174,259,377,557,832 ],
  [ 1,3,6,12,22,40,72,124,210,360,505,594,505,264,110,43,9,0 
     ],[ 1,3,6,12,22,40,72,126,217,347,533,751,851,707,415,
      169,43,5,0 ],
  [ 1,3,6,12,22,40,72,126,217,365,611,1011,1645 ],
  [ 1,3,6,12,22,40,72,126,217,365,611,1011,1645,2661,4298,
      6947,11146,17706 ],
  [ 1,3,6,12,22,40,72,126,217,365,616,1015,1595 ],
  [ 1,3,6,12,22,40,72,126,217,365,616,1049,1792 ],
  [ 1,3,6,12,22,40,72,126,217,372,636,1053,1679 ],
  [ 1,3,6,12,22,40,72,126,220,383,664,1152,1992 ],
  [ 1,3,6,12,22,40,72,126,220,383,664,1152,1992,3425,5882,
      10108,17352 ],
  [ 1,3,6,12,22,40,72,126,220,383,664,1152,1992,3425,5882,
      10108,17352,29738 ],
  [ 1,3,6,12,22,40,72,126,221,390,687,1194,2057 ],
  [ 1,3,6,12,22,40,72,126,222,393,693,1223,2159 ],
  [ 1,3,6,12,22,40,73,121,164,206,262,328,393,421,395,319,
      196,81,23,5,1,0 ],
  [ 1,3,6,12,22,40,73,121,182,254,321,307,220,125,39,2,0 ],
  [ 1,3,6,12,22,40,73,122,184,196,134,59,12,0 ],
  [ 1,3,6,12,22,40,73,124,191,273,314,248,141,67,20,1,0 ],
  [ 1,3,6,12,22,40,73,124,191,273,320,286,204,111,44,15,3,0 ]
    ,[ 1,3,6,12,22,40,73,130,230,401,687,1160,1927 ],
  [ 1,3,6,12,22,40,73,132,214,345,562,938,1542 ],
  [ 1,3,6,12,22,40,73,132,219,351,570,909,1311 ],
  [ 1,3,6,12,22,40,73,132,219,351,580,971,1607 ],
  [ 1,3,6,12,22,40,73,132,219,351,580,971,1610 ],
  [ 1,3,6,12,22,40,73,132,225,296,310,239,126,46,5,0 ],
  [ 1,3,6,12,22,40,73,132,229,388,640,1017,1582 ],
  [ 1,3,6,12,22,40,73,132,231,396,650,1006,1329 ],
  [ 1,3,6,12,22,40,73,132,233,379,526,578,475,181,24,3,0 ],
  [ 1,3,6,12,22,40,73,132,233,402,685,1138,1744 ],
  [ 1,3,6,12,22,40,73,132,233,404,690,1161,1933 ],
  [ 1,3,6,12,22,40,73,132,233,404,690,1161,1947 ],
  [ 1,3,6,12,22,40,73,132,233,404,692,1159,1881 ],
  [ 1,3,6,12,22,40,73,132,233,404,697,1195,2027 ],
  [ 1,3,6,12,22,40,73,132,233,404,702,1201,2008 ],
  [ 1,3,6,12,22,40,73,132,233,404,702,1220,2107 ],
  [ 1,3,6,12,22,40,73,132,233,404,702,1220,2109 ],
  [ 1,3,6,12,22,40,73,132,235,409,712,1222,2041 ],
  [ 1,3,6,12,22,40,73,132,235,412,724,1221,1918 ],
  [ 1,3,6,12,22,40,73,132,235,414,719,1240,2141,3664,6207,
      10484,17638 ],
  [ 1,3,6,12,22,40,73,132,235,414,719,1242,2145 ],
  [ 1,3,6,12,22,40,73,132,235,414,726,1200,1939 ],
  [ 1,3,6,12,22,40,73,132,235,414,726,1243,2083 ],
  [ 1,3,6,12,22,40,73,132,235,414,726,1259,2171 ],
  [ 1,3,6,12,22,40,73,132,237,422,743,1255,2084 ],
  [ 1,3,6,12,22,40,73,132,237,422,743,1255,2086 ],
  [ 1,3,6,12,22,40,73,132,239,416,737,1264,2134 ],
  [ 1,3,6,12,22,40,73,132,239,420,712,1164,1878 ],
  [ 1,3,6,12,22,40,73,132,239,420,717,1210,2046 ],
  [ 1,3,6,12,22,40,73,132,239,432,760,1319,2255 ],
  [ 1,3,6,12,22,40,73,132,239,432,777,1370,2399 ],
  [ 1,3,6,12,22,40,73,132,239,432,777,1390,2481 ],
  [ 1,3,6,12,22,40,73,132,239,432,777,1390,2483 ],
  [ 1,3,6,12,22,40,73,132,239,432,777,1396,2494 ],
  [ 1,3,6,12,22,40,73,132,239,432,782,1403,2506 ],
  [ 1,3,6,12,22,40,73,132,239,432,782,1416,2524 ],
  [ 1,3,6,12,22,40,73,132,239,432,782,1416,2555 ],
  [ 1,3,6,12,22,40,73,132,239,432,782,1416,2557 ],
  [ 1,3,6,12,22,40,73,132,239,432,782,1416,2560 ],
  [ 1,3,6,12,22,40,73,132,239,432,782,1416,2562 ],
  [ 1,3,6,12,22,40,74,124,222,394,687,1200,2045 ],
  [ 1,3,6,12,22,40,74,128,195,273,314,246,140,66,16,0 ],
  [ 1,3,6,12,22,40,74,136,246,410,655,1015,1489 ],
  [ 1,3,6,12,22,40,74,136,246,410,655,1015,1491 ],
  [ 1,3,6,12,22,40,74,136,246,440,788,1414,2535 ],
  [ 1,3,6,12,22,40,74,136,246,442,781,1368,2370 ],
  [ 1,3,6,12,22,40,74,136,246,442,793,1425,2560 ],
  [ 1,3,6,12,22,40,74,136,248,435,743,1267,2143 ],
  [ 1,3,6,12,22,40,74,136,248,435,748,1274,2151 ],
  [ 1,3,6,12,22,40,74,136,248,447,798,1418,2485 ],
  [ 1,3,6,12,22,40,74,136,248,450,807,1435,2541,4475,7821,
      13655,23778 ],
  [ 1,3,6,12,22,40,74,136,248,450,812,1440,2530 ],
  [ 1,3,6,12,22,40,74,136,248,450,812,1459,2618 ],
  [ 1,3,6,12,22,40,74,136,248,450,812,1460,2513 ],
  [ 1,3,6,12,22,40,74,136,248,450,812,1460,2625 ],
  [ 1,3,6,12,22,40,74,136,248,450,812,1460,2627 ],
  [ 1,3,6,12,22,40,74,136,248,450,817,1474,2640 ],
  [ 1,3,6,12,22,40,74,136,248,450,817,1485,2669 ],
  [ 1,3,6,12,22,40,74,136,248,450,817,1485,2695 ],
  [ 1,3,6,12,22,40,74,136,248,450,817,1485,2696 ],
  [ 1,3,6,12,22,40,74,136,248,450,817,1485,2697 ],
  [ 1,3,6,12,22,40,74,136,250,448,799,1419,2520 ],
  [ 1,3,6,12,22,40,74,136,250,460,841,1510,2702 ],
  [ 1,3,6,12,22,40,74,136,250,460,841,1530,2782 ],
  [ 1,3,6,12,22,40,74,136,250,460,841,1532,2789 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1546,2822 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1546,2824 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2840 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2856 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2857 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2858 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2859 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2860 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2861 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2861,5260,9656 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2862 ],
  [ 1,3,6,12,22,40,74,136,250,460,846,1556,2862,5264,9675 ],
  [ 1,3,6,12,23,37,46,38,18,6,2,0 ],
  [ 1,3,6,12,23,37,58,90,136,206,298,368,314,148,28,0 ],
  [ 1,3,6,12,23,39,58,74,55,16,1,0 ],
  [ 1,3,6,12,23,44,61,62,27,1,0 ],
  [ 1,3,6,12,23,44,77,115,117,64,16,2,0 ],
  [ 1,3,6,12,23,44,77,117,143,142,111,59,22,7,1,0 ],
  [ 1,3,6,12,23,44,77,120,170,220,265,275,79,1,0 ],
  [ 1,3,6,12,23,44,77,122,185,272,384,526,691,835,902,866,
      765,616,387,159,35,1,0 ],
  [ 1,3,6,12,23,44,78,124,181,248,328,423,529,642,766,909,
      1067 ],
  [ 1,3,6,12,23,44,78,124,181,248,328,423,529,642,766,909,
      1067,1228,1396,1587,1797,2006,2218,2457,2719,2976,3232,3519,
      3833,4138,4438,4773,5139,5492,5836,6219,6637 ],
  [ 1,3,6,12,23,44,78,124,181,248,328,423,529,642,766,909,
      1067,1228,1396,1587,1797,2006,2218,2457,2719,2976,3232,3519,
      3833,4138,4438,4773,5139,5492,5836,6219,6637,7038 ],
  [ 1,3,6,12,23,44,78,125,193,283,354,310,197,87,12,0 ],
  [ 1,3,6,12,23,44,78,128,203,315,483,728,1041 ],
  [ 1,3,6,12,23,44,78,128,205,327,521,801,1156 ],
  [ 1,3,6,12,23,44,78,128,205,327,521,821,1246 ],
  [ 1,3,6,12,23,44,78,128,205,327,521,821,1283 ],
  [ 1,3,6,12,23,44,78,130,216,355,577,930,1398 ],
  [ 1,3,6,12,23,44,79,132,216,355,584,952,1539 ],
  [ 1,3,6,12,23,44,80,131,179,212,251,229,164,76,25,4,0 ],
  [ 1,3,6,12,23,44,80,138,224,343,506,697,838,756,453,164,29,
      3,0 ],
  [ 1,3,6,12,23,44,80,140,223,319,422,477,375,154,21,3,1,0 ],
  [ 1,3,6,12,23,44,80,140,243,416,708,1168,1825 ],
  [ 1,3,6,12,23,44,80,142,240,382,582,835,1072 ],
  [ 1,3,6,12,23,44,80,142,248,422,708,1150,1800 ],
  [ 1,3,6,12,23,44,80,142,252,439,760,1310,2235 ],
  [ 1,3,6,12,23,44,80,142,252,442,772,1345,2333 ],
  [ 1,3,6,12,23,44,80,142,254,435,753,1254,1912 ],
  [ 1,3,6,12,23,44,80,142,254,442,753,1283,2165 ],
  [ 1,3,6,12,23,44,81,144,238,358,520,712,871,942,1040 ],
  [ 1,3,6,12,23,44,81,144,254,425,586,596,421,201,68,15,0 ],
  [ 1,3,6,12,23,44,81,146,235,381,543,673,745,537,282,104,22,
      2,0 ],[ 1,3,6,12,23,44,81,146,253,441,787,1383,2369 ],
  [ 1,3,6,12,23,44,81,146,253,444,789,1355,2271 ],
  [ 1,3,6,12,23,44,81,146,253,444,789,1369,2314 ],
  [ 1,3,6,12,23,44,81,146,259,435,667,912,1130 ],
  [ 1,3,6,12,23,44,81,146,259,444,741,1195,1760 ],
  [ 1,3,6,12,23,44,81,146,259,444,744,1230,2005 ],
  [ 1,3,6,12,23,44,81,146,261,460,797,1343,2222 ],
  [ 1,3,6,12,23,44,81,146,261,460,799,1338,2203 ],
  [ 1,3,6,12,23,44,81,146,261,460,806,1400,2414 ],
  [ 1,3,6,12,23,44,81,146,261,464,824,1445,2516 ],
  [ 1,3,6,12,23,44,81,146,263,470,835,1469,2556 ],
  [ 1,3,6,12,23,44,81,146,263,470,835,1475,2595 ],
  [ 1,3,6,12,23,44,81,146,263,470,835,1475,2598 ],
  [ 1,3,6,12,23,44,81,146,263,470,835,1480,2617 ],
  [ 1,3,6,12,23,44,81,146,263,470,840,1490,2619 ],
  [ 1,3,6,12,23,44,81,146,263,470,840,1501,2661 ],
  [ 1,3,6,12,23,44,81,146,263,470,840,1501,2680 ],
  [ 1,3,6,12,23,44,81,146,263,472,844,1495,2629 ],
  [ 1,3,6,12,23,44,81,146,265,470,786,1234,1897 ],
  [ 1,3,6,12,23,44,81,146,265,482,858,1482,2502 ],
  [ 1,3,6,12,23,44,81,146,265,482,868,1526,2658 ],
  [ 1,3,6,12,23,44,81,146,265,482,868,1551,2763 ],
  [ 1,3,6,12,23,44,81,146,265,482,873,1570,2817 ],
  [ 1,3,6,12,23,44,81,146,265,482,878,1573,2726 ],
  [ 1,3,6,12,23,44,81,146,265,482,878,1573,2755 ],
  [ 1,3,6,12,23,44,81,146,265,482,878,1584,2837 ],
  [ 1,3,6,12,23,44,81,146,265,482,878,1595,2890 ],
  [ 1,3,6,12,23,44,81,146,265,482,878,1595,2892 ],
  [ 1,3,6,12,23,44,81,146,265,482,878,1595,2894 ],
  [ 1,3,6,12,23,44,81,146,265,482,878,1595,2895 ],
  [ 1,3,6,12,23,44,81,148,270,482,829,1384,2217 ],
  [ 1,3,6,12,23,44,81,148,272,493,893,1596,2803 ],
  [ 1,3,6,12,23,44,82,150,248,387,502,565,549,267,37,4,0 ],
  [ 1,3,6,12,23,44,82,150,269,476,834,1437,2458 ],
  [ 1,3,6,12,23,44,82,150,269,476,834,1437,2458,4208,7177,
      12161,20409 ],
  [ 1,3,6,12,23,44,82,150,271,481,862,1556,2784 ],
  [ 1,3,6,12,23,44,82,150,273,489,884,1614,2940 ],
  [ 1,3,6,12,23,44,82,150,274,498,898,1610,2879 ],
  [ 1,3,6,12,23,44,82,150,274,498,902,1632,2953 ],
  [ 1,3,6,12,23,44,82,150,274,498,903,1625,2884 ],
  [ 1,3,6,12,23,44,82,150,274,498,903,1636,2961 ],
  [ 1,3,6,12,23,44,82,150,274,498,903,1636,2963 ],
  [ 1,3,6,12,23,44,82,150,274,498,903,1636,2964 ],
  [ 1,3,6,12,23,44,82,150,274,498,903,1636,2965 ],
  [ 1,3,6,12,23,44,82,150,274,498,903,1636,2966 ],
  [ 1,3,6,12,23,44,82,150,276,510,936,1694,3031 ],
  [ 1,3,6,12,23,44,82,150,276,510,941,1717,3112 ],
  [ 1,3,6,12,23,44,82,150,276,510,941,1730,3172 ],
  [ 1,3,6,12,23,44,82,150,276,510,941,1730,3174 ],
  [ 1,3,6,12,23,44,82,150,276,510,941,1730,3177 ],
  [ 1,3,6,12,23,44,82,150,276,510,941,1730,3179 ],
  [ 1,3,6,12,23,44,82,150,277,514,951,1756,3246 ],
  [ 1,3,6,12,23,44,82,152,281,521,957,1728,3097 ],
  [ 1,3,6,12,23,44,83,134,169,138,51,8,0 ],
  [ 1,3,6,12,23,44,83,138,180,162,58,8,2,0 ],
  [ 1,3,6,12,23,44,83,138,208,278,278,183,95,56,26,6,0 ],
  [ 1,3,6,12,23,44,83,138,218,281,261,182,103,54,25,6,0 ],
  [ 1,3,6,12,23,44,83,145,230,359,564,861,1278 ],
  [ 1,3,6,12,23,44,83,145,234,338,414,518,512,305,48,2,0 ],
  [ 1,3,6,12,23,44,83,145,250,415,629,891,1107 ],
  [ 1,3,6,12,23,44,83,149,248,339,392,337,259,186,69,9,0 ],
  [ 1,3,6,12,23,44,83,149,248,393,579,740,765,649,430,169,25,
      1,0 ],[ 1,3,6,12,23,44,83,156,274,478,860,1544,2753 ],
  [ 1,3,6,12,23,44,83,156,276,463,746,1167,1747 ],
  [ 1,3,6,12,23,44,83,156,284,511,911,1612,2860 ],
  [ 1,3,6,12,23,44,83,156,286,496,843,1453,2530 ],
  [ 1,3,6,12,23,44,83,156,288,509,924,1669,2933 ],
  [ 1,3,6,12,23,44,83,156,288,525,964,1767,3229 ],
  [ 1,3,6,12,23,44,83,156,288,527,952,1611,2513 ],
  [ 1,3,6,12,23,44,83,156,288,527,957,1689,2938 ],
  [ 1,3,6,12,23,44,83,156,288,527,967,1745,3135 ],
  [ 1,3,6,12,23,44,83,156,290,532,949,1595,2551 ],
  [ 1,3,6,12,23,44,83,156,290,535,988,1808,3237 ],
  [ 1,3,6,12,23,44,83,156,290,535,988,1821,3330 ],
  [ 1,3,6,12,23,44,83,156,290,535,993,1844,3409 ],
  [ 1,3,6,12,23,44,83,156,290,535,993,1844,3418 ],
  [ 1,3,6,12,23,44,83,156,290,537,996,1817,3304 ],
  [ 1,3,6,12,23,44,83,156,292,542,998,1791,3193 ],
  [ 1,3,6,12,23,44,83,156,292,543,1013,1890,3524 ],
  [ 1,3,6,12,23,44,83,156,292,545,1010,1826,3285 ],
  [ 1,3,6,12,23,44,83,156,294,537,1002,1843,3318 ],
  [ 1,3,6,12,23,44,83,156,294,541,990,1794,3215 ],
  [ 1,3,6,12,23,44,83,156,294,544,993,1804,3283 ],
  [ 1,3,6,12,23,44,83,156,294,544,998,1827,3355 ],
  [ 1,3,6,12,23,44,83,156,294,550,1015,1828,3212 ],
  [ 1,3,6,12,23,44,83,156,294,550,1026,1895,3519,6492,11976,
      22048,40550 ],
  [ 1,3,6,12,23,44,83,156,294,550,1026,1915,3571 ],
  [ 1,3,6,12,23,44,83,156,294,550,1030,1917,3519 ],
  [ 1,3,6,12,23,44,83,156,294,553,1032,1921,3572 ],
  [ 1,3,6,12,23,44,83,156,294,553,1037,1896,3439 ],
  [ 1,3,6,12,23,44,83,156,294,553,1037,1920,3548 ],
  [ 1,3,6,12,23,44,83,156,294,553,1037,1939,3592 ],
  [ 1,3,6,12,23,44,83,156,294,553,1037,1943,3633 ],
  [ 1,3,6,12,23,44,83,156,294,553,1042,1937,3594 ],
  [ 1,3,6,12,23,44,83,156,294,553,1042,1941,3573 ],
  [ 1,3,6,12,23,44,83,156,294,553,1042,1952,3642 ],
  [ 1,3,6,12,23,44,83,156,294,553,1042,1952,3644 ],
  [ 1,3,6,12,23,44,83,156,294,553,1042,1963,3690 ],
  [ 1,3,6,12,23,44,83,156,294,553,1042,1963,3694 ],
  [ 1,3,6,12,23,44,83,156,294,553,1042,1963,3696 ],
  [ 1,3,6,12,23,44,84,149,259,451,782,1352,2324 ],
  [ 1,3,6,12,23,44,84,149,259,451,782,1352,2324,3985,6820,
      11644,19851 ],
  [ 1,3,6,12,23,44,84,149,261,461,811,1427,2505 ],
  [ 1,3,6,12,23,44,84,149,261,461,811,1427,2505,4381,7658,
      13342 ],[ 1,3,6,12,23,44,84,149,261,461,811,1427,2508 ],
  [ 1,3,6,12,23,44,84,149,261,461,811,1427,2510 ],
  [ 1,3,6,12,23,44,84,152,274,504,918,1658,2972 ],
  [ 1,3,6,12,23,44,84,153,267,453,718,1032,1295 ],
  [ 1,3,6,12,23,44,84,153,273,484,847,1448,2416 ],
  [ 1,3,6,12,23,44,84,160,262,402,548,563,470,253,43,6,0 ],
  [ 1,3,6,12,23,44,84,160,272,472,774,1216,1540 ],
  [ 1,3,6,12,23,44,84,160,278,496,891,1562,2712 ],
  [ 1,3,6,12,23,44,84,160,280,504,923,1652,2867 ],
  [ 1,3,6,12,23,44,84,160,280,504,923,1667,2901 ],
  [ 1,3,6,12,23,44,84,160,285,506,926,1700,3102 ],
  [ 1,3,6,12,23,44,84,160,285,506,926,1700,3103 ],
  [ 1,3,6,12,23,44,84,160,291,493,864,1507,2547 ],
  [ 1,3,6,12,23,44,84,160,291,512,886,1426,2221 ],
  [ 1,3,6,12,23,44,84,160,295,538,977,1684,2766 ],
  [ 1,3,6,12,23,44,84,160,299,553,1030,1906,3491 ],
  [ 1,3,6,12,23,44,84,160,299,553,1030,1919,3559 ],
  [ 1,3,6,12,23,44,84,160,299,553,1030,1919,3562 ],
  [ 1,3,6,12,23,44,84,160,299,555,1032,1914,3527 ],
  [ 1,3,6,12,23,44,84,160,301,551,987,1751,3084 ],
  [ 1,3,6,12,23,44,84,160,301,551,992,1779,3183 ],
  [ 1,3,6,12,23,44,84,160,301,554,1015,1865,3414 ],
  [ 1,3,6,12,23,44,84,160,301,556,1019,1814,3117 ],
  [ 1,3,6,12,23,44,84,160,301,560,1047,1961,3612 ],
  [ 1,3,6,12,23,44,84,160,301,563,1049,1924,3457 ],
  [ 1,3,6,12,23,44,84,160,301,563,1054,1953,3583 ],
  [ 1,3,6,12,23,44,84,160,301,563,1054,1966,3654 ],
  [ 1,3,6,12,23,44,84,160,301,563,1054,1972,3677 ],
  [ 1,3,6,12,23,44,84,160,301,563,1054,1974,3679 ],
  [ 1,3,6,12,23,44,84,160,301,563,1057,1986,3723 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1968,3585 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1968,3586 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1974,3674 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1981,3680 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1981,3681 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1983,3644 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3691 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3730 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3737 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3739 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3740 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3746 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3747 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3748 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3749 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3751 ],
  [ 1,3,6,12,23,44,84,160,301,563,1059,1994,3752 ],
  [ 1,3,6,12,23,44,84,160,303,562,1022,1866,3360 ],
  [ 1,3,6,12,23,44,84,160,303,562,1046,1936,3530 ],
  [ 1,3,6,12,23,44,84,160,303,571,1074,2001,3719 ],
  [ 1,3,6,12,23,44,84,160,303,571,1074,2001,3722 ],
  [ 1,3,6,12,23,44,84,160,303,571,1074,2014,3771 ],
  [ 1,3,6,12,23,44,84,160,303,571,1074,2016,3787 ],
  [ 1,3,6,12,23,44,84,160,303,571,1079,2029,3807 ],
  [ 1,3,6,12,23,44,84,160,303,571,1079,2040,3856 ],
  [ 1,3,6,12,23,44,84,160,303,571,1079,2042,3841 ],
  [ 1,3,6,12,23,44,84,160,303,571,1079,2042,3853 ],
  [ 1,3,6,12,23,44,84,160,303,571,1079,2042,3857 ],
  [ 1,3,6,12,23,44,84,160,303,571,1079,2042,3859 ],
  [ 1,3,6,12,23,44,84,160,303,571,1079,2042,3862 ],
  [ 1,3,6,12,23,44,84,160,303,573,1071,1947,3528 ],
  [ 1,3,6,12,23,44,84,160,303,573,1076,1978,3625 ],
  [ 1,3,6,12,23,44,84,160,303,573,1076,1978,3629 ],
  [ 1,3,6,12,23,44,84,160,303,573,1076,1978,3630 ],
  [ 1,3,6,12,23,44,84,160,303,573,1081,2031,3821 ],
  [ 1,3,6,12,23,44,84,160,303,573,1081,2033,3791 ],
  [ 1,3,6,12,23,44,84,160,303,573,1084,2045,3862 ],
  [ 1,3,6,12,23,44,84,160,303,573,1086,2042,3838 ],
  [ 1,3,6,12,23,44,84,160,303,573,1086,2055,3879 ],
  [ 1,3,6,12,23,44,84,160,303,573,1086,2055,3879,7309,13693,
      25691 ],
  [ 1,3,6,12,23,44,84,160,303,573,1086,2055,3879,7309,13693,
      25691,48140 ],
  [ 1,3,6,12,23,44,84,160,303,573,1086,2055,3881 ],
  [ 1,3,6,12,23,44,84,160,303,573,1086,2055,3890 ],
  [ 1,3,6,12,23,44,84,160,305,560,1010,1754,2910 ],
  [ 1,3,6,12,23,44,84,160,305,562,1056,1980,3654 ],
  [ 1,3,6,12,23,44,84,160,305,565,1068,2015,3763 ],
  [ 1,3,6,12,23,44,84,160,305,569,1031,1803,3066 ],
  [ 1,3,6,12,23,44,84,160,305,569,1038,1811,2984 ],
  [ 1,3,6,12,23,44,84,160,305,569,1063,1994,3737 ],
  [ 1,3,6,12,23,44,84,160,305,572,1064,1964,3639 ],
  [ 1,3,6,12,23,44,84,160,305,572,1064,1977,3688 ],
  [ 1,3,6,12,23,44,84,160,305,572,1064,1977,3689 ],
  [ 1,3,6,12,23,44,84,160,305,572,1068,1960,3563 ],
  [ 1,3,6,12,23,44,84,160,305,572,1068,1960,3566 ],
  [ 1,3,6,12,23,44,84,160,305,572,1073,1979,3628 ],
  [ 1,3,6,12,23,44,84,160,305,572,1073,1988,3591 ],
  [ 1,3,6,12,23,44,84,160,305,578,1091,2056,3825 ],
  [ 1,3,6,12,23,44,84,160,305,578,1092,2065,3904 ],
  [ 1,3,6,12,23,44,84,160,305,578,1094,2074,3889 ],
  [ 1,3,6,12,23,44,84,160,305,578,1096,2078,3912 ],
  [ 1,3,6,12,23,44,84,160,305,578,1096,2078,3921 ],
  [ 1,3,6,12,23,44,84,160,305,581,1093,1997,3596 ],
  [ 1,3,6,12,23,44,84,160,305,581,1096,2064,3897 ],
  [ 1,3,6,12,23,44,84,160,305,581,1098,1995,3539 ],
  [ 1,3,6,12,23,44,84,160,305,581,1098,2018,3676 ],
  [ 1,3,6,12,23,44,84,160,305,581,1098,2019,3672 ],
  [ 1,3,6,12,23,44,84,160,305,581,1103,2028,3675 ],
  [ 1,3,6,12,23,44,84,160,305,581,1103,2035,3691 ],
  [ 1,3,6,12,23,44,84,160,305,581,1103,2069,3875 ],
  [ 1,3,6,12,23,44,84,160,305,581,1103,2073,3884 ],
  [ 1,3,6,12,23,44,84,160,305,581,1103,2078,3891 ],
  [ 1,3,6,12,23,44,84,160,305,581,1103,2091,3948 ],
  [ 1,3,6,12,23,44,84,160,305,581,1103,2091,3965 ],
  [ 1,3,6,12,23,44,84,160,305,581,1103,2093,3964 ],
  [ 1,3,6,12,23,44,84,160,305,581,1107,2109,4015 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2060,3773 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2060,3815 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2073,3863 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2073,3864 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2080,3899 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2087,3925 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2087,3926 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2093,3897 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2093,3947 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2093,3948 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2100,3976 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2100,3979 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2102,3904 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2102,3955 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2102,3966 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2102,3969 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2103,3987 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,3994 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4000 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4001 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4006 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4011 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4017 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4018 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4021 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4023 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4024 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4025 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4026 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4027 ],
  [ 1,3,6,12,23,44,84,160,305,581,1108,2113,4028 ],
  [ 1,3,6,12,23,44,85,156,287,527,965,1771,3259 ],
  [ 1,3,6,12,23,44,85,164,299,535,981,1816,3349 ],
  [ 1,3,6,12,23,44,85,164,299,535,981,1816,3349,6142,11264,
      20705 ],[ 1,3,6,12,23,44,85,164,310,581,1094,2061,3868 ],
  [ 1,3,6,12,23,44,85,164,310,581,1094,2065,3886 ],
  [ 1,3,6,12,23,44,85,164,310,583,1096,2052,3829 ],
  [ 1,3,6,12,23,44,85,164,312,591,1116,2111,3996 ],
  [ 1,3,6,12,23,44,85,164,312,591,1116,2111,3999 ],
  [ 1,3,6,12,23,44,85,164,312,591,1123,2136,4051 ],
  [ 1,3,6,12,23,44,85,164,312,591,1123,2136,4056 ],
  [ 1,3,6,12,23,44,85,164,312,591,1123,2136,4058 ],
  [ 1,3,6,12,23,44,85,164,312,591,1123,2136,4060 ],
  [ 1,3,6,12,23,44,85,164,312,591,1123,2136,4063 ],
  [ 1,3,6,12,23,44,85,164,312,591,1123,2136,4063,7723,14677 ],
  [ 1,3,6,12,23,44,85,164,314,599,1106,2018,3693 ],
  [ 1,3,6,12,23,44,85,164,314,599,1135,2123,3887 ],
  [ 1,3,6,12,23,44,85,164,314,599,1135,2140,4029 ],
  [ 1,3,6,12,23,44,85,164,314,599,1145,2192,4184 ],
  [ 1,3,6,12,23,44,85,164,314,599,1145,2192,4187 ],
  [ 1,3,6,12,23,44,85,164,314,599,1145,2192,4189 ],
  [ 1,3,6,12,23,44,85,164,314,599,1145,2192,4190 ],
  [ 1,3,6,12,23,44,85,164,314,599,1145,2192,4194 ],
  [ 1,3,6,12,23,44,85,164,314,599,1145,2192,4195 ],
  [ 1,3,6,12,23,44,85,164,314,601,1113,2037,3712 ],
  [ 1,3,6,12,23,44,85,164,314,601,1142,2163,4097 ],
  [ 1,3,6,12,23,44,85,164,314,601,1147,2187,4169 ],
  [ 1,3,6,12,23,44,85,164,314,601,1147,2187,4170 ],
  [ 1,3,6,12,23,44,85,164,314,601,1152,2207,4226 ],
  [ 1,3,6,12,23,44,85,164,314,601,1152,2207,4228 ],
  [ 1,3,6,12,23,44,85,164,314,601,1152,2207,4229 ],
  [ 1,3,6,12,23,44,85,164,314,601,1152,2207,4230 ],
  [ 1,3,6,12,23,44,85,164,316,606,1152,2188,4151 ],
  [ 1,3,6,12,23,44,85,164,316,606,1162,2217,4189 ],
  [ 1,3,6,12,23,44,85,164,316,606,1162,2228,4268 ],
  [ 1,3,6,12,23,44,85,164,316,606,1162,2230,4276 ],
  [ 1,3,6,12,23,44,85,164,316,609,1159,2173,4060 ],
  [ 1,3,6,12,23,44,85,164,316,609,1159,2173,4072 ],
  [ 1,3,6,12,23,44,85,164,316,609,1164,2219,4229 ],
  [ 1,3,6,12,23,44,85,164,316,609,1164,2221,4218 ],
  [ 1,3,6,12,23,44,85,164,316,609,1167,2238,4294 ],
  [ 1,3,6,12,23,44,85,164,316,609,1167,2238,4297 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2230,4249 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2239,4289 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2241,4277 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2241,4293 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2241,4294 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2241,4294,8225 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2241,4296 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2241,4297 ],
  [ 1,3,6,12,23,44,85,164,316,609,1169,2241,4299 ],
  [ 1,3,6,12,23,44,85,164,316,609,1173,2259,4346 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2221,4167 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2221,4173 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2221,4174 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2232,4236 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2236,4262 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2243,4283 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2252,4313 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2252,4315 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2253,4324 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4343 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4348 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4351 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4354 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4355 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4355,8374,16102,
      30952 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4355,8374,16102,
      30952,59459 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4356 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4357 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4358 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4359 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4359,8394,16167 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4360 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4361 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4361,8404,16181 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4362 ],
  [ 1,3,6,12,23,44,85,164,316,609,1174,2263,4362,8408 ],
  [ 1,3,6,12,24,43,61,64,47,22,5,0 ],
  [ 1,3,6,12,24,43,67,94,116,109,71,27,3,0 ],
  [ 1,3,6,12,24,43,70,103,129,151,152,114,50,6,0 ],
  [ 1,3,6,12,24,43,70,112,179,282,440,692,1088 ],
  [ 1,3,6,12,24,43,70,112,179,282,440,692,1088,1675,2534,3837,
      5856,8925,13555 ],
  [ 1,3,6,12,24,43,71,107,143,158,146,107,41,2,0 ],
  [ 1,3,6,12,24,43,71,109,151,200,238,241,204,159,128,88,41,
      9,0 ],[ 1,3,6,12,24,43,71,116,190,312,512,838,1354 ],
  [ 1,3,6,12,24,43,71,116,190,312,512,838,1354,2190,3552,5754,
      9244,14728 ],[ 1,3,6,12,24,43,74,125,202,326,510,733,864 ]
    ,[ 1,3,6,12,24,43,74,125,202,326,510,733,864,796,625,508,
      464,440,432,432,431 ],
  [ 1,3,6,12,24,43,74,125,202,326,510,733,864,796,625,508,
      464,440,432,432,431,426 ],
  [ 1,3,6,12,24,43,74,125,202,326,510,733,864,796,625,508,
      464,440,432,432,431,426,410 ],
  [ 1,3,6,12,24,43,74,125,202,326,510,733,864,796,625,508,
      464,440,432,432,431,426,410,366 ],
  [ 1,3,6,12,24,48,66,96,109,121,118,81,33,2,0 ],
  [ 1,3,6,12,24,48,82,124,169,185,153,98,44,10,1,0 ],
  [ 1,3,6,12,24,48,85,140,223,329,443,536,534,354,123,18,1,0 
     ],[ 1,3,6,12,24,48,86,147,261,454,781,1335,2271 ],
  [ 1,3,6,12,24,48,86,147,261,454,781,1348,2329 ],
  [ 1,3,6,12,24,48,87,148,245,380,542,725,836,754,411,90,8,0 
     ],[ 1,3,6,12,24,48,87,152,250,389,590,806,890,689,309,
      61,3,0 ],[ 1,3,6,12,24,48,87,152,258,437,732,1180,1769 ],
  [ 1,3,6,12,24,48,88,149,255,410,632,924,1313 ],
  [ 1,3,6,12,24,48,88,149,255,415,613,853,1036 ],
  [ 1,3,6,12,24,48,88,149,255,434,710,1168,1900 ],
  [ 1,3,6,12,24,48,88,152,252,384,546,729,865,903,792,540,
      276,101,27,7,3,1,0 ],
  [ 1,3,6,12,24,48,88,152,258,431,709,1156,1835 ],
  [ 1,3,6,12,24,48,88,156,261,430,664,872,986,944,701,372,
      136,38,12,5,1,0 ],
  [ 1,3,6,12,24,48,88,160,284,463,675,952,1289 ],
  [ 1,3,6,12,24,48,88,160,296,528,900,1444,2088 ],
  [ 1,3,6,12,24,48,89,153,266,453,744,1192,1849 ],
  [ 1,3,6,12,24,48,89,160,291,525,942,1693,2997 ],
  [ 1,3,6,12,24,48,89,160,291,527,952,1718,3048 ],
  [ 1,3,6,12,24,48,89,164,305,556,1009,1815,3239 ],
  [ 1,3,6,12,24,48,90,146,208,227,207,140,40,0 ],
  [ 1,3,6,12,24,48,90,164,292,489,780,1193,1695 ],
  [ 1,3,6,12,24,48,90,164,296,517,877,1418,2035 ],
  [ 1,3,6,12,24,48,90,164,300,541,959,1676,2857 ],
  [ 1,3,6,12,24,48,90,164,300,544,977,1704,2878 ],
  [ 1,3,6,12,24,48,90,164,300,544,977,1716,2969 ],
  [ 1,3,6,12,24,48,90,168,291,497,812,1285,1999 ],
  [ 1,3,6,12,24,48,91,168,303,524,878,1434,2242 ],
  [ 1,3,6,12,24,48,91,168,307,552,985,1735,2977 ],
  [ 1,3,6,12,24,48,91,168,307,554,986,1694,2726 ],
  [ 1,3,6,12,24,48,91,168,307,554,986,1714,2908 ],
  [ 1,3,6,12,24,48,91,168,311,563,1014,1805,3158 ],
  [ 1,3,6,12,24,48,91,168,311,569,1032,1853,3300 ],
  [ 1,3,6,12,24,48,91,168,311,574,1051,1923,3490 ],
  [ 1,3,6,12,24,48,91,172,300,489,798,1263,2018 ],
  [ 1,3,6,12,24,48,91,172,325,597,1079,1930,3388 ],
  [ 1,3,6,12,24,48,91,172,325,600,1103,2020,3659 ],
  [ 1,3,6,12,24,48,91,172,325,600,1103,2020,3659,6600 ],
  [ 1,3,6,12,24,48,91,172,325,604,1113,1996,3467 ],
  [ 1,3,6,12,24,48,91,172,325,604,1113,1996,3485 ],
  [ 1,3,6,12,24,48,91,172,327,612,1146,2131,3947 ],
  [ 1,3,6,12,24,48,91,172,329,593,1039,1764,2786 ],
  [ 1,3,6,12,24,48,91,172,329,603,1036,1749,2706 ],
  [ 1,3,6,12,24,48,91,172,329,621,1161,2154,3955 ],
  [ 1,3,6,12,24,48,91,172,329,624,1141,2052,3594 ],
  [ 1,3,6,12,24,48,91,172,329,624,1169,2154,3930 ],
  [ 1,3,6,12,24,48,91,172,329,624,1179,2224,4197 ],
  [ 1,3,6,12,24,48,91,172,329,624,1184,2247,4261 ],
  [ 1,3,6,12,24,48,91,172,329,626,1183,2233,4201 ],
  [ 1,3,6,12,24,48,92,172,314,552,952,1633,2712 ],
  [ 1,3,6,12,24,48,92,172,322,602,1123,2085,3792 ],
  [ 1,3,6,12,24,48,92,176,330,602,1105,1975,3493 ],
  [ 1,3,6,12,24,48,92,176,332,612,1126,2041,3640 ],
  [ 1,3,6,12,24,48,92,176,332,612,1126,2061,3713 ],
  [ 1,3,6,12,24,48,92,176,336,630,1177,2193,4045 ],
  [ 1,3,6,12,24,48,92,176,336,632,1186,2212,4068 ],
  [ 1,3,6,12,24,48,92,176,336,638,1209,2258,4205 ],
  [ 1,3,6,12,24,48,92,176,338,642,1215,2295,4313 ],
  [ 1,3,6,12,24,48,92,176,338,642,1220,2324,4420 ],
  [ 1,3,6,12,24,48,92,176,338,646,1236,2340,4450 ],
  [ 1,3,6,12,24,48,92,176,340,642,1201,2220,4070 ],
  [ 1,3,6,12,24,48,92,176,340,642,1211,2276,4250 ],
  [ 1,3,6,12,24,48,92,176,340,642,1211,2289,4314 ],
  [ 1,3,6,12,24,48,92,176,340,649,1229,2325,4364 ],
  [ 1,3,6,12,24,48,92,176,340,652,1247,2372,4472 ],
  [ 1,3,6,12,24,48,92,176,340,652,1247,2385,4524 ],
  [ 1,3,6,12,24,48,92,176,340,652,1247,2385,4536 ],
  [ 1,3,6,12,24,48,92,176,340,652,1252,2382,4502 ],
  [ 1,3,6,12,24,48,92,176,340,652,1252,2395,4560 ],
  [ 1,3,6,12,24,48,92,176,340,654,1232,2261,4079 ],
  [ 1,3,6,12,24,48,92,176,340,654,1257,2416,4637 ],
  [ 1,3,6,12,24,48,93,166,262,331,364,295,114,9,0 ],
  [ 1,3,6,12,24,48,93,169,300,504,805,1179,1210 ],
  [ 1,3,6,12,24,48,93,169,310,566,1017,1787,3008 ],
  [ 1,3,6,12,24,48,93,169,310,566,1017,1805,3158 ],
  [ 1,3,6,12,24,48,93,169,310,566,1017,1827,3264 ],
  [ 1,3,6,12,24,48,93,169,310,566,1022,1850,3340 ],
  [ 1,3,6,12,24,48,93,173,302,493,683,724,565,275,54,0 ],
  [ 1,3,6,12,24,48,93,173,310,541,917,1431,1973 ],
  [ 1,3,6,12,24,48,93,180,321,535,772,919,792,449,151,14,0 ],
  [ 1,3,6,12,24,48,93,180,328,537,865,1418,2273 ],
  [ 1,3,6,12,24,48,93,180,335,526,721,773,505,186,43,0 ],
  [ 1,3,6,12,24,48,93,180,343,610,1042,1637,2169 ],
  [ 1,3,6,12,24,48,93,180,343,628,1135,2079,3832 ],
  [ 1,3,6,12,24,48,93,180,347,668,1288,2476,4756 ],
  [ 1,3,6,12,24,48,93,180,349,676,1305,2509,4809 ],
  [ 1,3,6,12,24,48,93,180,351,644,1148,2026,3434 ],
  [ 1,3,6,12,24,48,93,180,351,663,1244,2328,4287 ],
  [ 1,3,6,12,24,48,93,180,351,666,1243,2294,4167 ],
  [ 1,3,6,12,24,48,93,180,351,666,1248,2317,4237 ],
  [ 1,3,6,12,24,48,93,180,351,669,1268,2369,4339 ],
  [ 1,3,6,12,24,48,93,180,351,672,1280,2413,4414 ],
  [ 1,3,6,12,24,48,93,180,351,672,1280,2435,4573 ],
  [ 1,3,6,12,24,48,93,180,351,675,1281,2399,4309 ],
  [ 1,3,6,12,24,48,93,180,351,675,1286,2439,4567 ],
  [ 1,3,6,12,24,48,93,180,351,682,1326,2580,5013 ],
  [ 1,3,6,12,24,48,93,180,351,682,1326,2580,5016 ],
  [ 1,3,6,12,24,48,93,180,351,682,1326,2580,5017 ],
  [ 1,3,6,12,24,48,93,180,351,684,1282,2366,4332 ],
  [ 1,3,6,12,24,48,93,180,351,684,1317,2523,4842 ],
  [ 1,3,6,12,24,48,93,180,351,684,1317,2526,4798 ],
  [ 1,3,6,12,24,48,93,180,351,684,1322,2546,4914 ],
  [ 1,3,6,12,24,48,93,180,351,684,1322,2546,4918 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2510,4693 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2546,4845 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2547,4833 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2569,4905 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2569,4929 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2569,4955 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2569,4978 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2569,4980 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2569,4982 ],
  [ 1,3,6,12,24,48,93,180,351,684,1327,2572,4950 ],
  [ 1,3,6,12,24,48,93,180,351,684,1331,2588,5032 ],
  [ 1,3,6,12,24,48,93,180,351,684,1332,2570,4931 ],
  [ 1,3,6,12,24,48,93,180,351,684,1332,2592,5042 ],
  [ 1,3,6,12,24,48,93,180,351,684,1332,2592,5046 ],
  [ 1,3,6,12,24,48,94,162,280,467,767,1280,2120 ],
  [ 1,3,6,12,24,48,94,173,311,528,867,1435,2368 ],
  [ 1,3,6,12,24,48,94,173,311,531,878,1464,2350 ],
  [ 1,3,6,12,24,48,94,173,321,582,1036,1816,3160 ],
  [ 1,3,6,12,24,48,94,173,321,594,1049,1812,3149 ],
  [ 1,3,6,12,24,48,94,173,321,594,1088,1992,3622 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,1972,3509 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,1972,3509,6232,11110 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,1999,3605 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,1999,3617 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,1999,3617,6313,10973,
      19122 ],[ 1,3,6,12,24,48,94,173,321,594,1093,1999,3627 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,1999,3648 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,2012,3672 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,2012,3687 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,2012,3695 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,2012,3696 ],
  [ 1,3,6,12,24,48,94,173,321,594,1093,2012,3697 ],
  [ 1,3,6,12,24,48,94,177,334,592,992,1630,2656 ],
  [ 1,3,6,12,24,48,94,177,334,618,1139,2047,3406 ],
  [ 1,3,6,12,24,48,94,177,334,629,1159,2142,3933 ],
  [ 1,3,6,12,24,48,94,177,334,629,1172,2182,4020 ],
  [ 1,3,6,12,24,48,94,177,334,629,1181,2219,4128 ],
  [ 1,3,6,12,24,48,94,177,334,629,1190,2256,4226 ],
  [ 1,3,6,12,24,48,94,177,334,629,1190,2256,4228 ],
  [ 1,3,6,12,24,48,94,184,339,565,940,1586,2614 ],
  [ 1,3,6,12,24,48,94,184,339,565,940,1586,2614,4286,7078,
      11668 ],[ 1,3,6,12,24,48,94,184,346,572,860,1135,1200 ],
  [ 1,3,6,12,24,48,94,184,350,636,1123,1910,3083 ],
  [ 1,3,6,12,24,48,94,184,352,637,1173,2104,3756 ],
  [ 1,3,6,12,24,48,94,184,354,668,1221,2187,3785 ],
  [ 1,3,6,12,24,48,94,184,354,668,1232,2244,4011 ],
  [ 1,3,6,12,24,48,94,184,354,668,1242,2284,4147 ],
  [ 1,3,6,12,24,48,94,184,354,669,1265,2354,4259 ],
  [ 1,3,6,12,24,48,94,184,354,669,1265,2365,4297 ],
  [ 1,3,6,12,24,48,94,184,358,675,1257,2262,3652 ],
  [ 1,3,6,12,24,48,94,184,358,683,1304,2488,4699 ],
  [ 1,3,6,12,24,48,94,184,358,684,1299,2466,4538 ],
  [ 1,3,6,12,24,48,94,184,358,684,1299,2466,4540 ],
  [ 1,3,6,12,24,48,94,184,358,685,1301,2468,4638 ],
  [ 1,3,6,12,24,48,94,184,358,685,1311,2528,4856 ],
  [ 1,3,6,12,24,48,94,184,358,687,1310,2435,4401 ],
  [ 1,3,6,12,24,48,94,184,358,687,1310,2446,4484 ],
  [ 1,3,6,12,24,48,94,184,358,687,1310,2455,4496 ],
  [ 1,3,6,12,24,48,94,184,358,692,1335,2576,4972 ],
  [ 1,3,6,12,24,48,94,184,358,693,1339,2546,4734 ],
  [ 1,3,6,12,24,48,94,184,358,696,1346,2560,4844 ],
  [ 1,3,6,12,24,48,94,184,358,696,1351,2590,4939 ],
  [ 1,3,6,12,24,48,94,184,358,696,1356,2634,5083 ],
  [ 1,3,6,12,24,48,94,184,360,677,1247,2176,3320 ],
  [ 1,3,6,12,24,48,94,184,360,689,1299,2422,4306 ],
  [ 1,3,6,12,24,48,94,184,360,692,1318,2481,4615 ],
  [ 1,3,6,12,24,48,94,184,360,692,1321,2529,4787 ],
  [ 1,3,6,12,24,48,94,184,360,692,1328,2541,4782 ],
  [ 1,3,6,12,24,48,94,184,360,692,1331,2547,4793 ],
  [ 1,3,6,12,24,48,94,184,360,695,1329,2522,4757 ],
  [ 1,3,6,12,24,48,94,184,360,695,1337,2531,4755 ],
  [ 1,3,6,12,24,48,94,184,360,701,1366,2659,5166 ],
  [ 1,3,6,12,24,48,94,184,360,701,1366,2661,5158 ],
  [ 1,3,6,12,24,48,94,184,360,704,1363,2544,4661 ],
  [ 1,3,6,12,24,48,94,184,360,704,1368,2644,5101 ],
  [ 1,3,6,12,24,48,94,184,360,704,1373,2670,5197 ],
  [ 1,3,6,12,24,48,94,184,360,704,1378,2681,5216 ],
  [ 1,3,6,12,24,48,94,184,360,704,1378,2694,5256 ],
  [ 1,3,6,12,24,48,94,184,360,704,1378,2694,5257 ],
  [ 1,3,6,12,24,48,94,184,360,704,1378,2694,5262 ],
  [ 1,3,6,12,24,48,94,184,360,704,1378,2694,5268 ],
  [ 1,3,6,12,24,48,94,184,362,654,1155,1959,3134 ],
  [ 1,3,6,12,24,48,94,184,362,671,1211,2077,3182 ],
  [ 1,3,6,12,24,48,94,184,362,672,1226,2206,3841 ],
  [ 1,3,6,12,24,48,94,184,362,672,1226,2206,3842 ],
  [ 1,3,6,12,24,48,94,184,362,672,1226,2232,3990 ],
  [ 1,3,6,12,24,48,94,184,362,672,1226,2232,4032 ],
  [ 1,3,6,12,24,48,94,184,362,681,1275,2411,4544 ],
  [ 1,3,6,12,24,48,94,184,362,685,1292,2466,4690 ],
  [ 1,3,6,12,24,48,94,184,362,685,1292,2466,4690,8838,16637 ],
  [ 1,3,6,12,24,48,94,184,362,688,1286,2343,4085 ],
  [ 1,3,6,12,24,48,94,184,362,688,1302,2422,4393 ],
  [ 1,3,6,12,24,48,94,184,362,691,1312,2472,4562 ],
  [ 1,3,6,12,24,48,94,184,362,691,1312,2500,4736 ],
  [ 1,3,6,12,24,48,94,184,362,691,1319,2517,4777 ],
  [ 1,3,6,12,24,48,94,184,362,694,1266,2262,3902 ],
  [ 1,3,6,12,24,48,94,184,362,694,1309,2431,4387 ],
  [ 1,3,6,12,24,48,94,184,362,694,1325,2523,4793 ],
  [ 1,3,6,12,24,48,94,184,362,697,1302,2400,4337 ],
  [ 1,3,6,12,24,48,94,184,362,697,1337,2557,4865 ],
  [ 1,3,6,12,24,48,94,184,362,697,1337,2557,4899 ],
  [ 1,3,6,12,24,48,94,184,362,697,1337,2557,4899,9350,17747 ],
  [ 1,3,6,12,24,48,94,184,362,697,1337,2570,4925 ],
  [ 1,3,6,12,24,48,94,184,362,700,1335,2529,4700 ],
  [ 1,3,6,12,24,48,94,184,362,700,1338,2546,4824 ],
  [ 1,3,6,12,24,48,94,184,362,700,1343,2578,4916 ],
  [ 1,3,6,12,24,48,94,184,362,700,1343,2582,4973 ],
  [ 1,3,6,12,24,48,94,184,362,700,1343,2587,4972 ],
  [ 1,3,6,12,24,48,94,184,362,700,1348,2592,4967 ],
  [ 1,3,6,12,24,48,94,184,362,700,1348,2596,4989 ],
  [ 1,3,6,12,24,48,94,184,362,700,1348,2600,4997 ],
  [ 1,3,6,12,24,48,94,184,362,700,1348,2600,4998 ],
  [ 1,3,6,12,24,48,94,184,362,700,1348,2611,5041 ],
  [ 1,3,6,12,24,48,94,184,362,700,1348,2611,5042 ],
  [ 1,3,6,12,24,48,94,184,362,700,1348,2611,5043 ],
  [ 1,3,6,12,24,48,94,184,362,700,1350,2588,4879 ],
  [ 1,3,6,12,24,48,94,184,362,700,1350,2599,4911 ],
  [ 1,3,6,12,24,48,94,184,362,700,1350,2599,4939 ],
  [ 1,3,6,12,24,48,94,184,362,700,1350,2599,4940 ],
  [ 1,3,6,12,24,48,94,184,362,700,1350,2599,4941 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2596,4937 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2618,5020 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2618,5045 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2618,5048 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2618,5069 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2620,5062 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2620,5066 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2631,5086 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2631,5090 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2631,5115 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2631,5116 ],
  [ 1,3,6,12,24,48,94,184,362,700,1353,2631,5118 ],
  [ 1,3,6,12,24,48,94,184,362,700,1355,2635,5122 ],
  [ 1,3,6,12,24,48,94,184,362,703,1359,2610,4977 ],
  [ 1,3,6,12,24,48,94,184,362,703,1359,2610,4997 ],
  [ 1,3,6,12,24,48,94,184,362,703,1359,2625,5037 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2617,4968 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2628,5044 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2629,4984 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2634,5066 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2641,5091 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2641,5093 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2645,5110 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2645,5124 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2651,5149 ],
  [ 1,3,6,12,24,48,94,184,362,703,1364,2651,5153 ],
  [ 1,3,6,12,24,48,94,184,362,706,1363,2567,4753 ],
  [ 1,3,6,12,24,48,94,184,362,706,1363,2567,4761 ],
  [ 1,3,6,12,24,48,94,184,362,706,1363,2567,4767 ],
  [ 1,3,6,12,24,48,94,184,362,706,1366,2643,5102 ],
  [ 1,3,6,12,24,48,94,184,362,706,1376,2686,5236 ],
  [ 1,3,6,12,24,48,94,184,362,709,1378,2676,5185 ],
  [ 1,3,6,12,24,48,94,184,362,709,1378,2676,5188 ],
  [ 1,3,6,12,24,48,94,184,362,709,1383,2666,5096 ],
  [ 1,3,6,12,24,48,94,184,362,709,1383,2673,5125 ],
  [ 1,3,6,12,24,48,94,184,362,709,1383,2677,5154 ],
  [ 1,3,6,12,24,48,94,184,362,709,1383,2684,5189 ],
  [ 1,3,6,12,24,48,94,184,362,709,1383,2695,5241 ],
  [ 1,3,6,12,24,48,94,184,362,709,1383,2696,5233 ],
  [ 1,3,6,12,24,48,94,184,362,709,1383,2696,5254 ],
  [ 1,3,6,12,24,48,94,184,362,709,1384,2704,5287 ],
  [ 1,3,6,12,24,48,94,184,362,709,1388,2664,5025 ],
  [ 1,3,6,12,24,48,94,184,362,709,1388,2686,5165 ],
  [ 1,3,6,12,24,48,94,184,362,709,1388,2697,5203 ],
  [ 1,3,6,12,24,48,94,184,362,709,1388,2708,5268 ],
  [ 1,3,6,12,24,48,94,184,362,709,1388,2719,5297 ],
  [ 1,3,6,12,24,48,94,184,362,709,1388,2719,5310 ],
  [ 1,3,6,12,24,48,94,184,362,709,1388,2719,5318 ],
  [ 1,3,6,12,24,48,94,184,362,712,1374,2654,5158 ],
  [ 1,3,6,12,24,48,94,184,362,712,1374,2654,5158,10003,19377 ],
  [ 1,3,6,12,24,48,94,184,362,712,1380,2660,5119 ],
  [ 1,3,6,12,24,48,94,184,362,712,1385,2688,5209 ],
  [ 1,3,6,12,24,48,94,184,362,712,1390,2709,5284 ],
  [ 1,3,6,12,24,48,94,184,362,712,1390,2712,5282 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2690,5149 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2702,5197 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2703,5198 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2713,5259 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2716,5267 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2716,5269 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2716,5275 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2716,5296 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2716,5297 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2717,5285 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2717,5291 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2718,5263 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2721,5237 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2721,5263 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2728,5321 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2728,5338 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2728,5339 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2729,5319 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2729,5338 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2729,5340 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2729,5341 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2729,5343 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2729,5344 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2729,5345 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2729,5346 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2732,5307 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2732,5339 ],
  [ 1,3,6,12,24,48,94,184,362,712,1395,2732,5355 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2717,5185 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2726,5309 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2728,5256 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2730,5289 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2730,5289,10101 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2730,5295 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2732,5333 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5331 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5332 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5333 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5334 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5338 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5340 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5345 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5346 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5347 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5359 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5360 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2739,5361 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2741,5348 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2741,5362 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2741,5366 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5359 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5376 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5381 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5382 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5383 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5385 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5393 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5394 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5395 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5396 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5397 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5400 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5401 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5403 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5404 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5405 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5406 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5407 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5408 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5409 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5410 ],
  [ 1,3,6,12,24,48,94,184,362,712,1400,2752,5410,10636 ],
  [ 1,3,6,12,24,48,95,177,330,614,1137,2098,3846 ],
  [ 1,3,6,12,24,48,95,177,330,614,1142,2118,3914 ],
  [ 1,3,6,12,24,48,95,177,332,619,1152,2141,3960 ],
  [ 1,3,6,12,24,48,95,177,332,619,1152,2141,3970 ],
  [ 1,3,6,12,24,48,95,177,332,622,1164,2155,3947 ],
  [ 1,3,6,12,24,48,95,177,332,622,1164,2174,4033 ],
  [ 1,3,6,12,24,48,95,177,332,622,1164,2174,4044 ],
  [ 1,3,6,12,24,48,95,177,332,622,1164,2174,4054 ],
  [ 1,3,6,12,24,48,95,177,332,622,1164,2174,4055 ],
  [ 1,3,6,12,24,48,95,177,332,622,1164,2174,4056 ],
  [ 1,3,6,12,24,48,95,181,343,653,1237,2335,4379 ],
  [ 1,3,6,12,24,48,95,181,345,643,1189,2166,3856 ],
  [ 1,3,6,12,24,48,95,181,345,649,1224,2304,4310 ],
  [ 1,3,6,12,24,48,95,181,345,652,1202,2099,3491 ],
  [ 1,3,6,12,24,48,95,181,345,652,1227,2311,4308 ],
  [ 1,3,6,12,24,48,95,181,345,652,1232,2329,4367 ],
  [ 1,3,6,12,24,48,95,181,345,655,1234,2322,4338 ],
  [ 1,3,6,12,24,48,95,181,345,661,1259,2395,4532 ],
  [ 1,3,6,12,24,48,95,181,345,661,1268,2390,4398 ],
  [ 1,3,6,12,24,48,95,181,345,661,1268,2428,4608 ],
  [ 1,3,6,12,24,48,95,188,365,684,1258,2320,4280 ],
  [ 1,3,6,12,24,48,95,188,365,698,1336,2563,4863 ],
  [ 1,3,6,12,24,48,95,188,365,699,1336,2534,4790 ],
  [ 1,3,6,12,24,48,95,188,365,699,1336,2545,4813 ],
  [ 1,3,6,12,24,48,95,188,365,702,1352,2603,4990 ],
  [ 1,3,6,12,24,48,95,188,365,704,1364,2620,4984 ],
  [ 1,3,6,12,24,48,95,188,365,705,1354,2573,4795 ],
  [ 1,3,6,12,24,48,95,188,365,705,1354,2573,4795,8862,16344 ],
  [ 1,3,6,12,24,48,95,188,365,708,1369,2627,5047 ],
  [ 1,3,6,12,24,48,95,188,365,708,1375,2656,5134 ],
  [ 1,3,6,12,24,48,95,188,365,708,1380,2682,5194 ],
  [ 1,3,6,12,24,48,95,188,367,703,1350,2580,4906 ],
  [ 1,3,6,12,24,48,95,188,367,704,1347,2557,4746 ],
  [ 1,3,6,12,24,48,95,188,367,704,1347,2576,4897 ],
  [ 1,3,6,12,24,48,95,188,367,704,1357,2622,5030 ],
  [ 1,3,6,12,24,48,95,188,367,712,1386,2701,5262 ],
  [ 1,3,6,12,24,48,95,188,367,713,1384,2670,5160 ],
  [ 1,3,6,12,24,48,95,188,367,716,1402,2717,5265 ],
  [ 1,3,6,12,24,48,95,188,367,716,1402,2739,5334 ],
  [ 1,3,6,12,24,48,95,188,367,716,1402,2739,5355 ],
  [ 1,3,6,12,24,48,95,188,367,716,1402,2744,5342 ],
  [ 1,3,6,12,24,48,95,188,369,690,1295,2432,4405 ],
  [ 1,3,6,12,24,48,95,188,369,699,1294,2334,4167 ],
  [ 1,3,6,12,24,48,95,188,369,699,1322,2474,4553 ],
  [ 1,3,6,12,24,48,95,188,369,711,1352,2541,4730 ],
  [ 1,3,6,12,24,48,95,188,369,711,1355,2574,4888 ],
  [ 1,3,6,12,24,48,95,188,369,711,1367,2622,5008 ],
  [ 1,3,6,12,24,48,95,188,369,711,1372,2654,5111 ],
  [ 1,3,6,12,24,48,95,188,369,715,1388,2678,5127 ],
  [ 1,3,6,12,24,48,95,188,369,720,1398,2703,5200 ],
  [ 1,3,6,12,24,48,95,188,369,720,1403,2706,5222 ],
  [ 1,3,6,12,24,48,95,188,369,720,1403,2706,5222,10110,19536 ],
  [ 1,3,6,12,24,48,95,188,369,720,1403,2722,5247 ],
  [ 1,3,6,12,24,48,95,188,369,720,1403,2739,5343 ],
  [ 1,3,6,12,24,48,95,188,369,720,1408,2732,5299 ],
  [ 1,3,6,12,24,48,95,188,369,720,1408,2748,5340 ],
  [ 1,3,6,12,24,48,95,188,369,720,1408,2748,5358 ],
  [ 1,3,6,12,24,48,95,188,369,720,1408,2759,5399 ],
  [ 1,3,6,12,24,48,95,188,369,720,1408,2759,5402 ],
  [ 1,3,6,12,24,48,95,188,369,720,1408,2759,5405 ],
  [ 1,3,6,12,24,48,95,188,369,724,1419,2739,5230 ],
  [ 1,3,6,12,24,48,95,188,369,724,1424,2787,5439 ],
  [ 1,3,6,12,24,48,95,188,369,724,1424,2796,5478 ],
  [ 1,3,6,12,24,48,95,188,369,724,1424,2798,5484 ],
  [ 1,3,6,12,24,48,95,188,371,720,1396,2711,5258 ],
  [ 1,3,6,12,24,48,95,188,371,720,1396,2711,5260 ],
  [ 1,3,6,12,24,48,95,188,371,720,1401,2704,5130 ],
  [ 1,3,6,12,24,48,95,188,371,720,1401,2713,5175 ],
  [ 1,3,6,12,24,48,95,188,371,720,1401,2737,5338 ],
  [ 1,3,6,12,24,48,95,188,371,720,1401,2737,5344 ],
  [ 1,3,6,12,24,48,95,188,371,720,1401,2739,5326 ],
  [ 1,3,6,12,24,48,95,188,371,723,1388,2623,4856 ],
  [ 1,3,6,12,24,48,95,188,371,723,1388,2623,4857 ],
  [ 1,3,6,12,24,48,95,188,371,723,1410,2744,5320 ],
  [ 1,3,6,12,24,48,95,188,371,732,1441,2828,5548 ],
  [ 1,3,6,12,24,48,95,188,371,732,1441,2836,5551 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2843,5590 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2843,5591 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5622 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5624 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5625 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5626 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5627 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5628 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5629 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5631 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5632 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5633 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2854,5634 ],
  [ 1,3,6,12,24,48,95,188,371,732,1446,2856,5640 ],
  [ 1,3,6,12,24,48,95,188,373,707,1296,2346,4209 ],
  [ 1,3,6,12,24,48,95,188,373,716,1310,2367,4204 ],
  [ 1,3,6,12,24,48,95,188,373,716,1315,2194,3190 ],
  [ 1,3,6,12,24,48,95,188,373,718,1382,2681,5145 ],
  [ 1,3,6,12,24,48,95,188,373,719,1387,2690,5208 ],
  [ 1,3,6,12,24,48,95,188,373,722,1396,2695,5187 ],
  [ 1,3,6,12,24,48,95,188,373,728,1405,2693,5092 ],
  [ 1,3,6,12,24,48,95,188,373,728,1411,2718,5209 ],
  [ 1,3,6,12,24,48,95,188,373,728,1418,2758,5299 ],
  [ 1,3,6,12,24,48,95,188,373,728,1418,2758,5331 ],
  [ 1,3,6,12,24,48,95,188,373,728,1422,2778,5391 ],
  [ 1,3,6,12,24,48,95,188,373,728,1422,2791,5460 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2769,5321 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2782,5402 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2782,5402,10473,20301 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2782,5415 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2782,5416 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2782,5417 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2784,5434 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2784,5439 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2784,5440 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5456 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5463 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5464 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5473 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5478 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5483 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5484 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5485 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5486 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5487 ],
  [ 1,3,6,12,24,48,95,188,373,728,1423,2795,5488 ],
  [ 1,3,6,12,24,48,95,188,373,731,1420,2768,5381 ],
  [ 1,3,6,12,24,48,95,188,373,731,1420,2768,5382 ],
  [ 1,3,6,12,24,48,95,188,373,731,1427,2793,5458 ],
  [ 1,3,6,12,24,48,95,188,373,731,1427,2793,5462 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2794,5429 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2796,5442 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2801,5462 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2801,5463 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2801,5464 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2807,5494 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2811,5492 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2811,5511 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2811,5519 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2813,5522 ],
  [ 1,3,6,12,24,48,95,188,373,731,1432,2813,5523 ],
  [ 1,3,6,12,24,48,95,188,373,737,1451,2848,5575 ],
  [ 1,3,6,12,24,48,95,188,373,737,1451,2855,5572 ],
  [ 1,3,6,12,24,48,95,188,373,737,1451,2855,5606 ],
  [ 1,3,6,12,24,48,95,188,373,737,1451,2855,5609 ],
  [ 1,3,6,12,24,48,95,188,373,737,1452,2840,5509 ],
  [ 1,3,6,12,24,48,95,188,373,737,1452,2840,5521 ],
  [ 1,3,6,12,24,48,95,188,373,737,1452,2840,5521,10729 ],
  [ 1,3,6,12,24,48,95,188,373,737,1452,2840,5523 ],
  [ 1,3,6,12,24,48,95,188,373,737,1452,2864,5651 ],
  [ 1,3,6,12,24,48,95,188,373,737,1455,2875,5671 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2833,5422 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2855,5558 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2866,5614 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2866,5624 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2866,5626 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2866,5633 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2866,5639 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5661 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5664 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5683 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5684 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5688 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5689 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5690 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5691 ],
  [ 1,3,6,12,24,48,95,188,373,737,1456,2879,5692 ],
  [ 1,3,6,12,24,48,95,188,373,740,1453,2848,5560 ],
  [ 1,3,6,12,24,48,95,188,373,740,1458,2857,5534 ],
  [ 1,3,6,12,24,48,95,188,373,740,1458,2861,5618 ],
  [ 1,3,6,12,24,48,95,188,373,740,1458,2872,5601 ],
  [ 1,3,6,12,24,48,95,188,373,740,1458,2872,5625 ],
  [ 1,3,6,12,24,48,95,188,373,740,1458,2872,5650 ],
  [ 1,3,6,12,24,48,95,188,373,740,1462,2884,5665 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2871,5632 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2879,5666 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2881,5636 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2881,5670 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2888,5695 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2888,5699 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2888,5700 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2888,5702 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2892,5692 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2892,5697 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2892,5700 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2892,5714 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2892,5715 ],
  [ 1,3,6,12,24,48,95,188,373,740,1463,2892,5717 ],
  [ 1,3,6,12,24,48,95,188,373,740,1467,2882,5647 ],
  [ 1,3,6,12,24,48,95,188,373,740,1467,2882,5667 ],
  [ 1,3,6,12,24,48,95,188,373,740,1467,2895,5706 ],
  [ 1,3,6,12,24,48,95,188,373,740,1467,2908,5760 ],
  [ 1,3,6,12,24,48,95,188,373,740,1467,2908,5763 ],
  [ 1,3,6,12,24,48,95,188,373,740,1467,2908,5764 ],
  [ 1,3,6,12,24,48,95,188,373,740,1467,2908,5765 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2870,5582 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2875,5621 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2879,5627 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2879,5641 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2886,5652 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2886,5657 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2886,5658 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2886,5672 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2886,5676 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2886,5677 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2886,5678 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2888,5648 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2888,5673 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2890,5648 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2890,5668 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2890,5685 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2891,5687 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5663 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5698 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5699 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5709 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5710 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5711 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5712 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5716 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5720 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5723 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5724 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5725 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5726 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5727 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5727,11316,22356 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2899,5727,11329 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5699 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5709 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5712 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5714 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5722 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5724 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5726 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5728 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5730 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5731 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2901,5732 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5747 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5748 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5749 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5750 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5755 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5756 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5758 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5759 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5763 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5764 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5765 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5766 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5767 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5768 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5769 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5770 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5770,11433 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5771 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5772 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5773 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5773,11445 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5774 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5774,11435 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5775 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5775,11453 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5776 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5776,11444 ],
  [ 1,3,6,12,24,48,95,188,373,740,1468,2912,5776,11457 ],
  [ 1,3,6,12,24,48,96,192,376,724,1392,2668,5096 ],
  [ 1,3,6,12,24,48,96,192,376,730,1420,2764,5379 ],
  [ 1,3,6,12,24,48,96,192,378,744,1459,2848,5555 ],
  [ 1,3,6,12,24,48,96,192,378,744,1465,2874,5631 ],
  [ 1,3,6,12,24,48,96,192,380,752,1487,2934,5784 ],
  [ 1,3,6,12,24,48,96,192,380,752,1487,2934,5784,11398,22437 ],
  [ 1,3,6,12,24,48,96,192,380,752,1487,2940,5806 ],
  [ 1,3,6,12,24,48,96,192,380,752,1492,2938,5778 ],
  [ 1,3,6,12,24,48,96,192,380,752,1492,2960,5858 ],
  [ 1,3,6,12,24,48,96,192,380,752,1492,2960,5867 ],
  [ 1,3,6,12,24,48,96,192,380,752,1492,2960,5870 ],
  [ 1,3,6,12,24,48,96,192,382,760,1499,2950,5799 ],
  [ 1,3,6,12,24,48,96,192,382,760,1504,2970,5854 ],
  [ 1,3,6,12,24,48,96,192,382,760,1504,2976,5887 ],
  [ 1,3,6,12,24,48,96,192,382,760,1509,2990,5916 ],
  [ 1,3,6,12,24,48,96,192,382,760,1509,2996,5936 ],
  [ 1,3,6,12,24,48,96,192,382,760,1509,2996,5943 ],
  [ 1,3,6,12,24,48,96,192,382,760,1509,2996,5948 ],
  [ 1,3,6,12,24,48,96,192,382,760,1509,2996,5949 ],
  [ 1,3,6,12,24,48,96,192,382,760,1513,3012,5984 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3005,5953 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,5992 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,5995 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,5998 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,6001 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,6002 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,6003 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,6004 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,6007 ],
  [ 1,3,6,12,24,48,96,192,382,760,1514,3016,6008 ],
  [ 1,3,6,12,24,48,96,192,384,759,1500,2950,5792 ],
  [ 1,3,6,12,24,48,96,192,384,759,1500,2961,5835 ],
  [ 1,3,6,12,24,48,96,192,384,759,1500,2961,5836 ],
  [ 1,3,6,12,24,48,96,192,384,759,1500,2967,5867 ],
  [ 1,3,6,12,24,48,96,192,384,762,1512,3006,5973 ],
  [ 1,3,6,12,24,48,96,192,384,765,1523,3035,6046 ],
  [ 1,3,6,12,24,48,96,192,384,765,1524,3039,6053 ],
  [ 1,3,6,12,24,48,96,192,384,765,1524,3039,6060 ],
  [ 1,3,6,12,24,48,96,192,384,768,1498,2872,5424 ],
  [ 1,3,6,12,24,48,96,192,384,768,1526,3010,5943 ],
  [ 1,3,6,12,24,48,96,192,384,768,1526,3032,6029 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3030,5987 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3030,5999 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3041,6037 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6077 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6079 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6081 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6082 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6082,12120,24138 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6083 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6085 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6085,12132 ],
  [ 1,3,6,12,24,48,96,192,384,768,1531,3052,6087 ],
  [ 1,3,6,12,24,48,96,192,384,768,1534,3053,6051 ],
  [ 1,3,6,12,24,48,96,192,384,768,1534,3064,6110 ],
  [ 1,3,6,12,24,48,96,192,384,768,1534,3064,6118 ],
  [ 1,3,6,12,24,48,96,192,384,768,1534,3064,6122 ],
  [ 1,3,6,12,24,48,96,192,384,768,1535,3068,6124 ],
  [ 1,3,6,12,24,48,96,192,384,768,1535,3068,6131 ],
  [ 1,3,6,12,24,48,96,192,384,768,1535,3068,6132 ],
  [ 1,3,6,12,24,48,96,192,384,768,1535,3068,6133 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3050,6042 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3050,6050 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3050,6056 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3061,6050 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3061,6082 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3061,6085 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3061,6087 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3061,6097 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3061,6098 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3061,6099 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3061,6100 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6115 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6127 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6128 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6131 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6132 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6134 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6135 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6136 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6137 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6138 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6139 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6140 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6140,12272 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6141 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6141,12263 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6142 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6142,12280 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6143 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6143,12284 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6144 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6144,12288 ],
  [ 1,3,6,12,24,48,96,192,384,768,1536,3072,6144,12288,24576 ] ];

growthpos :=
[ 341,362,52,864,920,1243,52,920,1282,864,1282,1243,872,872,
  908,872,908,799,872,908,799,891,6,811,811,50,798,798,407,
  1239,16,747,798,909,798,909,361,1239,1275,1238,50,747,407,16,
  1142,811,361,811,1068,1068,805,805,1275,1142,1238,1240,1228,
  1125,1240,1228,1228,1240,1125,1125,1228,1125,1240,362,52,864,
  920,1282,52,920,1243,864,1243,1282,872,872,908,872,908,799,
  872,908,799,891,50,16,747,50,747,16,1067,1067,811,798,798,
  805,811,361,909,407,1142,1275,6,811,1239,798,1238,798,805,
  811,1239,407,909,361,1238,1275,1142,1228,1125,1228,1125,1240,
  1125,1228,1240,1240,1240,1228,1125,117,1083,822,1907,117,822,
  1907,860,1907,1907,1192,1192,1055,1192,1055,1064,1192,1055,
  1064,1601,125,797,51,50,767,811,1735,555,797,767,50,394,767,
  1052,1052,1357,1631,1128,125,51,1357,811,1478,767,1204,747,
  555,1735,394,1204,1128,1631,1478,1645,1900,1900,1901,1645,1900,
  1645,1901,1901,1645,1900,1901,19,19,216,1,19,139,19,139,216,
  52,52,52,52,52,69,52,52,69,111,3,52,52,3,52,52,319,319,
  52,52,27,69,27,69,69,319,305,113,3,52,318,52,113,27,69,27,
  318,318,69,69,113,305,113,217,217,217,217,217,142,142,142,
  217,142,142,142,331,1273,19,331,1139,3,1272,1141,857,857,873,
  857,873,904,857,873,904,959,57,37,869,57,869,750,1280,1280,
  37,869,815,934,793,934,934,1280,1007,1277,57,869,1280,750,
  1277,793,934,795,1281,1280,934,934,1277,1007,1277,1125,1125,
  1228,1228,1228,1228,1228,1228,1125,1125,1125,1125,851,19,3,
  851,331,412,412,870,870,794,870,794,918,870,794,918,823,57,
  869,750,57,37,869,1216,1143,869,750,879,905,752,890,905,1216,
  911,911,57,37,1135,869,911,41,890,879,1269,1135,890,905,1087,
  1087,1087,418,418,1003,1003,1003,418,418,418,418,1003,1003,
  1003,139,412,668,1141,1594,14,1258,1280,1237,1282,1282,1280,
  1282,1282,1277,1473,113,1251,917,307,1127,1236,1999,1815,1008,
  911,1251,1237,903,1203,1276,1962,2001,2001,307,1086,1999,1008,
  2001,919,1280,1232,1901,1997,1257,1143,2001,2001,1981,2001,
  2001,2001,2001,2001,1992,1992,1992,2001,1730,1730,1732,19,216,
  19,216,139,52,52,52,52,52,69,52,52,69,111,3,52,52,3,52,
  52,318,318,52,52,27,69,27,69,69,318,306,113,3,52,319,52,
  113,27,69,27,319,319,69,69,113,306,113,142,142,142,142,142,
  217,217,217,142,217,217,217,412,331,851,851,870,870,794,870,
  794,918,870,794,918,823,57,869,37,57,750,869,1135,1269,869,
  37,879,890,41,905,890,1135,1087,1087,57,750,1216,869,1087,
  752,905,879,1143,1216,905,890,911,911,911,1003,1003,418,418,
  418,1003,1003,1003,1003,418,418,418,1272,14,1594,1282,1282,
  1282,1282,1280,1233,1258,1277,1282,1159,307,1008,911,307,1086,
  1008,1901,1997,1236,917,1232,1143,903,1280,1235,1999,2001,2001,
  113,1127,1815,1251,2001,919,1275,1251,1962,1999,1277,1280,1981,
  2001,2001,1992,1992,1730,1730,1732,2001,2001,2001,1992,2001,
  2001,2001,1141,1271,900,900,906,900,906,888,900,906,888,821,
  57,750,869,57,869,37,1277,1282,750,869,795,930,793,930,930,
  1277,1007,1277,57,869,1277,37,1277,793,930,815,1282,1277,930,
  930,1277,1007,1277,1228,1228,1125,1125,1125,1125,1125,1125,
  1228,1228,1228,1228,668,1282,1282,1282,1280,1282,1277,1258,
  1237,1280,1473,307,1008,1086,307,911,1008,1997,1901,1251,1127,
  1251,1257,919,1276,1203,1999,2001,2001,113,917,1962,1236,1981,
  903,1143,1232,1815,1999,1237,1280,2001,2001,2001,1730,1730,
  1992,1992,1992,2001,2001,2001,1732,2001,2001,2001,1258,1282,
  1277,1282,1280,1282,1282,1282,1233,1159,113,1236,1127,307,917,
  1251,1999,1962,1008,1086,1232,1277,919,1235,1280,1815,2001,
  1981,307,911,1999,1008,2001,903,1280,1251,1997,1901,1143,1275,
  2001,2001,2001,2001,2001,2001,2001,2001,1730,1732,1730,2001,
  1992,1992,1992,342,342,38,352,352,38,37,350,381,57,858,876,
  57,876,855,1280,1282,858,876,871,934,926,925,934,1282,1282,
  1259,57,876,1256,855,1282,926,934,865,1282,1282,929,931,1282,
  1280,1259,1242,1280,1280,1242,1282,1282,1280,1282,1282,1282,
  1282,1280,342,342,342,27,38,352,352,62,57,858,876,57,876,
  855,1282,1280,858,876,871,934,926,929,931,1237,1282,1282,57,
  876,1282,855,1282,926,925,865,1256,1237,931,929,1282,1282,
  1280,1280,1242,1242,1280,1280,1280,1242,1282,1280,1282,1280,
  1242,352,34,353,37,358,39,383,57,877,818,57,818,901,1277,
  1277,877,818,826,932,828,932,934,1277,1280,1237,57,818,1282,
  901,1282,828,934,796,1282,1280,930,930,1282,1282,1277,1204,
  1204,1204,1204,1280,1280,1204,833,1280,833,1280,1204,342,352,
  342,342,27,62,57,858,876,57,876,855,1237,1256,858,876,871,
  931,926,931,929,1282,1282,1282,57,876,1237,855,1280,926,929,
  865,1280,1282,934,925,1282,1282,1282,1282,1280,1280,1282,1242,
  1242,1280,1280,1242,1280,1242,1280,353,352,34,353,55,57,877,
  818,57,818,901,1277,1280,877,818,826,934,828,930,930,1280,
  1282,1280,57,818,1280,901,1282,828,932,796,1280,1277,934,932,
  1280,1283,1282,1280,1204,1204,1280,1204,1204,1204,1280,1204,
  1280,1204,1204,350,39,39,382,57,815,918,57,918,795,1282,1280,
  815,918,789,934,896,932,934,1282,1252,1282,57,918,1282,795,
  1237,896,931,789,1277,1282,934,932,1252,1237,1280,1282,1008,
  1008,1282,1282,1282,1008,1280,1282,1280,1282,1008,342,352,381,
  57,858,876,57,876,855,1282,1282,858,876,871,929,926,934,925,
  1256,1280,1282,57,876,1282,855,1259,926,931,865,1282,1280,934,
  934,1259,1282,1282,1282,1282,1282,1282,1280,1280,1282,1242,
  1280,1242,1280,1282,353,383,57,877,818,57,818,901,1280,1282,
  877,818,826,930,828,934,932,1282,1282,1282,57,818,1277,901,
  1277,828,930,796,1277,1277,932,934,1237,1280,1282,833,1280,
  1280,833,1204,1204,1280,1204,1204,1204,1204,1280,382,57,815,
  918,57,918,795,1282,1277,815,918,789,934,896,935,933,1282,
  1237,1253,57,918,1282,795,1280,896,932,789,1280,1282,934,931,
  1282,1252,1237,1280,1282,1282,1280,1008,1008,1282,1282,1008,
  1282,1008,1282,135,1136,980,135,980,1058,1907,1907,1136,980,
  1037,1206,960,1206,1206,1905,1804,1905,135,980,1905,1058,1907,
  960,1206,874,1907,1907,1206,1206,1905,1804,1907,1905,1907,1907,
  1905,1907,1907,1907,1905,1907,1905,1907,1907,20,20,3,20,20,
  138,216,6,6,20,57,20,57,57,216,136,214,3,6,138,6,137,20,
  57,20,14,14,19,19,137,137,214,217,141,142,217,142,142,217,
  142,142,142,142,217,333,20,333,3,411,411,34,337,337,37,34,
  825,755,1000,1142,1275,6,34,777,337,978,337,37,34,776,1000,
  755,825,978,1275,1142,1228,1125,1228,1125,981,1125,1228,981,
  981,981,1228,1125,20,3,333,1271,1139,34,337,34,814,337,48,
  354,404,849,849,6,34,94,337,759,34,814,337,776,1000,825,755,
  74,410,410,1018,1018,438,438,96,1018,1018,778,778,96,438,438,
  20,20,216,138,20,20,6,57,6,19,19,14,215,137,3,20,14,20,
  137,6,57,6,138,216,57,57,137,215,137,142,217,217,142,142,
  217,142,142,142,142,217,142,333,1139,1271,337,34,337,814,34,
  755,825,1000,410,410,6,337,776,34,74,337,814,34,94,404,354,
  48,759,849,849,438,438,1018,1018,778,438,438,96,96,778,1018,
  1018,849,849,337,34,34,750,337,354,48,404,1275,1142,6,337,
  94,34,978,34,750,337,94,404,48,354,978,1142,1275,1125,1228,
  1125,1228,981,1228,1125,981,981,981,1125,1228,668,1000,404,94,
  403,777,1002,405,1715,2001,1931,14,1000,299,404,1924,94,403,
  777,1715,1966,1111,1275,1721,2001,1932,1901,2001,2001,1935,
  1903,1938,1993,1949,1899,1812,1995,1937,777,95,404,403,1000,
  1275,1111,1436,1932,2001,14,777,1715,95,1721,404,403,1000,299,
  1715,431,1137,1924,1931,2001,2001,1935,1901,2001,1899,1937,
  1995,1812,1903,1949,1993,1938,333,337,755,337,755,825,777,
  1275,978,20,333,1000,3,1142,34,825,34,411,411,37,37,1275,
  1142,978,981,1228,1125,981,1228,1228,981,1125,1125,1228,1125,
  981,337,354,337,825,755,777,850,759,20,3,1001,333,850,34,48,
  34,1271,1139,814,814,411,411,74,778,1018,438,96,438,1018,778,
  1018,1018,438,438,96,354,333,750,750,849,978,1275,20,34,851,
  34,1142,333,48,3,404,95,354,48,1275,978,1142,1279,979,979,
  1206,1279,979,1279,1206,1206,1279,979,1206,755,931,878,1275,
  1275,1231,19,825,1002,48,1234,48,331,825,431,1111,48,878,
  1277,1142,1215,1249,1211,1123,1218,1282,1279,1163,1206,1280,
  1279,1206,1213,814,814,1271,760,850,20,34,1139,34,850,3,825,
  333,404,95,48,354,411,75,410,853,762,78,414,414,763,853,853,
  853,414,78,414,331,403,1277,1215,57,354,403,48,1142,814,878,
  37,1111,405,878,48,1275,1234,1231,1213,1279,1206,1163,1279,
  1282,1218,1123,1206,1211,1280,1249,403,1234,1275,57,48,403,
  354,1231,814,48,37,1275,1002,931,878,1215,1277,1142,1211,1280,
  1282,1123,1218,1206,1279,1163,1249,1213,1279,1206,1924,2001,
  138,95,668,95,1931,1139,1111,411,1715,299,1002,405,1932,1721,
  2001,2001,1899,1903,2001,1935,1949,1938,1993,1901,1937,1812,
  1995,666,138,411,1721,1142,666,75,1215,978,1931,2001,1142,
  1231,1594,14,1594,1730,2001,2001,1992,1992,2001,1730,1730,1730,
  1992,2001,1992,137,74,1932,978,666,410,1142,1142,1924,1721,
  1278,1234,1594,1594,14,2001,1732,1992,2001,1992,1732,2001,1732,
  1732,1992,1992,2001,20,216,20,214,20,19,20,216,138,57,57,
  214,138,137,142,142,142,142,217,142,142,217,217,217,142,142,
  404,333,411,337,755,337,1139,1271,814,814,850,850,759,96,438,
  1018,778,1018,438,96,438,438,1018,1018,778,404,2001,1271,405,
  411,1436,1715,1275,1111,2001,1924,1931,1937,1812,1949,1993,
  1938,1903,1935,2001,1995,2001,1899,1901,1275,337,354,337,851,
  850,750,750,1142,1275,978,981,1125,1228,981,1125,1125,981,
  1228,1228,1125,1228,981,411,1277,1275,2001,1932,1215,1275,14,
  1594,1594,1732,1732,1992,1992,2001,1732,1732,2001,2001,2001,
  1992,1992,354,333,1001,777,755,825,849,760,850,414,78,763,
  853,853,78,414,414,414,853,763,853,755,1137,1275,878,931,
  1234,1231,1275,1206,1213,1163,1279,1206,1218,1123,1282,1279,
  1280,1249,1211,1000,777,825,755,1142,978,1275,1206,979,979,
  1279,1206,979,1206,1279,1279,1206,979,1279,668,403,403,2001,
  1932,1721,1949,1993,1937,1812,1995,1901,1899,2001,1938,2001,
  1935,1903,403,403,1931,2001,1924,1812,1995,1938,1949,1993,2001,
  1903,1935,1937,1901,2001,1899,331,1231,1275,1234,1279,1206,
  1279,1206,1163,1123,1282,1218,1213,1249,1211,1280,1142,1215,
  1277,1280,1249,1218,1282,1123,1163,1206,1279,1211,1206,1213,
  1279,666,666,1992,1992,1732,1732,2001,1992,1992,2001,2001,2001,
  1732,1732,666,1992,2001,2001,1730,1730,2001,1992,1992,1992,
  1730,2001,1730,2001,1992,1732,2001,1732,1992,2001,1992,1992,
  1732,1732,2001,674,1599,9,1594,314,666,314,666,934,934,1599,
  9,1599,1599,666,314,314,674,934,1599,934,674,674,1599,934,
  934,1599,314,666,314,666,934,1599,934,1594,314,314,666,934,
  934,1599,9,666,314,314,674,674,314,1599,9,1599,666,314,1594,
  1599,9,666,9,1599,1594,1599,934,934,674,666,674,2,503,503,
  672,743,503,672,743,479,743,743,504,504,655,504,655,345,504,
  655,345,360,21,21,332,464,365,20,323,473,21,365,333,473,365,
  329,329,329,639,674,21,332,329,20,639,365,323,464,473,323,
  473,323,674,640,639,737,646,646,646,737,646,737,646,646,737,
  646,646,572,572,436,743,572,436,743,370,743,743,573,573,591,
  573,591,368,573,591,368,406,21,332,21,365,365,333,329,329,
  21,464,20,329,365,473,323,473,636,444,332,21,323,20,536,464,
  329,365,323,473,323,473,445,536,636,646,736,644,736,646,736,
  646,644,644,646,644,736,482,545,1884,114,557,1480,511,1645,
  1884,1391,1391,1573,1391,1573,1205,1391,1573,1205,1048,7,1304,
  1304,114,1035,1035,575,1784,17,749,880,1847,880,1767,574,1784,
  1867,1768,114,749,646,114,1520,955,621,955,1415,1415,1331,
  1331,1768,1598,1768,1829,1656,1432,1829,1656,1643,1645,1399,
  1432,1643,1399,1645,545,1884,482,545,1645,126,1868,1629,1391,
  1391,1573,1391,1573,1205,1391,1573,1205,1048,17,114,749,1304,
  1035,880,574,1767,7,1304,1035,1784,880,1784,575,1847,1768,
  1867,1304,1304,574,52,1598,1020,575,1020,1331,1331,1415,1415,
  1905,1520,1867,1643,1645,1432,1656,1829,1829,1656,1432,1399,
  1645,1399,1643,1212,557,291,1254,558,742,742,1642,1642,1270,
  1642,1270,1276,1642,1270,1276,927,146,1450,1075,1450,89,1171,
  690,1905,146,1075,1171,1995,779,1905,690,1995,1226,1226,846,
  160,612,115,774,160,612,846,1687,1571,1539,1840,1867,1505,
  1867,742,742,1433,1865,1865,742,742,565,565,1714,1445,1714,
  1629,742,743,1481,2001,1986,1907,1905,1999,1907,1999,1280,1907,
  1999,1282,1206,113,1680,1096,1680,1067,1277,742,1907,113,1096,
  1277,1997,910,1907,742,1997,2001,2001,1743,1487,742,48,1766,
  1105,742,1681,1523,1750,1747,1523,2001,1712,2001,2001,2001,
  1903,2001,2001,2001,2001,1903,1903,1907,1329,1907,545,1868,511,
  1868,1629,1391,1391,1573,1391,1573,1205,1391,1573,1205,1048,7,
  1304,1304,114,1035,1035,646,1675,17,749,880,1767,880,1847,621,
  1675,1867,1768,114,749,575,114,1520,955,574,955,1415,1415,
  1331,1331,1768,1598,1768,1645,1643,1399,1645,1643,1656,1829,
  1432,1399,1656,1432,1829,742,558,1220,1248,1642,1642,1270,1642,
  1270,1276,1642,1270,1276,927,146,846,160,846,758,1084,612,
  1995,146,160,1084,1905,66,1995,612,1905,1867,1867,1450,1075,
  690,115,1505,1589,690,1507,1539,1840,1840,1539,1226,774,1226,
  1714,1714,565,742,742,1865,1865,1433,1445,742,565,742,1907,
  2001,2001,1907,1907,1999,1907,1997,1282,1907,1999,1282,934,266,
  1711,1120,1356,1122,1011,646,1939,212,993,1015,1395,923,1946,
  734,1993,2001,2001,1760,1525,568,249,1907,1169,693,1682,1903,
  1905,1894,1905,1988,1727,2001,2001,2001,1534,1901,1903,2001,
  1995,1907,1907,1997,1897,2001,1645,1907,1637,1637,1903,1637,
  1903,1054,1637,1903,1054,898,114,1057,1383,1401,1025,56,489,
  1706,52,1401,756,1901,867,1901,489,1822,1907,1905,1401,1401,
  489,7,1526,1057,489,1383,1552,1552,1553,1553,1905,1530,1905,
  1907,1907,1412,1645,1645,1645,1645,1412,1576,1907,1576,1907,
  743,1907,1907,1999,1905,1999,1282,1907,1999,1280,1206,212,1760,
  1525,1704,913,1009,693,1395,266,1476,1014,1968,914,1999,568,
  1946,2001,1995,1711,1120,734,250,1727,993,646,1356,1544,1901,
  1903,1905,2001,1907,2001,1903,1901,1907,2001,1995,2001,1997,
  1897,1534,2001,1907,2001,1907,1907,1999,1907,1997,1282,1907,
  1999,1282,934,113,1743,1487,1743,802,786,742,1997,113,1487,
  786,1997,802,2001,742,1907,2001,2001,1680,1096,742,48,1712,
  1096,742,1680,1750,1523,1523,1750,2001,1766,2001,2001,2001,
  1903,2001,2001,1907,1907,1329,1903,2001,1903,2001,482,545,128,
  552,390,128,132,384,384,111,1403,1404,1403,1051,1063,644,1888,
  111,1404,1063,1907,1085,1880,646,1888,1907,1907,1403,1404,639,
  114,1599,1517,646,1385,1520,1520,1582,1599,1907,1598,1907,1768,
  1905,1598,1768,1907,1907,1905,1599,1599,1907,1599,1905,545,482,
  545,60,128,552,390,63,111,1403,1404,1403,1051,1063,575,1905,
  111,1404,1063,1907,1085,1905,575,1907,1907,1907,1403,1404,646,
  114,1599,1517,639,1385,1598,1599,1599,1582,1907,1599,1905,1905,
  1768,1520,1905,1905,1905,1768,1599,1598,1907,1598,1768,552,129,
  426,132,664,101,413,146,1600,1588,1600,995,1279,740,1999,146,
  1588,1279,1997,1017,1997,742,1999,1997,1999,1600,1588,742,122,
  1867,1733,742,1205,1905,1903,1905,1905,1999,1867,1999,1905,
  1905,1644,1905,1997,1997,1905,1205,1903,1280,1903,1905,545,390,
  482,545,60,63,111,1403,1404,1403,1051,1063,646,1880,111,1404,
  1063,1888,1085,1888,644,1907,1907,1907,1403,1404,646,114,1598,
  1517,644,1385,1582,1599,1599,1598,1907,1599,1907,1907,1905,
  1598,1907,1768,1768,1905,1598,1520,1905,1520,1905,426,552,129,
  426,29,146,1600,1588,1600,995,1279,742,1997,146,1588,1279,
  1999,1017,1999,740,1997,1999,1997,1600,1588,741,122,1867,1733,
  736,1205,1903,1905,1905,1903,1997,1867,1999,1997,1905,1644,
  1997,1905,1905,1905,1903,1644,1997,1644,1905,384,101,38,357,
  52,1065,1201,1065,906,794,374,1280,52,1201,794,1282,873,1280,
  374,1282,1282,1282,1065,1201,374,27,1117,1034,374,889,1161,
  1161,1160,1157,1282,1117,1280,1282,1277,1206,1282,1282,1282,
  1277,1205,1206,1280,1206,1277,545,390,384,111,1403,1404,1403,
  1051,1063,646,1907,111,1404,1063,1905,1085,1907,639,1880,1905,
  1907,1403,1404,575,114,1599,1517,575,1385,1599,1582,1520,1520,
  1907,1599,1907,1907,1907,1599,1907,1905,1905,1907,1520,1598,
  1768,1598,1907,426,413,146,1600,1588,1600,995,1279,741,1993,
  146,1588,1279,1999,1017,1999,736,1993,1999,1999,1600,1588,742,
  122,1867,1733,740,1205,1905,1905,1903,1905,1999,1862,1999,1280,
  1997,1903,1280,1905,1905,1997,1644,1644,1905,1644,1997,357,52,
  1065,1201,1065,906,794,375,1277,52,1201,794,1282,873,1282,372,
  1237,1282,1282,1065,1201,375,27,1098,1034,372,889,1157,1160,
  1161,1161,1282,1112,1282,1280,1282,1206,1280,1277,1277,1282,
  1206,1206,1282,1206,1282,69,1205,1205,1205,829,895,441,1282,
  69,1205,895,1282,819,1282,441,1280,1282,1280,1205,1205,439,57,
  1206,1045,441,897,1206,1206,1206,1206,1280,1206,1282,1280,1282,
  1206,1280,1282,1282,1282,1205,1206,1280,1206,1282,15,15,5,19,
  19,21,216,1,5,19,138,19,138,21,216,136,214,5,5,21,3,111,
  15,21,15,5,5,15,15,136,111,213,217,141,111,217,142,142,217,
  111,111,142,111,217,4,448,338,54,323,470,5,448,338,165,54,
  844,473,1349,1334,1685,33,33,334,22,1298,333,23,109,1298,
  1298,1292,1288,844,1362,1359,1849,1536,1364,1360,852,1536,1849,
  1375,1375,852,1364,1360,448,54,338,473,1349,5,448,54,844,338,
  165,323,470,984,1088,33,33,23,22,771,109,334,333,1298,1298,
  1288,1292,164,525,615,1532,1508,525,615,183,1508,1532,1379,
  1379,183,525,615,338,338,473,845,15,4,54,1349,54,470,323,
  165,1685,1334,109,333,23,22,1298,33,334,33,1288,1292,1298,
  1298,1359,1362,844,1536,1849,1364,852,1360,1849,1536,1375,1375,
  1360,1364,852,331,365,1271,19,54,331,1139,3,1271,365,1139,
  411,410,54,338,365,6,52,338,365,54,54,338,338,54,849,748,
  849,414,414,769,1018,1018,414,414,57,57,1018,769,1018,333,
  850,19,54,3,851,331,411,20,411,1271,1139,54,338,20,6,954,
  54,333,338,54,338,54,338,1139,954,1271,1204,1276,962,1279,
  1206,1276,1204,958,958,1206,962,1279,329,21,323,20,328,365,
  473,2,473,736,678,23,334,18,18,456,23,320,334,526,633,526,
  633,643,646,736,646,743,646,736,646,736,742,600,510,646,646,
  736,138,165,411,668,1139,1594,473,14,1985,2001,165,845,473,
  14,1430,470,329,1349,166,845,470,1349,1932,1652,2001,2001,
  1991,1524,2001,1907,1993,2001,1565,1528,1999,1801,1999,15,19,
  216,19,216,21,138,213,137,15,15,21,3,111,5,21,5,15,15,5,
  5,213,111,137,142,217,111,141,217,217,142,111,111,217,111,
  142,338,470,338,1349,473,845,1088,984,333,109,334,22,771,33,
  23,33,1292,1288,1298,1298,615,526,164,1508,1532,525,183,615,
  1532,1508,1379,1379,615,525,183,411,331,851,333,850,1139,1271,
  338,54,333,6,954,338,20,54,338,54,338,54,1271,954,1139,1276,
  1204,962,1206,1279,1204,1276,958,958,1279,962,1206,1271,14,
  473,1594,2001,1932,470,1349,473,14,1652,165,329,845,470,1349,
  165,845,2001,1430,1985,1999,1999,1528,1991,2001,2001,1907,1524,
  1801,2001,1565,1993,1139,365,1271,849,849,338,54,365,6,748,
  54,365,338,338,54,54,338,410,52,409,853,853,58,438,438,853,
  853,757,757,438,58,438,329,668,2001,1985,1349,470,329,14,
  1430,845,473,165,1349,470,845,165,2001,1652,1932,1993,2001,
  1524,1907,2001,2001,1991,1528,1565,1999,1801,1999,329,678,736,
  334,23,320,18,456,334,18,23,633,526,633,526,736,646,643,736,
  742,646,646,736,646,743,510,600,736,646,646,1932,2001,844,
  165,329,14,1652,1349,473,470,845,166,1349,470,1985,1430,2001,
  2001,1907,1528,2001,1991,1999,1999,1801,1524,1993,1565,2001,
  666,1359,617,643,164,632,164,736,844,1767,1868,1534,1699,1965,
  1685,1956,1732,2001,1907,1998,2001,2001,1732,1522,1522,2001,
  1907,1997,844,164,736,164,633,617,643,1359,1699,1534,1868,
  1767,1956,1685,1963,2001,1732,1907,2001,1998,1732,2001,1522,
  1522,1997,1907,2001,4,473,22,1362,448,323,448,1292,1288,1298,
  1298,1685,1298,1334,852,1360,1375,1536,1849,1360,852,1364,1364,
  1849,1375,1536,323,22,526,448,473,448,1288,1292,1298,1298,
  1088,771,984,183,615,1379,1508,1532,615,183,525,525,1532,1379,
  1508,18,646,473,2,323,633,526,633,526,736,456,678,736,646,
  600,742,736,646,736,646,646,743,510,646,164,22,18,22,52,52,
  52,52,164,164,164,169,169,169,169,169,169,169,169,169,169,
  169,169,526,646,1362,1577,1505,1505,1577,1685,1334,1685,1593,
  1593,1544,1868,1868,1593,1593,1643,1643,1868,1544,1868,323,4,
  1298,1298,1292,1288,984,771,1088,615,183,1028,1117,1154,183,
  615,525,525,1154,1028,1117,473,526,633,526,633,678,456,736,
  646,736,510,743,647,736,646,646,646,742,600,736,1298,1298,
  1288,1292,1334,1298,1685,1360,852,1377,1686,1471,852,1360,1364,
  1364,1471,1377,1686,4,448,448,1868,1505,1534,1841,1767,1580,
  1540,1868,1532,1634,1597,1581,1859,1582,1543,448,448,1767,1577,
  1699,1540,1868,1581,1841,1767,1859,1543,1582,1580,1532,1597,
  1634,4,1699,1577,1767,1868,1540,1597,1532,1634,1543,1859,1582,
  1580,1841,1581,1767,1534,1505,1868,1767,1853,1582,1859,1543,
  1634,1532,1597,1581,1540,1580,1868,632,666,1998,2001,1558,1732,
  2001,2001,1997,1907,1907,2001,1558,1732,632,1868,1868,1643,
  1593,1593,1868,1868,1544,1544,1593,1504,1593,2001,1997,1522,
  2001,1732,1997,2001,1907,1907,1732,1522,2001,666,1907,1645,
  1997,314,743,185,632,1997,1907,2001,1907,1997,1645,743,314,
  185,632,2001,1907,1997,632,632,1907,1907,1641,1641,185,483,
  185,674,1997,1645,1907,1907,314,185,743,1645,1997,1907,1907,
  743,185,314,666,632,185,1645,1907,1997,632,185,1997,1907,1645,
  483,1907,1641,1907,1907,1641,1907,632,674,632,572,572,436,743,
  572,436,743,370,743,743,573,573,591,573,591,368,573,591,368,
  406,332,21,21,365,464,20,473,323,332,365,20,323,464,323,473,
  323,535,445,21,21,473,333,637,365,473,365,329,329,329,329,
  445,637,535,646,644,736,644,646,644,646,736,736,646,736,644,
  482,545,1868,114,557,1629,511,1629,1868,1391,1391,1573,1391,
  1573,1205,1391,1573,1205,1048,114,17,749,114,749,114,1415,
  1415,1304,1035,880,1331,955,621,1847,575,1598,1768,7,1304,
  1675,1035,1768,880,1331,955,1675,646,1767,574,1768,1867,1520,
  1656,1432,1656,1432,1829,1399,1643,1645,1829,1645,1643,1399,
  545,1868,482,545,1629,126,1884,1645,1391,1391,1573,1391,1573,
  1205,1391,1573,1205,1048,1304,7,1304,1304,1304,52,1331,1331,
  114,1035,1035,1415,1020,575,1784,574,1520,1905,17,749,1847,
  880,1867,880,1415,1020,1767,574,1784,575,1867,1768,1598,1645,
  1399,1829,1432,1656,1432,1829,1656,1643,1643,1645,1399,1219,
  557,291,1248,558,742,742,1642,1642,1270,1642,1270,1276,1642,
  1270,1276,927,1450,146,1075,846,160,115,1840,1539,846,758,
  1084,1840,1589,612,1995,690,774,1226,146,160,1905,1084,1226,
  66,1539,1507,1995,612,1905,690,1867,1867,1505,742,565,1865,
  1433,1865,565,742,742,742,1714,1714,1445,1645,742,743,1645,
  2001,2001,1907,1905,1999,1907,1999,1280,1907,1999,1282,1206,
  1711,266,1120,1704,1476,249,1901,1544,1760,913,1014,1903,993,
  568,1999,734,1907,2001,212,1525,1946,1009,2001,914,1905,1356,
  1395,693,1968,646,1995,2001,1727,2001,1907,2001,1897,1997,1907,
  1995,2001,2001,1903,1901,1534,545,1884,511,1884,1480,1391,1391,
  1573,1391,1573,1205,1391,1573,1205,1048,114,17,749,114,749,
  114,1415,1415,1304,1035,880,1331,955,574,1767,646,1598,1768,7,
  1304,1784,1035,1768,880,1331,955,1784,575,1847,621,1768,1867,
  1520,1643,1399,1643,1399,1645,1432,1656,1829,1645,1829,1656,
  1432,742,558,1212,1254,1642,1642,1270,1642,1270,1276,1642,1270,
  1276,927,846,146,160,1450,1075,115,1571,1687,1450,89,1171,
  1539,160,690,1905,612,1505,1867,146,1075,1995,1171,1867,779,
  1840,846,1905,690,1995,612,1226,1226,774,1714,1445,742,565,
  742,1433,1865,1865,1714,742,742,565,1907,1986,2001,1907,1907,
  1999,1907,1997,1282,1907,1999,1282,934,1680,113,1096,1743,1487,
  48,1523,1751,1743,803,786,1523,1096,742,2001,742,1766,2001,
  113,1487,1907,786,2001,803,1750,1680,1997,742,1997,742,2001,
  2001,1712,2001,1903,1907,1329,1907,1903,2001,2001,2001,2001,
  2001,1903,1481,1907,1637,1637,1903,1637,1903,1054,1637,1903,
  1054,898,1401,52,1401,1401,1401,7,1552,1552,1057,1025,756,
  1553,1057,489,1901,489,1530,1905,114,1383,1822,56,1905,867,
  1553,1383,1706,489,1901,489,1905,1907,1526,1907,1576,1645,1412,
  1645,1412,1645,1645,1907,1907,1907,1576,743,1907,1907,1999,
  1905,1999,1282,1907,1999,1280,1206,1743,113,1487,1680,1096,48,
  1750,1523,1680,1067,1277,1747,1105,742,1907,742,1712,2001,113,
  1096,1997,1277,2001,910,1523,1681,1907,742,1997,742,2001,2001,
  1766,1907,1329,2001,1903,2001,1903,2001,2001,1907,2001,2001,
  1903,1907,1907,1999,1907,1997,1282,1907,1999,1282,934,1760,212,
  1525,1356,993,249,1905,1903,1711,1122,1015,1894,1169,734,1946,
  568,1727,1988,266,1120,1993,1011,2001,923,1905,1682,1939,646,
  1395,693,2001,2001,1907,1997,1897,2001,1907,1995,1534,1903,
  1901,2001,2001,2001,1907,482,545,128,552,390,128,132,384,384,
  1403,111,1404,1403,1404,114,1582,1599,1403,1051,1063,1520,1517,
  639,1907,575,1599,1907,111,1404,1880,1063,1907,1085,1520,1385,
  1907,646,1905,575,1907,1905,1599,1768,1598,1905,1520,1907,1599,
  1905,1907,1907,1907,1907,1598,545,482,545,60,128,552,390,63,
  1403,111,1404,1403,1404,114,1599,1582,1403,1051,1063,1599,1517,
  644,1888,646,1599,1907,111,1404,1907,1063,1907,1085,1598,1385,
  1880,646,1888,644,1907,1907,1598,1905,1520,1768,1598,1905,1598,
  1768,1907,1905,1907,1905,1520,552,129,426,132,664,101,413,
  1600,146,1588,1600,1588,122,1905,1905,1600,995,1279,1903,1733,
  736,1999,742,1862,1999,146,1588,1993,1279,1999,1017,1905,1205,
  1993,741,1999,740,1999,1999,1867,1905,1644,1905,1644,1997,1903,
  1905,1280,1997,1280,1997,1644,545,390,482,545,60,63,1403,111,
  1404,1403,1404,114,1599,1598,1403,1051,1063,1599,1517,575,1905,
  646,1599,1907,111,1404,1907,1063,1905,1085,1582,1385,1905,575,
  1907,639,1907,1907,1599,1907,1598,1905,1599,1768,1520,1905,
  1905,1768,1905,1768,1598,426,552,129,426,29,1600,146,1588,
  1600,1588,122,1905,1903,1600,995,1279,1905,1733,740,1999,741,
  1867,1997,146,1588,1997,1279,1999,1017,1903,1205,1997,742,1999,
  736,1997,1999,1867,1997,1644,1905,1903,1905,1644,1905,1997,
  1905,1997,1905,1644,384,101,38,357,1065,52,1201,1065,1201,27,
  1160,1157,1065,906,794,1161,1034,372,1282,375,1112,1282,52,
  1201,1237,794,1282,873,1161,889,1277,375,1282,372,1282,1282,
  1098,1282,1206,1277,1206,1282,1206,1277,1280,1282,1280,1282,
  1206,545,390,384,1403,111,1404,1403,1404,114,1520,1520,1403,
  1051,1063,1582,1517,646,1880,639,1598,1907,111,1404,1888,1063,
  1907,1085,1599,1385,1888,644,1907,646,1907,1907,1599,1907,1599,
  1907,1599,1905,1598,1907,1768,1905,1768,1905,1599,426,413,1600,
  146,1588,1600,1588,122,1903,1905,1600,995,1279,1905,1733,742,
  1997,742,1867,1999,146,1588,1999,1279,1999,1017,1905,1205,1999,
  740,1997,742,1999,1997,1867,1280,1903,1997,1205,1905,1644,1997,
  1905,1905,1905,1905,1903,357,1065,52,1201,1065,1201,27,1161,
  1161,1065,906,794,1160,1034,374,1280,374,1117,1282,52,1201,
  1282,794,1280,873,1157,889,1280,374,1282,374,1282,1282,1117,
  1280,1206,1282,1205,1277,1206,1282,1282,1277,1282,1277,1206,
  1205,69,1205,1205,1205,57,1206,1206,1205,829,895,1206,1045,
  441,1282,439,1206,1280,69,1205,1280,895,1282,819,1206,897,
  1282,441,1282,441,1280,1282,1206,1280,1206,1282,1205,1282,1206,
  1282,1280,1282,1280,1282,1206,15,4,109,333,22,1288,1292,33,
  54,338,1298,448,334,1349,473,1298,1685,5,33,845,54,1334,338,
  1298,448,165,23,470,323,844,1359,1362,1849,1375,1360,1364,852,
  1375,1849,1536,1536,852,1360,1364,15,15,15,3,15,15,5,19,19,
  5,5,21,216,21,111,214,1,5,138,19,137,19,5,5,138,21,216,
  21,136,214,111,217,111,217,111,142,111,217,142,142,142,217,
  111,333,109,22,1292,1288,33,338,54,1298,448,23,470,323,771,
  1088,5,33,165,338,984,54,1298,448,845,334,1349,473,164,615,
  526,1532,1379,615,525,183,1379,1532,1508,1508,183,615,525,4,
  22,1291,1288,448,338,54,1298,33,323,470,23,1362,1359,5,448,
  165,338,844,54,1298,33,845,473,1349,334,1334,1685,1298,1360,
  1364,1849,1375,1536,1364,1360,852,852,1536,1849,1375,22,1288,
  1292,448,54,338,1298,33,473,1349,334,526,617,5,448,845,54,
  164,338,1298,33,165,323,470,23,984,1088,771,615,525,1532,
  1379,1508,525,615,183,182,1508,1532,1379,52,52,22,6,6,52,22,
  18,14,18,164,163,3,22,14,6,164,6,52,22,14,18,14,18,164,
  164,164,169,169,169,169,169,169,169,169,169,169,169,169,4,
  1298,338,54,448,1298,526,470,526,1577,1767,5,1298,165,338,
  1699,54,448,1298,845,633,1349,633,1534,1868,1505,1532,1597,
  1859,1582,1543,1581,1767,1841,1634,1540,1868,1580,1298,54,338,
  448,1298,633,1349,633,1505,1868,5,1298,845,54,1534,338,448,
  1298,165,526,470,526,1699,1767,1577,1859,1582,1532,1597,1634,
  1580,1868,1540,1543,1841,1767,1581,338,338,1291,333,473,845,
  334,1362,844,15,4,1349,54,1359,54,1288,109,470,323,165,23,
  1685,1334,1298,852,1364,1536,1375,1849,1364,852,1360,1360,1849,
  1536,1375,331,338,338,365,1271,365,748,850,19,54,1139,331,
  849,3,54,54,1271,365,1139,365,411,410,52,1018,769,414,57,
  414,769,1018,1018,1018,414,414,57,338,338,333,851,333,954,
  1271,19,54,851,3,1139,331,54,54,412,20,411,20,1271,1139,954,
  1279,962,1204,958,1276,962,1279,1206,1206,1276,1204,958,1292,
  633,845,633,1577,1699,15,1288,1349,54,1767,54,4,1288,470,526,
  166,526,1868,1534,1505,1841,1581,1543,1582,1859,1597,1634,1532,
  1767,1868,1540,1580,334,845,473,771,984,15,109,1349,54,1088,
  54,1288,4,470,23,165,323,617,164,526,1154,1028,183,525,615,
  1028,1154,1117,1117,615,183,525,329,320,646,736,21,323,329,
  20,643,365,526,23,473,2,473,18,736,678,456,736,646,646,510,
  743,646,736,646,646,736,742,600,329,1652,2001,138,165,668,
  411,1932,1139,166,165,1594,473,14,473,1985,2001,1430,1999,
  1801,2001,1528,1991,1524,2001,1907,1999,1993,2001,1565,456,736,
  21,23,329,20,678,365,526,323,473,18,473,2,736,643,646,743,
  510,646,646,736,600,736,742,646,736,646,646,632,111,525,1430,
  954,632,52,1505,1298,1652,646,1430,456,1685,1685,1334,1593,
  1504,1868,1544,1868,1643,1593,1593,1593,1868,1868,1544,137,165,
  1985,1139,667,411,1534,1334,1932,643,2001,678,1956,1965,1685,
  2001,1558,2001,1907,1997,1558,2001,1732,1732,1997,2001,1907,15,
  216,19,214,19,15,15,216,21,138,21,213,137,111,142,111,142,
  111,217,111,142,217,217,217,142,111,470,338,615,338,1292,333,
  1349,473,845,334,1088,984,771,183,525,1508,1379,1532,525,183,
  615,616,1532,1508,1379,412,2001,1271,470,470,14,473,1594,473,
  2001,1932,1652,1993,1565,1999,1801,1999,1528,1991,2001,2001,
  2001,1907,1524,1271,331,338,338,851,333,851,333,1139,1271,954,
  1206,962,1276,958,1204,962,1206,1279,1279,1204,1276,958,411,
  1868,1685,2001,736,1985,736,1963,1956,1685,1732,1522,1998,1907,
  2001,1522,1732,2001,2001,2001,1997,1907,338,338,1139,365,1271,
  365,850,850,748,438,58,853,757,853,58,438,438,438,853,853,
  757,1292,1349,633,845,633,1767,1699,1577,1540,1580,1634,1597,
  1532,1582,1543,1859,1868,1767,1853,1581,1349,334,845,473,1359,
  844,1362,1471,1377,852,1364,1360,1377,1471,1686,1686,1360,852,
  1364,329,668,329,2001,1985,1430,1999,1801,1993,1565,2001,1524,
  1907,2001,1999,2001,1991,1528,329,320,678,736,456,646,646,736,
  600,742,646,646,736,736,646,743,510,329,1932,2001,1652,2001,
  1565,2001,1524,1907,1528,2001,1991,1993,1999,1999,1801,643,736,
  646,742,600,736,646,646,510,646,743,736,646,736,646,667,633,
  1997,1907,1732,1522,2001,1907,1997,2001,2001,2001,1732,1522,
  632,2001,1907,2001,1522,1732,1907,2001,1998,1997,1732,2001,
  1522,1868,1544,1593,1643,1593,1544,1868,1868,1868,1593,1593,
  1643,632,1645,1907,1997,185,743,314,674,1997,2001,1907,1907,
  1641,1907,483,185,185,632,1907,1907,1641,632,666,1907,1645,
  1997,1997,314,743,185,632,1641,1907,1907,1907,185,185,483,
  1907,1997,1645,1645,743,314,185,632,632,185,1907,1907,1641,
  674,314,1997,1645,1907,743,1645,1997,1907,2001,1997,1907,666,
  632,632,665,435,1999,192,399,1905,401,1905,1999,1879,1879,
  1644,1879,1644,1903,1879,1644,1903,1897,154,843,146,66,1474,
  1084,1999,742,843,1474,53,714,1118,1903,1903,1905,1903,1277,
  154,146,1905,1084,1905,1118,1997,758,735,1999,741,1997,1277,
  1903,1905,1901,1997,1997,1997,1901,1903,1644,1879,1997,1644,
  1903,1879,435,1999,665,435,1905,89,1999,1905,1879,1879,1644,
  1879,1644,1903,1879,1644,1903,1897,843,154,146,966,1452,912,
  1997,741,154,1452,115,742,1156,1905,1905,1903,1905,1276,843,
  146,1903,912,1903,1156,1999,831,741,1997,742,1999,1276,1905,
  1903,1644,1879,1997,1997,1901,1997,1901,1997,1903,1644,1879,
  1903,839,399,27,839,355,369,369,1181,1181,872,1181,872,1205,
  1181,872,1205,916,1023,1023,16,886,28,886,1246,386,941,804,
  52,434,939,956,1072,1072,806,750,941,6,956,886,806,28,1196,
  886,433,1196,386,1246,854,1050,1050,389,435,1151,1151,1024,
  435,389,435,435,1024,1151,1151,1905,369,467,1206,2001,2001,
  1999,1997,1907,1999,1907,1905,1999,1907,1907,1905,1756,1850,82,
  1251,842,1015,1944,542,1755,948,234,698,972,1535,1893,1899,
  1907,1279,1839,121,1703,1011,1900,965,1946,1244,601,1639,459,
  1393,1225,1901,1891,1908,1999,1944,1938,1802,1999,1907,1999,
  1999,1569,1893,1705,435,1999,401,1999,1905,1879,1879,1644,1879,
  1644,1903,1879,1644,1903,1897,154,843,146,66,1474,1084,1999,
  735,843,1474,53,741,1118,1903,1903,1905,1903,1277,154,146,
  1905,1084,1905,1118,1997,758,742,1999,714,1997,1277,1903,1905,
  1644,1903,1903,1879,1644,1997,1901,1997,1879,1901,1997,1997,
  369,355,839,839,1181,1181,872,1181,872,1205,1181,872,1205,916,
  941,941,6,886,804,886,1196,432,1023,28,52,386,28,1072,956,
  956,1050,854,1023,16,1072,886,1050,939,1246,886,386,1246,434,
  1196,750,806,806,1024,1151,435,435,389,1151,1024,1151,1151,
  389,435,435,1279,2001,2001,1999,1999,1907,1999,1905,1907,1999,
  1907,1907,1277,1850,1756,82,1244,1470,1011,1393,705,1839,972,
  234,601,948,1703,1899,1893,1900,1279,1755,121,1535,1015,1907,
  1176,1639,1251,698,1946,723,1944,1225,1891,1901,1907,1999,1705,
  1893,1569,1999,1907,1999,1999,1802,1938,1944,1206,1279,1276,
  1276,1205,1276,1205,1038,1276,1205,1038,929,1033,885,49,746,
  1033,16,1282,373,885,1033,27,373,885,1145,1145,1145,1203,899,
  1033,49,1145,16,1205,885,1282,746,373,1282,373,1282,899,1203,
  1205,1146,1280,1205,1205,1047,1205,1047,1205,1280,1146,1280,
  1280,467,1999,1999,1907,1997,1907,1907,1999,1907,1905,1905,
  1839,1755,121,1251,948,1011,1639,601,1850,842,234,459,965,
  1893,1535,1703,1901,1225,1756,82,1899,1015,1891,972,1393,1244,
  542,1944,698,1946,1279,1907,1900,1570,1893,1999,1999,1907,1944,
  1802,1938,1705,1907,1999,1999,1999,1999,1907,1999,1905,1907,
  1999,1907,1907,1277,1755,1839,121,1244,972,1015,1946,698,1756,
  1470,234,723,1176,1899,1703,1535,1891,1225,1850,82,1893,1011,
  1901,948,1944,1251,705,1393,601,1639,1279,1900,1907,1802,1938,
  1999,1999,1907,1705,1569,1893,1944,1907,1999,1999,359,458,295,
  557,558,295,115,604,682,1562,1562,146,991,1644,1201,1997,742,
  1562,1644,115,742,1900,1903,1905,1905,1905,1280,1562,146,1903,
  1201,1905,1900,1999,992,742,1999,741,1999,1280,1903,1905,1905,
  1995,1995,1997,1905,1997,1903,1997,1997,1905,1997,1995,458,359,
  458,149,295,557,558,295,1562,1562,146,991,1644,1201,2000,741,
  1562,1644,115,742,1900,1903,1905,1905,1905,1280,1562,146,1905,
  1201,1905,1900,1997,992,736,1999,742,1997,1280,1905,1903,1903,
  1997,1997,1995,1903,1995,1905,1997,1995,1905,1995,1997,557,128,
  511,115,482,129,545,1396,1396,111,1036,1388,1174,1888,575,
  1396,1388,117,644,1492,1598,1520,1520,1644,1115,1396,111,1599,
  1174,1645,1492,1907,881,646,1905,575,1888,1115,1645,1645,1400,
  1644,1644,1644,1598,1903,1400,1116,1903,1039,1903,1644,458,558,
  359,458,149,295,1562,1562,146,991,1644,1201,1999,736,1562,
  1644,115,742,1900,1905,1903,1905,1905,1280,1562,146,1905,1201,
  1903,1900,1997,992,741,1999,742,1997,1280,1905,1905,1905,1995,
  1995,1997,1905,1997,1903,1995,1997,1903,1997,1995,511,557,128,
  511,132,1396,1396,111,1036,1388,1174,1907,639,1396,1388,117,
  646,1492,1599,1599,1582,1645,1114,1396,111,1582,1174,1645,1492,
  1880,881,639,1907,646,1880,1114,1645,1645,1598,1644,1644,1903,
  1400,1644,1400,1903,1644,1598,1644,1644,604,129,129,604,1407,
  1407,117,1030,1595,820,1907,488,1407,1595,28,489,1408,1559,
  1550,1550,1645,1206,1407,117,1560,820,1645,1408,1907,868,489,
  1907,489,1892,1206,1645,1644,1645,1905,1905,1905,1645,1905,
  1624,1903,1905,1644,1905,1905,458,558,682,1562,1562,146,991,
  1644,1201,1999,742,1562,1644,115,741,1900,1905,1903,1903,1903,
  1280,1562,146,1905,1201,1905,1900,1999,992,742,1997,742,1999,
  1280,1905,1905,1905,1997,1997,1997,1903,1995,1905,1997,1995,
  1905,1995,1997,511,545,1396,1396,111,1036,1388,1174,1905,646,
  1396,1388,117,575,1492,1520,1598,1599,1645,1115,1396,111,1520,
  1174,1645,1492,1888,881,575,1888,644,1907,1115,1644,1645,1039,
  1903,1903,1116,1400,1644,1598,1644,1644,1400,1644,1903,604,
  1407,1407,117,1030,1595,820,1907,489,1407,1595,28,489,1408,
  1550,1559,1560,1645,1206,1407,117,1550,820,1644,1408,1892,868,
  488,1907,489,1907,1206,1645,1645,1644,1905,1905,1903,1624,1905,
  1645,1905,1905,1645,1905,1905,1893,1893,112,1222,1713,1203,
  1999,742,1893,1713,115,740,1521,1900,1900,1892,1905,1268,1893,
  112,1892,1203,1905,1521,1999,924,742,1999,740,1999,1268,1905,
  1905,1903,1997,1997,1995,1905,1997,1905,1995,1997,1903,1997,
  1997,4,15,54,448,338,1349,473,33,109,22,334,333,1298,1288,
  1292,1320,1067,33,5,1298,54,1320,448,845,338,23,165,323,470,
  936,1386,1547,1432,1434,1498,1789,1286,1434,1432,1434,1434,
  1286,1498,1789,15,338,448,54,470,323,33,333,22,23,109,1298,
  1292,1288,1320,1067,33,5,1298,338,1320,448,165,54,334,845,
  473,1349,936,1547,1386,1432,1434,1789,1498,1286,1434,1432,1434,
  1434,1286,1789,1498,19,5,19,216,21,5,15,3,21,15,5,15,15,
  50,16,5,1,5,19,50,5,138,19,21,138,21,216,6,22,22,17,110,
  24,24,7,110,17,110,110,7,24,24,338,331,1271,365,338,338,6,
  365,54,338,338,54,1158,810,54,19,54,331,1053,54,1140,3,365,
  1271,365,1139,810,1158,1053,962,1277,1277,1205,962,1277,962,
  1205,1205,962,1277,1205,338,845,473,333,33,22,334,33,1292,
  1298,1298,343,363,109,15,1288,54,118,4,1349,54,23,470,323,
  165,751,942,942,451,346,1466,1466,1370,346,451,123,123,1370,
  1466,1466,851,333,338,54,6,333,338,338,54,338,1158,810,54,
  19,54,3,1053,54,851,331,20,412,20,411,810,1053,1158,962,
  1277,1205,1277,962,1277,962,1205,1205,962,1205,1277,329,845,
  470,14,329,1349,845,470,1349,1907,1019,165,138,166,411,1900,
  165,668,1139,473,1594,473,14,1188,1907,1905,1575,1999,1999,
  1997,1554,1990,1761,1979,1896,1554,1999,1997,334,23,18,320,
  334,633,526,633,556,441,23,21,526,20,523,323,329,365,18,473,
  2,473,364,644,646,646,675,644,736,465,675,646,546,546,597,
  741,741,448,22,473,448,1292,1298,1298,1547,936,4,15,1288,54,
  1386,109,1349,54,323,470,23,165,1067,1320,1320,1286,1789,1434,
  1434,1432,1789,1286,1498,1498,1432,1434,1434,22,323,4,1298,
  1292,1287,942,751,448,5,1298,338,942,33,165,54,473,844,334,
  1349,363,343,118,1370,1466,346,123,451,1466,1370,1466,1466,
  451,346,123,18,22,52,52,52,116,74,22,3,52,6,116,22,14,6,
  18,14,18,14,74,116,116,169,115,115,115,169,115,169,115,115,
  169,115,115,473,633,526,633,646,364,323,21,526,20,644,23,
  329,365,2,473,18,473,441,523,556,597,741,546,675,646,736,
  465,644,741,646,546,675,1298,1288,1292,942,751,448,5,1298,54,
  942,33,845,338,323,165,23,470,363,118,343,1026,1155,123,346,
  451,1155,1026,1155,1155,451,123,346,448,448,1549,964,1288,15,
  4,54,1387,1288,1349,54,526,470,526,166,1067,1327,1327,1309,
  1789,1609,1609,1432,1789,1309,1498,1498,1431,1838,1838,4,1327,
  1067,1298,5,448,338,1327,1298,165,54,633,845,633,1349,964,
  1549,1387,1431,1838,1789,1498,1309,1609,1432,1609,1838,1309,
  1789,1498,1327,1067,1298,5,448,54,1327,1298,845,338,526,165,
  526,470,964,1387,1549,1432,1609,1498,1789,1309,1838,1431,1838,
  1609,1309,1498,1789,363,1386,22,1387,1053,333,118,1905,1053,
  644,1907,523,1900,1087,1594,1594,1321,1792,1896,1896,1599,1792,
  1321,1561,1561,1599,1896,1896,936,6,964,810,363,363,1188,810,
  364,1188,441,1019,832,1087,1087,1127,997,1277,1277,1073,997,
  1086,997,997,1073,1277,1277,15,1292,338,1547,333,470,338,473,
  1349,334,845,1067,1320,1320,1286,1498,1434,1434,1432,1498,1286,
  1789,1789,1432,1434,1434,15,19,22,15,216,19,21,216,21,138,
  16,50,50,7,24,110,110,17,24,7,24,24,17,110,110,338,1549,
  1292,470,338,633,1349,633,845,1067,1327,1327,1309,1498,1838,
  1838,1431,1498,1309,1789,1789,1432,1609,1609,1158,338,412,331,
  333,851,333,851,810,1158,1053,962,1205,1277,1205,962,1205,962,
  1277,1277,962,1277,1205,343,1907,1158,646,1905,556,1907,1087,
  1594,1594,1321,1561,1896,1896,1599,1561,1321,1792,1792,1599,
  1896,1896,470,338,334,1349,473,845,751,942,942,451,123,1155,
  1155,1026,123,451,346,346,1026,1155,1155,1271,473,14,473,1594,
  1019,1900,1907,1554,1997,1896,1999,1575,1997,1554,1999,1999,
  1761,1979,1990,365,1140,365,1271,810,1053,1158,962,1205,1205,
  1277,962,1205,962,1277,1277,962,1205,1277,329,320,329,441,556,
  523,597,741,675,546,646,644,465,736,741,646,675,546,329,668,
  1019,1907,1900,1554,1999,1990,1979,1761,1999,1554,1997,1997,
  1575,1999,1896,329,364,646,644,646,546,736,644,465,546,646,
  675,675,597,741,741,1188,1905,1907,1761,1979,1997,1999,1554,
  1896,1575,1999,1990,1554,1997,1999,363,363,1073,1277,997,997,
  1086,1277,1073,1277,1277,1127,997,997,333,1599,1896,1792,1561,
  1321,1896,1599,1896,1896,1321,1792,1561,1599,1896,1561,1792,
  1321,1896,1599,1896,1896,1321,1561,1792,457,1905,1905,1438,134,
  496,134,457,1438,1905,1905,1997,1997,1905,665,134,254,334,
  1905,1997,1997,334,457,1997,1905,1997,1997,134,665,254,457,
  1997,1905,1997,1997,134,254,665,1905,1438,1905,1905,496,134,
  134,457,334,254,1905,1997,1997,457,134,1438,1905,1905,665,
  1905,1997,1997,1905,1997,1997,457,457,334,2,668,18,320,448,
  18,470,470,476,476,499,476,499,741,476,499,741,479,23,23,
  496,23,334,391,742,736,23,496,391,742,344,736,742,742,662,
  662,23,334,707,391,662,333,736,348,742,707,736,742,734,734,
  734,474,475,737,737,737,474,474,474,474,476,476,476,411,18,
  18,338,320,323,329,493,493,391,493,391,739,493,391,739,370,
  23,334,389,23,23,499,741,594,334,389,391,742,367,592,742,
  741,420,423,23,23,606,499,423,20,592,380,743,606,592,742,
  646,621,646,327,327,646,646,646,325,325,325,327,493,493,493,
  166,329,473,468,1685,1334,1876,1905,1907,1907,1768,1997,1907,
  1752,1999,1567,253,1905,1127,309,1641,1905,1999,1826,1754,1086,
  1262,1999,919,1779,1997,2001,1995,1991,310,1486,1999,1754,2001,
  917,1993,1280,1907,2001,1969,1905,2001,1987,2001,2001,2001,
  2001,2001,2001,1907,1907,1907,2001,1557,1557,1504,18,165,18,
  165,166,114,114,114,114,114,124,114,114,124,34,3,114,114,3,
  114,114,319,319,114,114,27,124,27,124,124,319,298,48,3,114,
  319,114,48,27,124,27,319,319,124,124,48,298,48,169,169,169,
  169,169,169,167,169,169,169,169,169,323,2,338,411,519,519,
  385,519,385,724,519,385,724,368,23,499,23,23,389,334,646,
  743,499,23,380,595,20,737,595,646,621,646,23,389,743,334,
  646,367,737,391,606,743,737,595,423,420,423,646,646,327,327,
  327,493,493,493,646,325,325,325,470,1334,1685,1533,1643,1520,
  1645,1582,1901,1624,1520,1905,1032,147,1518,773,147,1384,1518,
  1617,1728,1346,773,976,1642,757,1710,1901,1860,1901,1764,144,
  1397,1586,1468,1716,863,1722,1089,1735,1901,1890,1720,1712,
  1725,1712,1859,1859,1363,1363,1363,1543,1543,1471,1686,1504,
  1555,1504,448,668,609,609,549,609,549,631,609,549,631,368,23,
  391,334,23,496,23,737,743,391,334,348,706,333,737,706,737,
  734,734,23,496,743,23,734,344,737,391,732,743,737,706,662,
  662,662,737,737,474,474,474,476,476,476,737,474,474,474,473,
  1643,1533,1520,1628,1520,1905,1624,1583,1895,1381,147,1518,
  1384,147,773,1518,1728,1617,1468,1397,1089,1836,863,1684,1579,
  1905,1725,1712,144,773,1735,1346,1712,757,1616,976,1586,1886,
  1860,1903,1716,1901,1764,1363,1363,1859,1859,1686,1555,1504,
  1504,1363,1471,1543,1543,1876,1907,1907,1907,1905,1999,1907,
  1752,1999,1204,253,1905,1641,309,1127,1905,1995,2001,1754,1486,
  1280,1995,917,1999,1997,1826,1987,2001,310,1086,1980,1754,2001,
  919,1997,1262,2001,1907,1905,1995,2001,1995,1991,2001,2001,
  2001,2001,2001,1557,1504,1557,2001,1907,1907,1907,455,463,128,
  507,599,128,116,559,512,116,1376,1405,116,1405,1396,1905,1907,
  1376,1405,1059,1905,1203,1852,1905,1907,1905,1907,116,1405,
  1905,1396,1907,1203,1905,1062,1907,1907,1903,1905,1907,1903,
  1907,1884,1905,1905,1884,1907,1645,1628,1645,1907,1645,1645,
  1644,463,455,463,115,128,507,599,129,116,1376,1405,116,1405,
  1396,1907,1905,1376,1405,1059,1905,1203,1903,1905,1907,1905,
  1907,116,1405,1907,1396,1907,1203,1852,1062,1905,1907,1905,
  1903,1907,1905,1905,1905,1884,1884,1905,1905,1628,1629,1645,
  1905,1645,1644,1629,507,128,576,116,524,173,515,116,1398,1409,
  116,1409,1516,1907,1907,1398,1409,1150,1903,1203,1903,1767,
  1907,1903,1903,116,1409,1768,1516,1754,1203,1905,862,1768,1905,
  1905,1905,1754,1753,1907,1645,1645,1645,1645,1905,1519,1389,
  1039,1905,1039,1582,1400,463,599,455,463,115,129,116,1376,
  1405,116,1405,1396,1907,1905,1376,1405,1059,1905,1203,1905,
  1903,1907,1905,1907,116,1405,1907,1396,1905,1203,1903,1062,
  1905,1907,1890,1879,1907,1905,1907,1907,1905,1905,1907,1884,
  1629,1644,1628,1884,1644,1629,1628,576,507,128,576,127,116,
  1398,1409,116,1409,1516,1907,1905,1398,1409,1150,1767,1203,
  1905,1905,1905,1753,1867,116,1409,1905,1516,1768,1203,1903,862,
  1901,1907,1753,1903,1867,1753,1768,1905,1645,1645,1905,1645,
  1389,1400,1519,1645,1582,1400,1389,559,173,295,558,174,1596,
  1900,174,1900,1081,1999,1997,1596,1900,921,1997,1205,1995,1997,
  1999,1997,1999,174,1900,1999,1081,1999,1205,1997,840,1999,1999,
  1997,1995,1999,1997,1997,1999,1999,1999,1999,1999,1905,1905,
  1903,1999,1903,1905,1905,463,599,512,116,1376,1405,116,1405,
  1396,1907,1907,1376,1405,1059,1903,1203,1890,1879,1905,1903,
  1907,116,1405,1907,1396,1907,1203,1905,1062,1907,1905,1905,
  1905,1907,1905,1907,1907,1907,1907,1907,1905,1644,1645,1629,
  1905,1629,1628,1645,576,515,116,1398,1409,116,1409,1516,1905,
  1754,1398,1409,1150,1905,1203,1753,1903,1754,1753,1754,116,
  1409,1907,1516,1907,1203,1905,862,1907,1907,1903,1905,1903,
  1903,1754,1105,1905,1905,1105,1645,1400,1582,1389,1645,1400,
  1389,1519,558,174,1596,1900,174,1900,1081,1999,1999,1596,1900,
  921,1997,1205,1997,1995,1999,1997,1999,174,1900,1999,1081,1997,
  1205,1995,840,1997,1999,1997,1997,1999,1997,1999,1997,1999,
  1999,1997,1999,1905,1905,1905,1999,1905,1905,1905,140,1578,
  1640,140,1640,1410,1907,1907,1578,1640,1043,1905,1044,1905,
  1905,1905,1905,1905,140,1640,1905,1410,1907,1044,1905,875,1907,
  1907,1905,1905,1905,1905,1907,1905,1907,1907,1905,1907,1643,
  1643,1642,1907,1642,1643,1643,22,22,3,22,22,131,317,7,7,20,
  173,20,130,130,317,156,252,3,7,190,7,143,20,173,20,10,10,
  25,25,143,156,252,314,180,180,314,180,128,180,128,180,128,
  128,180,333,22,333,109,540,540,128,495,387,160,61,1467,1865,
  1485,1469,1868,7,128,1499,495,1479,387,160,61,1499,1493,1861,
  1484,1479,1867,1531,1907,1531,1907,1531,1556,1372,1430,1322,
  1556,1322,1430,1372,22,109,333,1654,1427,128,495,61,1474,387,
  155,621,620,1095,1097,7,128,178,495,987,61,1474,387,1499,
  1493,1484,1861,164,621,622,1503,1503,646,646,169,1373,1373,
  1305,847,34,463,463,22,22,316,131,22,22,6,130,6,25,25,14,
  303,143,3,22,10,22,143,6,130,6,190,284,173,173,143,303,143,
  180,314,314,180,180,180,128,128,180,128,180,128,333,1427,
  1654,495,128,387,1465,61,1865,1467,1485,621,622,7,495,1499,
  128,164,387,1465,61,178,619,561,173,987,1095,1097,646,646,
  1503,1503,847,463,463,34,169,1305,1373,1373,1069,1069,495,128,
  61,967,387,621,155,620,1867,1531,7,495,178,128,1479,61,967,
  387,178,619,173,561,1479,1469,1868,1531,1907,1531,1907,1556,
  1430,1372,1322,1556,1322,1372,1430,700,1485,620,88,736,1074,
  1847,734,1745,1999,1999,14,1485,276,620,1999,88,736,1074,1766,
  1997,1749,1995,1907,1999,1995,1861,2001,2001,1995,1903,1905,
  1770,1691,1764,1606,1907,1778,1442,153,438,673,1102,1995,1824,
  1964,1993,2001,14,1442,1766,153,1907,438,673,1102,277,1746,
  742,1867,1999,1997,2001,2001,1995,1861,2001,1766,1778,1907,
  1606,1903,1691,1719,1905,333,387,1865,387,1861,1484,1442,1867,
  1479,22,333,1493,109,1531,61,1467,61,540,540,160,160,1868,
  1469,1479,1556,1907,1531,1556,1907,1430,1322,1372,1531,1430,
  1372,1322,387,621,387,1484,1861,1442,1095,987,22,109,1493,333,
  1097,61,155,61,1653,1420,1474,1474,622,621,164,847,1503,646,
  167,646,1373,1305,1373,1503,463,463,34,436,333,837,837,928,
  1119,1277,20,61,931,61,1143,333,105,16,429,90,430,79,1277,
  1119,1143,1282,989,989,1206,1282,937,1199,1061,1206,1199,937,
  1061,1229,1997,1866,1995,1997,1997,25,1467,1810,155,1997,105,
  335,1101,681,1824,295,1866,1999,1851,1997,1993,1993,1781,1997,
  1999,1780,1640,1644,1993,1899,1337,1874,1165,1165,1275,830,915,
  20,61,1179,61,915,16,1101,333,429,90,79,430,436,53,436,929,
  764,81,441,441,801,894,894,929,378,28,378,335,736,1997,1997,
  173,561,731,173,1896,1162,1821,79,1749,732,1821,295,1999,1991,
  1997,1997,1999,1901,1899,1995,1901,1742,1463,1880,1825,1878,
  1769,736,1995,1999,173,173,731,561,1997,1162,295,79,1999,1810,
  1997,1866,1997,1997,1905,1993,1993,1999,1781,1997,1644,1780,
  1627,1997,1874,1899,1337,1989,2001,131,153,669,153,1999,1187,
  1749,432,1746,277,1847,734,1995,1905,2001,2001,1764,1903,2001,
  1995,1691,1905,1719,1868,1778,1606,1907,736,156,621,1772,1469,
  736,53,1991,1119,1997,1999,1887,1995,1999,1993,1999,1789,1995,
  1999,1999,1999,1854,1457,1457,1789,1905,1905,1905,143,164,1999,
  1479,674,436,1896,1143,1985,1881,1999,1997,1976,1999,753,2001,
  1656,2001,2001,2001,1329,1903,1329,1656,1895,1895,1903,22,284,
  22,252,20,25,20,284,190,130,130,252,156,143,180,180,180,180,
  314,128,128,180,314,180,128,128,619,333,622,387,1865,387,
  1420,1653,1465,1465,1097,1095,987,169,646,1503,847,1503,463,
  34,463,646,1373,1373,1305,619,2001,1282,732,441,1990,1768,
  1999,1824,2001,1997,1999,1999,1907,1995,1995,1995,1297,1709,
  1899,2001,1907,1563,1641,1868,387,621,387,1071,1071,967,967,
  1531,1867,1479,1556,1531,1907,1556,1531,1372,1322,1430,1907,
  1372,1430,1322,436,1999,1277,2001,1999,1997,1999,753,1999,1976,
  1656,1656,2001,2001,2001,1329,1329,1903,2001,1731,1895,1895,
  436,333,1167,1092,1247,1166,915,830,915,441,81,764,929,929,
  28,378,378,441,894,801,894,1229,1901,1999,1821,1997,1993,1995,
  1999,1880,1997,1899,1995,1902,1742,1463,1901,1999,1878,1769,
  1819,1167,1092,1166,1247,1143,1119,1277,1206,989,989,1282,1206,
  937,1061,1199,1282,1061,937,1199,700,670,670,2001,1997,1881,
  1995,1995,1999,1907,2001,1641,1564,1907,1995,1899,1709,1296,
  731,731,1999,1999,1985,1907,2001,1995,1995,1999,1899,1294,1709,
  1999,1641,1907,1563,335,1997,1997,1993,1999,1880,1995,1901,
  1896,1463,1901,1742,1997,1718,1825,1878,1905,1995,1999,1993,
  1997,1997,1999,1781,1627,1644,1901,1993,1337,1874,1899,736,674,
  2001,2001,1656,1656,2001,1895,1895,1731,2001,1903,1329,1329,
  736,1999,1999,1995,1789,1789,1905,1905,1905,1999,1457,1854,
  1457,2001,2001,1656,2001,1656,1895,1903,1895,2001,1329,1329,
  1903,737,1645,1344,1599,169,474,169,674,1903,1903,1907,1344,
  1645,1645,474,167,169,737,1903,1907,1903,737,737,1907,1903,
  1903,1645,169,474,169,674,1903,1907,1903,1599,169,169,474,
  1903,1903,1907,1344,474,169,169,455,455,169,1438,1344,1438,
  478,169,1438,1438,1344,474,1344,1438,1438,1907,1903,1903,455,
  478,455,411,320,18,338,18,329,323,493,493,391,493,391,739,
  493,391,739,370,334,23,389,334,23,391,742,593,23,389,499,
  741,367,594,741,742,423,420,334,23,596,391,420,20,594,380,
  742,596,594,741,621,646,621,325,325,646,646,646,327,327,327,
  325,493,493,493,470,329,473,165,1965,1685,1907,1905,1768,1876,
  1907,1997,1907,1907,1999,1645,1754,310,1086,1905,1641,1262,
  1997,1779,252,1127,1905,2001,919,1826,1999,1999,1991,1995,1905,
  1641,1997,1277,1995,911,1995,1280,1905,1995,1970,1907,1993,
  2001,1987,1907,1907,2001,2001,2001,2001,2001,2001,1907,1504,
  1557,1557,2,470,18,668,448,476,476,499,476,499,741,476,499,
  741,479,23,23,334,23,496,391,707,742,23,334,391,736,333,742,
  736,707,734,734,23,496,742,391,734,344,742,348,736,742,742,
  736,662,662,662,476,476,474,474,474,737,737,737,476,474,474,
  474,323,18,411,338,493,493,391,493,391,739,493,391,739,370,
  334,23,23,334,389,391,596,742,23,23,499,594,20,741,594,596,
  646,621,334,389,742,391,621,367,741,380,592,742,741,594,420,
  423,420,493,493,327,327,327,646,646,646,493,325,325,325,166,
  1685,1334,1624,1645,1520,1643,1582,1905,1533,1520,1901,1032,
  1468,144,773,1346,1397,1107,1642,1722,147,773,1468,1617,757,
  1905,1686,1720,1764,1734,1518,1384,1579,976,1901,863,1728,1191,
  1860,1903,1907,1860,1725,1712,1725,1471,1543,1363,1363,1363,
  1859,1686,1859,1543,1504,1555,1504,166,165,115,115,117,115,
  117,115,115,117,115,28,114,6,114,114,114,6,238,238,6,114,
  52,300,27,300,300,238,48,298,114,114,238,6,298,27,300,52,
  238,238,300,300,298,48,298,169,169,169,169,169,167,169,169,
  169,169,169,169,473,1907,1876,1907,1905,1907,1999,1907,1768,
  1997,1645,1905,253,1641,1905,1127,1277,1995,1905,310,1641,1905,
  1970,911,1999,1826,1997,2001,1993,1754,1086,1999,1262,1987,919,
  1907,1280,1779,1997,2001,1995,1995,1991,1995,1504,1557,2001,
  2001,2001,2001,2001,2001,1557,1907,1907,1907,1533,1643,1520,
  1645,1582,1901,1624,1520,1905,1032,1518,147,1384,1346,773,976,
  1903,1860,144,1397,1468,1907,863,1686,1905,1579,1712,1725,1468,
  773,1720,1107,1725,757,1860,1191,1722,1642,1617,1728,1734,1764,
  1901,1504,1555,1859,1859,1686,1363,1363,1363,1504,1471,1543,
  1543,455,463,128,507,599,128,116,559,512,1376,116,1405,1376,
  1405,1059,1903,1905,116,1405,1396,1907,1203,1905,1907,1905,
  1907,1905,1376,1405,1879,1059,1905,1203,1907,1060,1905,1905,
  1905,1907,1905,1905,1905,1629,1644,1905,1884,1907,1907,1905,
  1907,1645,1645,1645,1628,463,455,463,115,128,507,599,129,1376,
  116,1405,1376,1405,1059,1905,1903,116,1405,1396,1907,1203,1905,
  1907,1905,1907,1905,1376,1405,1905,1059,1905,1203,1905,1060,
  1852,1905,1907,1905,1905,1907,1903,1628,1629,1884,1905,1905,
  1905,1884,1907,1644,1645,1628,1629,507,128,576,116,524,173,
  515,1398,116,1409,1398,1409,1150,1905,1905,116,1409,1516,1905,
  1203,1905,1907,1767,1867,1753,1398,1409,1905,1150,1905,1203,
  1754,866,1905,1903,1907,1907,1905,1907,1753,1389,1400,1645,
  1645,1905,1905,1645,1105,1582,1039,1519,1389,463,599,455,463,
  115,129,1376,116,1405,1376,1405,1059,1905,1852,116,1405,1396,
  1907,1203,1907,1905,1905,1907,1905,1376,1405,1905,1059,1903,
  1203,1905,1060,1903,1905,1907,1905,1905,1907,1905,1645,1628,
  1905,1907,1884,1884,1905,1905,1629,1628,1629,1644,576,507,128,
  576,127,1398,116,1409,1398,1409,1150,1767,1903,116,1409,1516,
  1907,1203,1907,1907,1903,1903,1903,1398,1409,1903,1150,1905,
  1203,1905,866,1903,1767,1907,1905,1903,1903,1905,1519,1389,
  1645,1905,1645,1645,1645,1905,1400,1519,1389,1400,559,173,295,
  558,1596,174,1900,1596,1900,921,1997,1995,174,1900,1081,1999,
  1205,1997,1999,1997,1999,1997,1596,1900,1997,921,1997,1205,
  1999,922,1997,1997,1999,1997,1997,1999,1995,1905,1905,1999,
  1999,1999,1999,1999,1997,1905,1903,1905,1905,463,599,512,1376,
  116,1405,1376,1405,1059,1905,1905,116,1405,1396,1905,1203,1907,
  1905,1879,1905,1905,1376,1405,1905,1059,1905,1203,1907,1060,
  1905,1903,1907,1907,1905,1907,1905,1645,1645,1907,1907,1905,
  1905,1907,1884,1628,1629,1644,1645,576,515,1398,116,1409,1398,
  1409,1150,1903,1905,116,1409,1516,1907,1203,1907,1905,1905,
  1907,1905,1398,1409,1767,1150,1753,1203,1907,866,1905,1905,
  1905,1754,1753,1867,1905,1039,1519,1905,1105,1645,1645,1905,
  1645,1389,1389,1400,1582,558,1596,174,1900,1596,1900,921,1997,
  1997,174,1900,1081,1999,1205,1999,1997,1997,1999,1997,1596,
  1900,1997,921,1995,1205,1997,922,1995,1997,1999,1999,1997,1999,
  1997,1903,1905,1999,1997,1999,1999,1999,1999,1905,1905,1905,
  1905,1578,140,1640,1578,1640,1043,1905,1905,140,1640,1410,1907,
  1044,1907,1907,1903,1907,1903,1578,1640,1903,1043,1905,1044,
  1907,892,1905,1905,1907,1907,1903,1907,1905,1642,1643,1907,
  1905,1907,1907,1907,1905,1643,1642,1643,1643,22,333,128,495,
  387,1484,1861,7,128,495,1442,387,1442,1485,1865,1479,1867,128,
  128,1484,52,1469,376,1485,376,160,160,540,540,1453,1531,1867,
  1430,1322,1531,1907,1556,1556,1907,1531,1372,1322,1372,1430,22,
  22,22,6,25,25,3,22,22,14,6,131,317,130,143,303,7,7,173,
  20,156,20,14,6,130,130,317,131,156,252,156,180,128,314,180,
  180,180,314,180,128,128,180,128,495,128,387,1861,1484,7,495,
  128,1442,387,153,620,621,987,1095,128,128,173,376,1095,52,
  1485,376,1465,1465,1427,1654,115,622,621,1373,1305,646,646,
  169,847,1503,1503,1373,34,463,463,333,387,1865,1467,22,333,
  109,1485,61,540,540,160,1868,1469,128,495,160,387,1453,61,
  1442,28,1467,1865,1485,1442,1469,1868,1453,1372,1430,1907,1556,
  1531,1907,1531,1556,1322,1372,1430,1322,387,1467,1865,22,109,
  333,1485,61,1654,1427,1465,622,621,128,495,1474,61,115,387,
  1442,28,155,621,620,153,1095,1097,985,463,463,1503,847,1503,
  646,646,169,34,1373,1373,1305,837,837,20,61,61,928,333,438,
  88,436,1277,1119,52,376,79,38,1190,38,928,349,105,436,88,
  438,1190,1131,1280,937,1199,989,1282,1206,1282,989,1206,1061,
  1061,937,1199,335,130,621,155,736,1165,1824,734,1866,1999,
  1995,160,1465,300,436,1995,104,673,1080,1821,1997,1867,1995,
  1851,1999,1995,1644,1780,1999,1997,1781,1993,1993,1993,1640,
  1337,1899,1874,130,155,621,736,1165,1995,1847,1997,1997,1997,
  160,1465,1846,104,1887,436,673,1080,291,1821,742,1749,1995,
  1993,1997,1901,1742,1901,1995,1899,1997,1999,1880,1463,1718,
  1895,1819,22,22,317,20,317,131,173,251,156,22,22,130,6,156,
  6,131,6,25,25,14,14,303,143,156,128,180,180,180,314,314,
  180,180,128,180,128,128,333,620,387,1427,1654,1474,1097,1095,
  495,128,1465,387,985,61,153,28,1865,1467,1485,1442,621,622,
  115,1373,1373,646,169,646,1503,1503,847,1305,463,463,34,620,
  387,1070,1069,967,1531,1867,495,128,967,61,1453,387,153,28,
  621,155,620,153,1867,1531,1453,1430,1372,1531,1556,1907,1531,
  1907,1556,1322,1430,1372,1322,1275,1964,1745,1995,2001,1989,
  540,1427,1824,88,1997,88,700,1077,742,1867,230,1745,1999,1907,
  1993,1691,1905,1903,1995,2001,2001,1764,1861,1770,1907,1607,
  1778,1102,1074,1229,915,830,376,52,1166,38,907,38,1187,349,
  436,105,88,438,436,74,436,801,894,81,441,441,929,764,929,
  894,378,28,378,700,673,2001,1994,1485,620,736,88,1905,1074,
  1745,32,1847,734,1745,230,1999,1999,1989,1778,1907,1861,1766,
  2001,2001,1995,1903,1606,1905,1770,1660,736,1999,1999,1442,153,
  673,438,1989,1102,230,32,1995,1824,1964,1745,1993,2001,1905,
  1905,1770,2001,1903,1995,1861,2001,1766,1660,1778,1907,1606,
  1997,1997,1484,173,652,79,1995,1166,1723,396,1846,300,1824,
  734,1995,1905,1997,1780,1640,1781,1999,1997,1993,1993,1997,
  1644,1874,1337,1899,736,1531,622,1905,1131,736,73,1995,1079,
  1993,1999,1907,1999,1999,1976,1999,1329,1903,2001,2001,2001,
  2001,1656,1656,1329,1903,1895,1895,1453,115,1995,1190,672,436,
  1905,1078,1995,1851,1999,1997,1997,1999,1997,1854,1457,1999,
  1999,1999,1789,1995,1789,1457,1905,1905,1905,333,1865,387,1867,
  387,540,376,1861,1484,1442,1485,1867,1479,1469,1322,1372,1556,
  1531,1907,1531,1556,1907,1430,1430,1322,1372,621,387,621,387,
  1654,376,1484,1861,1442,1485,1095,987,1095,34,463,847,1503,
  1503,646,169,646,463,1373,1305,1373,436,1997,1229,734,396,
  1997,1866,1995,1723,1997,1997,1995,1874,1337,1993,1997,1993,
  1781,1997,1999,1899,1780,1640,1644,1280,333,438,349,837,837,
  928,928,1119,1277,1190,1061,937,1282,1206,989,989,1206,1282,
  1199,937,1199,1061,436,1999,1280,1997,1995,1993,1999,1997,1999,
  1997,1457,1457,1999,1999,1999,1789,1789,1995,1854,1905,1905,
  1905,438,349,1165,1165,1275,1187,830,915,907,378,28,929,929,
  764,81,441,441,378,801,894,894,1282,1749,1995,1745,2001,1997,
  1999,1999,1606,1778,1766,2001,1861,1995,1903,2001,1907,1770,
  1660,1905,1080,1080,1077,1282,1078,1079,1280,1047,1047,1146,
  1282,1146,1146,1146,1282,1206,1047,1047,1206,335,736,673,1997,
  1997,1887,1718,1895,1997,1880,1999,1901,1899,1995,1819,1901,
  1742,1463,736,673,1995,1999,1995,1337,1899,1993,1993,1993,1999,
  1781,1997,1874,1644,1780,1640,700,1989,2001,1997,1907,1606,
  2001,1861,1764,1903,2001,1995,1778,1691,1905,1770,1905,1995,
  1999,1770,1660,1995,2001,1903,1766,1861,2001,1905,1606,1778,
  1907,736,672,1905,1905,1789,1789,1995,1999,1999,1999,1905,1854,
  1457,1457,736,1903,1895,2001,1656,1656,2001,2001,2001,1895,
  1329,1903,1329,1905,1905,1789,1995,1789,1999,1999,1999,1905,
  1457,1457,1854,455,1907,1903,1903,167,474,169,478,1438,1345,
  1438,1903,1903,1907,474,169,169,455,1345,1438,1438,737,737,
  1645,1344,1599,1903,169,474,169,674,1599,1645,1966,1907,169,
  169,474,1344,1645,1645,1903,474,169,169,737,737,169,1907,1903,
  1903,674,169,1903,1907,1903,474,1903,1903,1907,1438,1438,1345,
  455,478,455,338,20,333,338,410,410,1113,1099,838,1113,838,
  1245,1091,838,1250,820,1090,1094,750,1094,65,1094,1217,1031,
  1090,750,1094,1216,752,1031,1217,1216,929,929,1109,65,995,
  1090,929,37,1172,1094,1198,996,1175,1100,1087,1087,1087,438,
  438,1087,1087,1087,438,438,438,438,772,772,772,18,412,2,329,
  323,519,519,385,519,385,724,519,385,724,368,23,499,389,23,
  23,334,743,606,499,389,380,737,367,595,737,743,420,423,23,
  23,646,334,423,20,595,391,743,646,595,737,646,621,646,325,
  325,493,493,493,327,327,327,325,646,646,646,20,18,20,20,114,
  114,27,114,27,291,114,27,291,27,114,114,6,114,6,114,120,
  151,114,6,114,120,7,120,120,120,52,52,114,6,120,114,52,7,
  120,114,151,120,120,120,52,52,52,22,22,22,22,22,22,22,22,
  22,22,22,22,411,411,411,1115,1091,838,1091,834,1214,1115,838,
  1214,792,1109,1090,750,1094,65,1090,1100,996,1094,750,1094,
  1100,752,995,1216,1217,929,929,1090,65,1031,1094,929,37,996,
  1094,1269,1172,996,1217,1087,1087,1087,438,438,772,772,772,
  438,438,438,438,1087,1087,1087,323,329,611,611,419,611,419,
  624,611,419,624,345,334,391,389,334,23,23,743,606,391,389,
  380,741,367,590,741,743,423,420,334,23,646,23,420,20,590,
  499,743,646,590,741,621,646,621,327,327,493,493,493,325,325,
  325,327,646,646,646,2,575,575,417,644,427,742,575,428,741,
  368,574,575,389,477,20,575,741,535,574,389,477,711,367,644,
  638,725,409,408,575,20,646,574,408,20,523,477,544,629,639,
  737,646,646,646,322,322,646,646,646,328,328,328,322,646,646,
  646,575,575,417,646,439,742,575,428,742,345,575,574,389,477,
  20,574,737,639,575,389,477,743,367,646,725,638,408,408,574,
  20,644,575,409,20,629,477,649,523,535,741,646,646,646,328,
  328,646,646,646,322,321,322,328,646,646,646,495,387,128,377,
  537,128,52,553,392,1405,1405,1056,1405,116,1409,1905,1599,
  1405,1056,1409,1907,1644,1598,1907,1907,1115,1091,1405,116,
  1598,1409,1115,117,1520,1390,1907,1520,1598,1907,1599,1582,
  1599,575,644,1598,1520,1599,646,574,575,575,1599,1599,1598,
  387,495,387,145,128,377,537,65,1405,1405,1056,1405,116,1409,
  1907,1598,1405,1056,1409,1907,1644,1598,1907,1907,1115,1115,
  1405,116,1520,1409,1091,117,1598,1390,1905,1520,1599,1905,1520,
  1599,1582,574,575,1520,1598,1598,574,575,646,644,1599,1598,
  1520,377,38,416,52,342,87,342,1049,1049,872,1049,28,1151,
  1282,1204,1049,872,1151,1280,1192,1203,1282,1282,834,838,1049,
  28,1204,1151,838,29,1204,887,1282,1201,1204,1282,1152,1152,
  1152,391,385,1049,1049,1151,419,391,356,400,887,1151,1049,387,
  537,495,387,145,65,1405,1405,1056,1405,116,1409,1907,1598,
  1405,1056,1409,1907,1644,1599,1905,1907,1091,1115,1405,116,
  1520,1409,1114,117,1598,1390,1905,1599,1520,1905,1520,1520,
  1599,646,574,1598,1599,1520,575,644,574,575,1598,1520,1598,
  416,377,38,416,37,1049,1049,872,1049,28,1151,1282,1203,1049,
  872,1151,1282,1192,1204,1282,1280,838,834,1049,28,1201,1151,
  838,29,1203,887,1266,1204,1204,1266,1144,1152,1152,419,391,
  1049,1151,1049,391,385,419,385,1151,1049,1049,553,87,227,432,
  1644,1644,1260,1644,295,1104,1999,1903,1644,1260,1104,1999,
  1642,1903,1999,1999,1277,1277,1644,295,1905,1104,1277,188,1905,
  1205,1999,1905,1905,1997,1905,1905,1866,742,742,1905,1905,1905,
  742,742,741,742,1903,1905,1905,387,537,392,1405,1405,1056,
  1405,116,1409,1907,1520,1405,1056,1409,1905,1644,1520,1905,
  1905,1114,1091,1405,116,1599,1409,1091,117,1599,1390,1907,1598,
  1520,1907,1599,1520,1520,575,646,1599,1599,1598,644,575,575,
  574,1520,1598,1599,416,342,1049,1049,872,1049,28,1151,1280,
  1204,1049,872,1151,1282,1192,1204,1266,1282,838,838,1049,28,
  1204,1151,838,29,1204,887,1282,1204,1201,1282,1152,1144,1152,
  356,419,1151,887,1049,385,400,391,391,1049,1049,1151,432,1644,
  1644,1260,1644,295,1104,1999,1905,1644,1260,1104,1999,1642,
  1905,1997,1999,1277,1277,1644,295,1905,1104,1276,188,1903,1205,
  1997,1905,1905,1999,1905,1905,1905,741,742,1905,1900,1905,742,
  742,742,742,1905,1905,1905,1205,1205,908,1205,29,1066,1277,
  1206,1205,908,1066,1277,1055,1206,1282,1280,837,836,1205,29,
  1205,1066,839,28,1206,891,1282,1206,1206,1282,1173,1206,1197,
  372,374,1206,1173,1206,374,375,372,375,1173,1206,1206,478,379,
  128,22,333,1440,1301,128,52,509,1440,514,1305,1510,1868,772,
  1087,128,7,1305,128,772,22,749,333,148,128,502,615,1400,1400,
  1291,646,493,1390,1291,1392,493,646,493,493,1390,1392,1291,
  379,333,22,128,615,502,128,379,478,171,118,1305,1868,1510,
  772,1087,128,7,1305,333,772,22,128,128,1332,749,1301,1440,
  1400,1291,1400,646,493,1291,1390,1392,493,646,493,493,1390,
  1291,1392,379,6,379,1208,1023,52,341,52,1138,362,52,443,442,
  750,750,52,6,52,379,750,6,1023,379,1186,1023,1023,1208,52,
  379,379,389,389,379,379,52,389,389,389,389,52,379,379,22,
  478,1868,1305,478,379,128,1510,118,502,615,171,1087,772,128,
  22,128,333,772,7,1305,128,1332,1301,749,1440,1400,1291,1400,
  493,646,1291,1392,1390,646,493,493,493,1392,1291,1390,22,120,
  164,22,6,22,120,7,165,120,120,20,20,7,4,34,7,6,4,34,7,
  10,23,23,14,52,52,52,18,18,116,116,116,18,18,4,4,116,116,
  116,1124,769,509,52,128,1124,514,502,171,615,1087,772,128,22,
  128,128,772,7,769,333,148,502,128,615,1400,1400,1291,493,646,
  1392,1291,1390,646,493,493,493,1392,1390,1291,586,1510,441,
  171,674,1477,1591,506,1868,1210,782,171,120,171,615,783,14,
  586,1440,1845,1907,1424,1982,1527,1868,1867,638,743,1868,1867,
  1527,742,725,725,638,1527,1868,1863,1305,52,502,586,1371,1626,
  1591,1907,951,1130,128,34,1322,128,772,23,334,749,148,1322,
  480,1425,1582,1582,1421,646,458,1400,1424,1400,458,646,493,
  493,1449,1449,841,379,333,1868,514,1301,1440,1440,1087,772,
  333,22,749,128,772,7,1305,128,614,516,128,172,1291,1400,1400,
  493,646,1390,1392,1291,646,493,493,493,1291,1392,1390,379,441,
  362,1023,1209,1138,750,750,379,6,1023,379,750,6,52,52,1225,
  1023,1023,1138,379,379,52,389,389,379,52,379,389,389,389,389,
  379,379,52,615,514,769,1124,1124,772,1087,333,7,769,128,772,
  22,128,128,614,128,516,172,1291,1400,1400,646,493,1392,1390,
  1291,493,646,493,493,1291,1390,1392,1907,1907,1868,2001,1210,
  782,615,120,1424,171,783,14,586,1440,654,1591,171,1868,1868,
  1527,1867,725,742,1527,1863,1868,743,638,638,725,1868,1527,
  1867,1371,1477,1907,752,752,514,7,1371,118,752,7,1371,514,
  646,126,126,646,514,118,514,367,367,118,514,514,367,367,367,
  367,514,118,514,586,586,1130,951,749,23,334,128,772,34,1322,
  128,1423,518,1322,172,1421,1580,1580,458,646,1400,1400,1424,
  646,458,493,493,841,1448,1448,674,783,1210,1441,14,586,615,
  783,120,171,172,1995,1424,1907,1868,1867,1868,1527,742,725,
  1868,1527,1867,638,743,638,725,1867,1868,1527,782,1210,1440,
  14,586,172,783,120,1424,615,1724,171,1591,506,1863,1527,1868,
  743,638,1527,1868,1863,725,742,725,638,1867,1527,1868,333,772,
  20,772,772,333,6,951,772,784,1130,772,783,1087,1087,1087,338,
  411,1113,1113,1113,411,338,338,338,1113,1113,1113,772,6,951,
  772,333,20,772,772,784,772,1130,783,1087,1087,1087,411,338,
  1113,1113,1113,338,411,338,338,1113,1113,1113,22,1301,478,
  1087,22,502,509,1868,1305,1305,1510,1291,1400,1400,493,493,
  1392,1390,1291,493,493,646,646,1291,1390,1392,23,22,20,4,164,
  22,151,165,34,120,52,52,52,4,18,116,116,116,18,4,18,18,
  116,116,116,502,1130,165,518,502,1907,1322,1626,1591,1421,
  1582,1582,458,493,1448,1448,841,493,458,646,646,1424,1400,
  1400,1087,22,502,478,1121,769,769,1124,1400,1291,1400,493,493,
  1291,1390,1392,493,493,646,646,1390,1291,1392,20,1130,1087,
  1224,951,951,1210,1087,1087,1087,338,338,1113,1113,1113,338,
  338,411,411,1113,1113,1113,23,22,151,34,165,120,52,52,52,18,
  4,52,52,52,4,18,18,18,52,52,52,1301,1585,1626,1322,1907,
  1582,1582,1421,493,458,1400,1424,1400,458,493,646,646,1448,
  1448,841,1338,1305,1305,1869,1400,1400,1291,493,493,1390,1291,
  1392,493,493,646,646,1390,1392,1291,560,560,737,1868,1863,
  1544,716,716,1863,1544,1868,642,642,743,742,1868,1863,1544,
  334,586,1582,1422,1580,493,646,841,1448,1449,646,493,458,458,
  1400,1424,1400,586,1580,1421,1582,646,493,1424,1400,1400,493,
  646,458,458,1449,841,1448,1527,1867,1868,725,725,1867,1868,
  1527,638,638,743,742,1527,1867,1868,478,509,646,646,1324,1378,
  1292,646,646,646,646,1292,1378,1324,478,646,646,1292,1378,
  1324,646,646,646,646,1378,1292,1324,646,646,1378,1292,1324,
  646,646,646,646,1378,1324,1292,320,646,646,646,18,2,18,320,
  646,646,646,646,646,646,2,18,18,320,646,646,646,478,478,646,
  646,646,646,128,333,128,509,646,646,646,646,128,128,333,646,
  646,646,646,333,128,128,320,320,18,646,646,646,320,18,646,
  646,646,2,646,646,646,646,646,646,478,509,478,323,473,448,
  1685,1334,1624,1628,1583,1533,1520,1895,1643,1520,1905,1381,
  144,1468,773,147,1397,1346,1886,1586,1518,773,1089,1860,757,
  1579,1684,1735,1901,1716,147,1384,1905,1518,1764,863,1903,976,
  1617,1728,1836,1616,1712,1725,1712,1471,1543,1555,1504,1504,
  1859,1686,1859,1543,1363,1363,1363,2,323,411,410,575,644,428,
  575,427,741,575,417,742,368,575,574,20,477,389,574,629,544,
  575,20,477,639,20,638,644,646,646,646,574,389,725,575,646,
  367,737,477,535,741,711,523,409,408,408,646,646,328,328,328,
  646,646,646,646,322,322,322,473,667,666,737,736,661,737,663,
  742,737,497,743,368,736,736,333,486,496,736,556,570,736,333,
  486,636,333,639,736,736,737,737,736,496,639,736,737,344,737,
  486,636,737,710,556,666,666,666,737,737,472,471,472,737,737,
  737,737,472,472,472,1334,1685,1905,1903,1808,1901,1906,1628,
  1905,1905,1643,1029,1518,976,773,1346,1384,147,1708,1583,1107,
  773,1191,1899,757,1583,1827,1859,1764,1901,1468,1397,1783,144,
  1734,863,1901,1468,1472,1807,1793,1472,1725,1712,1725,1859,
  1859,1555,1504,1504,1543,1543,1471,1686,1363,1363,1363,666,
  2001,1999,2001,1999,1947,1999,2001,2001,1999,1641,1999,1999,
  1129,1382,1129,1999,1999,1641,1999,1129,1382,1970,919,1905,
  1905,1999,2001,1986,1999,1129,1999,1999,1986,919,1905,1382,
  1641,1999,1970,1905,1986,2001,1986,1732,1732,2001,2001,2001,
  2001,2001,2001,1732,1732,1732,1732,1917,1999,2001,2001,1999,
  1999,2001,1993,2001,1206,754,1997,1086,1997,1086,1997,1997,
  1907,1976,1086,1997,2001,911,1907,1997,1907,1991,2001,1997,
  1086,1997,1976,2001,911,1997,1997,1903,1903,1835,1903,2001,
  1991,2001,2001,2001,2001,2001,2001,1732,1732,1732,2001,1732,
  1732,1732,742,743,315,743,742,288,202,737,643,1907,1905,1206,
  1905,1645,1905,1997,1907,1907,1195,1905,2001,1277,1905,1999,
  2001,2001,2001,1905,1645,1997,1907,2001,1280,1999,1905,1907,
  2001,1969,1907,2001,1999,2001,2001,1999,1999,2001,2001,2001,
  1999,2001,2001,1907,1907,1905,742,742,742,297,304,695,695,189,
  1905,1903,1205,1903,1644,1882,1997,1903,1905,1205,1882,1999,
  1276,1903,1997,1999,1999,1999,1903,1644,1997,1905,1999,1279,
  1995,1903,1903,1999,1969,1903,1999,1999,1997,1997,1999,1999,
  1997,1997,1997,1999,1999,1997,1905,1903,1901,743,218,742,283,
  677,283,567,1903,1905,983,1905,1645,1997,1999,1907,1907,983,
  1997,1995,1010,1905,1999,2001,1999,2001,1905,1645,1999,1999,
  2001,1277,1999,1280,1907,1999,1970,1907,1995,2001,2001,1907,
  1907,1903,1907,1999,1999,1907,1282,1999,1206,1905,1645,745,742,
  741,743,208,186,1907,1905,1195,1905,1645,1905,1999,1905,1907,
  1206,1905,2001,1277,1907,1997,2001,2001,2001,1905,1645,1999,
  1903,1999,1280,1997,1905,1905,2001,1970,1905,2001,2001,2001,
  2001,1999,1999,2001,2001,2001,1999,1999,2001,1901,1907,1905,
  742,734,270,684,176,1907,1905,983,1905,1645,1997,1999,1905,
  1903,983,1997,2001,1010,1907,1999,1995,2001,1999,1905,1645,
  1997,1999,2001,1277,1997,1280,1905,2001,1970,1905,1999,2001,
  2001,1999,1907,1903,1999,1907,1907,1907,1999,1907,1905,1645,
  1645,694,301,308,566,1905,1903,1276,1903,1752,1279,1997,1903,
  1905,1276,1279,1999,1116,1903,1997,1999,1999,1999,1903,1903,
  1997,1280,1999,1205,1997,1279,1806,1999,1969,1805,1999,1999,
  1997,1999,1999,1999,1999,1999,1999,1999,1997,1999,1903,1905,
  1901,743,736,490,1907,1905,1206,1905,1645,1905,1999,1907,1907,
  1206,1905,1999,1277,1907,1997,1999,1999,2001,1905,1645,1999,
  1907,2001,1280,1999,1905,1907,1999,1970,1907,2001,2001,2001,
  2001,2001,2001,2001,1999,1999,2001,2001,1999,1907,1905,1809,
  529,492,1907,1905,983,1905,1645,1997,1997,1907,1907,983,1997,
  2001,1010,1907,1997,2001,2001,2001,1905,1645,1999,1999,2001,
  1277,1999,1280,1907,2001,1969,1907,2001,1999,2001,1282,1999,
  1995,1282,1907,1907,1999,1907,1907,1645,1645,1808,646,1907,
  1905,1277,1905,1753,1280,1999,1907,1884,1277,1280,2001,1105,
  1907,1997,2001,1993,2001,1905,1905,1999,1282,1999,1206,1997,
  1280,1806,2001,1970,1807,2001,2001,2001,1999,2001,2001,1999,
  2001,2001,2001,2001,2001,1903,1907,1809,1905,1903,977,1903,
  1642,1644,1905,1602,1905,977,1620,1907,961,1645,1905,1905,1907,
  1905,1903,1642,1903,1645,1907,1046,1905,1205,1645,1907,1837,
  1645,1905,1907,1907,1905,1907,1803,1900,1907,1907,1907,1905,
  1907,1566,1568,1551,662,423,43,541,699,1690,1670,48,32,662,
  1763,425,1419,1667,1402,1760,1991,43,36,1679,48,1716,446,1689,
  671,36,47,709,643,1712,1712,2001,2001,1903,1903,2001,1903,
  1895,2001,1895,1733,1329,1329,1656,420,351,456,196,686,487,43,
  340,450,199,68,1307,1911,1676,1678,1999,196,175,856,671,1901,
  440,205,298,1326,1672,1945,1636,1355,1993,1726,1999,1692,1995,
  1854,1662,1659,1999,1905,1905,1300,1789,1458,340,59,340,787,
  938,32,337,68,775,337,60,420,423,765,929,68,59,105,424,929,
  16,790,420,943,973,791,1158,72,408,408,1204,780,410,408,73,
  780,1204,1204,1204,28,339,339,456,450,1911,1307,662,420,196,
  1676,68,487,686,199,1999,1678,298,539,232,699,1734,86,1358,
  196,1636,1938,1353,1326,1726,1987,1355,1659,1999,1995,1662,
  1854,1999,1692,1905,1905,1458,1789,1300,539,1466,1430,540,59,
  539,1429,52,1430,1466,1429,646,646,175,495,1474,36,169,387,
  1464,175,127,582,581,127,1088,984,1088,646,646,844,1500,1500,
  646,646,182,182,1373,1298,1373,953,1076,662,68,298,1223,421,
  621,195,736,1999,1901,196,456,244,43,1694,86,1013,351,134,
  462,255,347,1726,1355,1987,1905,1999,1662,1995,1854,1999,1905,
  1659,1692,1458,1300,1789,564,1667,420,195,662,970,1495,731,
  1693,1999,1997,298,1489,191,740,1997,102,736,1700,1636,1999,
  1833,1894,1726,1987,1918,1905,1999,1999,1916,1854,1936,1942,
  1997,1905,1458,1789,1351,1419,60,621,646,940,1435,1495,1813,
  1394,1907,155,1285,1497,36,1437,366,543,1289,126,1416,485,
  1284,1717,1657,1814,1907,1894,1488,1669,1501,1894,1907,1439,
  1439,1418,1309,1311,424,699,1402,423,1670,1690,1763,1991,1760,
  699,541,1658,48,1760,32,1738,43,643,737,40,36,2001,1712,1712,
  1895,2001,1903,1903,2001,2001,1903,1903,1895,1656,1329,1329,
  340,423,337,938,787,775,929,765,422,52,969,425,929,38,79,68,
  1158,993,952,943,408,408,72,780,1204,410,73,411,1204,780,
  1204,1204,339,339,28,736,422,1076,953,1223,1901,1999,353,175,
  1012,43,1678,364,235,196,347,275,461,134,1993,1355,1726,1999,
  1905,1662,1854,1995,1905,1999,1692,1659,1789,1300,1458,1271,
  1813,1693,1956,2001,1999,740,1502,1823,48,1995,92,742,882,635,
  1842,256,844,2001,1721,1985,1999,1938,1907,1933,2001,2001,1907,
  1903,1995,1868,1329,1699,940,970,1271,917,917,340,59,986,32,
  761,38,971,340,339,98,85,339,408,72,408,931,931,74,410,410,
  931,931,766,766,339,28,339,564,646,1907,1394,1289,451,457,36,
  1437,1021,1482,155,1284,491,1417,126,1814,1657,1717,1894,1907,
  1488,1501,1669,1907,1894,1439,1439,1311,1309,1418,662,1997,
  1999,1700,177,741,740,1962,1149,298,298,1894,1705,1969,1636,
  1918,1993,1726,1936,1942,1999,1854,1916,1905,1999,1905,1979,
  1351,1789,1458,1999,2001,882,184,703,48,1995,1182,1701,728,
  844,300,1831,643,1985,1721,2001,2001,1907,1907,2001,1933,1999,
  1938,1995,1903,1699,1329,1868,737,1901,646,1781,1716,737,81,
  1997,1694,1905,2001,1834,1705,2001,1991,1986,1903,1645,1645,
  1645,2001,2001,1907,1907,1903,1907,1903,1903,1678,169,1997,
  1760,674,441,1880,1734,1705,1900,1970,1905,1991,1986,2001,2001,
  1907,1645,2001,1645,1903,1645,1903,1907,1903,1903,1907,539,
  1975,662,1999,364,741,450,1671,813,1367,1310,1993,1726,1355,
  1659,1905,1854,1662,1995,1905,1692,1999,1999,1789,1458,1300,
  346,541,646,387,1865,456,1374,1649,1483,1323,1088,1088,984,
  182,646,1500,844,1500,646,182,646,646,1373,1373,1298,742,1999,
  1221,741,704,1823,1867,1969,1638,1977,1927,1923,1997,1781,1997,
  1997,1972,1781,1997,1999,1999,1663,1644,1456,2001,446,742,662,
  946,1009,1005,944,1712,2001,1712,1895,1895,2001,1903,1903,1903,
  1733,2001,2001,1329,1656,1329,441,1999,1999,1907,1999,1969,
  1907,1991,2001,1991,1907,1907,2001,1645,1645,1903,1903,1645,
  2001,1903,1907,1903,371,440,957,998,1230,1066,832,911,911,441,
  100,910,910,759,100,441,441,441,800,861,861,1413,1590,1990,
  1739,1894,1925,1930,1993,1880,1993,1901,1992,1890,1993,1880,
  1999,1999,1737,1811,1668,1310,1315,1368,1671,1355,1726,1993,
  1905,1659,1854,1995,1662,1692,1905,1999,1999,1300,1458,1789,
  646,453,449,1894,1900,1475,1901,1905,1900,1572,1907,1645,1634,
  1907,1729,1548,1328,1303,513,454,1928,1995,1921,1907,2001,1995,
  1978,1999,2001,1903,1999,1999,1645,1899,1329,607,1912,1970,
  1929,1968,1835,1967,1832,1748,1835,1968,1411,1411,1348,1833,
  1816,1475,1900,1894,1905,1901,1900,1907,1572,1634,1645,1907,
  1729,1303,1328,1548,666,666,1995,2001,1685,1685,2001,1995,1959,
  1959,1995,1685,1334,1334,666,1959,1959,2001,1685,1685,1995,
  1995,2001,1995,1334,1685,1334,2001,1995,1685,1973,1685,1959,
  1995,1959,1995,1334,1334,1685,737,1997,2001,1997,314,674,314,
  674,1903,1903,1907,1997,1997,2001,674,314,314,737,1907,1903,
  1903,666,666,1997,1997,2001,2001,164,468,164,666,1997,2001,
  1997,1997,164,164,468,2001,1997,1997,1997,469,164,164,737,737,
  314,1907,1903,1903,674,314,1903,1903,1907,674,1903,1907,1903,
  1903,1907,1903,449,449,449,329,320,412,338,493,493,391,493,
  391,739,493,391,739,370,23,334,23,23,389,499,606,743,334,23,
  391,592,20,742,592,606,621,646,23,389,741,499,646,367,742,
  380,594,741,742,592,423,420,423,493,493,325,325,325,646,646,
  646,493,327,327,327,668,1334,1685,1907,1907,1752,1907,1905,
  1999,1876,1907,1999,1204,309,1754,1086,310,1486,1754,1907,2001,
  1905,1127,1280,1905,919,1997,1999,1980,1995,2001,253,1641,1826,
  1905,1991,917,1995,1262,2001,1995,1995,1997,2001,1987,2001,
  1907,1907,1557,1557,1504,2001,2001,2001,1907,2001,2001,2001,
  470,470,609,609,549,609,549,631,609,549,631,368,23,391,496,
  23,334,23,743,732,391,496,348,737,344,706,737,743,662,662,
  23,334,737,23,662,333,706,391,743,737,706,737,734,734,734,
  474,474,476,476,476,474,474,474,474,737,737,737,473,1907,
  1907,1752,1905,1768,1999,1876,1907,1997,1567,309,1754,1486,310,
  1086,1754,2001,1907,1905,1641,1262,1969,917,1997,1779,1999,
  1987,2001,253,1127,2001,1905,2001,919,1905,1280,1826,1999,1999,
  1993,1991,1995,2001,1557,1557,1907,1907,1907,2001,2001,2001,
  1504,2001,2001,2001,1624,1645,1520,1643,1582,1905,1533,1520,
  1901,1032,144,1346,1397,147,773,1468,1901,1735,1518,1384,976,
  1890,863,1901,1710,1586,1725,1712,147,773,1860,1518,1712,757,
  1720,1089,1728,1617,1642,1722,1764,1901,1716,1504,1555,1543,
  1471,1543,1363,1363,1363,1504,1859,1859,1686,455,463,128,507,
  599,128,116,559,512,116,1376,1405,116,1405,1396,1905,1907,
  1376,1405,1059,1905,1203,1879,1890,1907,1905,1907,116,1405,
  1905,1396,1907,1203,1905,1062,1907,1907,1903,1905,1907,1903,
  1907,1629,1628,1644,1629,1645,1907,1905,1907,1645,1907,1907,
  1905,463,455,463,115,128,507,599,129,116,1376,1405,116,1405,
  1396,1907,1905,1376,1405,1059,1890,1203,1903,1905,1907,1905,
  1907,116,1405,1907,1396,1907,1203,1879,1062,1905,1907,1905,
  1903,1907,1905,1905,1644,1629,1629,1628,1644,1905,1884,1907,
  1628,1907,1905,1884,507,128,576,116,524,173,515,116,1398,1409,
  116,1409,1516,1907,1907,1398,1409,1150,1903,1203,1903,1753,
  1907,1903,1903,116,1409,1754,1516,1754,1203,1905,862,1754,1905,
  1905,1905,1754,1753,1907,1400,1389,1400,1389,1582,1905,1645,
  1105,1519,1105,1905,1645,463,599,455,463,115,129,116,1376,
  1405,116,1405,1396,1907,1905,1376,1405,1059,1905,1203,1905,
  1903,1907,1905,1907,116,1405,1907,1396,1905,1203,1903,1062,
  1905,1907,1905,1852,1907,1905,1907,1645,1644,1628,1645,1629,
  1884,1905,1905,1629,1905,1884,1905,576,507,128,576,127,116,
  1398,1409,116,1409,1516,1907,1901,1398,1409,1150,1753,1203,
  1905,1905,1905,1753,1867,116,1409,1905,1516,1768,1203,1903,862,
  1905,1907,1767,1903,1867,1753,1768,1582,1400,1389,1519,1400,
  1645,1645,1905,1389,1905,1645,1645,559,173,295,558,174,1596,
  1900,174,1900,1081,1999,1997,1596,1900,921,1997,1205,1995,1997,
  1999,1997,1999,174,1900,1999,1081,1999,1205,1997,840,1999,1999,
  1997,1995,1999,1997,1997,1905,1905,1905,1905,1905,1999,1999,
  1997,1905,1997,1999,1999,463,599,512,116,1376,1405,116,1405,
  1396,1907,1907,1376,1405,1059,1903,1203,1905,1852,1905,1903,
  1907,116,1405,1907,1396,1907,1203,1905,1062,1907,1905,1905,
  1905,1907,1905,1907,1645,1645,1645,1645,1628,1905,1907,1884,
  1644,1884,1905,1907,576,515,116,1398,1409,116,1409,1516,1905,
  1768,1398,1409,1150,1905,1203,1767,1903,1768,1753,1754,116,
  1409,1907,1516,1907,1203,1905,862,1907,1907,1903,1905,1903,
  1903,1754,1039,1582,1519,1039,1389,1645,1905,1645,1400,1645,
  1645,1905,558,174,1596,1900,174,1900,1081,1999,1999,1596,1900,
  921,1997,1205,1997,1995,1999,1997,1999,174,1900,1999,1081,1997,
  1205,1995,840,1997,1999,1997,1997,1999,1997,1999,1903,1905,
  1905,1903,1905,1999,1999,1999,1905,1999,1999,1999,140,1578,
  1640,140,1640,1410,1907,1907,1578,1640,1043,1905,1044,1905,
  1905,1905,1905,1905,140,1640,1905,1410,1907,1044,1905,875,1907,
  1907,1905,1905,1905,1905,1907,1642,1643,1643,1642,1643,1907,
  1907,1905,1643,1905,1907,1907,22,22,3,22,22,190,284,7,7,20,
  130,20,173,173,284,156,252,3,7,131,7,143,20,130,20,14,14,
  25,25,143,156,252,180,128,128,180,128,180,314,180,128,180,
  180,314,333,22,333,109,540,540,128,495,387,160,61,1484,1861,
  1493,1469,1868,7,128,1442,495,1479,387,160,61,1442,1485,1865,
  1467,1479,1867,1531,1430,1372,1430,1372,1322,1531,1907,1556,
  1322,1556,1907,1531,22,109,333,1653,1420,128,495,61,1465,387,
  173,561,619,1095,1097,7,128,153,495,987,61,1465,387,1442,
  1485,1467,1865,164,621,622,1373,1373,463,463,34,1503,1503,847,
  1305,167,646,646,22,22,284,190,22,22,6,173,6,25,25,10,303,
  143,3,22,14,22,143,6,173,6,131,317,130,130,143,303,143,128,
  180,180,128,128,314,180,180,128,180,314,180,333,1420,1653,
  495,128,387,1474,61,1861,1484,1493,621,622,7,495,1442,128,
  164,387,1474,61,153,620,621,155,987,1095,1097,463,463,1373,
  1373,1305,646,646,167,34,847,1503,1503,1071,1071,495,128,61,
  967,387,561,173,619,1867,1531,7,495,153,128,1479,61,967,387,
  153,620,155,621,1479,1469,1868,1372,1430,1372,1430,1322,1907,
  1531,1556,1322,1556,1531,1907,700,1493,619,90,731,1092,1810,
  732,1768,1999,1999,10,1493,277,619,1985,90,731,1092,1746,1997,
  1824,1999,1881,1999,1999,1641,1907,1899,1709,1297,1995,1999,
  1995,1563,1907,2001,1999,1499,178,429,670,1167,1999,1749,1990,
  1997,2001,10,1499,1746,178,1881,429,670,1167,277,1766,681,
  1901,1985,1997,2001,1899,1709,1641,1907,1564,1999,2001,1907,
  1295,1995,1995,1995,333,387,1861,387,1865,1467,1499,1867,1479,
  22,333,1485,109,1531,61,1484,61,540,540,160,160,1868,1469,
  1479,1322,1430,1372,1322,1430,1907,1556,1531,1372,1909,1531,
  1556,387,561,387,1467,1865,1499,1095,987,22,109,1485,333,1097,
  61,173,61,1654,1427,1465,1465,622,621,164,1305,1373,463,34,
  463,1503,847,1503,1373,646,646,169,430,333,837,837,931,1119,
  1277,20,61,928,61,1143,333,79,16,438,88,436,105,1277,1119,
  1143,1199,937,937,1061,1199,989,1282,1206,1061,1282,989,1206,
  1247,1997,1821,1999,1997,1997,25,1484,1847,173,1993,79,335,
  1166,742,1749,295,1821,1999,1887,1997,1718,1825,1463,1742,1901,
  1995,1896,1901,1878,1999,1880,1997,1162,1162,1282,830,915,20,
  61,1187,61,915,16,1166,333,438,88,105,436,437,53,436,894,
  801,28,378,378,764,929,929,894,441,81,441,335,731,1997,1997,
  130,621,736,155,1905,1165,1866,79,1824,734,1866,295,1999,1995,
  1997,1874,1899,1644,1627,1780,1999,1997,1781,1337,1993,1993,
  1997,731,1991,1999,130,155,736,621,1997,1165,295,79,1995,1847,
  1997,1821,1997,1997,1896,1825,1878,1901,1463,1742,1901,1995,
  1899,1769,1997,1999,1880,1997,2001,190,178,669,178,1999,1179,
  1824,441,1766,277,1810,732,1999,1772,2001,1907,1563,1294,1899,
  1709,1995,1995,1995,1641,1999,1907,2001,736,156,621,1905,1469,
  736,53,1995,1119,1997,1999,1851,1995,1999,1993,1999,1457,1854,
  1905,1905,1905,1995,1789,1789,1457,1999,1999,1999,144,164,1995,
  1479,674,437,1905,1143,1999,1907,1999,1993,1976,1999,753,1903,
  1329,1895,1731,1895,1656,2001,1656,1329,2001,2001,2001,22,317,
  22,252,20,25,20,317,131,173,173,252,156,144,128,128,128,128,
  180,180,180,314,180,314,180,180,620,333,622,387,1861,387,
  1427,1654,1474,1474,1097,1095,987,34,463,1373,1305,1373,646,
  169,646,463,1503,1503,847,620,2001,1275,734,432,1964,1745,
  1995,1749,2001,1989,1999,1778,1606,1691,1719,1905,1903,1995,
  2001,1907,2001,1764,1868,1868,387,561,387,1069,1069,967,967,
  1531,1867,1479,1322,1372,1430,1322,1372,1531,1556,1907,1430,
  1531,1907,1556,437,1999,1277,2001,1995,1997,1999,753,1999,1976,
  1329,1329,1895,1895,1903,1656,1656,2001,1903,2001,2001,2001,
  430,333,1102,1074,1229,1101,915,830,915,378,28,801,894,894,
  81,441,441,378,929,764,929,1247,1867,1995,1866,1997,1997,1995,
  1999,1337,1874,1627,1901,1644,1997,1781,1999,1899,1993,1997,
  1993,1102,1074,1101,1229,1143,1119,1277,1061,937,937,1199,1061,
  989,1206,1282,1199,1206,989,1282,700,673,673,2001,1993,1907,
  1691,1719,1778,1606,1907,1861,1766,2001,1905,2001,1995,1903,
  736,736,1999,1999,1999,1606,1907,1905,1691,1770,2001,1903,1995,
  1778,1861,2001,1764,335,1997,1997,1997,1899,1337,1780,1644,
  1640,1781,1999,1997,1874,1993,1993,1993,1896,1991,1999,1878,
  1769,1742,1901,1463,1899,1901,1995,1819,1880,1997,1999,736,674,
  1895,1895,1329,1329,1903,2001,2001,2001,1903,2001,1656,1656,
  736,1905,1905,1854,1457,1457,1999,1999,1999,1905,1789,1995,
  1789,1731,1895,1329,1903,1329,2001,2001,2001,1895,1656,1656,
  2001,455,1438,1344,1438,169,474,169,478,1903,1903,1907,1344,
  1438,1438,474,169,169,455,1903,1907,1903,455,455,1907,1903,
  1903,1438,169,474,169,478,1903,1907,1903,1438,169,167,474,
  1903,1903,1907,1344,474,167,169,737,737,167,1645,1344,1645,
  674,169,1599,1645,1344,474,1344,1645,1599,1907,1903,1903,737,
  674,737,329,411,410,575,646,428,575,439,742,575,417,742,345,
  574,575,20,477,389,575,523,649,574,20,477,535,20,725,646,
  644,646,646,575,389,638,574,646,367,741,477,639,737,743,629,
  410,408,408,646,646,322,322,322,646,646,646,646,328,328,328,
  338,412,611,611,419,611,419,624,611,419,624,345,334,391,23,
  334,389,23,646,743,391,23,380,590,20,741,590,646,646,621,
  334,389,743,23,621,367,741,499,606,743,741,590,420,423,420,
  646,646,325,325,325,493,493,493,646,327,327,327,333,1091,
  1113,838,1099,838,1250,1113,838,1245,820,1109,1090,65,1094,
  750,1090,996,1198,1094,65,1094,1175,37,1217,1031,995,1087,
  1087,1090,750,1216,1094,1087,752,1100,1094,1031,1217,1216,1172,
  929,929,929,772,772,438,438,438,1087,1087,1087,772,438,438,
  438,1115,1091,838,1091,834,1214,1115,838,1214,792,1090,1094,
  65,1094,750,1094,1172,1269,1090,65,1094,996,37,1216,995,1031,
  1087,1087,1109,750,1217,1090,1087,752,1217,1094,996,1100,1100,
  996,929,929,929,1087,1087,438,438,438,772,772,772,1087,438,
  438,438,495,387,128,377,537,128,52,553,392,1405,1405,116,
  1405,1056,1409,1598,1907,1405,116,1409,1520,117,1905,1520,1599,
  1520,1599,1405,1056,1905,1409,1520,1644,1907,1390,1520,1907,
  1905,1599,1091,1114,1091,1520,1598,644,575,575,1599,1598,1599,
  1599,575,646,574,387,495,387,145,128,377,537,65,1405,1405,
  116,1405,1056,1409,1599,1905,1405,116,1409,1520,117,1905,1599,
  1520,1520,1520,1405,1056,1907,1409,1599,1644,1905,1390,1598,
  1907,1907,1598,1115,1091,1114,1598,1520,575,574,644,1598,1520,
  1599,1598,646,574,575,377,38,416,52,342,87,342,1049,1049,28,
  1049,872,1151,1204,1282,1049,28,1151,1201,29,1266,1204,1204,
  1144,1152,1049,872,1282,1151,1152,1192,1282,887,1204,1280,1282,
  1204,838,838,838,1049,1049,385,391,400,1151,1049,887,1151,356,
  419,391,387,537,495,387,145,65,1405,1405,116,1405,1056,1409,
  1520,1905,1405,116,1409,1599,117,1907,1598,1520,1599,1520,1405,
  1056,1907,1409,1582,1644,1905,1390,1598,1907,1907,1598,1115,
  1115,1091,1599,1598,574,646,575,1520,1598,1598,1520,574,575,
  644,416,377,38,416,37,1049,1049,28,1049,872,1151,1204,1266,
  1049,28,1151,1204,29,1282,1204,1201,1152,1144,1049,872,1280,
  1151,1152,1192,1266,887,1203,1282,1282,1203,834,838,838,1151,
  1049,391,419,385,1049,1049,1151,1049,419,391,385,553,87,227,
  432,1644,1644,295,1644,1260,1104,1905,1997,1644,295,1104,1905,
  188,1997,1905,1905,1905,1905,1644,1260,1999,1104,1905,1642,
  1999,1205,1905,1999,1999,1903,1277,1277,1276,1905,1905,742,742,
  742,1905,1905,1900,1905,741,742,742,387,537,392,1405,1405,116,
  1405,1056,1409,1520,1907,1405,116,1409,1598,117,1907,1598,1598,
  1582,1599,1405,1056,1907,1409,1599,1644,1907,1390,1599,1905,
  1907,1520,1091,1115,1115,1599,1599,646,575,574,1598,1599,1520,
  1598,575,644,575,416,342,1049,1049,28,1049,872,1151,1201,1282,
  1049,28,1151,1204,29,1282,1203,1204,1152,1152,1049,872,1282,
  1151,1152,1192,1282,887,1204,1282,1280,1204,838,834,838,887,
  1151,419,356,391,1049,1151,1049,1049,391,385,400,432,1644,
  1644,295,1644,1260,1104,1905,1999,1644,295,1104,1905,188,1999,
  1903,1905,1905,1905,1644,1260,1999,1104,1866,1642,1997,1205,
  1903,1999,1999,1905,1277,1277,1277,1903,1905,742,741,742,1905,
  1905,1905,1905,742,742,742,1205,1205,29,1205,908,1066,1206,
  1282,1205,29,1066,1206,28,1282,1206,1205,1206,1173,1205,908,
  1280,1066,1197,1055,1282,891,1206,1277,1277,1206,836,837,839,
  1173,1206,374,372,375,1206,1206,1173,1206,372,374,375,333,22,
  128,379,478,1305,1868,128,7,333,1305,22,1440,749,1301,1400,
  1291,128,52,1440,128,1400,514,1510,509,128,171,615,502,772,
  772,1087,1291,1390,493,646,493,1392,1291,1390,1392,493,493,
  646,22,478,379,128,516,614,128,22,333,128,7,1440,1301,749,
  1400,1291,128,52,1440,509,1400,514,171,128,1305,1510,1868,
  1305,772,1087,772,1291,1392,646,493,493,1390,1291,1392,1390,
  493,646,493,22,6,22,165,151,7,4,7,34,4,14,23,23,52,52,7,
  6,14,22,52,7,120,22,34,120,120,165,6,20,20,116,116,18,18,
  4,116,116,116,116,4,18,18,379,333,1301,1332,333,22,128,749,
  7,615,502,128,1291,1400,128,379,171,478,1400,118,1440,128,
  1305,1868,1510,1305,772,1087,772,1392,1291,646,493,493,1291,
  1390,1392,1390,493,646,493,379,1023,1225,379,6,379,1023,6,
  1208,1023,1023,379,379,52,341,1138,52,52,362,1138,52,52,443,
  441,52,750,750,750,379,379,389,389,389,379,379,52,52,389,
  389,389,769,1121,333,7,128,769,22,615,128,502,1291,1400,128,
  379,171,128,1400,118,1124,478,128,615,172,502,772,772,1087,
  1390,1291,493,646,493,1291,1392,1390,1392,493,493,646,560,749,
  23,128,334,34,1424,518,1322,1421,1582,128,1023,171,502,1580,
  126,586,1305,1322,1907,1591,1626,772,1130,951,1400,1424,646,
  458,493,841,1449,1448,1400,493,646,458,1332,10,614,560,151,
  1995,1423,1907,1863,1868,148,1186,1724,148,1544,646,737,1338,
  148,1845,654,1585,784,784,1224,1868,1863,642,743,642,1863,
  1868,1544,1544,716,716,742,22,478,1301,22,1868,1305,1305,1291,
  1400,478,379,1510,128,1400,118,1440,128,502,615,172,128,1087,
  772,772,1390,1291,493,493,646,1291,1392,1390,1392,646,493,493,
  22,23,4,120,164,34,52,52,22,6,120,22,52,7,14,7,165,120,
  120,34,20,20,6,116,116,18,4,18,116,116,116,116,18,18,4,
  516,22,1124,769,769,1400,1291,509,52,1124,128,1400,514,171,
  128,502,172,615,128,1087,772,772,1291,1390,493,493,646,1392,
  1291,1390,1392,646,493,493,165,1907,1322,1626,1421,1580,502,
  1023,1591,128,1582,126,586,1305,480,1424,172,1322,1130,772,
  951,1449,841,493,458,646,1424,1400,1400,1448,646,493,458,120,
  34,164,52,52,22,6,120,7,52,7,120,22,23,14,14,23,20,6,20,
  52,52,4,18,18,52,52,52,52,18,4,18,586,586,1868,1867,1510,
  441,674,171,1527,1477,1868,171,1591,506,1868,171,1210,783,782,
  1867,1868,638,638,743,1868,1867,1527,1527,742,725,725,334,
  1580,1421,1305,52,586,502,1580,1371,171,128,1626,1591,1907,
  1322,951,1130,772,841,1448,646,493,458,1400,1424,1400,1448,
  458,646,493,1582,1421,1305,52,586,128,1582,1371,1591,502,1322,
  171,1424,518,951,772,1130,1424,1400,493,646,458,1448,841,1448,
  1400,458,493,646,478,1400,379,1527,1400,478,118,1867,1400,
  1582,1868,1527,1582,1087,1087,1087,1378,1292,646,646,646,1292,
  1324,1378,1324,646,646,646,1400,52,1863,1400,509,514,1527,
  1400,1582,1527,1868,1582,1087,1087,1087,1292,1378,646,646,646,
  1324,1292,1378,1324,646,646,646,379,1868,333,1291,514,615,333,
  1301,1440,1440,749,1087,772,772,1390,1392,493,493,646,1390,
  1392,1291,1291,646,493,493,441,379,379,362,1208,379,1023,1208,
  1138,1023,750,750,750,52,379,389,389,389,379,52,379,379,389,
  389,389,615,1868,1907,506,615,1907,1868,2001,1424,1210,783,
  782,1867,1527,725,725,742,1527,1863,1868,1868,743,638,638,
  1291,514,615,333,769,1124,1124,769,772,1087,772,1392,1390,646,
  493,493,1392,1390,1291,1291,493,646,493,514,1868,1291,1421,
  1867,1867,1421,1087,1087,1087,1378,1324,646,646,646,1378,1324,
  1292,1292,646,646,646,646,514,1371,1477,1907,1371,752,752,752,
  514,118,367,367,367,118,514,514,514,367,367,367,1868,1424,
  1982,1868,1907,783,781,1210,1527,1867,638,743,638,1867,1527,
  1868,1868,725,725,742,749,1440,1440,1301,772,772,1087,1390,
  1392,493,646,493,1390,1392,1291,1291,493,493,646,586,586,334,
  1130,951,772,1449,1449,458,493,646,1400,1400,1424,841,646,458,
  493,674,586,783,1210,783,1527,1868,742,725,726,1868,1527,1867,
  1863,638,743,638,586,783,1210,782,1868,1527,743,638,638,1527,
  1870,1863,1867,725,742,725,772,951,1130,1448,1448,458,646,493,
  1400,1400,1424,841,493,458,646,333,333,1113,1113,338,338,411,
  1113,1113,1113,1113,411,338,338,333,1113,1113,411,338,338,
  1113,1113,1113,1113,338,411,338,1113,1113,338,411,338,1113,
  1113,1113,1113,338,338,411,478,646,646,646,128,333,128,509,
  646,646,646,646,646,646,333,128,128,478,646,646,646,320,320,
  646,646,646,646,18,2,18,320,646,646,646,646,18,18,2,646,
  646,646,646,2,18,18,478,478,128,646,646,646,509,128,646,646,
  646,333,646,646,646,646,646,646,320,320,320,1685,1965,1999,
  1999,1999,1999,1997,1876,1999,2000,1907,934,1905,1277,1127,
  1905,1641,253,1786,2001,1262,1086,1280,1787,919,1999,1997,1992,
  1991,1995,1754,1641,1754,310,1995,911,2001,1905,1997,1995,2001,
  1995,1987,2001,1993,2001,2001,1557,1504,1557,1907,1907,1907,
  2001,2001,2001,2001,667,2001,2001,1993,1999,1999,2001,1917,
  2001,1999,1206,1997,1976,1086,1997,1086,1976,1903,1903,1997,
  1086,1997,1835,911,1997,1907,1997,1991,2001,754,1086,1907,1997,
  2001,911,1903,1997,1907,1997,2001,1997,2001,1991,2001,1732,
  1732,1732,1732,1732,2001,2001,2001,1732,2001,2001,2001,2001,
  1947,1947,1947,1992,2001,2001,1947,2001,930,1999,1999,1129,
  1382,1129,1999,1905,2001,1999,1129,1382,1907,919,1999,1999,
  1905,2001,1986,1999,1129,1905,1999,1986,919,1999,1382,2001,
  1905,1907,1999,1986,2001,1986,2001,2001,1732,1732,1732,1732,
  1732,1732,2001,2001,2001,2001,741,743,288,742,743,315,202,674,
  441,1905,1907,1206,1905,1645,1903,1905,2001,1905,1206,1905,
  1907,1277,1997,2001,1999,2001,2001,1907,1645,1905,1905,2001,
  1280,2001,1905,2001,1999,1999,1999,2001,1999,2001,2001,1999,
  1901,1907,1907,2001,1999,2001,2001,2001,2001,1999,743,528,695,
  207,288,743,743,98,1905,1907,1206,1905,1645,1907,1907,1999,
  1905,1206,1905,1907,1277,1997,2001,1999,1993,2001,1907,1645,
  1907,1905,2001,1280,1999,1905,1999,1999,2001,1997,2001,2001,
  1999,1999,2001,1907,1905,1905,1999,2001,2001,1999,2001,1999,
  2001,743,293,741,202,500,287,415,1905,1907,983,1905,1645,1999,
  1907,2001,1905,983,1997,1905,1010,1997,2001,1999,1999,2001,
  1907,1645,1907,1997,2001,1277,2001,1280,2001,1997,2001,1999,
  2001,2001,1995,1907,1907,1645,1645,1905,1999,1907,1282,1999,
  1282,1999,1907,695,743,741,743,208,98,1905,1907,1206,1905,
  1645,1907,1907,1999,1905,1206,1905,1907,1277,1999,1999,1999,
  2001,2001,1907,1645,1907,1905,1999,1280,1999,1905,1999,1999,
  2001,1997,2001,2001,2001,2001,1999,1905,1903,1907,2001,1999,
  1999,2001,1999,2001,1999,742,742,293,742,66,1882,1905,982,
  1903,1642,1997,1905,1979,1903,982,1995,1905,1004,1997,1999,
  1995,1999,1997,1905,1642,1903,1995,1999,1271,1979,1279,1997,
  1997,1999,1995,1992,1999,1999,1997,1905,1644,1903,1644,1905,
  1905,1997,1905,1997,1905,1905,674,287,315,441,1901,1907,1277,
  1905,1905,1261,1807,1999,1905,1277,1280,1807,1206,1997,2001,
  1999,2001,2001,1903,1905,1907,1263,2001,1105,2001,1280,2001,
  1999,2001,1997,2001,2001,1999,2001,2001,1907,1907,1907,2001,
  2001,1999,2001,1999,2001,2001,743,743,441,1905,1907,1195,1905,
  1645,1907,1907,2001,1905,1206,1905,1905,1277,1999,1999,1997,
  1999,2001,1907,1645,1907,1905,2001,1280,2001,1905,2001,1997,
  2001,1999,2001,2001,2001,2001,2001,1907,1907,1901,1999,2001,
  2001,1999,2001,1999,2001,741,415,1905,1907,983,1905,1645,1999,
  1905,2001,1905,983,1997,1907,1010,1999,1999,1999,2001,2001,
  1907,1645,1907,1997,2001,1277,2001,1280,2001,1999,1999,1999,
  2001,1999,2001,1282,1999,1905,1206,1645,1907,1999,1907,1907,
  1907,1907,1999,441,1905,1903,1277,1905,1905,1282,1807,2001,
  1905,1277,1263,1807,1206,1999,1999,1999,2001,2001,1907,1905,
  1907,1280,1999,1105,1999,1280,1999,1999,2001,1999,2001,2001,
  2001,1999,2001,1907,1901,1907,2001,2001,2001,2001,2001,2001,
  2001,1279,1280,827,1279,1183,1187,1206,1282,1279,827,1194,1206,
  817,1280,1282,1279,1282,1280,1280,1183,1205,1194,1282,884,1282,
  929,1282,1280,1282,1280,1267,1282,1282,1280,1282,1161,1157,
  1161,1282,1282,1280,1282,1280,1282,1282,662,420,298,538,699,
  1636,1938,196,68,450,1326,340,856,1676,1974,1901,1999,43,175,
  1307,196,1678,364,1672,353,199,204,683,721,1355,1726,1993,
  1999,1905,1458,1789,1300,1905,1999,1659,1692,1662,1854,1995,
  423,699,540,48,643,737,43,423,662,36,32,1679,1986,1667,1716,
  2001,48,36,1419,671,1760,447,47,43,1763,1689,1993,1690,1712,
  2001,1712,2001,1903,1656,1329,1329,1895,2001,1895,1733,1903,
  2001,1903,420,52,424,1158,993,68,337,68,943,337,105,423,420,
  929,929,32,59,60,340,765,38,973,340,775,790,968,787,72,408,
  408,1204,1204,339,339,28,1204,1204,780,780,73,410,409,538,
  662,1671,813,450,340,196,1310,68,704,728,298,1999,1734,43,
  456,155,351,1678,86,1315,196,882,1413,1688,1700,1355,1987,
  1726,1905,1999,1789,1458,1300,1999,1905,1659,1692,1662,1995,
  1854,540,1374,1649,456,59,456,1323,59,1861,1501,1489,646,646,
  36,495,1285,175,169,387,1343,175,184,550,551,177,984,1088,
  1088,646,646,1373,1373,1298,646,646,182,182,844,1500,1500,944,
  1009,662,32,43,944,425,742,48,740,1991,1760,48,541,36,43,
  1760,32,1009,699,48,742,44,740,1712,1712,2001,1903,2001,1329,
  1656,1329,2001,1895,1895,1903,1903,1903,2001,646,1310,339,134,
  449,943,1638,643,1636,1907,1905,36,1323,126,347,1705,60,454,
  1326,844,1894,1444,1894,1475,1901,1900,1645,1907,1548,1328,
  1303,1729,1905,1901,1634,1572,1907,1900,1315,98,462,454,973,
  1999,1844,1999,1999,2001,47,1343,1416,282,1900,415,500,1672,
  300,1867,679,1705,1921,1926,1995,2001,1999,1645,1899,1329,1999,
  2001,1907,1903,1978,1999,1995,340,351,1671,422,1975,882,1700,
  1999,1694,699,539,1289,196,1901,86,813,298,740,741,282,298,
  1987,1355,1726,1659,1999,1300,1458,1789,1999,1692,1905,1905,
  1995,1662,1854,421,339,337,986,1271,970,765,929,423,59,940,
  422,929,16,98,68,1271,971,993,970,410,409,72,1204,780,339,
  28,339,780,1204,1204,1204,411,410,73,347,340,1012,1223,953,
  1694,1999,671,175,1076,298,1734,440,282,196,742,235,740,195,
  1993,1726,1355,1999,1692,1458,1300,1789,1659,1999,1905,1905,
  1995,1854,1662,1158,1823,844,1894,1907,1705,643,1374,1284,134,
  1905,60,646,1636,635,1590,161,1636,1901,1475,1900,1901,1729,
  1303,1328,1548,1907,1634,1645,1905,1907,1572,1900,969,776,787,
  917,761,424,52,938,68,917,38,993,421,424,79,90,420,410,72,
  409,766,931,28,339,339,931,766,931,931,410,74,408,703,741,
  1999,1997,1658,346,457,244,1781,1165,1867,235,1823,741,1860,
  295,1977,1923,1927,1997,1999,1456,1644,1663,1999,1997,1781,
  1781,1972,1997,1997,662,1995,2001,1763,184,646,736,1999,1204,
  300,200,1956,1701,1992,1693,1985,2001,1721,1938,1995,1868,1329,
  1699,1903,2001,1907,1999,1933,2001,1907,1997,1999,1690,177,564,
  195,1962,1148,1705,686,1693,298,1762,731,1918,1726,1987,1999,
  1905,1458,1789,1351,1979,1936,1942,1905,1916,1854,1999,737,
  1760,646,1437,1678,737,81,1999,1901,1995,1999,1907,1962,1986,
  1991,2001,1907,2001,1903,1907,1903,1645,1903,1903,1907,1645,
  1645,2001,1716,169,1394,1901,674,441,1900,1678,1999,1880,2001,
  1997,1991,2001,1991,1645,1903,1907,1903,1903,1907,2001,1907,
  1903,1645,2001,1645,541,1670,662,1991,447,737,662,1402,1738,
  1712,1667,2001,1712,1712,1895,1895,1329,1329,1656,1903,1733,
  2001,2001,2001,1903,1903,451,456,646,387,1649,539,1501,1865,
  1496,1490,1088,984,1088,182,646,1298,1373,1373,646,182,646,
  646,1500,844,1500,621,1907,1106,491,487,1813,1482,1892,1495,
  1814,1717,1657,1894,1439,1418,1309,1311,1439,1894,1907,1907,
  1669,1501,1488,1999,440,462,450,1223,1013,999,953,1726,1993,
  1355,1905,1659,1789,1300,1458,1692,1905,1999,1999,1854,1995,
  1662,441,2001,1999,2001,1997,1999,1999,2001,1986,1991,1903,
  1903,1903,1903,1909,1907,1907,2001,1645,2001,1645,1645,415,364,
  1204,1147,1282,1148,911,911,832,441,100,861,800,861,100,441,
  441,441,910,910,759,1938,1842,1990,1740,1999,1926,1921,1995,
  1907,1999,1329,1899,1645,1999,1903,2001,2001,1999,1978,1995,
  1676,1358,1317,1911,1726,1355,1993,1692,1905,1300,1789,1458,
  1905,1659,1999,1999,1854,1662,1995,742,743,662,2001,1985,1721,
  1999,1995,1699,1329,1868,1904,1907,2001,1938,2001,1933,1907,
  702,736,1925,1993,1930,1880,1999,1668,1811,1737,1999,1880,1993,
  1993,1890,1992,1901,730,1928,1995,1922,2001,1902,1765,1330,
  1585,1879,2001,1999,1999,1999,1995,1978,1726,1918,1993,1940,
  1997,1351,1789,1458,1905,1905,1999,1936,1854,1916,1999,666,666,
  1959,1959,1334,1334,1685,1995,1995,2001,1995,1973,1685,1685,
  666,2001,1995,1685,1334,1334,1959,1995,1959,1995,1685,2001,
  1685,1959,1995,1335,1685,1334,2001,1995,1995,1959,1685,1685,
  2001,737,1907,1903,1903,314,674,314,674,1997,2001,1997,1903,
  1907,1903,674,314,314,737,1997,1997,2001,449,449,1903,1907,
  1903,1903,164,469,164,449,1907,1903,1903,1903,164,164,468,
  1903,1903,1907,1907,469,164,164,737,737,314,1997,1997,2001,
  674,314,1997,2001,1997,674,2001,1997,1997,2001,1997,1997,666,
  666,666,473,1905,1901,1905,1903,1905,1643,1906,1808,1628,1029,
  1468,1107,1397,1346,773,144,1807,1472,976,1384,1191,1793,863,
  1827,1583,1783,1712,1725,1518,773,1859,147,1725,757,1472,1468,
  1583,1708,1899,1901,1901,1764,1734,1363,1363,1543,1471,1543,
  1555,1504,1504,1363,1859,1859,1686,1999,1999,1999,1999,1997,
  1907,1999,1999,1876,934,1754,1262,1641,1905,1086,310,1995,1997,
  1277,1641,1280,2001,911,1997,1999,1754,2001,1987,1905,1127,
  1992,253,1993,919,1995,1905,2001,1786,1787,2001,1995,1991,1995,
  2001,2001,1907,1907,1907,1557,1557,1504,2001,2001,2001,2001,
  735,737,264,680,623,264,193,552,426,1603,1184,1644,1603,1644,
  174,1997,1999,1184,1644,1203,1999,1279,1997,1999,1999,1999,
  1997,1603,1644,1997,174,1997,1279,1999,1644,1999,1999,1997,
  1999,1997,1997,1997,1999,1997,1903,1905,1905,1905,1903,1905,
  1999,1999,1999,1997,737,735,737,132,264,680,623,101,1603,1184,
  1644,1603,1644,174,1999,1997,1184,1644,1203,1999,1279,1997,
  1999,1999,1999,1997,1603,1644,1999,174,1997,1279,1997,1644,
  1997,1999,1999,1997,1997,1999,1995,1997,1999,1905,1903,1903,
  1903,1905,1905,1997,1999,1997,1999,680,227,627,193,653,152,
  398,1635,1193,1644,1635,1644,233,1999,1999,1193,1644,1276,1997,
  1276,1997,1999,1999,1997,1997,1635,1644,1999,233,1997,1276,
  1999,1189,1999,1997,1999,1999,1997,1999,1997,1905,1905,1644,
  1644,1903,1903,1644,1205,1997,1280,1997,1905,737,623,735,737,
  132,101,1603,1184,1644,1603,1644,174,1999,1997,1184,1644,1203,
  1999,1279,1999,1997,1999,1999,1997,1603,1644,1999,174,1995,
  1279,1997,1644,1997,1999,1999,1997,1997,1999,1997,1999,1997,
  1903,1905,1905,1905,1903,1903,1999,1997,1999,1997,627,680,227,
  627,83,1635,1193,1644,1635,1644,233,1999,1997,1193,1644,1276,
  1999,1276,1999,1999,1997,1999,1995,1635,1644,1997,233,1997,
  1276,1997,1189,1997,1999,1999,1997,1995,1999,1997,1997,1905,
  1644,1903,1644,1644,1644,1903,1905,1997,1905,1905,552,152,128,
  390,1389,1040,1519,1389,1519,52,1907,1905,1040,1519,857,1907,
  1042,1905,1907,1907,1907,1905,1389,1519,1907,52,1905,1042,1907,
  1039,1907,1907,1907,1905,1905,1907,1903,1907,1884,1629,1645,
  1645,1645,1629,1644,1907,1905,1907,1884,737,623,426,1603,1184,
  1644,1603,1644,174,1999,1999,1184,1644,1203,1997,1279,1999,
  1997,1997,1997,1997,1603,1644,1999,174,1997,1279,1999,1644,
  1999,1997,1999,1999,1997,1999,1997,1999,1999,1905,1905,1903,
  1903,1905,1905,1997,1999,1997,1999,627,398,1635,1193,1644,1635,
  1644,233,1997,1999,1193,1644,1276,1999,1276,1999,1997,1999,
  1999,1997,1635,1644,1999,233,1997,1276,1999,1189,1999,1999,
  1997,1999,1997,1997,1997,1280,1997,1903,1205,1644,1644,1903,
  1644,1905,1905,1905,1997,390,1389,1040,1519,1389,1519,52,1907,
  1907,1040,1519,857,1907,1042,1907,1905,1907,1907,1905,1389,
  1519,1907,52,1903,1042,1905,1039,1905,1907,1907,1907,1905,1907,
  1905,1905,1907,1645,1644,1629,1629,1645,1645,1884,1907,1884,
  1907,1203,902,1203,1203,1203,57,1282,1282,902,1203,893,1282,
  883,1282,1282,1280,1282,1279,1203,1203,1280,57,1280,883,1282,
  891,1282,1282,1282,1282,1279,1282,1280,1280,1282,1204,1203,
  1204,1204,1204,1203,1282,1280,1282,1282,387,495,128,333,22,
  1491,1648,52,128,376,1427,376,1427,1491,1650,1531,1867,128,
  128,1491,7,1453,387,1491,495,178,178,582,582,1469,1479,1867,
  1907,1531,1322,1430,1372,1372,1430,1322,1556,1531,1556,1907,
  387,387,387,6,415,415,38,376,349,98,38,998,1237,998,1131,
  1280,52,61,1179,20,1190,333,98,61,1187,998,1237,998,1190,
  1277,1119,1282,989,1199,937,1061,937,1199,1061,1206,1206,1282,
  989,333,128,22,1648,1491,61,495,28,1343,387,178,582,582,1097,
  985,128,109,178,22,1095,61,1420,333,1343,1427,1491,1650,115,
  622,621,847,1503,463,463,34,1373,1305,1373,1503,167,646,646,
  495,22,1650,1343,387,495,28,1491,61,582,582,178,1868,1453,
  128,333,178,22,1469,61,1427,109,1343,1650,1491,1427,1453,1868,
  1469,1556,1907,1430,1372,1322,1430,1322,1372,1531,1556,1907,
  1531,22,1343,1650,376,128,376,1420,52,1650,1491,1427,622,621,
  128,495,1491,7,115,387,1343,128,178,582,582,178,1095,987,
  1095,646,646,1305,1373,1373,463,463,34,169,1503,847,1503,84,
  84,20,7,6,84,20,26,11,26,252,156,7,22,11,3,156,6,84,22,
  11,26,11,26,156,143,303,180,314,128,180,128,180,128,128,180,
  180,180,314,501,998,582,31,522,1164,1361,688,1683,2001,1920,
  178,1427,291,26,1983,98,336,1420,1361,1995,1683,1988,1875,
  2001,1989,1764,2001,1809,1774,1336,1905,1665,1877,1861,1903,
  2001,1999,1187,178,397,660,1179,1995,1683,1988,1999,1999,178,
  1343,1683,11,1771,415,501,1491,218,1361,658,1683,1997,1985,
  1999,2001,1999,1608,1903,1645,1872,1736,1293,1900,1995,1995,
  1995,387,349,1237,333,1237,998,1179,1277,1190,387,387,998,6,
  1119,38,998,61,415,415,98,98,1280,1131,1190,1206,1282,937,
  1061,1199,1199,1061,937,989,1282,989,1206,376,582,387,1491,
  1650,1491,987,1095,333,128,1427,22,1095,52,178,128,1650,1343,
  1420,1343,621,622,115,1503,847,463,34,463,1305,1373,1373,1503,
  646,646,169,397,349,835,835,835,1079,1280,376,28,835,6,1078,
  349,31,28,397,31,397,31,1280,1079,1078,1282,1146,1047,1047,
  1206,1047,1206,1047,1146,1282,1146,1146,1241,1954,1361,1988,
  2001,1997,582,1491,1361,11,1997,98,522,1343,658,1683,218,1361,
  1999,1878,1997,1999,1995,1293,1872,1736,1903,1645,1608,1995,
  2001,1900,1999,1179,998,1237,915,907,387,61,998,6,830,38,
  1164,387,415,98,98,415,436,74,436,929,929,28,378,378,894,
  894,801,764,441,81,441,522,336,2001,1997,1491,582,522,11,
  1771,998,1361,178,1683,688,1361,291,1999,1985,1997,1999,2001,
  1608,1645,1903,1736,1872,1293,1900,1995,1995,1995,522,1985,
  1999,1427,178,336,26,1997,1179,291,178,1995,1361,1954,1361,
  1997,2001,1771,1995,1995,1736,1293,1872,1608,1903,1645,1995,
  1999,2001,1900,1999,1999,1491,178,522,11,1920,998,1683,582,
  1683,291,1361,688,1989,1901,1999,2001,1861,1336,1809,1774,1877,
  1905,1702,1766,1999,1903,2001,736,1479,622,1901,143,736,74,
  1999,1531,1985,2001,1878,1999,1999,1976,1999,1656,2001,1895,
  1903,1895,1903,1329,1329,1656,2001,2001,2001,1469,115,1989,156,
  672,436,1771,1453,1997,1875,1999,1997,1997,1999,1997,1995,1789,
  1905,1905,1905,1457,1854,1457,1789,1999,1999,1999,495,1650,22,
  1867,376,582,495,1648,1491,1427,1491,1867,1531,1453,1531,1556,
  1372,1322,1430,1322,1372,1430,1907,1907,1531,1556,582,22,621,
  387,1650,333,1491,1648,1343,1420,985,1097,1095,167,646,1373,
  1373,1305,463,34,463,646,847,1503,1503,26,1999,1237,688,582,
  1988,1683,1988,1683,1999,1999,1920,1999,1903,1877,1702,1905,
  1336,1774,1809,2001,2001,1861,1766,303,20,26,22,84,84,84,84,
  156,251,156,180,180,180,128,128,128,128,180,314,180,314,180,
  436,1999,1867,1999,1989,1997,1999,1997,1999,1997,1789,1789,
  1905,1905,1905,1457,1457,1854,1995,1999,1999,1999,415,387,1179,
  1164,1241,1164,907,915,830,441,81,894,801,894,28,378,378,441,
  929,929,764,1648,1683,1988,1361,1954,1997,1999,1999,1900,1999,
  1645,1903,1608,1872,1293,1736,2001,1995,1995,1995,1491,1420,
  1343,1648,1453,1531,1867,1556,1531,1372,1430,1322,1372,1322,
  1430,1907,1556,1531,1907,501,660,501,1999,1999,1771,1995,1995,
  1872,1293,1736,1608,1645,1903,1995,2001,1999,1900,522,336,1920,
  2001,1983,1903,2001,1905,1877,1665,1809,1336,1774,1999,1764,
  2001,1861,522,1997,2001,1997,2001,1900,1903,1608,1645,1293,
  1736,1872,1999,1999,1995,1995,1771,1999,1999,1995,1995,1872,
  1736,1293,1645,1608,1903,1995,1900,1999,2001,736,672,1999,1999,
  1457,1457,1854,1905,1905,1905,1999,1995,1789,1789,736,2001,
  2001,1903,1329,1329,1895,1895,1903,2001,1656,2001,1656,1999,
  1999,1457,1854,1457,1905,1905,1905,1999,1789,1789,1995,737,
  1903,1903,1907,169,474,167,674,1966,1599,1645,1903,1907,1903,
  474,169,167,737,1599,1645,1344,455,455,1438,1438,1345,1907,
  167,474,169,478,1345,1438,1438,1903,169,169,474,1438,1345,
  1438,1903,475,169,169,455,455,169,1903,1903,1907,478,169,1907,
  1903,1903,474,1903,1907,1903,1645,1344,1645,737,674,737,737,
  737,497,736,663,743,737,661,742,368,736,736,496,486,333,736,
  737,636,736,496,486,710,344,736,639,639,666,666,736,333,736,
  736,666,333,556,486,570,556,636,737,737,737,737,472,472,737,
  737,737,472,471,472,472,737,737,737,741,743,308,734,736,288,
  283,694,490,1905,1907,1645,1905,1206,1907,1999,1907,1905,1645,
  1905,1970,1280,1997,1907,1999,2001,2001,1907,1206,1999,1905,
  2001,1277,1907,1905,1907,1999,1999,1999,2001,1999,2001,1907,
  1905,1999,2001,2001,2001,1999,2001,1809,2001,2001,1999,743,742,
  743,208,315,743,742,187,1905,1907,1645,1905,1206,1903,2001,
  1905,1905,1645,1905,1970,1280,1997,1907,1999,2001,2001,1907,
  1195,2001,1905,2001,1277,1905,1905,1905,1999,2001,1997,2001,
  2001,1999,1901,1907,2001,1999,1999,1999,2001,2001,1905,2001,
  1999,2001,695,270,529,202,677,301,492,1905,1907,1645,1905,983,
  1999,2001,1907,1905,1645,1997,1969,1277,1997,1907,1999,1999,
  2001,1907,983,2001,1997,2001,1010,1907,1280,1907,1997,2001,
  1999,2001,2001,2001,1645,1645,1907,1907,1999,1995,1907,1282,
  1808,1282,1999,1907,742,695,742,742,297,189,1903,1905,1644,
  1903,1205,1905,1999,1903,1903,1644,1882,1969,1279,1997,1903,
  1997,1999,1999,1905,1205,1999,1882,1997,1276,1903,1903,1903,
  1997,1999,1995,1999,1999,1999,1905,1903,1997,1999,1999,1999,
  1997,1997,1901,1997,1999,1997,684,743,218,742,176,1905,1903,
  1645,1905,983,1999,2001,1905,1905,1645,1997,1970,1277,1999,
  1907,1997,2001,1999,1907,983,1995,1997,2001,1010,1905,1280,
  1905,1999,2001,1997,1999,2001,2001,1905,1645,1907,1999,1907,
  1903,1907,1999,1645,1999,1907,1907,737,283,308,646,1905,1884,
  1905,1905,1277,1282,2001,1806,1905,1753,1280,1970,1206,1997,
  1907,1999,2001,2001,1907,1277,2001,1280,2001,1105,1807,1280,
  1907,1999,2001,1997,2001,1993,1999,1903,1907,2001,2001,2001,
  2001,2001,1999,1809,1999,2001,2001,743,742,643,1905,1907,1645,
  1905,1195,1907,2001,1907,1905,1645,1905,1969,1280,1999,1905,
  1997,1999,2001,1907,1206,2001,1905,2001,1277,1907,1905,1907,
  1997,2001,1999,2001,2001,2001,1907,1907,2001,2001,1999,1999,
  2001,2001,1905,2001,1999,2001,742,567,1905,1907,1645,1905,983,
  1999,1999,1907,1905,1645,1997,1970,1277,1999,1905,1999,2001,
  1995,1903,983,2001,1997,2001,1010,1907,1280,1907,1999,1995,
  1999,2001,1999,2001,1206,1905,1999,1282,1907,1903,1999,1907,
  1645,1907,1907,1999,566,1903,1905,1903,1903,1276,1280,1999,
  1806,1903,1752,1279,1969,1205,1997,1903,1997,1999,1999,1905,
  1276,1999,1279,1997,1116,1805,1279,1903,1997,1999,1997,1999,
  1999,1999,1903,1905,1999,1997,1999,1999,1999,1999,1901,1999,
  1999,1999,1903,1905,1642,1903,977,1645,1907,1645,1903,1642,
  1620,1837,1046,1905,1645,1903,1907,1905,1905,977,1905,1644,
  1907,961,1645,1205,1602,1905,1907,1905,1905,1907,1907,1566,
  1568,1907,1905,1907,1803,1907,1900,1551,1905,1907,1907,699,538,
  298,420,662,813,1671,196,175,353,1367,364,1700,1289,1975,1726,
  1993,43,68,882,196,1355,340,1310,450,155,298,740,741,1678,
  1901,1999,1789,1458,1905,1999,1692,1854,1995,1662,1300,1659,
  1905,1999,540,662,423,48,737,643,43,541,699,40,32,1690,1670,
  1658,1712,2001,48,32,1763,662,1712,425,36,43,1419,1667,1402,
  1738,1760,1991,1760,1656,1329,2001,1903,1903,1903,2001,1903,
  1329,1895,2001,1895,538,52,541,1649,1374,175,495,175,1483,387,
  177,451,346,1088,1088,36,59,184,456,984,59,1323,456,1285,
  1489,1501,1865,169,646,646,1373,1373,646,646,182,1500,1500,
  844,1298,182,646,646,420,699,1938,1636,351,456,196,1353,86,
  686,487,232,1987,1726,43,340,199,450,1355,68,1326,196,1307,
  1911,1676,1358,1678,1999,1734,1458,1789,1999,1905,1692,1995,
  1854,1662,1300,1659,1999,1905,423,993,1158,340,59,340,952,38,
  787,938,969,408,408,32,337,775,68,72,337,943,68,60,420,423,
  79,765,929,929,339,339,1204,1204,780,410,409,73,28,780,1204,
  1204,1009,944,671,36,43,1005,447,740,36,742,2001,1712,48,425,
  48,43,1712,32,945,662,36,740,48,742,1760,1716,2001,1329,1656,
  1903,2001,1733,2001,1903,1903,1329,1895,1895,2001,646,1672,582,
  275,513,998,1705,491,1867,1995,1928,47,973,300,462,1921,98,
  454,1315,1416,1999,1842,1990,1900,2001,1999,1645,1899,2001,
  1999,1903,1995,1999,1978,1329,1907,2001,1999,1326,127,347,453,
  957,1894,1284,1823,1900,1894,36,943,844,134,1475,339,449,1310,
  126,1636,635,1590,1705,1905,1907,1548,1328,1645,1907,1634,1900,
  1907,1572,1303,1901,1905,1729,456,450,1945,440,1911,1307,856,
  1993,1355,662,420,1676,196,1726,68,1636,298,487,686,200,205,
  1999,1678,1901,1300,1789,1659,1905,1999,1995,1662,1854,1458,
  1999,1692,1905,539,581,387,1466,1430,1474,984,1088,540,59,
  1429,539,1088,52,127,175,1430,1466,1429,1464,646,646,169,1373,
  1298,646,182,646,844,1500,1500,1373,646,646,182,461,364,953,
  1076,1012,1355,1993,662,68,1223,298,1726,422,134,196,621,195,
  736,235,1999,1901,1678,1789,1300,1905,1692,1999,1662,1995,1854,
  1458,1999,1905,1659,1230,1969,1417,1969,1970,1912,709,791,1831,
  255,1929,85,607,1368,485,1833,257,1739,1970,1834,1969,1348,
  1833,1835,1411,1968,1967,1748,1832,1816,1968,1835,1411,1149,
  1021,1221,911,832,447,16,1182,86,911,38,1066,440,366,103,93,
  371,441,81,441,800,861,100,441,441,910,759,910,861,441,100,
  441,564,741,1993,1918,1667,420,662,195,1726,970,1636,298,1495,
  731,1693,298,1999,1997,1962,1351,1789,1905,1905,1999,1999,1916,
  1854,1458,1936,1942,1979,457,1657,1814,1419,60,646,621,1717,
  940,126,155,1435,1495,1813,1482,1394,1907,1437,1311,1309,1907,
  1439,1894,1488,1669,1501,1418,1894,1907,1439,1927,1977,1679,
  106,703,244,1923,986,1638,704,1497,191,1823,741,1997,1781,
  1999,1663,1644,1781,1999,1997,1997,1972,1997,1456,1997,1781,
  1999,666,1712,410,1721,1355,666,72,1900,1726,1657,1987,1721,
  1930,1986,1991,2001,1334,1685,1995,2001,1995,2001,1685,1685,
  1334,1959,1959,1995,1712,72,1985,1726,666,408,1475,1355,1717,
  1726,2001,1925,1991,2001,1991,1685,1334,1995,1959,1959,1685,
  2001,1685,1334,1995,2001,1995,425,1402,699,2001,425,643,671,
  1670,1690,1763,1689,1991,1760,1716,1329,1329,1895,1895,2001,
  1903,1903,2001,1656,2001,1904,1733,424,340,410,337,1158,420,
  938,787,775,790,929,765,929,28,339,780,1204,1204,410,73,411,
  339,1204,780,1204,736,2001,1271,643,728,1813,1693,1956,1701,
  2001,1999,1995,1699,1329,1999,1995,1938,1907,1933,2001,1868,
  2001,1907,1904,1987,422,347,351,1076,953,1223,1013,1901,1999,
  1694,1458,1300,1999,1659,1905,1662,1854,1995,1789,1905,1999,
  1692,408,1894,1993,1814,1918,1985,1993,2001,1986,1991,1334,
  1334,1959,1959,1995,1685,1685,1973,1685,2001,1995,1995,339,340,
  940,970,1271,971,917,917,761,339,28,931,766,931,74,410,410,
  339,931,931,766,1671,1284,1894,844,1894,1905,1705,1907,1303,
  1328,1634,1907,1645,1900,1572,1907,1548,1905,1901,1729,1289,
  1700,882,1413,1734,1694,1999,1300,1458,1692,1999,1905,1854,
  1662,1995,1789,1905,1659,1999,564,646,543,1907,1394,1437,1418,
  1309,1894,1439,1907,1488,1501,1669,1311,1907,1894,1439,662,736,
  1997,1999,1997,1458,1789,1936,1997,1942,1999,1854,1916,1351,
  1905,1999,1905,742,1999,2001,1995,1868,1329,2001,1903,1907,
  1907,2001,1933,1699,1999,1938,1995,1880,1997,1999,1737,1811,
  1993,1999,1880,1901,1890,1992,1668,1880,1993,1999,737,674,1903,
  1903,1903,1903,1645,1645,1645,2001,1907,2001,1907,1907,737,
  1907,1903,2001,1907,1907,1645,2001,1645,1903,1903,1645,1903,
  1903,1907,1903,1645,1903,2001,1645,1645,1903,1907,1907,2001,
  449,1907,1903,1903,164,468,164,449,1903,1907,1903,1903,1907,
  1903,469,164,164,449,1903,1903,1907,737,737,1997,2001,1997,
  1903,314,674,314,674,2001,1997,1997,1903,314,314,674,1997,
  1997,2001,1907,674,314,314,666,666,164,1997,1997,2001,666,164,
  1997,2001,1997,469,2001,1997,1997,1907,1903,1903,737,674,737,
  741,743,288,742,743,315,202,674,441,1907,1905,1645,1905,1206,
  1905,1997,2001,1907,1645,1905,2001,1280,1999,1999,1907,2001,
  2001,1905,1195,1997,1907,2001,1277,1999,1905,2001,1907,1905,
  2001,2001,1999,2001,2001,1999,1999,2001,2001,1907,1901,1907,
  2001,2001,2001,1999,743,528,695,208,288,743,743,98,1907,1905,
  1645,1905,1206,1905,1999,1999,1907,1645,1905,2001,1280,1999,
  1999,1907,2001,2001,1905,1206,1999,1907,2001,1277,1997,1905,
  1999,1907,1907,1999,2001,2001,1999,1999,2001,2001,1999,1999,
  1905,1907,1903,1999,2001,1999,2001,743,293,741,202,500,287,
  415,1907,1905,1645,1905,983,1997,1999,2001,1907,1645,1997,1999,
  1277,1999,1999,1907,1999,2001,1905,983,1999,1999,2001,1010,
  1999,1280,2001,1905,1907,2001,2001,2001,2001,1907,1907,1907,
  1907,1999,1905,1645,1206,1999,1282,1999,1907,695,743,741,743,
  208,98,1907,1905,1645,1905,1206,1905,1999,1999,1907,1645,1905,
  2001,1280,2001,1997,1907,2001,2001,1905,1206,1999,1907,1999,
  1277,1997,1905,1999,1907,1907,1999,2001,1993,2001,2001,1999,
  1999,2001,2001,1907,1905,1905,2001,1999,2001,1999,742,742,293,
  742,66,1905,1903,1642,1903,982,1995,1997,1997,1905,1642,1995,
  1999,1271,1999,1997,1903,1999,1992,1882,982,1995,1997,1999,
  1004,1995,1279,1979,1905,1905,1979,1997,1999,1999,1997,1905,
  1905,1997,1905,1644,1644,1903,1905,1997,1905,1905,674,287,315,
  441,1907,1905,1905,1905,1277,1280,1999,1999,1903,1905,1263,
  2001,1105,1999,1999,1907,2001,2001,1905,1277,1999,1282,2001,
  1206,1999,1280,2001,1807,1807,1999,2001,2001,1999,2001,2001,
  2001,2001,2001,1907,1907,1901,2001,1999,2001,2001,743,743,441,
  1907,1905,1645,1905,1206,1905,1999,2001,1907,1645,1905,1999,
  1280,2001,1997,1905,1999,2001,1905,1206,1999,1903,2001,1277,
  1999,1905,2001,1905,1907,2001,2001,2001,2001,2001,2001,2001,
  2001,1999,1901,1907,1907,1999,2001,1999,2001,741,415,1907,1905,
  1645,1905,983,1997,1997,2001,1907,1645,1997,2001,1277,2001,
  1997,1907,2001,2001,1905,983,1999,1999,1995,1010,1999,1280,
  2001,1907,1905,2001,2001,1999,2001,1282,1999,1999,1282,1907,
  1645,1905,1645,1907,1907,1907,1999,441,1903,1905,1905,1905,
  1277,1263,1999,2001,1907,1905,1280,2001,1105,2001,1997,1907,
  2001,2001,1901,1277,1999,1261,1999,1206,1997,1280,1999,1807,
  1807,2001,2001,2001,2001,1999,2001,2001,1999,2001,1907,1907,
  1907,2001,2001,2001,2001,1280,1279,1183,1279,827,1194,1280,
  1282,1280,1183,1194,1282,884,1282,1280,1205,1282,1267,1279,827,
  1279,1187,1282,817,1280,929,1282,1206,1206,1282,1280,1282,1282,
  1280,1282,1282,1280,1282,1161,1161,1157,1282,1280,1282,1282,
  699,540,43,423,662,1738,1402,48,36,671,1712,446,1763,1658,
  1670,1712,2001,43,32,1690,48,1712,424,1667,662,47,36,643,737,
  1716,1760,1991,2001,1903,1903,2001,1733,1329,1656,1329,1903,
  1895,1895,2001,538,450,340,196,741,740,43,456,351,282,86,882,
  1975,1289,1355,1987,196,68,1700,662,1726,421,298,298,1315,
  1310,1671,813,1694,1999,1901,1995,1662,1999,1905,1692,1300,
  1789,1458,1854,1659,1999,1905,456,59,456,1865,1501,36,495,175,
  1496,387,184,346,451,984,1088,175,59,177,541,1088,52,1489,
  539,1343,1323,1374,1649,169,646,646,1500,844,646,646,182,1298,
  1373,1373,1500,182,646,646,340,351,1413,882,699,538,196,1688,
  86,728,704,155,1987,1355,298,421,298,662,1726,68,1700,196,
  813,1671,1310,1315,1734,1999,1678,1662,1995,1999,1659,1905,
  1789,1300,1458,1854,1905,1999,1692,420,971,1271,424,59,420,
  993,16,1271,986,940,408,408,68,337,970,32,72,337,970,68,98,
  339,339,98,929,765,929,409,410,780,1204,1204,339,339,28,73,
  1204,780,1204,1013,1223,671,175,298,999,440,736,244,621,1993,
  1726,196,340,195,43,1355,68,953,450,282,347,134,462,1901,
  1678,1999,1854,1995,1692,1999,1905,1789,1458,1300,1662,1905,
  1659,1999,742,1689,550,235,702,1147,1701,741,1482,1993,1925,
  205,790,298,742,1930,79,736,1358,1867,1894,1590,1990,1880,
  1999,1997,1890,1992,1999,1993,1880,1668,1737,1811,1901,1880,
  1999,1993,1763,184,742,743,1204,1956,1823,1813,1985,2001,199,
  775,1693,48,1721,423,662,1676,300,844,635,1842,1999,1995,2001,
  2001,1933,1903,2001,1907,1699,1868,1329,1907,1999,1995,1938,
  541,662,1993,447,1986,1679,1419,2001,1712,662,425,1667,48,
  1712,32,1690,43,737,643,36,47,2001,1716,1760,1903,2001,1895,
  1895,2001,1656,1329,1329,1903,2001,1903,1733,456,551,387,1501,
  1861,1285,1088,984,538,52,1489,541,1088,59,177,175,1649,1374,
  1323,1343,646,646,169,844,1500,646,182,646,1373,1298,1373,
  1500,646,646,182,740,440,1223,1012,1076,1726,1993,450,68,953,
  43,1355,340,195,196,462,134,347,282,1999,1694,1734,1995,1854,
  1659,1905,1999,1458,1789,1300,1662,1999,1692,1905,1282,1992,
  1860,1892,1995,1928,683,968,1762,44,1922,90,730,1317,679,1444,
  161,1740,2001,1907,1999,1999,1995,1879,1999,2001,1765,1585,
  1330,1978,2001,1901,1999,1204,1165,1106,911,911,364,38,1148,
  32,832,38,1148,364,415,60,60,415,441,81,441,910,910,100,441,
  441,861,861,800,759,441,100,441,703,646,2001,1985,1676,424,
  662,48,1721,775,1693,199,1844,643,844,300,2001,1995,1999,1933,
  2001,1903,1907,2001,1868,1699,1329,1907,1938,1995,1999,457,
  1923,1977,856,106,741,742,1927,969,295,235,1999,1638,1823,
  1867,1997,1999,1781,1972,1997,1999,1781,1997,1456,1663,1644,
  1997,1997,1999,1781,1717,1814,1307,60,564,36,1657,938,1495,
  487,1416,126,1284,491,1394,1437,1907,1669,1501,1439,1907,1894,
  1418,1311,1309,1488,1894,1439,1907,666,1726,408,1726,1712,666,
  72,1918,1355,1926,1901,1475,1921,2001,1991,1986,1685,2001,1959,
  1959,1995,1685,1334,1334,1685,2001,1995,1995,1355,72,1918,1712,
  666,408,1726,1726,1921,1475,1901,1926,1991,1986,2001,1973,1685,
  1995,2001,1995,1334,1685,1334,1685,1959,1959,1995,422,1974,699,
  1993,340,721,353,1938,1636,1326,1672,1999,1901,1678,1662,1854,
  1905,1659,1999,1458,1300,1789,1995,1999,1905,1692,420,425,408,
  337,787,340,993,1158,943,973,929,929,765,73,410,1204,780,
  1204,339,28,339,411,1204,1204,780,740,1987,787,731,686,1999,
  1636,1894,1705,1999,1997,1962,1916,1854,1979,1942,1936,1458,
  1351,1789,1999,1999,1905,1905,2001,424,740,699,1009,944,944,
  1009,1760,1991,1760,1903,1903,2001,1895,1895,1329,1329,1656,
  2001,1903,2001,1904,408,1993,1993,1995,1900,1900,1995,1991,
  2001,1991,1685,1685,2001,1995,1995,1334,1334,1685,2001,1959,
  1995,1959,420,420,973,943,1158,993,761,917,917,410,74,931,
  931,766,28,339,339,410,766,931,931,1911,1705,1894,1636,1999,
  1997,1962,1999,1854,1916,1905,1999,1905,1351,1458,1789,1999,
  1940,1997,1936,1672,1326,1636,1938,1678,1901,1999,1854,1662,
  1905,1999,1659,1300,1458,1789,1995,1692,1905,1999,646,454,500,
  2001,1999,1900,1978,1999,1999,1907,2001,1645,1329,1899,1995,
  2001,1999,1903,449,454,1905,1907,1705,1572,1907,1729,1901,1905,
  1548,1303,1328,1900,1645,1907,1634,646,1705,1907,1905,1907,
  1572,1907,1645,1634,1303,1548,1328,1900,1901,1729,1905,1900,
  1999,2001,1999,1978,1999,2001,1903,1329,1645,1899,1995,1907,
  1999,2001,737,674,1645,2001,1907,1907,2001,1907,1903,1903,1645,
  1645,1903,1903,737,1645,1645,1645,1903,1903,1903,1903,1907,
  2001,1907,2001,1907,2001,1645,1907,2001,1907,1903,1907,1903,
  1645,1903,1903,1645,666,1997,2001,1997,164,468,164,666,1997,
  1997,2001,1997,1997,2001,469,164,164,666,2001,1997,1997,737,
  737,1903,1903,1907,2001,314,674,314,674,1903,1907,1903,1997,
  314,314,674,1907,1903,1903,1997,674,314,314,449,449,164,1907,
  1903,1903,449,164,1903,1903,1907,469,1903,1907,1903,1997,2001,
  1997,737,674,737,2,18,320,18,4,18,320,18,476,476,494,476,
  494,519,742,742,476,494,519,535,741,736,741,741,533,743,476,
  494,719,519,743,741,719,479,719,535,742,742,743,742,742,736,
  736,736,736,697,697,736,674,697,674,697,736,18,18,320,4,18,
  18,320,493,493,494,493,494,612,742,743,493,494,612,697,739,
  712,743,743,697,741,493,494,737,612,743,739,743,370,743,697,
  742,743,741,742,743,646,644,644,646,527,527,644,441,527,441,
  527,644,18,18,4,4,4,4,128,128,128,128,128,128,275,211,128,
  128,128,229,227,211,275,229,206,206,128,128,282,128,304,227,
  301,34,301,229,275,211,206,304,314,45,296,296,45,45,45,296,
  293,45,293,45,296,2,18,4,320,18,494,494,530,494,530,549,
  697,742,494,530,549,743,735,742,743,742,743,742,494,530,729,
  549,739,735,737,368,737,743,697,742,742,695,743,742,644,644,
  742,585,585,644,527,585,527,585,644,18,4,18,320,494,494,613,
  494,613,385,697,742,494,613,385,741,644,741,743,743,741,743,
  494,613,685,385,743,644,743,368,743,741,697,742,743,695,742,
  743,736,736,743,534,534,736,697,534,697,534,736,4,18,18,128,
  128,128,128,128,128,301,229,128,128,128,301,227,282,282,211,
  304,314,128,128,211,128,206,227,229,34,229,301,301,229,314,
  304,206,45,293,293,45,293,293,293,45,293,45,293,293,18,18,
  116,116,116,116,116,145,295,228,116,116,145,286,124,198,197,
  228,283,286,116,116,198,145,283,124,286,28,286,286,295,228,
  286,273,286,30,239,239,30,178,178,239,178,178,178,178,239,2,
  530,530,626,530,626,388,742,743,530,626,388,743,613,737,697,
  743,743,743,530,626,730,388,695,613,697,368,697,743,742,743,
  743,742,741,742,697,697,742,743,743,697,535,743,535,743,697,
  610,610,626,610,626,498,742,741,610,626,498,741,610,742,535,
  742,741,742,610,626,736,498,529,610,533,368,533,741,742,741,
  742,742,743,742,697,697,742,743,743,697,697,743,697,743,697,
  476,493,128,466,466,1644,1873,34,128,510,1513,600,1494,1617,
  1873,1645,1876,128,128,1644,116,1645,559,1621,512,161,161,644,
  646,1643,1638,1876,1907,1587,1628,1907,1632,1634,1905,1645,
  1645,1634,1645,1905,493,476,493,116,644,646,128,466,466,161,
  152,1644,1907,1618,1645,1907,34,128,1494,510,1645,600,161,129,
  1513,1621,1905,1645,1625,1905,1643,1907,1628,1905,1645,1634,
  1645,1905,1634,1632,1632,1907,1644,466,128,466,1905,1645,128,
  508,128,1645,603,177,646,646,1206,1117,128,128,177,531,1206,
  173,1645,517,1645,1645,1644,1907,167,644,646,1645,1644,644,
  646,181,1645,1644,1645,1645,181,646,644,493,466,1905,1645,476,
  493,116,1621,152,625,646,167,1907,1624,128,466,158,466,1625,
  152,1513,34,1645,1907,1605,1447,1643,1905,1625,1645,1905,1905,
  1634,1645,1907,1644,1632,1634,1645,1907,1633,466,1644,1907,466,
  128,466,1645,145,1901,1645,1645,646,646,128,508,1644,128,161,
  603,1645,129,181,646,621,182,1203,1110,1203,646,644,1644,1645,
  1645,646,644,181,181,1645,1645,1644,1205,1206,510,128,128,
  1206,577,644,181,646,1907,1645,116,531,133,128,1645,132,1206,
  517,181,646,152,646,1645,1644,1907,1645,1905,1628,1907,1645,
  1907,1644,1645,1645,1645,1645,1905,736,1605,621,152,736,1903,
  1899,736,1905,1999,1997,119,1612,210,644,1997,260,736,1509,
  1905,1999,1903,1999,1901,1997,1997,1905,1997,1997,1997,1905,
  1997,1995,1997,1905,1905,1999,1995,1447,182,646,737,1901,1999,
  1907,1986,1999,2001,167,1643,1905,153,1907,742,743,1621,296,
  1907,742,1907,1999,1997,2001,2001,1997,1905,2001,1907,1999,
  1999,1907,1907,1999,1999,1997,493,466,1907,600,1880,1645,1447,
  1907,1643,476,493,1537,116,1645,152,1645,129,630,630,119,167,
  1876,1638,1643,1634,1905,1644,1634,1907,1907,1633,1645,1645,
  1907,1645,1587,466,646,603,1451,1907,1643,1117,1187,466,128,
  1637,466,1203,145,181,129,1907,1629,1612,1643,646,644,167,
  1645,1644,644,182,646,1645,1644,1645,1645,646,646,152,646,577,
  1205,1187,1206,1645,1907,510,128,1205,128,1643,577,181,127,
  646,181,644,153,1907,1644,1645,1907,1628,1644,1645,1907,1645,
  1905,1645,1645,1907,1645,1644,1999,1999,1907,2001,2001,1999,
  630,1629,1775,181,1995,301,701,1645,743,1907,238,1907,2001,
  1905,1999,1999,1997,1905,1999,2001,2001,1905,1907,1999,2001,
  1907,1997,1885,1905,1999,1274,1274,559,173,1776,132,1255,295,
  1905,558,742,301,259,742,742,122,742,1280,1279,281,742,742,
  1280,1279,1280,1280,742,293,741,732,736,1999,1997,1537,628,
  720,133,1880,1903,1905,158,1775,717,1900,236,1999,1978,1997,
  1997,1997,1903,1905,1999,1999,1995,1880,1880,1997,1997,1995,
  737,1995,2001,1447,190,732,642,1999,1901,219,161,2001,1900,
  1999,1907,1999,1999,1907,1999,1997,1999,1907,1999,1907,1999,
  1907,1999,1999,2001,1905,1999,2001,1645,182,732,153,1999,1905,
  1907,646,1907,296,1905,735,1999,1905,2001,2001,1905,1905,2001,
  1999,1999,1997,1999,1907,1999,1907,1999,737,1645,646,1880,1643,
  733,245,1999,1643,1995,2001,1905,1999,2001,1999,2001,1907,1999,
  1999,2001,2001,2001,1901,1907,1907,2001,2001,1999,1625,167,
  1979,1645,743,742,1907,1645,1999,1907,1999,1999,2001,1999,1972,
  2001,1905,1999,2001,2001,1907,1999,1903,1907,2001,2001,1999,
  493,1880,466,1907,600,630,512,1907,1645,1514,1618,1907,1630,
  1624,1634,1644,1633,1645,1907,1645,1587,1907,1907,1907,1632,
  1628,628,466,646,603,1907,517,1629,1907,1644,1645,1117,1205,
  1187,182,644,1644,1645,1645,646,152,646,646,1645,1645,1644,
  644,1999,1950,717,625,1999,1905,1979,1905,1999,1978,1979,1997,
  1879,1995,1997,1997,1880,1995,1999,1999,1999,1905,1903,1907,
  577,646,517,1206,1206,1205,1206,1645,1905,1645,1645,1644,1905,
  1645,1645,1645,1644,1907,1907,1645,1907,1644,742,2001,1907,
  2001,1999,1997,2001,2001,1999,2001,1907,1905,1999,2001,2001,
  1907,1905,2001,2001,2001,2001,1999,742,558,1905,1901,1997,1905,
  1265,1276,1255,742,281,1279,1280,1280,293,741,742,742,1280,
  1280,1279,1907,1907,2001,1905,2001,1999,1997,2001,1907,1997,
  1905,2001,1907,1999,1905,2001,2001,1999,1999,1997,1621,1515,
  1546,1907,1645,1545,1907,1645,1633,1633,1907,1645,1634,1644,
  1907,1907,1645,1634,1905,701,736,743,2001,1997,1907,1999,1997,
  1997,1907,2001,1907,1905,2001,1999,2001,1999,1905,736,737,1999,
  1999,1999,1907,1999,1997,1999,1999,2001,1905,1999,1999,1907,
  2001,1905,736,1997,1997,1997,1999,1903,1997,1905,1905,1905,
  1997,1997,1997,1997,1997,1995,1907,1997,2001,1999,1997,1997,
  2001,1907,1907,1905,2001,1999,1907,1999,1999,736,743,2001,1999,
  1905,1907,2001,2001,1999,2001,2001,2001,1907,1905,736,1999,
  1997,1997,1901,1901,1999,1997,1999,1999,1905,1999,1903,2001,
  1999,1905,2001,1903,2001,1999,2001,2001,1907,1903,1999,736,
  1999,1910,2001,314,736,314,743,2001,2001,1999,1997,1999,1999,
  736,225,289,736,1999,1999,1997,736,736,1999,1997,1999,1999,
  289,736,225,743,2001,1999,2001,2001,314,314,736,2001,1999,
  1993,2001,737,311,289,736,737,311,1993,2001,1999,742,289,1999,
  1999,1997,737,2001,2001,1999,1995,2001,1999,737,742,736,320,
  18,18,4,320,18,18,493,493,494,493,494,612,743,742,493,494,
  612,697,739,741,743,743,697,743,493,494,743,612,741,739,737,
  370,737,697,743,742,743,743,742,644,646,646,644,692,692,646,
  441,692,441,692,646,2,18,18,320,18,4,476,476,494,476,494,
  519,741,736,476,494,519,741,741,742,742,535,743,533,476,494,
  535,519,742,741,736,479,736,741,741,736,533,743,742,697,736,
  736,697,736,736,736,697,736,697,736,736,18,18,18,320,4,493,
  493,494,493,494,612,743,741,493,494,612,743,739,742,743,697,
  744,697,493,494,697,612,743,739,712,370,712,743,743,741,697,
  741,742,692,646,646,692,644,644,646,527,644,527,644,646,4,4,
  4,4,116,116,145,116,145,52,271,291,116,145,52,222,145,291,
  271,222,286,286,116,145,283,52,286,145,198,28,198,222,271,
  291,286,286,296,293,45,45,293,293,293,45,293,293,293,293,45,
  18,18,4,128,128,128,128,128,128,229,301,128,128,128,275,227,
  275,211,282,304,206,128,128,229,128,314,227,211,34,211,275,
  229,301,206,206,304,293,45,45,293,296,296,45,45,296,45,296,
  45,2,18,494,494,530,494,530,549,742,697,494,530,549,743,735,
  697,742,743,739,743,494,530,743,549,743,735,742,368,742,743,
  742,697,743,742,695,439,742,742,439,644,644,742,585,644,585,
  644,742,18,494,494,613,494,613,385,743,697,494,613,385,743,
  644,697,742,741,743,741,494,613,741,385,742,644,741,368,741,
  743,743,697,741,743,695,672,743,743,672,736,736,743,534,736,
  534,736,743,152,152,175,152,175,128,230,275,152,175,128,285,
  152,301,285,301,283,293,152,175,275,128,201,152,274,28,274,
  285,230,275,293,312,301,295,46,46,295,293,293,46,293,293,
  293,293,46,476,493,128,466,466,1645,1905,34,128,510,1447,600,
  1514,1618,1907,1625,1907,128,128,1645,116,1643,559,1537,512,
  158,161,646,644,1625,1643,1905,1905,1634,1645,1905,1633,1587,
  1907,1645,1644,1632,1628,1907,493,476,493,116,646,644,128,466,
  466,161,152,1644,1873,1617,1645,1907,34,128,1513,510,1625,600,
  158,129,1494,1617,1873,1644,1645,1876,1638,1905,1645,1907,1628,
  1587,1628,1907,1632,1633,1634,1905,1645,466,128,466,1907,1644,
  128,508,128,1645,603,152,646,646,1203,1117,128,128,181,531,
  1203,173,1637,517,1644,1643,1645,1905,161,646,644,1644,1645,
  646,644,152,1644,1645,1645,1644,181,644,646,493,466,1873,1644,
  476,493,116,1617,152,644,646,161,1907,1645,128,466,161,466,
  1643,152,1494,34,1644,1907,1618,1514,1645,1907,1630,1628,1907,
  1907,1587,1628,1905,1645,1634,1587,1645,1905,1634,466,1645,
  1905,466,128,466,1643,145,1905,1645,1643,646,646,128,508,1645,
  128,167,603,1644,129,177,646,646,152,1206,1117,1205,644,646,
  1645,1644,1644,644,646,181,152,1645,1644,1645,1206,1205,510,
  128,128,1187,577,588,153,589,1907,1643,116,531,181,128,1645,
  132,1205,517,133,589,153,588,1645,1645,1905,1628,1907,1645,
  1905,1644,1905,1645,1645,1644,1645,1628,1907,736,1618,646,153,
  737,1905,1905,735,1907,2001,1999,167,1645,296,646,1999,302,
  736,1515,1905,2001,1907,1999,1907,2001,1997,1905,2001,2001,
  1997,1905,1997,1999,1999,1905,1907,1999,1999,1514,152,588,729,
  1903,1997,1905,1999,1997,1999,119,1644,1905,152,1901,739,736,
  1610,210,1905,742,1903,1997,1997,1997,1997,1997,1905,1997,1903,
  1995,1999,1905,1903,1997,1995,1997,493,466,1907,600,1905,1645,
  1447,1907,1625,476,493,1621,116,1624,152,1644,129,625,646,167,
  119,1907,1624,1630,1587,1907,1645,1633,1905,1905,1634,1645,
  1628,1907,1644,1634,466,646,603,1644,1907,1645,1117,1203,466,
  128,1645,466,1187,145,177,129,1901,1645,1645,1644,646,646,115,
  1644,1645,646,152,644,1644,1645,1645,1644,646,644,182,589,577,
  1205,1206,1187,1643,1907,510,128,1206,128,1645,577,133,127,
  644,181,646,152,1907,1645,1628,1905,1645,1645,1644,1905,1628,
  1907,1645,1644,1907,1644,1645,1995,1999,1907,1993,2001,1990,
  646,1645,1900,181,1999,301,732,1634,719,1907,314,1905,2001,
  1907,1997,1997,1999,1907,1997,1999,1999,1907,1907,1997,2001,
  1905,1999,1903,1905,1995,1277,1277,559,173,1905,132,1255,295,
  1776,558,718,301,302,739,742,247,741,1279,1280,294,741,741,
  1279,1280,1280,1279,742,281,742,736,729,1999,1997,1605,621,
  736,152,1901,1903,1900,150,1899,736,1905,124,1999,1997,1995,
  1995,1999,1905,1903,1997,1997,1997,1905,1903,1997,1995,1997,
  737,1999,2001,1447,182,737,646,1999,1901,236,167,1999,1907,
  1986,1905,1999,2001,1905,1997,1999,2001,1905,1997,1905,2001,
  1907,1997,1999,1999,1907,1990,2001,1645,190,735,181,1999,1905,
  1777,646,1905,314,1907,736,1999,1907,1999,1999,1907,1907,1999,
  1997,1997,1999,1999,1905,1999,1905,2001,733,1645,646,1907,1645,
  737,245,1997,1643,1979,2001,1907,1997,1993,2001,1999,1901,2001,
  2001,1999,1999,1999,1907,1907,1905,2001,1999,2001,1645,161,
  1999,1643,743,742,1880,1645,1997,1907,2001,1997,1947,2001,1999,
  1999,1907,2001,1999,1999,1901,2001,1907,1901,2001,1999,2001,
  493,1907,466,1907,600,625,512,1880,1645,1447,1605,1907,1643,
  1638,1633,1645,1634,1644,1905,1644,1634,1907,1905,1907,1633,
  1645,646,466,646,603,1901,517,1451,1907,1643,1612,1117,1187,
  1205,152,646,1645,1644,1644,644,182,646,644,1645,1644,1645,
  646,2001,1999,717,646,1999,1907,2001,1905,2001,1999,1997,1997,
  1907,1999,1997,1997,1905,1999,2001,1999,2001,1905,1907,1907,
  577,644,517,1205,1187,1206,1205,1645,1907,1628,1644,1645,1907,
  1644,1628,1644,1645,1907,1905,1645,1905,1645,742,1999,1907,
  1999,1999,1999,1999,2001,2001,1999,1905,1907,2001,1999,1999,
  1905,1907,2001,1999,2001,1999,2001,718,558,1885,1905,1999,1903,
  1274,1274,1254,741,294,1280,1279,1279,281,742,742,741,1280,
  1279,1280,1880,1776,1999,1905,1997,1979,1997,1997,1879,1997,
  1905,1997,1903,1995,1880,1999,1997,1997,1995,1997,1538,1515,
  1645,1905,1645,1643,1905,1644,1574,1574,1905,1644,1633,1645,
  1907,1905,1645,1633,1907,732,736,736,1999,1997,1879,1995,1997,
  1997,1879,1997,1903,1905,1999,1995,1999,1995,1880,737,729,1995,
  2001,1997,1905,2001,1999,1997,1997,1999,1907,1999,1997,1907,
  1999,1907,736,1999,2001,1997,1999,1907,2001,1905,1905,1905,
  2001,1999,1997,1999,1997,1999,1905,1997,1997,1995,1997,1997,
  1997,1903,1903,1905,1999,1995,1905,1995,1999,737,742,1999,2001,
  1907,1905,1999,1999,2001,2001,1999,2001,1901,1907,736,1999,
  2001,2001,1905,1905,1999,2001,2001,1999,1907,1999,1907,1997,
  1999,1901,1997,1903,1997,1999,1999,1997,1905,1903,1999,736,
  1999,1997,1993,225,736,289,741,1999,1997,1999,1910,1999,1999,
  736,314,314,736,2001,1999,2001,736,736,1999,1910,2001,1999,
  314,736,314,741,1993,1999,1999,1997,289,225,736,1997,1999,
  1999,1997,736,225,290,736,736,224,1999,1997,1999,743,290,2001,
  1999,1910,736,2001,1999,2001,1999,1997,1999,736,743,736,18,2,
  18,320,4,18,494,494,530,494,530,549,743,742,494,530,549,742,
  735,742,697,743,742,743,494,530,743,549,695,735,697,368,697,
  742,743,742,743,739,743,585,644,644,585,742,742,644,439,742,
  439,742,644,18,4,4,4,4,128,128,128,128,128,227,229,211,128,
  128,227,301,295,211,229,301,293,293,128,128,275,227,270,295,
  282,27,282,301,229,211,293,270,218,145,114,114,145,145,145,
  114,29,145,29,145,114,18,18,4,320,494,494,610,494,610,419,
  741,742,494,610,419,742,644,736,535,739,742,743,494,610,739,
  419,529,644,535,345,535,742,741,742,743,741,742,585,646,646,
  585,742,742,646,439,742,439,742,646,18,4,18,116,116,116,116,
  116,145,286,286,116,116,145,295,124,197,198,198,273,286,116,
  116,228,145,286,124,228,28,228,295,286,286,286,283,283,178,
  178,178,178,239,239,178,30,239,30,239,178,18,2,519,519,484,
  519,484,730,742,741,519,484,730,742,651,719,719,535,681,532,
  519,484,535,730,741,651,741,342,741,742,742,741,532,681,741,
  393,579,579,393,579,579,579,393,579,393,579,579,18,128,128,
  152,128,152,87,280,223,128,152,87,275,173,274,293,270,293,
  201,128,152,295,87,301,173,293,27,293,275,280,223,201,312,
  283,117,178,178,117,42,42,178,32,42,32,42,178,612,612,562,
  612,562,636,743,743,612,562,636,742,598,737,743,697,735,696,
  612,562,697,636,743,598,743,342,743,742,743,743,696,736,739,
  553,578,578,553,520,520,578,432,520,432,520,578,466,466,128,
  510,577,1645,1907,128,116,592,1638,592,1638,1645,1907,1644,
  1907,128,116,1645,132,1645,554,1645,393,190,152,646,646,1645,
  1645,1907,1645,1406,1414,1645,1644,1644,1645,1066,1644,1066,
  1644,1645,466,466,466,145,646,646,128,510,577,152,145,1541,
  1907,1645,1628,1903,128,116,1645,592,1645,592,190,57,1645,
  1590,1907,1645,1645,1907,1645,1645,1414,1645,1414,1644,1644,
  1645,1066,1644,1066,1905,1406,510,34,600,1873,1515,116,504,
  160,1644,573,158,630,630,982,983,116,34,161,552,983,35,1447,
  390,1645,1514,1515,1873,159,583,583,1409,1409,465,465,160,
  1644,1409,1041,1644,60,600,510,466,577,1907,1645,466,466,145,
  1590,145,636,646,181,1905,1645,128,510,190,577,1645,145,1645,
  61,1645,1905,1645,1611,1645,1907,1645,1414,1645,1645,1406,1644,
  1905,1406,1066,1644,1066,1905,1414,600,1515,1873,510,34,600,
  1514,35,1880,1447,1513,580,584,116,504,1645,160,159,573,1645,
  60,161,644,646,167,983,983,983,465,465,1409,1409,1644,600,
  510,60,160,1041,1644,1409,1277,1277,592,160,231,1254,722,741,
  282,742,1997,1905,132,552,301,292,1905,239,1255,426,301,741,
  269,740,1905,1905,1995,1644,1905,1644,1905,1903,1997,1644,1205,
  1903,1205,1885,1905,735,1645,646,269,736,1905,1905,743,1907,
  1999,1999,182,1447,314,742,1999,243,739,1206,1907,1999,1907,
  1986,1907,2001,1999,1599,1907,1907,1905,1905,1997,1905,1280,
  1905,1206,1999,1857,1611,167,740,742,1759,1999,1907,2001,1997,
  2001,182,1645,1907,262,1907,742,743,1206,314,1905,735,1907,
  1999,1999,2001,1907,1905,1599,1907,1905,1997,1907,1206,1905,
  1280,1997,1753,466,577,1905,592,1905,1645,1645,1905,1645,466,
  466,1645,145,1645,145,1645,57,646,644,182,182,1907,1645,1645,
  1406,1645,1406,1414,1905,1905,1414,1066,1644,1206,1644,1406,
  600,644,573,1446,1907,1645,982,983,510,34,1447,600,983,35,
  161,60,1907,1512,1447,1645,547,547,159,1409,1409,510,116,600,
  1644,1409,1041,1644,390,552,116,741,722,1276,1277,1255,1903,
  1999,592,160,1255,231,1905,722,301,67,740,267,742,262,1999,
  1905,1905,1905,1644,1644,1644,1997,1885,1905,1205,1903,1280,
  1903,1612,1997,1979,1905,1999,1997,1997,644,1512,1905,267,1997,
  209,736,1203,736,1903,243,1905,1999,1905,1997,1903,1866,1590,
  1903,1997,1997,1582,1205,1995,1280,1903,1856,1757,1905,1999,
  1004,1010,554,35,1767,239,1010,41,1767,432,742,209,243,742,
  742,238,742,1203,1203,145,587,691,1276,1203,927,1276,432,239,
  554,732,742,1979,1997,1628,625,732,194,1905,1776,1905,101,
  1905,718,1777,236,1999,1997,1997,1903,1905,1459,1598,1997,1997,
  1903,1205,1903,1279,1941,1903,701,1997,2001,1645,161,727,730,
  1999,1767,219,97,2001,1905,2001,1907,1999,2001,1907,1767,1905,
  1907,1645,1997,1905,1907,1206,1997,1280,1999,1645,1997,2001,
  1645,161,674,301,1999,1767,1907,441,1900,238,1907,743,1999,
  1907,2001,1907,1599,1645,1907,1993,1997,1767,1280,1905,1280,
  1905,1907,521,1628,580,1905,1903,521,124,1997,1205,1997,1997,
  1905,1997,1999,1999,1999,1620,1905,1905,1905,1997,1997,1612,
  1205,1903,1280,1997,1905,1645,159,1999,1905,505,689,1907,1206,
  1999,1905,2001,1999,1947,2001,2001,1907,1645,1907,1907,1999,
  1905,1768,1206,1900,1282,1999,1907,466,1907,577,1903,592,646,
  393,1907,1612,1611,1645,1903,1645,1645,1414,1406,1414,1406,
  1905,1644,1406,1206,1905,1206,1644,1414,646,600,584,573,1907,
  390,1511,1905,1645,1447,983,983,983,116,510,1409,1409,1644,
  552,116,390,600,1041,1644,1409,730,1993,1999,743,441,1993,
  1905,2001,1907,2001,1999,1999,1905,1645,1905,1905,1997,1905,
  1905,1282,1999,1282,1905,1599,1999,722,740,426,1264,1276,1255,
  1255,1900,1999,1905,1644,1644,1905,1612,1885,1903,1612,1280,
  1997,1205,1997,1644,689,2001,1282,2001,1997,1999,2001,1993,
  2001,2001,1645,1645,1907,1907,1999,1905,1613,1282,1995,1282,
  1999,1907,742,432,1767,1903,1999,1765,1010,1010,1010,587,145,
  1203,1203,1276,239,554,432,691,927,1276,1203,1282,1907,1999,
  1907,2001,1999,1999,2001,1645,1905,1592,1768,1905,1997,1645,
  1282,1999,1280,1997,1905,1202,1203,1206,1282,1206,1206,1282,
  1066,1066,1066,1105,1205,1205,1066,934,1280,898,1205,1105,736,
  739,743,1993,1999,1907,1905,1905,1905,1645,1999,1905,1592,1282,
  1997,1282,1997,1645,736,742,1997,1999,1997,1628,1867,1866,1903,
  1995,1997,1590,1279,1995,1205,1997,1582,735,1999,2001,1999,
  1907,1645,1907,1599,1905,1905,1907,1280,1997,1280,1997,1905,
  1907,1999,2001,1905,1883,1905,1907,1905,1905,1599,1282,1997,
  1206,1997,1907,648,743,1907,1907,1645,1645,1999,1999,1907,1282,
  1999,1282,1900,1645,531,1907,1907,1907,1645,1905,1999,1907,
  1282,1999,1206,1999,1645,1907,1907,1645,1907,1905,1999,1907,
  1282,1999,1206,1905,1752,465,1599,1645,1905,175,499,65,587,
  1206,1905,1599,1645,1599,1905,549,128,64,577,1206,1905,1645,
  465,577,1905,1645,1206,1905,65,549,128,587,1905,1599,1206,
  1905,65,175,499,1997,1905,1280,1997,402,265,173,577,426,265,
  1280,1997,1905,393,173,1206,1905,1645,402,934,1280,1206,1280,
  1997,1905,426,393,577,320,320,18,18,4,493,493,494,493,494,
  612,743,712,493,494,612,743,739,743,742,697,741,697,493,494,
  697,612,742,739,741,370,741,743,743,712,697,743,743,527,644,
  644,527,646,646,644,692,646,692,646,644,320,18,4,18,494,494,
  613,494,613,385,743,741,494,613,385,743,644,742,697,741,743,
  741,494,613,741,385,695,644,697,368,697,743,743,741,741,743,
  742,534,736,736,534,743,743,736,672,743,672,743,736,2,18,18,
  476,476,494,476,494,519,535,719,476,494,519,742,741,741,736,
  719,742,743,476,494,741,519,742,741,742,479,742,742,535,719,
  743,533,743,674,697,697,674,736,736,697,736,736,736,736,697,
  18,18,493,493,494,493,494,612,697,737,493,494,612,743,739,
  743,741,743,743,743,493,494,743,612,742,739,742,370,742,743,
  697,737,743,697,741,441,692,692,441,646,646,692,644,646,644,
  646,692,4,116,116,145,116,145,52,222,198,116,145,52,271,145,
  271,291,283,286,286,116,145,222,52,296,145,291,28,291,272,
  222,198,286,286,286,293,293,293,293,45,45,293,293,45,293,45,
  293,152,152,175,152,175,128,285,274,152,175,128,230,152,285,
  301,275,312,293,152,175,301,128,301,152,275,28,275,230,285,
  274,293,283,201,293,293,293,293,46,46,293,295,46,295,46,293,
  476,493,128,466,466,1645,1880,34,128,510,1447,600,1447,1605,
  1907,1643,1907,128,128,1645,116,1638,559,1605,512,119,167,646,
  625,1645,1645,1907,1907,1633,1644,1907,1634,1634,1905,1644,
  1645,1633,1645,1905,493,476,493,116,646,625,128,466,466,167,
  152,1645,1905,1621,1624,1907,34,128,1447,510,1630,600,119,129,
  1514,1618,1907,1644,1625,1907,1624,1907,1644,1905,1645,1634,
  1645,1905,1633,1634,1587,1907,1628,466,128,466,1907,1451,128,
  508,128,1643,603,182,621,646,1187,1117,128,128,190,531,1205,
  173,1612,517,1644,1645,1645,1901,161,646,646,1645,1644,644,
  646,182,1645,1644,1644,1645,152,646,644,493,466,1907,1644,476,
  493,116,1618,152,646,644,161,1907,1645,128,466,161,466,1630,
  152,1514,34,1644,1873,1617,1494,1645,1907,1643,1645,1905,1905,
  1634,1645,1907,1628,1587,1634,1628,1907,1587,466,1645,1901,466,
  128,466,1645,145,1907,1644,1645,646,646,128,508,1645,128,115,
  603,1644,129,152,646,646,177,1203,1117,1187,646,644,1644,1645,
  1645,646,644,152,182,1644,1645,1644,1187,1205,510,128,128,
  1206,577,646,152,646,1907,1645,116,531,181,128,1628,132,1205,
  517,152,646,181,644,1643,1645,1907,1645,1905,1644,1907,1645,
  1907,1628,1644,1645,1644,1645,1905,732,1617,646,181,737,1905,
  1907,736,1907,2001,1995,161,1643,314,589,1997,301,729,1515,
  1905,2001,1907,1999,1907,2001,1999,1907,1999,1999,1999,1907,
  1999,1997,1997,1907,1905,2001,1997,1494,177,644,736,1885,1999,
  1899,1999,1997,1999,158,1644,1905,133,1879,718,736,1538,210,
  1905,719,1776,1997,1979,1999,1999,1995,1903,1999,1905,1997,
  1997,1879,1880,1995,1997,1995,493,466,1873,600,1873,1644,1513,
  1876,1645,476,493,1617,116,1638,152,1644,129,644,646,161,158,
  1907,1645,1625,1634,1905,1628,1632,1907,1907,1587,1628,1645,
  1905,1645,1633,466,646,603,1645,1905,1645,1117,1206,466,128,
  1643,466,1205,145,152,129,1905,1645,1643,1644,646,646,167,
  1645,1644,644,181,646,1645,1644,1644,1645,644,646,152,646,577,
  1206,1205,1206,1645,1907,510,128,1187,128,1628,577,152,127,
  588,153,589,133,1907,1643,1645,1907,1644,1628,1645,1907,1645,
  1905,1644,1645,1905,1645,1644,1999,1986,1905,2001,2001,1999,
  646,1645,1907,153,1997,302,736,1645,742,1907,314,1905,2001,
  1907,1999,1999,1997,1905,1999,2001,2001,1905,1905,1999,1999,
  1907,1997,1901,1903,1999,1274,1274,559,173,1905,132,1254,295,
  1903,558,739,302,301,718,742,245,742,1280,1279,281,742,742,
  1280,1279,1279,1280,741,294,741,736,737,2001,1999,1618,646,
  737,153,1905,1905,1905,167,1905,735,1907,236,2001,1999,1999,
  1999,1999,1905,1907,2001,2001,1997,1905,1907,1997,1999,1997,
  736,1997,1999,1514,152,729,588,1995,1903,124,150,1997,1905,
  1999,1900,1997,1999,1901,1997,1995,1997,1905,1997,1905,1997,
  1903,1997,1995,1999,1903,1999,2001,1645,181,735,181,1997,1905,
  1905,646,1905,296,1900,717,1999,1907,2001,2001,1905,1905,2001,
  1999,1999,1997,1997,1907,1997,1907,1999,737,1643,646,1907,1645,
  736,247,1997,1643,1997,2001,1907,1997,2001,2001,2001,1907,1999,
  1999,2001,2001,2001,1905,1905,1907,1999,2001,1999,1625,161,
  1999,1645,742,742,1905,1645,1997,1907,2001,1979,1947,1993,2001,
  2001,1901,1999,2001,2001,1907,1999,1905,1907,1999,2001,1999,
  493,1907,466,1905,600,644,512,1905,1645,1447,1537,1907,1625,
  1643,1632,1628,1587,1645,1907,1645,1633,1905,1907,1905,1634,
  1644,646,466,644,603,1905,517,1644,1907,1645,1637,1117,1203,
  1203,181,644,1644,1645,1645,646,152,644,646,1644,1645,1644,
  589,1999,1995,736,646,1999,1907,1993,1777,2001,1990,1999,1999,
  1905,1997,1999,1999,1907,1997,1999,2001,1999,1907,1905,1905,
  577,588,517,1205,1206,1187,1205,1643,1907,1645,1645,1628,1905,
  1645,1645,1645,1644,1905,1907,1628,1907,1644,741,1997,1905,
  1997,1997,1997,1997,1999,1999,1999,1905,1903,1997,1999,1999,
  1901,1903,1997,1999,1997,1999,1997,739,558,1903,1905,1995,1776,
  1277,1277,1255,742,281,1279,1280,1280,294,741,741,742,1279,
  1280,1279,1905,1903,1999,1905,1997,1997,1997,1999,1905,1995,
  1903,1999,1905,1997,1903,1997,1999,1995,1997,1995,1610,1515,
  1634,1880,1645,1643,1907,1645,1633,1633,1907,1645,1574,1644,
  1905,1907,1644,1574,1905,736,729,736,1999,1997,1901,1997,1995,
  1995,1905,1999,1905,1903,1997,1997,1997,1997,1903,737,736,1999,
  2001,1999,1907,1999,1997,1999,1999,2001,1905,1997,1999,1905,
  2001,1905,732,1990,2001,1999,2001,1905,1999,1907,1907,1907,
  1999,1997,1999,1997,1999,1997,1880,1997,1999,1997,1995,1995,
  1999,1880,1905,1903,1997,1997,1879,1997,1997,733,743,2001,1999,
  1901,1907,2001,2001,1999,1999,2001,1999,1907,1901,737,2001,
  1999,1999,1907,1907,2001,1999,1999,2001,1901,2001,1905,2001,
  1999,1905,2001,1907,2001,1999,1999,2001,1905,1907,1999,736,
  1999,2001,2001,314,736,289,743,1999,2001,1999,1997,1999,1999,
  736,226,224,736,1997,1999,1997,736,736,1999,1997,1993,1999,
  225,736,224,743,2001,1999,1999,2001,289,314,736,1910,1999,
  1999,1910,736,314,290,736,736,314,1999,1910,1999,741,290,1993,
  1999,1997,736,1997,1999,1997,1999,2001,1999,736,741,736,320,4,
  18,18,494,494,610,494,610,419,535,736,494,610,419,739,644,
  742,741,742,743,742,494,610,730,419,741,644,742,345,742,739,
  535,736,742,529,742,742,646,646,742,585,585,646,692,585,692,
  585,646,18,2,18,494,494,530,494,530,549,743,737,494,530,549,
  697,735,743,742,729,695,742,494,530,742,549,743,735,742,368,
  742,697,743,737,742,743,739,527,585,585,527,644,644,585,742,
  644,742,644,585,18,4,128,128,128,128,128,227,301,282,128,
  128,227,229,295,229,211,275,270,293,128,128,301,227,218,295,
  211,27,211,229,301,282,293,293,270,29,145,145,29,114,114,
  145,145,114,145,114,145,18,494,494,610,494,610,419,739,742,
  494,610,419,535,644,741,742,730,529,742,494,610,742,419,742,
  644,736,345,736,535,739,742,742,743,741,692,585,585,692,646,
  646,585,742,646,742,646,585,145,145,132,145,132,145,286,198,
  145,132,145,286,115,228,228,295,270,192,145,132,295,145,270,
  115,198,27,198,286,286,198,192,270,270,239,178,178,239,178,
  178,178,239,178,239,178,178,466,466,128,510,577,1645,1905,
  128,116,592,1645,592,1611,1645,1905,1645,1905,128,116,1612,
  132,1645,554,1628,393,177,181,646,636,1644,1645,1907,1905,
  1414,1406,1905,1414,1406,1645,1644,1406,1644,1414,1645,466,466,
  466,145,646,636,128,510,577,181,145,1645,1907,1590,1645,1905,
  128,116,1638,592,1645,592,177,57,1638,1645,1907,1541,1644,
  1907,1645,1905,1406,1645,1644,1406,1414,1645,1644,1414,1644,
  1645,1414,510,34,600,1907,1446,116,504,160,1645,573,167,646,
  644,983,982,116,34,119,552,983,35,1494,390,1542,1513,1447,
  1880,115,547,547,1644,1409,510,600,116,1409,1409,1644,1409,
  160,465,465,466,577,1907,1541,466,466,145,1645,145,646,646,
  152,1903,1628,128,510,152,577,1645,145,1638,61,1541,1907,1645,
  1638,1628,1903,1645,1644,1645,1645,1644,1414,1645,1414,1644,
  1406,1644,1645,1406,600,1447,1880,510,34,600,1513,35,1873,
  1515,1514,584,580,116,504,1644,160,159,573,1542,60,158,630,
  630,158,982,983,983,600,510,1409,1644,1409,465,465,160,116,
  1644,1409,1409,1277,1276,592,160,231,1255,722,740,269,741,
  1999,1903,132,552,258,292,1905,239,1254,426,203,742,282,741,
  1903,1900,1999,1885,1905,1644,1997,1644,1905,1644,1903,1612,
  1903,1644,1905,732,1645,630,282,701,1905,1907,743,1905,2001,
  1997,181,1513,238,742,1999,240,742,1204,1775,2001,1907,1999,
  1905,2001,1999,1905,1907,1907,1997,1645,1767,1905,1997,1599,
  1905,1907,1905,1638,158,741,742,1757,1999,1905,1979,1997,1979,
  177,1542,1903,203,1905,741,732,1200,291,1775,717,1903,1995,
  1979,1999,1997,1903,1459,1997,1598,1903,1905,1903,1628,1995,
  1776,1752,466,577,1907,592,1907,1645,1638,1907,1644,466,466,
  1590,145,1645,145,1541,57,636,646,181,177,1905,1645,1645,1644,
  1645,1414,1644,1645,1645,1406,1644,1414,1905,1406,1414,600,630,
  573,1515,1873,1644,983,982,510,34,1514,600,983,35,158,60,
  1880,1447,1513,1542,580,584,159,1644,1409,465,160,465,1409,
  1409,1644,1409,600,510,116,742,722,1277,1277,1254,1905,1997,
  592,160,1254,231,1905,722,203,67,741,282,742,203,1997,1905,
  1905,1997,1644,1644,1903,1905,1644,1905,1903,1644,1997,1644,
  1644,1999,2001,1907,1999,2001,1997,646,1447,1905,282,1999,240,
  732,1206,717,1907,291,1905,1999,1907,1999,1997,1767,1645,1993,
  1907,1907,1599,1905,1905,1999,1645,1905,1759,1905,1997,1010,
  1004,554,35,1766,239,1010,41,1758,432,741,240,240,741,741,
  238,742,1276,1203,145,691,587,1203,1203,1276,1203,691,145,587,
  735,742,2001,1997,1645,646,736,269,1907,1905,1777,107,1905,
  743,1907,236,1999,1999,1999,1997,1907,1599,1905,1907,1907,1905,
  1905,1645,1997,1905,1883,736,1999,1999,1611,167,742,740,1999,
  1759,236,107,1999,1907,2001,1777,1997,2001,1907,1997,1905,1907,
  1905,1905,1599,1907,1905,1883,1997,1907,1645,1997,1997,1612,
  119,672,261,1997,1766,1900,439,1903,238,1905,718,1995,1905,
  1999,1997,1582,1590,1997,1903,1903,1866,1995,1598,1995,1628,
  1867,521,1645,547,1905,1900,648,238,1997,1206,1979,2001,1907,
  1997,1999,1993,2001,1905,1768,1907,1999,1907,1907,1645,1905,
  1613,1999,1907,1907,1644,115,1995,1903,742,741,1879,1205,1995,
  1905,1999,1978,1992,1999,1999,1997,1612,1905,1997,1905,1620,
  1905,1903,1612,1997,1905,1905,466,1905,577,1907,592,636,393,
  1905,1645,1645,1628,1905,1645,1645,1644,1414,1406,1644,1645,
  1406,1414,1905,1645,1905,1414,1406,644,600,547,573,1880,390,
  1446,1907,1645,1494,982,983,983,160,465,1409,1644,1409,510,
  116,600,465,1644,1409,1409,741,1999,1997,718,439,1979,1905,
  1999,1900,1997,1997,1997,1995,1628,1903,1995,1866,1590,1903,
  1997,1867,1997,1582,1598,1999,722,741,426,1276,1277,1255,1254,
  1903,1999,1905,1903,1644,1905,1903,1644,1644,1644,1997,1905,
  1885,1905,1612,742,1999,1282,1999,1999,1999,1999,1999,2001,
  1947,1905,1645,1907,1999,1907,1645,1645,1999,1752,1999,1907,
  1907,741,432,1757,1905,1999,1758,1004,1010,1010,691,145,1203,
  1276,1203,145,587,691,587,1276,1203,1203,1280,1903,1999,1905,
  1971,1978,1997,1999,1903,1903,1598,1997,1459,1903,1628,1997,
  1905,1941,1903,1903,1200,1204,1206,1280,1205,1206,1282,1205,
  1066,1066,1280,1066,1066,1066,1280,1105,1205,1066,1105,732,742,
  732,1979,1997,1905,1995,1776,1903,1903,1905,1459,1598,1997,
  1752,1997,1903,1628,701,742,1997,2001,1999,1905,1907,1767,1997,
  1905,1907,1645,1997,1905,1905,1907,1599,732,1997,2001,1999,
  1999,1645,1907,1905,1599,1645,1907,1993,1905,1997,1767,1905,
  1879,1997,1999,1941,1903,1903,1997,1628,1598,1459,1997,1903,
  1903,1903,1905,521,742,1997,1905,1620,1903,1905,1905,1905,1997,
  1905,1997,1612,1612,648,1999,1907,1907,1905,1645,1907,1907,
  1999,1907,1905,1768,1613,1999,1907,1645,1999,1645,1907,1907,
  1999,1907,1905,1645,1752,577,1905,1997,1905,175,549,220,587,
  1997,1905,1905,1645,1905,1599,499,128,175,465,1905,1599,1645,
  577,465,1599,1645,1905,1599,175,499,128,587,1905,1905,1997,
  1905,220,175,549,1645,1599,1905,1645,549,128,128,465,577,128,
  1905,1645,1599,587,128,1905,1599,1645,549,1997,1905,1905,1905,
  1645,1599,577,587,465,18,18,2,530,530,626,530,626,388,743,
  697,530,626,388,742,613,697,737,730,742,743,530,626,743,388,
  741,613,743,368,743,742,743,697,743,743,695,535,743,743,535,
  697,697,743,742,697,742,697,743,4,18,128,128,152,128,152,87,
  275,293,128,152,87,279,173,293,274,295,312,201,128,152,270,
  87,283,173,223,27,223,278,275,293,201,293,301,32,42,42,32,
  178,178,42,117,178,117,178,42,18,128,128,227,128,227,38,270,
  293,128,227,38,270,128,293,293,218,206,314,128,227,218,38,
  304,128,293,27,293,270,270,293,314,206,304,293,45,45,293,45,
  45,45,293,45,293,45,45,613,613,722,613,722,388,743,697,613,
  722,388,743,530,697,743,715,743,742,613,722,742,388,743,530,
  743,345,743,743,743,697,742,739,695,697,743,743,697,535,535,
  743,741,535,741,535,743,508,603,128,549,385,1619,1905,114,
  179,391,1520,499,1582,1619,1768,1645,1907,128,179,1619,28,
  1643,498,1619,388,178,178,578,579,1645,1643,1905,1907,1645,
  1643,1907,1645,1645,1907,1644,1645,1644,1643,1907,603,508,603,
  28,578,579,128,549,385,178,128,1604,1752,1614,1645,1907,114,
  179,1583,391,1645,499,178,61,1520,1614,1752,1604,1645,1907,
  1635,1907,1643,1907,1643,1645,1643,1907,1644,1645,1628,1907,
  1643,549,231,419,1999,1860,179,733,29,1865,605,239,697,697,
  1277,1016,179,192,293,400,1277,179,1905,402,1865,1905,1858,
  1997,247,742,741,1765,1905,742,742,301,1905,1741,1903,1905,
  263,742,742,603,385,1752,1604,508,603,28,1614,128,579,578,
  178,1907,1645,128,549,178,385,1643,128,1520,52,1619,1768,1619,
  1582,1645,1907,1638,1643,1907,1907,1645,1643,1907,1643,1628,
  1645,1644,1907,1645,419,1858,1997,549,231,419,1905,117,1997,
  1858,1905,742,742,179,733,1818,29,245,605,1865,97,293,697,
  697,239,1277,1016,1276,742,742,1741,1905,1905,742,742,263,301,
  1903,1765,1905,838,834,391,29,27,838,391,439,31,427,1207,
  1108,28,400,31,27,1103,28,838,356,31,427,31,439,1103,1103,
  1280,1204,1282,1204,1282,1204,1282,1204,1203,1204,1170,1204,
  1282,520,1619,697,31,535,1619,1796,659,1797,2001,1999,178,
  1905,218,417,1995,178,497,1206,1800,2001,1800,1999,1907,2001,
  1997,1907,2001,2001,1999,1903,1999,1999,1997,1907,1905,2001,
  1999,1582,239,439,663,1582,1992,1796,1999,1997,1999,145,1860,
  1796,29,1905,579,520,1168,238,1795,687,1794,1997,1997,1997,
  1999,1997,1905,1999,1905,1997,1999,1903,1905,1995,1997,1997,
  603,385,1768,499,1905,1619,1520,1907,1645,508,603,1619,28,
  1645,128,1619,61,583,583,178,145,1907,1645,1638,1645,1907,
  1643,1645,1907,1907,1645,1644,1643,1905,1645,1645,419,697,605,
  1860,1999,1865,1016,1277,549,231,1808,419,1277,117,293,97,
  1999,1865,1905,1860,742,742,122,1905,1741,742,301,742,1765,
  1905,1903,1905,741,742,304,427,391,834,838,838,1108,1207,391,
  29,838,27,1117,391,31,27,417,31,417,29,1282,1117,1116,1282,
  1204,1204,1204,1282,1204,1282,1170,1204,1280,1204,1204,1907,
  1999,1797,1947,2001,1999,583,1865,1800,31,1999,178,531,1180,
  688,1800,291,1796,2001,1907,1997,1999,1999,1903,1999,2001,2001,
  1907,1905,1999,1999,1907,1999,1582,1619,1907,1117,1117,498,179,
  1614,28,994,128,1619,388,578,178,178,579,646,161,644,1117,
  1117,182,646,646,1117,1117,1178,1179,644,181,646,520,663,1999,
  1997,1604,692,527,29,1905,1604,1796,83,1798,657,1798,124,1999,
  1997,1995,1997,1999,1905,1905,1999,1999,1997,1903,1905,1995,
  1997,1997,535,1999,2001,1520,293,661,428,1999,1520,218,98,
  1947,1800,1993,1798,1999,2001,1905,1999,1999,2001,1903,1999,
  1907,2001,1905,1999,1997,2001,1907,1999,2001,1614,293,501,31,
  1999,1619,1799,415,1797,291,1800,657,1999,1907,1999,2001,1907,
  1903,2001,1999,1999,1999,1997,1907,1997,1907,2001,743,1645,742,
  1907,1103,743,167,1999,1206,1999,2001,1907,1997,2001,2001,1999,
  1903,2001,2001,2001,2001,2001,1907,1905,1907,1999,2001,2001,
  1645,247,1999,1108,737,646,1907,1185,1999,1907,2001,1997,2001,
  2001,1999,2001,1907,2001,2001,2001,1903,2001,1905,1903,1999,
  2001,2001,603,1907,385,1907,499,583,388,1907,1614,1520,1604,
  1907,1643,1635,1645,1643,1645,1645,1907,1645,1645,1905,1907,
  1905,1645,1643,697,419,742,605,1999,402,1865,1999,1858,1903,
  1016,1277,1276,301,742,1905,1905,1765,742,304,741,742,1764,
  1905,1905,428,2001,1768,659,415,2001,1800,2001,1795,2001,1999,
  1997,1999,1903,1999,1999,1999,1907,1999,1999,2001,1999,1907,
  1907,1282,391,417,356,838,838,838,834,1103,1282,1116,1204,
  1204,1282,1204,1204,1204,1204,1280,1282,1170,1282,1204,646,
  2001,1282,2001,1999,1999,1999,2001,1993,1999,1907,1907,2001,
  2001,2001,1907,1907,1999,2001,1999,2001,2001,578,388,1520,1619,
  1907,1604,1117,1117,988,646,182,1117,1179,1117,181,646,644,
  646,1116,1117,1177,1282,1800,2001,1800,1999,1999,1995,1999,
  1903,1999,1907,2001,1907,1999,1907,1999,2001,1997,1999,1999,
  1180,1206,1180,1277,1185,1206,1280,1185,1206,1206,1282,1185,
  1206,1132,1280,1282,1184,1206,1282,531,497,520,2001,1999,1905,
  1999,1999,1999,1903,2001,1907,1907,1999,1999,1999,1999,1907,
  535,663,1999,2001,1997,1907,2001,1999,1999,1999,2001,1903,1997,
  1999,1905,2001,1907,520,1999,2001,1997,2001,1907,2001,1907,
  1907,1903,2001,1997,1999,1997,1999,1999,1901,1997,1997,1997,
  1997,1997,1999,1905,1905,1905,1997,1997,1903,1997,1999,743,736,
  2001,2001,1907,1907,2001,2001,2001,1999,2001,1999,1903,1907,
  742,2001,2001,2001,1907,1907,2001,2001,1999,2001,1905,2001,
  1907,1999,1999,1901,1999,1901,1999,1999,1997,1999,1903,1901,
  1999,743,2001,2001,1993,314,743,289,737,1999,2001,2001,2001,
  2001,2001,743,314,290,743,1999,2001,1986,743,743,2001,2001,
  1999,2001,290,743,314,737,1993,2001,1999,2001,289,314,743,
  2001,2001,1999,2001,742,311,314,743,742,311,1999,2001,2001,
  736,314,1999,2001,2001,742,1997,1999,1999,1999,2001,2001,742,
  736,743,320,320,493,493,494,493,494,612,697,743,493,494,612,
  742,739,743,712,737,742,741,493,494,743,612,743,739,743,370,
  743,742,697,743,741,697,743,441,527,527,441,644,644,527,646,
  644,646,644,527,320,494,494,613,494,613,385,741,743,494,613,
  385,697,644,743,741,685,695,743,494,613,743,385,742,644,742,
  368,742,697,741,743,743,741,743,697,534,534,697,736,736,534,
  743,736,743,736,534,610,610,626,610,626,498,741,533,610,626,
  498,742,610,535,742,736,742,742,610,626,742,498,743,610,741,
  368,741,742,741,533,742,741,529,697,743,743,697,697,697,743,
  742,697,742,697,743,476,493,128,466,466,1645,1907,34,128,510,
  1514,600,1447,1537,1880,1630,1907,128,128,1645,116,1624,559,
  1618,512,167,119,630,630,1625,1645,1907,1907,1632,1645,1907,
  1587,1633,1907,1645,1628,1634,1644,1907,493,476,493,116,630,
  630,128,466,466,119,152,1645,1880,1537,1638,1876,34,128,1447,
  510,1643,600,167,129,1447,1605,1907,1645,1643,1907,1645,1907,
  1645,1907,1645,1633,1644,1907,1634,1587,1634,1905,1645,466,128,
  466,1907,1629,128,508,128,1644,603,190,628,628,1205,1117,128,
  128,182,531,1187,173,1645,517,1643,1612,1629,1907,167,646,646,
  1645,1645,646,646,152,1644,1645,1645,1644,182,644,646,493,466,
  1907,1645,476,493,116,1605,152,646,625,158,1905,1643,128,466,
  167,466,1625,152,1447,34,1645,1905,1621,1513,1624,1907,1625,
  1645,1907,1907,1632,1644,1905,1645,1634,1633,1645,1905,1634,
  466,1629,1907,466,128,466,1612,145,1907,1451,1637,644,646,128,
  508,1643,128,167,603,1643,129,182,621,646,181,1187,1117,1203,
  646,646,1645,1645,1644,644,646,182,152,1645,1644,1645,1206,
  1206,510,128,128,1205,577,642,133,644,1905,1645,116,531,153,
  128,1645,132,1206,517,153,644,181,646,1645,1643,1907,1645,
  1907,1645,1907,1644,1905,1645,1645,1644,1645,1644,1907,701,
  1621,646,181,736,1901,1900,717,1905,1999,1999,161,1645,296,
  647,1999,301,737,1515,1907,1999,1907,2001,1907,2001,1999,1907,
  2001,2001,1999,1905,1997,1999,1999,1905,1907,1999,1999,1513,
  181,646,736,1905,2001,1775,1999,1997,2001,161,1645,1907,181,
  1907,742,743,1621,296,1905,743,1907,1999,1995,2001,2001,1999,
  1907,2001,1905,1997,2001,1907,1905,1999,1997,1999,493,466,1905,
  600,1907,1644,1494,1905,1625,476,493,1618,116,1643,152,1645,
  129,646,644,161,161,1907,1645,1645,1632,1907,1645,1634,1905,
  1905,1634,1645,1644,1907,1628,1632,466,621,603,1645,1901,1644,
  1110,1203,466,128,1645,466,1203,145,182,129,1907,1644,1645,
  1645,646,646,161,1645,1645,646,181,644,1644,1645,1645,1644,
  646,644,181,644,577,1187,1205,1205,1644,1907,510,128,1206,128,
  1645,577,153,127,646,152,646,181,1907,1645,1643,1907,1645,
  1645,1645,1905,1644,1907,1645,1644,1907,1628,1645,1997,1999,
  1900,1979,1997,1997,644,1644,1905,152,1997,261,736,1546,742,
  1903,238,1905,1999,1905,1997,1997,1997,1905,1997,1997,1997,
  1905,1905,1995,1999,1903,1997,1901,1903,1950,1276,1265,559,173,
  1905,132,1255,295,1905,558,742,261,301,742,742,245,742,1280,
  1280,293,742,741,1279,1280,1280,1279,742,281,742,732,732,1999,
  1999,1617,646,737,181,1907,1905,1907,161,1907,736,1907,219,
  2001,1995,1999,1999,2001,1907,1907,1999,1999,1999,1907,1905,
  1999,1997,1999,720,1978,1999,1494,177,736,644,1997,1885,236,
  158,1999,1899,1999,1905,1997,1999,1880,1997,1997,1999,1880,
  1995,1903,1999,1905,1995,1997,1997,1880,1978,1999,1644,177,732,
  133,1979,1776,1905,625,1905,210,1775,717,1979,1880,1999,1999,
  1905,1880,1999,1995,1995,1997,1997,1903,1997,1879,1999,736,
  1638,644,1905,1644,736,122,1997,1545,1997,1997,1905,1997,1999,
  1999,1999,1905,1999,1999,1999,1997,1997,1901,1901,1903,1999,
  1997,1999,1643,167,1999,1645,743,742,1907,1645,1999,1901,2001,
  1999,2001,2001,2001,2001,1907,2001,2001,1999,1905,2001,1907,
  1905,2001,1999,2001,493,1873,466,1876,600,646,512,1873,1644,
  1513,1621,1876,1645,1645,1634,1645,1634,1645,1905,1628,1632,
  1907,1905,1907,1587,1645,646,466,646,603,1907,517,1645,1905,
  1645,1645,1117,1206,1206,181,646,1645,1645,1644,644,181,646,
  644,1645,1644,1645,646,2001,1999,735,646,1986,1905,2001,1907,
  2001,1999,1999,1999,1907,1999,1999,1997,1905,1999,2001,1999,
  2001,1905,1907,1907,577,646,517,1206,1205,1206,1206,1645,1907,
  1645,1645,1645,1907,1645,1644,1628,1645,1907,1905,1645,1905,
  1645,742,2001,1907,2001,1997,1999,2001,1972,2001,2001,1907,
  1903,2001,2001,1999,1905,1903,2001,1999,2001,1999,2001,742,558,
  1901,1903,1999,1905,1274,1274,1255,742,293,1280,1280,1279,281,
  742,742,741,1280,1279,1280,1907,1907,1999,1907,2001,1999,1999,
  2001,1907,1999,1907,2001,1905,1997,1907,2001,1999,1999,1997,
  1999,1621,1509,1645,1907,1645,1643,1907,1645,1634,1634,1907,
  1644,1633,1645,1907,1905,1645,1633,1907,736,737,743,2001,1999,
  1907,1999,1999,1999,1907,1999,1905,1907,2001,1997,2001,1997,
  1907,736,736,1997,1999,1997,1905,1999,1997,1997,1995,1997,1905,
  1997,1995,1905,1997,1905,701,1999,2001,1995,2001,1907,2001,
  1907,1905,1905,2001,1999,1997,1999,1997,1999,1907,1999,2001,
  1999,1999,1999,2001,1905,1905,1907,2001,1997,1907,1997,2001,
  737,743,2001,2001,1907,1903,1999,1999,2001,2001,1999,2001,1905,
  1907,733,2001,2001,2001,1907,1901,1999,2001,2001,1999,1907,
  1999,1907,2001,2001,1907,2001,1905,1999,2001,2001,1999,1907,
  1905,2001,737,1993,2001,1999,289,737,314,742,2001,1999,1995,
  2001,2001,1999,736,311,314,736,2001,1999,2001,737,736,1999,
  2001,2001,1999,314,736,311,742,1999,1993,2001,1999,314,289,
  737,1997,1999,1999,1997,736,226,289,736,736,225,1999,1997,
  1999,743,289,2001,1999,2001,736,1910,1999,2001,1999,1997,1999,
  736,743,736,320,494,494,610,494,610,419,742,535,494,610,419,
  741,644,535,736,739,741,743,494,610,739,419,742,644,742,345,
  742,741,742,535,743,742,529,439,742,742,439,646,646,742,585,
  646,585,646,742,612,612,562,612,562,636,742,743,612,562,636,
  743,598,743,737,697,736,696,612,562,697,636,739,598,743,342,
  743,743,742,743,696,735,743,432,520,520,432,578,578,520,553,
  578,553,578,520,466,466,128,510,577,1612,1907,128,116,592,
  1611,592,1645,1628,1907,1645,1903,128,116,1645,132,1645,554,
  1645,393,182,182,644,646,1645,1628,1903,1206,1644,1644,1206,
  1406,1414,1905,1406,1414,1414,1406,1905,466,466,466,145,644,
  646,128,510,577,182,145,1645,1905,1645,1645,1907,128,116,1645,
  592,1645,592,182,57,1611,1645,1905,1645,1645,1905,1645,1206,
  1644,1905,1066,1414,1406,1905,1414,1406,1406,1645,1644,510,34,
  600,1905,1511,116,504,160,1645,573,161,625,646,983,983,116,
  34,161,552,983,35,1447,390,1645,1447,1512,1907,159,580,584,
  1041,1644,552,390,116,1409,1644,1409,1409,116,510,600,466,577,
  1905,1645,466,466,145,1645,145,646,636,190,1907,1645,128,510,
  181,577,1645,145,1611,61,1645,1907,1590,1645,1645,1905,1645,
  1066,1905,1905,1066,1406,1645,1644,1406,1414,1414,1645,1644,
  600,1512,1907,510,34,600,1447,35,1907,1446,1447,547,547,116,
  504,1645,160,159,573,1645,60,167,646,644,161,983,982,983,390,
  552,1644,1041,1409,510,600,116,116,1409,1409,1644,1276,1264,
  592,160,231,1255,722,730,194,730,1999,1900,132,552,301,292,
  1905,239,1255,426,262,742,267,740,1905,1903,1999,1205,1997,
  1903,1280,1612,1905,1885,1612,1644,1644,1644,1997,736,1590,644,
  267,736,1903,1905,718,1905,1999,1997,152,1514,238,741,1997,
  209,742,1203,1905,1999,1903,1999,1905,1997,1997,1205,1997,1997,
  1279,1590,1866,1995,1903,1582,1628,1867,1995,1645,161,740,739,
  1767,2001,1905,1993,1999,1993,190,1645,1900,301,1907,742,743,
  1202,314,1907,736,1907,1999,1997,2001,1282,1997,1905,1282,1592,
  1905,1999,1645,1645,1905,1905,1997,466,577,1907,592,1907,1541,
  1645,1907,1645,466,466,1645,145,1645,145,1645,57,646,646,152,
  190,1903,1628,1645,1066,1905,1644,1066,1645,1645,1644,1414,
  1406,1645,1414,1644,600,646,573,1447,1880,1645,983,983,510,34,
  1513,600,983,35,167,60,1873,1515,1514,1645,584,580,159,1041,
  1644,600,60,510,1409,1644,1409,1409,465,465,160,742,722,1277,
  1276,1255,1905,1999,592,160,1255,231,1905,722,262,67,740,269,
  741,301,1999,1903,1905,1280,1903,1885,1205,1905,1644,1997,1644,
  1612,1905,1644,1903,1999,2001,1777,2001,2001,1999,646,1515,
  1907,269,1999,243,735,1206,735,1907,243,1907,2001,1905,1999,
  1280,1997,1905,1280,1907,1907,1905,1599,1905,1907,1645,1997,
  1767,1776,1999,1010,1010,554,35,1767,239,1010,41,1765,432,742,
  243,209,742,689,124,689,927,1276,239,432,554,1203,1276,1203,
  1203,587,145,691,732,727,2001,1999,1645,630,701,282,1907,1905,
  1907,97,1907,743,1905,219,2001,1997,1999,1280,1999,1905,1206,
  1907,1907,1997,1645,1645,1767,1905,1997,732,1997,1999,1638,158,
  742,741,1997,1757,236,101,1999,1905,1979,1905,1997,1979,1905,
  1279,1941,1997,1205,1903,1459,1997,1598,1903,1903,1905,1903,
  1999,2001,1645,161,674,301,1999,1767,1907,441,1907,314,1905,
  743,1999,1905,1993,1282,1905,1905,1282,1905,1905,1997,1905,
  1599,1905,1645,1999,648,1645,583,1907,1905,531,238,1999,1206,
  1999,2001,1905,1999,2001,1999,2001,1206,1999,1999,1282,1907,
  1907,1905,1645,1645,1907,1907,1999,1645,159,1999,1905,743,742,
  1907,1206,1999,1907,1999,1999,1947,1999,1993,1282,1900,1999,
  1282,1907,1645,1999,1645,1645,1907,1907,1999,466,1907,577,1907,
  592,646,393,1907,1645,1638,1645,1907,1644,1645,1066,1644,1644,
  1066,1645,1414,1644,1645,1645,1645,1406,1644,630,600,583,573,
  1873,390,1515,1873,1644,1447,983,982,983,60,600,1644,1041,
  1409,465,160,465,510,1409,1409,1644,742,2001,1999,743,441,
  2001,1907,1999,1907,2001,1997,1999,1280,1905,1997,1280,1767,
  1645,1993,1907,1907,1907,1599,1905,1995,722,740,426,1277,1277,
  1254,1255,1905,1997,1905,1205,1885,1997,1205,1644,1644,1903,
  1905,1905,1644,1905,1903,742,2001,1282,2001,1999,1997,2001,
  2001,1999,2001,1206,1905,1999,1282,1907,1645,1905,1907,1752,
  1907,1907,1999,742,432,1759,1905,1997,1767,1010,1004,1010,432,
  239,1276,927,1203,145,691,587,554,1203,1203,1276,1282,1907,
  1986,1905,2001,1999,1997,2001,1206,1997,1905,1282,1599,1905,
  1905,1907,1907,1905,1883,1997,1206,1206,1203,1282,1206,1205,
  1282,898,1205,1205,934,1066,1066,1205,1105,1105,1066,1066,1280,
  735,742,743,2001,1997,1907,1280,1997,1997,1206,1907,1599,1905,
  1907,1753,1907,1905,1905,736,739,1999,1999,1999,1206,1999,1997,
  1280,1905,1907,1905,1905,1857,1599,1907,1905,736,1997,1997,
  1997,1280,1903,1997,1205,1582,1590,1997,1903,1856,1903,1866,
  1995,1907,1997,2001,1280,1997,1997,1282,1645,1592,1905,1768,
  1905,1645,1905,1999,521,505,1282,1999,1905,1206,1768,1907,1999,
  1907,1907,1907,1645,1900,521,1280,1997,1997,1205,1612,1905,
  1997,1905,1905,1620,1905,1903,1282,1999,1905,1282,1613,1907,
  1999,1907,1907,1645,1645,1995,426,1280,934,1206,65,402,65,393,
  1206,1206,1280,1997,1280,1905,549,265,175,577,1905,1905,1997,
  426,577,1905,1997,1905,1905,175,549,265,393,1206,1280,1206,
  1206,65,65,402,1645,1905,1599,1645,499,128,173,577,465,128,
  1599,1645,1905,587,173,1905,1905,1997,499,1645,1599,1905,1599,
  1645,1905,465,587,577,613,613,722,613,722,388,743,743,613,
  722,388,743,530,743,697,742,739,742,613,722,715,388,695,530,
  697,345,697,743,743,743,742,743,743,741,535,535,741,743,743,
  535,697,743,697,743,535,508,603,128,549,385,1614,1907,114,
  179,391,1520,499,1520,1604,1907,1643,1907,128,179,1614,28,
  1635,498,1604,388,145,178,583,583,1645,1645,1907,1905,1645,
  1645,1905,1645,1645,1907,1645,1643,1645,1643,1907,603,508,603,
  28,583,583,128,549,385,178,128,1619,1905,1619,1645,1907,114,
  179,1520,391,1638,499,145,61,1582,1619,1768,1619,1645,1907,
  1645,1905,1645,1907,1644,1645,1643,1907,1645,1645,1645,1907,
  1643,549,231,419,1999,1865,179,733,29,1858,605,293,692,697,
  1277,1016,179,192,293,400,1276,179,1903,402,1860,1905,1865,
  1999,247,742,742,1764,1905,742,741,304,1905,1765,1905,1905,
  301,742,742,603,385,1768,1619,508,603,28,1619,128,578,579,
  178,1907,1645,128,549,178,385,1638,128,1582,52,1604,1752,1614,
  1520,1645,1907,1643,1644,1907,1907,1628,1643,1907,1643,1645,
  1645,1643,1907,1645,419,1865,1999,549,231,419,1905,117,1999,
  1860,1808,742,742,179,733,1865,29,122,605,1860,97,239,697,
  697,293,1277,1016,1277,741,742,1765,1903,1905,742,742,301,304,
  1905,1741,1905,838,838,391,29,27,838,391,428,29,428,1282,
  1103,28,400,31,27,1116,28,834,356,29,417,31,417,1108,1103,
  1282,1170,1282,1204,1280,1204,1282,1204,1204,1204,1204,1204,
  1282,531,1614,697,31,535,1619,1800,657,1800,2001,1999,178,
  1905,291,427,1997,178,663,1206,1795,2001,1800,2001,1907,2001,
  1999,1905,2001,2001,1997,1903,1999,1999,1999,1907,1907,2001,
  1999,1520,293,417,497,1520,1947,1798,2001,1999,2001,178,1865,
  1797,31,1905,578,520,1180,238,1800,688,1800,1999,1999,2001,
  1999,1999,1907,1999,1907,1999,2001,1903,1907,1999,1999,1999,
  603,385,1752,499,1752,1604,1583,1907,1645,508,603,1614,28,
  1635,128,1604,61,579,578,178,178,1907,1645,1645,1628,1907,
  1643,1644,1907,1907,1645,1643,1643,1907,1643,1645,419,697,605,
  1858,1997,1818,1016,1277,549,231,1905,419,1276,117,239,97,
  1997,1858,1905,1865,742,742,245,1903,1765,742,263,742,1741,
  1905,1905,1905,742,742,301,417,391,838,834,838,1117,1282,391,
  29,838,27,1116,391,29,27,439,31,427,31,1207,1108,1117,1280,
  1204,1204,1170,1282,1204,1282,1204,1204,1282,1204,1204,1907,
  1993,1798,2001,2001,1999,578,1858,1800,31,1997,178,520,1180,
  687,1800,291,1800,2001,1907,1999,1997,1999,1903,1997,2001,2001,
  1907,1907,1999,2001,1907,1999,1520,1604,1768,1117,1117,498,179,
  1619,28,988,128,1604,388,579,178,178,578,646,167,646,1116,
  1117,181,644,646,1117,1117,1179,1177,646,182,646,520,661,2001,
  1999,1619,697,535,31,1905,1619,1798,98,1796,659,1797,218,2001,
  1999,1999,1997,2001,1907,1905,2001,2001,1999,1903,1907,1999,
  1999,1999,527,1997,1999,1582,239,663,439,1995,1582,124,83,
  1992,1796,1999,1796,1997,1999,1905,1995,1997,1999,1903,1997,
  1905,1999,1905,1997,1997,1999,1905,1999,2001,1619,293,501,31,
  1997,1614,1795,415,1796,218,1800,659,1999,1907,2001,1999,1907,
  1907,1999,1999,1999,1999,1999,1907,1999,1903,2001,743,1643,742,
  1907,1103,742,161,1997,1206,1997,2001,1907,1995,2001,2001,1993,
  1905,2001,2001,1999,2001,2001,1907,1907,1907,2001,2001,2001,
  1645,247,1999,1103,736,646,1901,1185,1997,1907,2001,1999,2001,
  2001,2001,1999,1903,2001,1999,2001,1907,2001,1907,1907,2001,
  2001,2001,603,1768,385,1905,499,579,388,1905,1619,1520,1619,
  1907,1645,1643,1644,1643,1645,1644,1907,1643,1645,1907,1907,
  1907,1645,1645,697,419,741,605,1997,402,1860,1999,1865,1905,
  1016,1277,1277,263,742,1905,1903,1741,742,301,742,742,1765,
  1905,1905,427,1999,1907,657,415,1999,1797,1947,1799,2001,1999,
  1999,1997,1907,1999,1997,1999,1903,1999,2001,2001,2001,1907,
  1907,1280,391,439,356,834,838,838,838,1108,1207,1103,1170,
  1204,1282,1203,1204,1204,1204,1282,1282,1204,1282,1204,644,
  1997,1280,1997,1997,1997,1999,1999,1999,1999,1903,1901,1999,
  1997,1999,1901,1901,1999,1999,1999,1999,1999,579,388,1582,1619,
  1907,1619,1117,1117,994,644,181,1117,1178,1117,182,646,646,
  646,1117,1117,1179,1277,1794,1999,1796,1999,1997,1997,1999,
  1903,1997,1905,1997,1905,1997,1905,1999,1999,1997,1997,1997,
  1168,1206,1180,1282,1185,1206,1282,1184,1206,1206,1280,1132,
  1206,1185,1282,1282,1185,1206,1282,520,663,520,1999,1997,1905,
  1995,1997,1997,1903,1999,1905,1905,1999,1997,1999,1997,1905,
  535,497,1999,2001,1995,1905,2001,1999,1997,1999,2001,1903,1999,
  1999,1907,2001,1907,531,1999,2001,1999,1999,1907,2001,1905,
  1907,1903,2001,1999,1999,1999,1999,1999,1907,1999,2001,1997,
  1999,1999,1999,1907,1907,1907,2001,1999,1903,1999,2001,743,737,
  1999,2001,1903,1905,2001,2001,2001,2001,2001,2001,1907,1903,
  743,1999,2001,2001,1905,1907,2001,2001,2001,2001,1903,2001,
  1907,1999,2001,1907,1999,1907,2001,2001,2001,2001,1907,1907,
  2001,742,1999,1997,1999,290,742,289,736,1999,1999,1999,2001,
  1999,2001,743,311,314,743,2001,2001,2001,742,743,2001,2001,
  1993,2001,314,743,311,736,1999,1999,1999,1999,289,290,742,
  2001,2001,2001,2001,743,314,314,743,743,314,2001,2001,2001,
  737,314,1993,2001,2001,743,2001,2001,2001,2001,1986,2001,743,
  737,743,739,741,292,735,644,1905,1999,124,239,577,1901,600,
  1901,1905,1997,1905,1997,292,239,1903,132,1905,552,1905,426,
  301,302,742,742,1903,1905,1999,1997,1905,1905,1997,1905,1905,
  1999,1903,1905,1903,1905,1999,741,739,741,132,742,742,292,735,
  644,302,160,1905,1995,1782,1905,1997,124,239,1903,577,1905,
  600,301,79,1905,1905,1999,1901,1903,1999,1905,1997,1905,1999,
  1903,1905,1905,1999,1903,1905,1903,1999,1905,735,41,644,1999,
  1759,239,655,145,1905,591,240,735,734,1010,1006,239,41,209,
  554,1010,35,1767,432,1905,1765,1767,1999,124,742,742,1864,
  1865,742,741,238,1865,1865,1864,1865,124,689,689,741,644,1999,
  1901,739,741,132,1905,160,742,742,261,1995,1903,292,735,260,
  644,1900,160,1905,83,1901,1999,1905,1905,1903,1995,1900,1903,
  1999,1999,1903,1905,1999,1905,1903,1905,1903,1999,1905,644,
  1767,1999,735,41,644,1765,35,1999,1767,1766,742,741,239,655,
  1903,145,238,591,1905,83,240,742,742,240,1006,1010,1010,741,
  742,1865,1864,1865,689,689,124,238,1864,1865,1865,1206,1206,
  577,145,128,1206,510,589,181,588,1907,1628,132,554,152,128,
  1645,116,1206,393,181,646,153,646,1644,1645,1907,1644,1907,
  1645,1905,1645,1907,1645,1628,1645,1644,1645,1907,743,1905,742,
  153,743,1645,1907,674,1905,2001,1997,302,1765,243,646,1999,
  167,737,1206,1907,2001,1907,2001,1905,2001,1999,1905,2001,2001,
  1997,1907,1999,1999,1997,1907,1905,2001,1999,1905,240,646,737,
  1513,2001,1907,1999,1999,1999,301,1905,1905,181,1907,630,701,
  1204,291,1907,743,1907,1997,1999,2001,1999,1999,1907,1999,1907,
  1999,2001,1905,1907,1997,1999,1999,741,644,1999,600,1995,1905,
  1903,1999,1903,739,741,1782,132,1905,160,1901,79,742,742,302,
  301,1997,1905,1905,1903,1999,1905,1903,1999,1999,1905,1903,
  1905,1997,1905,1905,644,742,591,1767,1999,1903,1010,1006,735,
  41,1766,644,1010,35,240,83,1999,1767,1765,1905,741,742,238,
  1864,1865,689,124,689,1865,1865,1864,1865,741,742,238,646,510,
  1187,1187,1205,1645,1905,577,145,1205,128,1645,510,181,61,646,
  153,646,181,1905,1645,1645,1905,1645,1645,1644,1907,1645,1907,
  1644,1645,1905,1645,1645,1873,2001,1907,1999,2001,1997,742,
  1767,1905,153,1999,167,743,1206,743,1907,296,1907,1999,1907,
  1999,1997,1999,1907,1997,2001,2001,1907,1905,1999,1999,1907,
  1999,1447,1645,1905,983,982,552,35,1512,116,983,34,1447,390,
  630,167,167,630,580,159,584,1133,1134,159,580,584,1134,1134,
  1133,1134,580,159,584,743,729,2001,1997,1905,735,685,181,1907,
  1645,1900,108,1907,674,1907,219,1999,1999,1999,1997,2001,1907,
  1905,2001,2001,1999,1905,1907,1997,1999,1999,685,1999,1999,
  1901,240,729,589,1999,1447,219,108,2001,1907,2001,1900,1997,
  2001,1907,1997,1999,2001,1905,1999,1907,2001,1905,1999,1997,
  2001,1907,1997,1997,1903,209,672,152,1997,1512,1905,439,1905,
  243,1905,673,1995,1905,1999,1997,1905,1905,1997,1997,1997,1997,
  1995,1905,1995,1905,1999,742,1905,742,1905,1645,743,159,1999,
  1206,1999,2001,1907,1999,1999,1947,2001,1905,2001,2001,1999,
  2001,2001,1907,1905,1907,1999,2001,2001,1903,124,1995,1644,521,
  580,1905,1205,1997,1905,1999,1997,1992,1999,1999,1997,1905,
  1999,1997,1999,1905,1999,1885,1905,1997,1999,1999,741,1997,644,
  1999,600,742,426,1999,1905,1901,1905,1997,1905,1905,1903,1905,
  1905,1903,1999,1905,1905,1997,1999,1997,1905,1905,734,644,742,
  591,1999,432,1759,1999,1905,1767,1006,1010,1010,124,689,1865,
  1864,1865,742,238,741,689,1864,1865,1865,588,1999,1905,673,
  439,1999,1905,1999,1905,1997,1997,1997,1995,1905,1997,1995,
  1997,1905,1997,1997,1999,1997,1905,1905,1907,510,646,393,1206,
  1206,1206,1206,1628,1907,1645,1644,1645,1907,1628,1645,1645,
  1645,1905,1907,1644,1907,1645,584,2001,1282,2001,1999,1999,
  2001,1999,2001,1993,1905,1901,2001,1999,2001,1907,1907,1999,
  1997,1999,2001,2001,630,390,1513,1645,1873,1447,982,983,983,
  580,159,1134,1133,1134,159,584,580,584,1133,1134,1134,1282,
  1907,2001,1907,2001,1997,1999,2001,1905,1999,1907,1999,1907,
  1999,1907,1999,2001,1997,1999,1999,1204,1206,1206,1282,1205,
  1206,1282,1205,1206,1206,1280,1206,1206,1206,1280,1282,1205,
  1206,1282,743,737,701,1999,1999,1907,1997,1999,1999,1905,2001,
  1907,1907,1999,1999,1999,1999,1907,743,737,1997,2001,1999,1905,
  2001,1999,1997,1999,2001,1907,1997,1999,1905,2001,1907,743,
  1997,2001,1999,1999,1907,2001,1905,1907,1907,2001,1997,1999,
  1997,1999,1999,1905,1999,2001,1997,1999,1999,1999,1907,1907,
  1907,1999,1999,1905,1999,2001,742,521,1997,1999,1905,1885,1999,
  1999,1999,1997,1999,1997,1905,1905,743,1999,2001,2001,1905,
  1907,2001,2001,1999,2001,1905,2001,1907,1999,2001,1907,1999,
  1907,2001,2001,1999,2001,1905,1901,1997,742,1999,1997,1999,268,
  657,227,521,1997,1999,1999,2001,1999,2001,659,270,268,505,
  1999,2001,2001,742,505,2001,2001,1999,2001,268,659,270,521,
  1999,1999,1997,1999,227,268,657,2001,2001,1999,2001,657,270,
  221,505,742,270,1999,2001,2001,521,221,1999,2001,2001,657,
  1997,1999,1999,1999,2001,2001,742,521,505,2,18,320,18,322,
  328,4,18,320,22,18,333,468,468,449,666,4,4,333,18,449,320,
  22,18,22,22,328,322,333,468,468,737,455,474,474,334,455,737,
  455,455,334,474,474,18,18,320,468,468,4,18,18,333,320,22,
  322,328,339,408,4,4,22,18,339,18,333,320,22,22,322,328,22,
  322,328,646,463,324,327,23,463,646,463,463,23,325,327,18,18,
  164,165,4,4,4,33,4,23,23,14,163,163,3,4,7,4,34,4,33,4,
  7,14,23,23,34,163,164,167,167,167,167,34,167,167,34,34,34,
  167,167,2,448,666,18,4,320,448,18,470,333,470,322,328,4,18,
  333,4,22,320,448,18,4,18,320,18,339,339,408,327,325,463,
  646,463,325,327,23,23,463,463,646,338,411,18,4,18,338,320,
  323,22,328,468,468,4,18,22,4,333,18,338,320,4,18,18,320,
  449,449,666,474,474,455,737,455,474,474,334,334,455,455,737,
  471,33,23,22,334,333,1298,332,1291,1454,1697,7,33,114,23,
  809,22,334,333,116,163,525,615,1284,1645,1788,1364,852,1645,
  1789,1286,1460,1655,1307,824,1286,1645,1789,165,14,328,473,
  470,1685,1291,1334,1697,2001,14,165,1291,14,1301,328,473,470,
  14,165,329,470,1673,1673,2001,2001,1817,1531,2001,1531,1820,
  2001,1333,1506,1871,1871,1999,4,18,165,18,165,33,165,163,164,
  4,4,33,3,34,4,33,4,4,4,4,4,163,34,164,169,167,34,169,
  167,169,169,34,34,169,34,169,18,23,18,33,164,165,28,73,4,
  3,33,4,28,4,7,4,14,7,23,23,23,23,14,169,34,23,12,23,34,
  169,34,34,23,23,12,323,2,338,338,411,449,666,18,4,338,4,
  449,320,22,18,18,4,320,18,468,333,468,674,478,334,474,474,
  478,674,478,478,474,334,474,468,1334,1298,1685,1454,1697,23,
  33,1298,7,809,22,334,333,23,33,22,333,1645,1284,1788,1655,
  1460,1286,1789,1645,852,1364,824,1307,1645,1286,1789,448,448,
  666,339,410,18,4,448,4,339,18,333,320,18,4,18,320,322,22,
  328,441,378,23,327,325,378,441,378,378,325,23,327,334,473,
  1645,1788,33,23,334,7,1284,333,1298,22,33,23,333,22,1454,
  809,1697,1789,1645,824,1364,852,1645,1789,1286,1286,1460,1307,
  1655,472,1299,1677,33,7,334,23,1299,333,114,22,163,116,615,
  526,807,1365,1301,1791,1290,1366,1302,808,1319,1868,1319,1290,
  808,1366,1302,1674,2001,165,14,473,14,1673,470,1292,328,165,
  14,470,329,1697,1301,2001,2001,1531,1506,2001,1817,1871,1999,
  1871,1531,1820,1333,2002,471,34,23,1284,34,334,22,807,333,35,
  169,451,346,1334,1334,1685,1363,1504,1536,1859,1536,1557,1363,
  824,824,1536,1536,1859,164,14,1788,164,471,328,1301,468,246,
  164,743,742,1685,1685,1334,2001,1504,1907,2001,1907,1504,2001,
  1504,1504,1907,1907,2001,4,165,4,163,18,23,18,14,7,23,23,
  163,34,164,167,34,34,167,167,34,169,169,167,169,34,169,23,
  4,23,18,165,18,7,14,23,23,28,28,73,12,23,34,169,34,23,12,
  23,23,34,34,169,23,1645,470,332,322,163,116,615,525,1454,
  809,1698,1789,1286,1307,1655,1460,1286,1789,1645,1645,852,824,
  1364,163,18,23,18,6,6,20,20,34,163,164,169,34,167,169,34,
  34,169,169,169,34,169,169,322,1365,468,162,119,602,618,1334,
  1334,1685,1363,824,1471,1686,1471,824,1363,1557,1504,1471,1471,
  1686,322,2,22,22,328,322,339,339,410,327,23,378,441,378,23,
  327,325,325,378,378,441,470,116,163,525,615,1299,1299,1677,
  1302,808,1319,1868,1319,808,1302,1366,1366,1290,1290,1791,22,
  22,322,328,449,449,666,474,334,478,674,478,334,474,474,474,
  478,478,674,4,18,18,169,119,164,237,35,119,167,167,34,169,
  163,119,167,119,169,18,18,35,162,246,167,167,119,237,35,167,
  167,119,119,34,163,169,2,346,618,742,743,481,643,646,493,
  476,737,644,634,548,634,742,451,602,743,742,548,644,737,476,
  493,646,643,634,481,634,743,334,471,1686,1471,824,1363,1504,
  1471,1686,1471,1471,1557,824,1363,471,1859,1536,1504,1363,824,
  1536,1859,1536,1536,824,1557,1363,2001,1907,1504,2001,1504,
  1907,2001,1907,1907,1504,1504,2001,474,1907,1344,1907,167,737,
  169,474,1903,1903,1645,1344,1907,1345,476,169,34,334,1438,
  1438,1903,474,334,1438,1903,1438,1345,34,476,169,474,1903,
  1645,1903,1907,167,169,737,1438,1903,1438,1344,476,34,169,474,
  334,34,1345,1344,1907,474,169,1907,1907,1344,476,1344,1345,
  1907,1438,1438,1903,334,474,474,320,18,18,328,322,4,320,18,
  22,18,22,328,322,339,408,4,4,22,320,339,18,22,18,333,333,
  469,469,22,328,322,646,463,327,324,23,463,646,463,463,23,
  327,325,2,18,328,322,18,320,18,22,4,322,328,22,468,468,4,
  18,22,320,333,18,22,4,333,470,470,333,449,666,449,474,474,
  737,455,455,474,474,334,334,455,737,455,18,322,328,18,18,
  320,22,4,469,469,333,322,328,4,18,333,18,22,320,22,4,22,
  322,328,22,339,408,339,327,325,646,463,463,324,327,23,23,
  463,646,463,20,20,4,4,4,6,4,23,14,23,164,163,3,4,7,4,34,
  4,6,4,7,23,14,23,34,164,163,167,169,169,169,34,169,169,34,
  34,34,169,169,2,23,320,18,18,23,525,329,525,618,742,4,23,
  22,320,346,18,18,23,333,615,470,615,451,743,602,646,643,737,
  644,476,634,742,548,493,481,743,634,23,18,320,18,23,615,470,
  615,602,743,4,23,333,18,451,320,18,23,22,525,329,525,346,
  742,618,737,644,646,643,493,634,743,481,476,548,742,634,18,
  18,14,4,165,165,33,164,164,4,4,33,4,34,4,7,3,23,23,14,7,
  163,164,34,167,167,169,34,167,167,167,34,34,167,167,34,2,
  18,18,448,666,448,339,410,18,4,448,320,339,18,4,4,470,333,
  470,333,322,328,22,646,463,327,23,325,463,646,463,463,325,
  327,23,18,18,338,411,338,449,666,18,4,338,18,449,320,4,4,
  323,22,329,22,468,468,333,737,455,474,334,474,455,737,455,
  455,474,474,334,14,163,165,163,162,246,4,7,33,4,35,4,4,7,
  23,116,14,116,169,164,119,237,119,167,119,167,163,169,34,35,
  167,167,119,33,165,165,28,74,4,3,33,4,28,4,7,4,23,7,14,
  23,23,14,23,81,28,12,23,23,28,81,28,28,23,12,23,472,334,
  1645,1788,33,23,334,22,1284,333,116,7,1298,332,1292,114,1454,
  1697,809,1789,1645,1364,824,852,1645,1789,1286,1286,1460,1655,
  1307,472,1673,2001,165,14,473,329,1673,470,14,14,1685,1291,
  1334,1292,1697,2001,1301,1999,1871,2001,1506,1817,1531,2001,
  1531,1871,1820,2001,1333,1299,1677,33,7,334,22,1299,333,116,
  23,1298,114,1292,332,807,1301,1365,1868,1319,1302,1366,808,
  1290,1791,1290,1319,808,1302,1366,471,34,23,1284,333,334,22,
  119,34,809,1365,1301,809,1334,1685,1334,1363,1557,1686,1471,
  1471,1557,1363,824,824,1471,1686,1471,164,14,1788,468,471,328,
  164,163,1697,1301,2001,1697,1685,1993,1685,2001,1555,2001,1907,
  1907,1555,2001,1555,1555,1907,2001,1907,4,165,18,164,18,4,4,
  165,33,165,33,163,164,34,169,34,169,34,167,34,169,167,169,
  169,169,34,23,18,23,18,14,4,33,165,165,33,28,73,28,12,23,
  169,34,34,23,12,23,23,34,169,34,323,1645,470,23,23,1334,
  1298,1685,1298,1454,1697,809,1789,1286,1655,1307,1460,1286,
  1789,1645,1645,852,1364,824,468,2,18,18,338,338,411,338,449,
  666,449,474,334,674,478,478,334,474,474,474,478,674,478,322,
  169,164,1454,807,1697,1454,1334,1685,1334,1363,824,1859,1536,
  1536,824,1363,1557,1557,1536,1859,1536,18,18,448,448,668,448,
  339,410,339,327,23,441,378,378,23,327,325,324,378,441,378,
  14,33,163,165,163,35,246,162,167,119,169,163,34,119,169,167,
  167,35,248,119,33,33,165,165,34,164,163,169,34,169,167,34,
  34,169,169,169,34,169,169,334,473,334,1645,1788,1284,1655,
  1307,1789,1286,1645,824,1364,852,1460,1645,1789,1286,473,334,
  1299,1677,1299,1302,1366,1791,1290,1290,1366,1302,808,808,1319,
  1868,1319,472,1673,2001,1673,2001,1333,2001,1531,1531,1506,
  2002,1817,1820,1871,1999,1871,1284,1788,1645,1655,1307,1789,
  1645,1286,824,1364,852,1460,1286,1789,1645,471,334,1859,1536,
  1363,824,1504,1536,1859,1536,1536,1557,1363,824,471,2001,1907,
  2001,1504,1504,1907,2001,1907,1907,1504,2001,1504,1859,1536,
  1363,1504,824,1536,1859,1536,1536,824,1363,1557,474,1645,1903,
  1903,169,737,167,474,1907,2001,1907,1903,1438,1438,476,169,34,
  334,1345,1907,1345,474,474,1907,1344,1907,1903,169,737,169,
  334,1344,1907,1345,1438,34,169,476,1344,1907,1345,1438,476,
  169,34,474,334,34,1438,1903,1438,474,169,1903,1645,1903,476,
  1438,1903,1438,1344,1907,1344,474,334,474,18,2,666,448,18,
  320,4,448,18,18,320,18,408,339,4,18,4,320,339,4,448,18,
  333,470,333,470,22,328,322,463,646,327,325,23,646,463,463,
  463,23,327,325,18,165,164,4,4,4,33,4,14,23,23,20,20,3,4,
  7,4,6,4,33,4,7,23,23,14,6,20,20,23,23,23,23,7,23,23,7,
  7,7,23,23,411,338,18,18,4,338,320,18,18,320,408,339,4,18,
  4,18,339,4,338,320,22,323,22,329,22,322,328,463,646,325,
  327,23,646,463,463,463,23,325,327,471,165,328,14,473,470,
  165,329,470,1227,787,14,165,14,329,787,14,473,470,1291,1685,
  1291,1334,164,743,742,1421,1868,743,742,164,1867,1651,1651,
  1421,163,743,742,33,22,23,334,333,163,525,615,949,1130,7,33,
  116,22,770,23,334,333,114,1298,332,1292,115,571,608,1645,
  1340,525,615,116,1340,1645,1318,1318,35,452,347,18,4,165,18,
  14,23,23,73,28,4,4,7,4,28,3,33,4,23,23,7,14,14,23,23,
  34,169,23,23,12,169,34,34,34,12,23,23,18,322,2,22,328,322,
  337,337,18,4,22,320,337,4,22,18,470,333,333,470,18,320,18,
  495,495,320,18,18,495,495,495,495,18,320,18,23,18,6,20,20,
  28,73,4,3,6,4,28,4,7,4,23,7,23,14,14,23,23,169,34,23,
  23,12,34,169,34,34,12,23,23,470,163,525,615,975,768,23,33,
  116,22,768,7,334,333,332,1298,114,1292,170,451,346,1306,1461,
  451,346,167,1508,1369,1369,1306,167,451,346,22,322,328,337,
  337,18,4,22,18,337,4,333,320,323,22,22,328,18,18,320,387,
  387,18,320,18,387,387,387,387,18,18,320,18,18,81,53,7,4,4,
  4,28,7,33,4,116,23,116,14,13,25,25,115,167,23,23,14,167,
  115,34,34,8,25,25,2,340,408,23,4,18,320,340,23,22,18,615,
  333,615,470,25,330,326,644,576,327,324,25,507,646,507,576,
  25,327,324,340,408,23,4,18,18,340,23,333,320,526,22,526,
  329,25,326,330,646,507,324,327,25,576,644,576,507,25,324,
  327,333,28,20,28,339,333,6,949,339,768,1130,770,787,70,408,
  408,773,1127,438,438,91,1086,773,773,773,91,438,438,28,6,53,
  339,333,20,770,339,768,770,1130,787,70,408,408,1127,773,438,
  438,91,773,1086,773,773,91,438,438,4,14,18,73,4,23,18,165,
  33,33,165,14,23,23,34,34,23,23,12,34,34,169,169,12,23,23,
  4,18,20,4,165,18,33,165,33,165,6,20,20,7,23,23,23,7,23,
  7,23,23,7,23,23,18,81,14,23,18,163,33,163,165,13,25,25,
  115,34,25,25,8,34,115,167,167,14,23,23,408,18,323,2,338,
  338,338,411,22,328,322,463,463,327,325,23,463,463,646,646,
  23,327,325,20,1130,408,975,949,949,1227,70,408,408,773,773,
  438,438,91,773,773,1086,1127,91,438,438,23,18,33,33,165,165,
  6,20,20,23,7,20,20,6,7,23,23,23,6,20,20,470,1298,1334,
  1298,1685,115,571,608,1318,1340,525,615,116,1340,1318,1645,
  1645,35,452,347,448,448,448,668,22,322,328,463,463,325,327,
  23,463,463,646,646,23,325,327,334,334,471,170,346,451,1306,
  1306,346,451,167,1369,1369,1508,1461,167,346,451,334,473,115,
  608,571,1318,1645,347,452,35,1645,1318,1340,1340,116,615,525,
  471,115,608,571,1645,1318,615,525,116,1318,1645,1340,1340,35,
  347,452,165,742,743,1651,1651,742,743,164,1421,1421,1868,1867,
  164,742,743,18,18,167,167,22,22,14,167,167,167,167,14,22,
  22,2,646,646,329,323,23,646,646,646,646,23,329,323,646,646,
  323,329,23,646,646,646,646,23,323,329,334,646,646,182,114,
  496,114,334,182,646,646,646,646,182,496,114,114,334,182,646,
  646,2,18,646,646,646,646,4,320,18,18,646,646,646,646,4,18,
  320,182,182,182,182,4,4,4,334,334,114,182,646,646,334,114,
  182,646,646,496,182,646,646,182,646,646,18,18,2,320,468,468,
  320,18,18,333,4,328,322,22,328,322,4,320,22,18,22,18,333,
  4,22,328,322,22,339,408,339,325,327,646,463,463,327,325,23,
  23,463,646,463,411,338,320,18,4,338,18,320,18,18,666,449,4,
  320,4,18,449,4,338,18,22,329,22,323,333,468,468,455,737,
  474,474,334,737,455,455,455,334,474,474,471,468,328,14,472,
  165,470,329,165,2001,1673,14,470,14,329,1673,14,473,165,1292,
  1965,1291,1685,1301,2001,1697,1531,2001,2001,1817,1506,1999,
  1871,1871,1531,1333,2001,1820,333,22,23,334,33,615,525,163,
  1788,1645,7,333,116,22,1284,23,334,33,114,1292,464,1298,809,
  1697,1454,1645,1789,1364,852,824,1789,1645,1286,1286,1307,1655,
  1460,2,18,469,18,328,322,22,666,449,18,320,22,18,449,4,333,
  4,323,328,22,22,468,468,333,455,737,474,334,474,737,455,455,
  455,474,474,334,18,322,18,322,328,22,410,339,18,18,22,320,
  339,4,22,4,470,470,333,333,322,328,22,463,646,327,23,325,
  646,463,463,463,325,327,23,23,4,20,20,6,164,164,4,4,6,4,
  34,4,7,3,23,14,23,7,164,163,34,169,169,169,34,169,169,169,
  34,34,169,169,34,165,615,525,164,1677,1299,23,333,116,22,
  1299,7,334,33,464,1292,114,1298,1365,1301,807,1290,1791,1302,
  808,1366,1868,1319,1319,1290,1366,1302,808,23,23,14,74,28,4,
  4,7,4,28,3,33,4,23,14,7,23,23,14,23,28,81,12,23,23,81,
  28,28,28,23,12,23,2,18,743,602,23,320,18,18,451,23,333,4,
  526,329,526,22,618,742,346,634,743,646,493,643,737,644,476,
  481,634,742,548,18,742,618,23,18,18,320,346,23,22,4,615,
  470,615,333,602,743,451,634,742,737,476,644,646,643,493,548,
  634,743,481,246,162,7,4,4,4,35,7,33,4,116,14,116,23,119,
  164,169,163,169,167,167,119,237,119,35,34,119,169,167,471,
  164,328,164,468,471,14,1788,163,1697,2001,1301,1697,1685,1334,
  1685,1555,2001,2001,1907,1907,2001,1555,1555,1555,1907,2001,
  1907,34,22,119,333,334,23,1284,34,809,1301,1365,809,1334,
  1685,1334,1557,1363,1686,1471,1471,1363,1557,824,824,1471,1686,
  1471,18,14,18,164,4,23,4,165,165,33,33,164,164,34,34,167,
  167,34,169,169,34,167,169,167,169,34,18,2,322,18,470,18,
  448,668,448,448,339,410,339,23,327,646,463,463,327,23,325,
  325,463,646,463,18,169,14,23,4,163,165,163,33,162,246,35,
  119,167,237,35,119,169,119,167,167,163,169,34,468,18,323,18,
  338,411,338,338,449,666,449,334,474,737,455,455,474,334,474,
  474,455,737,455,23,1645,164,1454,1697,807,1454,1334,1685,1334,
  824,1363,1686,1471,1471,1363,824,1557,1557,1471,1686,1471,23,
  4,33,165,165,33,28,74,28,23,12,81,28,28,12,23,23,23,28,
  81,28,165,1298,1685,1298,1334,809,1697,1454,1286,1789,1364,
  852,824,1789,1286,1645,1645,1307,1655,1460,33,165,33,165,34,
  164,164,34,169,169,169,34,169,34,169,169,34,169,169,473,334,
  334,1645,1788,1284,1307,1655,1789,1286,1645,1364,824,852,1460,
  1645,1789,1286,473,473,1673,2001,1673,1333,2001,1999,1871,1871,
  2001,1506,1817,1820,1531,2001,1531,334,1299,1677,1299,1366,
  1302,1868,1319,1319,1302,1366,808,808,1290,1791,1290,1284,1788,
  1645,1307,1655,1789,1645,1286,1364,824,852,1460,1286,1789,1645,
  471,334,1471,1686,1363,824,1557,1686,1471,1471,1471,1557,1363,
  824,471,1907,2001,2001,1555,1555,2001,1907,1907,1907,1555,2001,
  1555,1471,1686,1363,1557,824,1686,1471,1471,1471,824,1363,1557,
  474,1907,1344,1344,169,476,34,334,1438,1903,1438,1344,1907,
  1907,737,169,167,474,1903,1645,1903,474,474,1645,1903,1903,
  1907,169,737,169,334,1903,1438,1438,1344,34,169,476,1903,1438,
  1438,1344,476,169,34,474,474,169,1907,1344,1907,334,34,1344,
  1907,1344,476,1344,1907,1344,1438,1903,1438,474,334,474,338,
  411,320,4,18,338,18,328,22,323,328,322,4,320,22,4,22,18,
  338,18,4,320,18,18,339,339,408,325,327,463,646,463,327,325,
  23,23,463,463,646,472,333,23,22,334,33,1292,464,1298,608,
  571,7,333,114,23,115,22,334,33,116,615,525,163,770,1130,949,
  525,615,1645,1340,1318,347,452,35,116,1318,1645,1340,470,14,
  328,473,165,1965,1291,1685,742,743,14,470,1291,14,164,328,
  472,165,14,470,329,165,787,785,1227,743,742,1421,1868,1421,
  742,743,164,163,1651,1651,1867,18,2,470,18,668,448,448,328,
  322,18,320,448,4,22,18,333,4,18,320,18,4,408,339,339,325,
  327,463,463,646,327,324,23,23,646,463,463,18,23,4,165,165,
  33,20,20,4,4,33,4,6,4,7,3,14,23,23,7,20,20,6,23,23,23,
  7,23,23,23,7,7,23,23,7,322,18,411,338,338,322,328,18,18,
  338,4,22,320,22,4,18,18,320,4,408,339,339,327,325,463,463,
  646,324,327,23,23,646,463,463,165,1685,1298,1334,608,571,23,
  333,1298,7,115,22,334,33,23,333,22,33,1130,770,949,452,347,
  1318,1340,1645,615,525,116,35,1645,1318,1340,165,33,165,20,
  20,4,4,33,3,6,4,33,4,4,4,4,4,20,6,20,20,20,7,23,23,20,
  20,6,6,23,7,23,473,473,743,742,165,329,473,14,165,470,1292,
  14,165,329,470,14,1227,787,787,742,743,1421,1421,1868,743,
  742,164,164,1867,1651,1651,334,571,608,33,22,334,23,115,333,
  114,7,163,526,615,116,949,1130,770,347,452,1645,1318,1340,
  525,615,116,35,1340,1646,1318,571,608,33,22,334,7,115,333,
  1298,23,33,22,333,23,949,770,1130,615,525,1318,1645,1340,452,
  347,35,116,1340,1318,1645,2,23,320,451,23,18,18,346,23,25,
  330,326,25,408,408,408,323,329,646,646,646,328,323,23,23,
  646,646,646,23,18,346,23,18,320,451,23,25,326,330,25,408,
  408,408,329,323,646,646,646,323,329,23,23,646,646,646,18,
  165,4,14,18,23,4,14,23,23,7,73,28,28,23,23,34,34,169,23,
  23,12,12,169,34,34,323,18,18,2,470,18,22,328,322,22,337,
  337,337,18,320,495,495,495,320,18,18,18,495,495,495,23,170,
  470,464,23,163,526,615,116,975,768,768,346,451,1306,1306,
  1461,451,346,167,167,1508,1369,1369,14,18,23,4,6,20,20,6,
  28,73,28,23,23,169,34,34,23,23,12,12,34,169,34,18,170,14,
  13,25,25,14,70,70,70,22,22,167,167,167,22,22,14,14,167,
  167,167,322,18,22,322,328,22,337,337,337,320,18,387,387,387,
  18,320,18,18,387,387,387,165,116,615,525,164,768,768,975,
  451,346,1369,1508,1369,346,451,167,167,1306,1306,1461,7,23,
  23,14,28,28,73,23,23,34,169,34,23,23,12,12,34,34,167,18,
  18,4,81,53,28,25,25,115,34,167,23,23,14,8,167,115,34,2,
  18,340,408,340,324,327,644,576,576,327,324,25,25,507,646,
  507,18,340,408,340,327,324,646,507,507,324,327,25,25,576,
  644,576,28,53,81,25,25,115,167,34,23,23,14,8,34,115,167,
  333,333,438,438,773,773,1127,438,438,91,91,1086,773,773,333,
  438,438,1127,773,773,438,438,91,91,773,1086,773,438,438,773,
  1127,773,438,438,91,91,773,773,1086,2,646,646,646,18,320,4,
  18,646,646,646,646,646,646,320,18,4,18,646,646,646,334,334,
  646,646,182,182,114,496,114,334,646,646,182,182,114,114,496,
  646,646,182,182,496,114,114,2,18,4,646,646,646,18,4,646,
  646,646,4,182,182,182,182,182,182,334,334,334,333,338,20,6,
  333,338,338,20,338,1227,950,6,338,6,20,950,6,333,338,52,
  409,52,409,769,1130,787,963,1275,1130,785,772,1271,990,990,
  963,772,1130,785,338,6,20,333,338,409,52,409,787,1130,6,338,
  52,6,769,20,333,338,6,338,20,338,950,950,1227,1130,785,963,
  1275,963,785,1130,772,772,990,990,1271,18,18,411,2,328,22,
  322,666,449,18,320,22,4,449,4,338,18,18,320,4,18,468,333,
  468,478,674,334,474,474,674,478,478,478,474,334,474,4,20,18,
  23,14,23,73,28,4,4,7,4,28,3,6,4,14,23,7,23,23,23,14,34,
  167,23,12,23,169,34,34,34,23,23,12,20,18,20,6,20,164,163,
  4,4,6,3,34,4,6,4,4,4,4,4,164,34,163,167,167,34,167,167,
  169,169,34,34,167,34,169,411,411,52,410,1227,950,20,338,52,
  6,950,6,333,338,20,338,6,338,1130,769,787,990,1271,772,785,
  1130,1275,963,963,990,1130,772,785,322,22,328,410,339,18,18,
  22,4,339,4,338,320,18,18,4,320,322,22,328,378,441,23,327,
  325,441,378,378,378,325,23,327,18,2,743,602,23,320,18,4,
  451,23,338,18,23,320,23,18,618,346,742,644,737,493,646,643,
  743,634,481,476,634,548,742,18,246,162,7,4,4,4,35,7,6,4,
  14,23,14,23,119,169,164,119,237,167,167,119,169,163,34,35,
  119,167,169,742,618,23,18,18,4,346,23,338,320,23,18,23,320,
  602,451,743,643,646,476,737,644,742,634,548,493,634,481,743,
  471,164,328,164,164,471,14,787,468,246,743,164,742,1685,1685,
  1993,1504,2001,1907,2001,1907,2001,1504,1504,1504,1907,1907,
  2001,34,22,119,34,334,23,769,333,35,451,169,346,1334,1334,
  1685,1504,1363,1536,1859,1536,1363,1557,824,824,1536,1536,1859,
  18,14,4,163,4,20,18,14,23,7,23,164,34,164,34,169,34,169,
  169,169,34,169,169,167,34,169,18,18,322,18,411,2,22,328,22,
  323,339,339,410,23,327,463,646,463,327,23,325,325,463,463,
  646,4,169,14,20,18,14,23,14,23,162,35,246,119,167,35,237,
  119,169,119,167,167,163,34,169,163,4,20,18,6,20,6,20,34,
  164,164,34,169,169,169,34,169,34,169,167,34,167,169,23,1130,
  468,162,602,119,618,1334,1334,1685,824,1363,1536,1859,1536,
  1363,824,1557,1504,1536,1536,1859,20,18,7,23,14,23,28,28,74,
  23,12,28,81,28,12,23,23,23,28,28,81,411,52,411,52,410,950,
  950,1227,772,785,963,1275,963,785,772,1130,1130,990,990,1271,
  22,323,22,329,449,449,666,334,474,455,737,455,474,334,474,
  474,455,455,737,18,4,18,169,119,164,35,237,119,169,167,169,
  34,163,119,167,119,169,18,2,346,618,742,481,743,634,742,548,
  737,476,644,634,493,643,646,18,35,162,246,167,167,163,169,
  34,167,167,119,119,35,119,237,451,602,743,548,742,634,743,
  481,646,493,643,634,476,644,737,334,471,1536,1859,824,1363,
  1557,1859,1536,1536,1536,1557,824,1363,471,1471,1686,1557,1363,
  824,1686,1471,1471,1471,824,1557,1363,1907,2001,1555,2001,1555,
  2001,1907,1907,1907,1555,1555,2001,474,1438,1903,1438,167,476,
  34,334,1345,1344,1907,1903,1645,1903,737,169,169,474,1907,
  1907,1344,474,334,1907,1345,1345,1438,34,476,169,474,2001,
  1907,1907,1903,169,169,737,1907,1344,1344,1438,476,34,169,474,
  474,169,1903,1903,1645,334,34,1438,1438,1903,476,1438,1438,
  1903,1345,1344,1907,334,474,474,334,18,18,320,334,632,323,
  632,728,742,4,334,22,18,457,18,320,334,22,632,323,632,457,
  742,728,646,736,646,736,493,676,742,563,493,563,742,676,322,
  22,472,448,1291,332,1298,1677,1299,22,333,114,23,1299,7,334,
  33,525,615,116,163,1301,1365,807,1319,1868,1366,808,1302,1791,
  1290,1290,1319,1302,1366,808,18,2,322,525,328,525,409,340,18,
  23,22,320,340,4,18,23,470,615,333,615,326,330,25,507,646,
  327,25,324,644,576,576,507,324,327,25,18,22,52,20,52,163,
  246,4,7,6,4,35,4,4,7,23,14,23,14,164,169,119,169,163,167,
  119,167,119,237,35,34,167,167,119,473,632,323,632,666,450,
  18,334,22,18,450,4,320,334,323,632,22,632,474,474,335,599,
  736,474,335,474,736,599,599,599,474,474,335,1298,464,1291,
  975,768,22,33,114,23,768,7,334,333,526,163,116,615,451,170,
  346,1027,1153,167,346,451,1093,947,947,1027,451,167,346,323,
  448,1848,1744,116,333,22,23,1312,116,334,33,1397,617,1397,
  164,1426,1905,1350,1505,1868,1645,1342,1430,1791,1347,1290,
  1319,1428,1905,1354,323,708,708,23,23,18,320,351,23,18,23,
  617,615,617,617,644,737,644,644,742,737,644,644,644,742,577,
  577,644,737,644,1696,1697,116,33,22,23,816,116,334,333,1397,
  163,1397,617,1325,1645,1789,1597,1634,1645,1789,1325,1707,1654,
  1314,1380,1325,1645,1789,713,163,608,164,618,713,14,728,1454,
  1697,2001,1426,1957,1685,2001,1957,1615,2001,2001,1955,1907,
  1934,1785,1785,1615,1897,2001,1960,35,115,122,346,335,25,457,
  809,816,1889,1905,931,1352,1934,1913,1830,1855,1999,1919,1773,
  1316,1953,812,848,1695,1992,1919,22,14,18,246,4,18,22,165,
  164,33,163,164,169,119,34,163,167,119,169,119,35,237,169,
  167,167,119,22,323,571,22,473,448,1298,1685,1298,1334,770,
  1130,949,116,615,1645,1340,1318,347,35,452,525,1318,1645,1340,
  18,237,14,18,22,163,164,163,164,163,248,122,115,163,236,122,
  119,119,122,236,167,163,167,115,742,18,2,323,338,410,338,
  409,451,743,602,493,643,737,644,476,634,548,742,646,481,743,
  634,25,742,1697,1696,1914,1350,1957,1352,1934,1913,848,1855,
  1999,1919,1773,1316,812,1953,1830,1695,1992,1919,18,22,33,164,
  165,163,28,76,53,23,14,80,53,28,8,25,25,23,28,80,53,473,
  448,667,448,666,457,742,728,493,736,646,736,493,676,563,742,
  646,563,742,676,1298,1334,1298,1685,1284,1645,1788,824,852,
  1645,1789,1286,1460,1307,1655,1364,1286,1645,1789,633,334,632,
  1645,1789,1325,1308,1647,1789,1325,1645,1581,1443,1853,1462,
  1645,1789,1325,632,666,1889,2001,1914,1531,2001,1999,1951,1871,
  1999,1871,1951,1828,1531,2001,1828,632,1312,1848,1744,1645,
  1430,1868,1505,1319,1428,1905,1354,1342,1290,1791,1347,1436,
  1999,1999,1843,1990,1999,1999,1436,1896,1843,1990,1896,1436,
  1999,1999,474,457,1584,1907,1364,1313,1557,1901,1664,1664,1584,
  1557,1364,1313,742,1907,2001,2001,859,1341,1999,1999,1999,1907,
  1529,2001,1734,1905,1995,1905,1993,1339,1993,1997,1997,1905,
  1339,1905,1993,632,1907,1901,1622,157,639,145,334,1622,1907,
  1901,2001,1995,1907,742,241,241,632,1907,2001,1995,742,474,
  1999,1999,1999,1907,167,737,247,457,1993,1997,1997,1901,35,
  247,359,1901,1666,1666,1622,476,167,35,460,460,157,1901,1999,
  1993,335,145,1661,1999,1997,639,1661,1999,1997,1622,1907,1901,
  474,457,742,22,322,473,448,1685,1298,1334,1788,1645,22,333,
  1298,7,1284,23,334,33,22,333,23,33,1697,809,1454,1645,1789,
  824,852,1364,1789,1645,1286,1286,1655,1307,1460,18,18,22,164,
  165,163,53,81,4,7,33,4,28,4,4,7,14,116,23,116,25,25,14,
  167,115,23,14,23,115,167,34,34,25,25,8,2,323,410,338,409,
  602,743,18,23,338,4,451,320,18,23,18,23,320,23,742,346,618,
  743,634,493,643,646,644,737,476,481,742,548,634,473,666,448,
  666,728,742,18,334,448,4,457,18,320,334,18,334,18,334,742,
  457,728,742,676,493,736,646,736,646,493,563,742,563,676,1334,
  1298,1685,949,1126,22,33,1298,7,770,23,334,333,22,33,23,333,
  571,115,608,1206,974,116,615,525,974,1206,1022,1022,452,35,
  347,632,666,1999,1999,164,615,632,14,1436,615,632,163,164,
  617,617,163,1957,931,1958,1999,1999,1455,1907,1907,1999,1999,
  1436,1436,1997,1984,1997,632,1744,1848,33,116,334,23,1312,333,
  22,116,163,1397,617,1397,1350,1905,1426,1791,1347,1645,1430,
  1342,1505,1868,1319,1290,1354,1905,1428,1914,2001,163,163,632,
  14,1889,615,633,615,164,164,617,617,1914,1889,2001,2001,1828,
  1531,2001,1828,1951,1999,1871,1531,1951,1871,1999,742,119,346,
  1325,119,457,25,335,807,122,1789,629,1350,1913,1913,1957,1905,
  1948,1905,1996,1905,1993,1905,1339,1339,1997,1997,1993,169,170,
  1789,169,474,330,474,1365,237,1645,674,1905,1934,1934,2001,
  1991,1734,1907,2001,1907,859,2001,1341,1529,1999,1999,1999,22,
  165,4,164,18,18,22,14,116,23,116,246,35,162,167,119,34,163,
  169,119,167,169,167,237,35,119,525,22,451,322,472,448,114,
  1292,332,1298,768,768,975,167,346,1369,1508,1369,346,167,451,
  451,1306,1306,1461,23,1645,470,323,526,163,1397,617,1397,1696,
  816,1697,1789,1325,1308,1647,1462,1325,1789,1645,1645,1853,
  1443,1581,164,18,18,22,6,52,20,52,35,246,162,167,119,169,
  163,34,119,167,167,167,35,237,119,326,474,1301,163,1325,629,
  1426,1352,1352,1685,1364,1313,1584,1907,1584,1313,1364,1557,
  1504,1664,1664,1901,2,322,22,525,329,525,340,340,408,327,25,
  388,441,388,25,327,324,324,395,395,436,473,22,632,323,632,
  450,450,666,474,335,498,674,498,335,474,474,474,656,656,672,
  114,1298,464,1292,1299,1299,1677,1366,808,1319,1868,1319,808,
  1366,1302,1302,1290,1290,1791,22,18,22,237,122,163,236,122,
  115,163,167,115,167,163,119,236,122,119,323,448,816,1697,
  1696,1645,1789,1581,1853,1443,1789,1645,1325,1325,1308,1647,
  1462,323,353,717,717,737,569,646,646,465,569,737,569,569,650,
  741,741,1312,1744,1848,1905,1354,1505,1868,1319,1342,1645,1430,
  1428,1290,1347,1791,335,713,1999,1919,848,1855,1905,1919,1992,
  1695,1773,1953,812,1316,713,1992,1919,1905,1855,848,1919,1999,
  1773,1695,812,1953,1316,2001,1960,1615,2001,1615,1955,2001,
  1907,1897,1785,1785,1934,742,1907,2001,1907,236,737,167,474,
  1999,1999,1999,1901,1995,1905,359,236,35,457,1997,1997,1993,
  632,334,1901,1907,1622,1622,145,641,157,632,1995,2001,1907,
  1907,242,242,742,1905,1907,1623,1623,641,145,157,742,457,35,
  1997,1997,1993,474,167,1999,1999,1999,476,1661,1666,1901,1666,
  1661,1901,335,460,460,320,328,320,469,469,333,408,339,320,18,
  333,18,339,4,22,4,328,323,22,22,328,322,22,463,646,324,23,
  327,646,463,463,463,327,325,23,328,320,411,338,338,468,468,
  320,18,338,4,333,18,22,4,320,18,18,4,666,449,449,474,474,
  455,455,737,474,474,334,334,737,455,455,668,1334,1292,1685,
  2001,1673,328,470,1292,14,1673,14,472,165,329,470,14,165,
  2001,1301,1697,1871,1999,1506,1817,2001,2001,1531,1531,1871,
  2001,1333,1820,470,333,470,410,339,320,18,333,4,339,4,448,
  18,320,18,4,18,328,22,322,378,441,23,325,327,441,378,378,
  378,327,23,325,472,473,2001,1697,470,328,473,14,1301,165,
  1292,14,470,329,165,14,2001,1673,1673,1820,2001,1531,1531,
  2001,2001,1817,1506,1333,1999,1871,1871,334,1697,1454,333,22,
  334,23,809,33,114,7,615,526,163,116,1788,1645,1284,1460,1655,
  1645,1286,1789,1364,852,824,1307,1789,1645,1286,1697,1454,333,
  22,334,7,809,33,1298,23,333,22,33,23,1788,1284,1645,852,
  1364,1286,1645,1789,1655,1460,1307,824,1789,1286,1645,471,468,
  328,1301,164,471,14,1788,164,742,743,164,246,1993,1685,1685,
  1504,2001,1907,1907,2001,2001,1504,1504,1504,2001,1907,1907,
  333,22,807,34,334,23,1284,34,346,451,169,35,1685,1334,1334,
  1557,1363,1536,1536,1859,1363,1504,824,824,1859,1536,1536,2,
  470,18,468,18,322,18,328,322,22,22,666,449,449,334,474,455,
  455,737,474,334,474,474,737,455,455,322,18,322,18,468,18,
  322,328,22,22,410,339,339,23,327,463,463,646,327,23,325,325,
  646,463,463,23,1365,165,332,23,615,526,164,116,1677,1299,
  1299,808,1302,1290,1290,1791,1302,808,1366,1366,1868,1319,1319,
  164,4,23,4,20,20,6,6,164,164,34,34,169,169,34,169,169,34,
  169,169,169,169,34,23,1645,164,618,602,119,163,1685,1334,
  1334,824,1363,1536,1536,1859,1363,824,1504,1557,1859,1536,1536,
  23,4,23,23,14,7,74,28,28,23,12,28,28,81,12,23,23,23,81,
  28,28,165,526,615,116,164,1697,809,1454,1286,1789,824,852,
  1364,1789,1286,1645,1645,1655,1307,1460,23,23,7,14,164,34,
  164,34,169,34,169,169,169,34,169,167,169,34,169,2,18,18,
  743,602,451,548,742,634,481,743,646,493,643,634,737,644,476,
  18,18,742,618,346,481,743,634,548,742,737,476,644,634,646,
  643,493,4,246,162,35,167,169,163,34,169,167,167,119,119,237,
  119,35,164,119,169,35,248,119,167,167,169,34,164,119,169,
  119,167,471,471,1907,2001,1555,1555,2001,2001,1907,1907,1907,
  2001,1555,1555,334,1471,1686,1557,824,1363,1686,1471,1471,1471,
  1363,1557,824,1536,1859,824,1557,1363,1859,1536,1536,1536,1363,
  824,1557,474,1438,1438,1903,169,476,34,334,1907,1345,1344,
  1903,1903,1645,737,169,169,474,2001,1907,1907,334,474,1907,
  1344,1344,1438,169,476,34,474,1907,1345,1345,1438,169,34,476,
  1344,1907,1907,1903,737,169,169,474,474,169,1645,1903,1903,
  334,34,1903,1438,1438,476,1903,1438,1438,1907,1345,1344,474,
  474,334,320,320,338,411,338,339,410,320,4,338,18,339,18,4,
  4,329,22,323,22,328,322,22,646,463,325,23,327,463,646,463,
  463,327,324,23,328,615,470,615,410,340,320,23,333,18,340,4,
  18,23,329,526,22,526,330,326,25,576,644,324,25,327,646,507,
  507,576,327,324,25,333,469,469,337,337,320,4,333,18,337,4,
  22,18,328,22,22,323,320,18,18,387,387,18,18,320,387,387,
  387,387,320,18,18,472,334,1130,949,333,23,334,22,770,33,116,
  7,1292,464,1298,114,608,571,115,1340,1646,525,116,615,1645,
  1340,1318,1318,347,452,35,472,787,1227,470,14,473,329,787,
  165,14,14,1965,1292,1685,1291,742,743,164,1867,1651,743,163,
  742,1421,1868,1421,1651,742,743,164,768,975,333,7,334,22,768,
  33,116,23,1292,114,1298,464,346,451,170,1508,1369,451,167,
  346,1306,1461,1306,1369,346,451,167,333,339,20,770,339,333,6,
  53,28,788,1130,770,768,408,408,71,773,1086,438,91,438,1127,
  773,773,773,438,438,91,339,6,949,339,333,20,28,28,788,770,
  1130,768,408,408,70,1086,773,438,91,438,773,1127,773,773,438,
  438,91,18,470,2,410,18,18,18,668,448,448,448,328,322,22,
  463,463,325,23,327,463,463,646,646,327,324,23,23,18,20,4,
  14,4,165,165,33,33,20,20,6,7,23,23,7,23,23,7,23,23,23,
  23,7,323,1130,165,23,23,1685,1298,1334,1298,608,571,115,1340,
  1318,452,35,347,1318,1340,1645,1645,615,525,116,410,18,18,18,
  411,338,338,338,322,328,22,463,463,327,23,325,463,463,646,
  646,325,327,23,20,81,73,1227,949,949,975,408,408,72,773,773,
  438,91,438,773,773,1127,1086,438,438,91,4,4,165,33,165,33,
  20,20,6,23,7,20,6,20,7,23,23,23,20,20,6,14,165,163,33,
  163,25,25,13,34,115,23,14,23,115,34,167,167,25,25,8,165,
  33,33,165,23,23,14,34,34,23,12,23,34,34,169,169,23,23,12,
  473,473,473,743,742,165,1651,1651,742,164,743,1421,1421,1868,
  1867,743,742,164,334,334,571,608,115,1318,1645,347,35,452,
  1645,1318,1340,1340,525,615,116,334,571,608,115,1645,1318,615,
  116,525,1318,1645,1340,1340,452,347,35,451,346,170,1306,1306,
  346,167,451,1369,1369,1508,1461,451,346,167,2,18,646,646,323,
  23,329,646,646,646,646,329,323,23,18,646,646,329,23,323,646,
  646,646,646,323,329,23,167,168,22,14,22,167,167,167,167,22,
  22,14,334,646,182,646,114,496,114,334,646,646,182,646,182,
  646,496,114,114,334,646,646,182,18,2,646,646,646,646,18,320,
  4,18,182,182,182,182,4,4,4,646,646,646,646,320,18,4,334,
  334,114,646,646,182,334,114,646,646,182,496,646,646,182,646,
  646,182,2,18,18,328,411,338,409,618,742,320,23,338,4,346,
  18,18,23,320,23,18,23,743,451,602,742,634,476,644,737,643,
  646,493,548,743,481,634,338,338,411,339,410,320,4,338,4,339,
  18,22,18,320,4,18,18,328,22,322,441,378,23,325,327,378,441,
  378,378,327,23,325,333,333,1130,787,338,20,333,6,769,338,52,
  6,338,20,338,6,1227,950,950,785,1130,963,963,1275,1130,785,
  772,772,1271,990,990,333,950,1227,338,6,333,20,950,338,6,6,
  409,52,409,52,785,1130,769,1271,990,1130,772,785,963,1275,
  963,990,785,1130,772,950,1227,338,6,333,6,950,338,52,20,338,
  6,338,20,787,769,1130,1275,963,772,1130,785,990,1271,990,963,
  785,772,1130,471,333,23,769,34,334,22,119,34,346,169,451,35,
  1685,1334,1334,1363,1557,1536,1536,1859,1504,1363,824,824,1859,
  1536,1536,468,14,787,164,471,328,164,163,742,164,743,246,
  1993,1685,1685,2001,1504,1907,1907,2001,1504,2001,1504,1504,
  2001,1907,1907,18,411,18,468,2,18,18,329,22,323,22,666,449,
  449,474,334,478,478,674,334,474,474,474,674,478,478,20,4,23,
  18,14,4,23,14,23,7,73,28,28,12,23,34,34,169,23,12,23,23,
  169,34,34,20,1130,411,20,20,411,52,410,52,1227,950,950,785,
  772,990,990,1271,772,785,1130,1130,1275,963,963,164,18,4,4,
  20,6,20,6,164,164,34,169,34,167,34,167,34,167,167,167,169,
  169,34,322,169,164,618,119,602,163,1685,1334,1334,1363,824,
  1471,1471,1686,824,1363,1504,1557,1686,1471,1471,18,18,323,22,
  329,22,410,339,339,327,23,378,378,441,23,327,325,325,441,
  378,378,14,23,14,23,14,246,35,162,167,119,34,163,169,119,
  169,167,167,248,35,119,23,7,23,14,164,34,164,169,34,34,169,
  169,34,169,169,169,169,34,169,18,2,18,743,602,451,742,548,
  644,476,737,493,646,643,634,743,634,481,18,4,246,162,35,169,
  167,119,35,236,167,167,119,119,169,163,34,18,742,618,346,
  743,481,643,493,646,476,737,644,634,742,634,548,164,119,169,
  248,35,119,167,167,34,169,164,119,167,119,167,471,471,2001,
  1907,1504,1504,2001,1907,2001,1907,1907,2001,1504,1504,334,
  1859,1536,1504,824,1363,1536,1859,1536,1536,1363,1557,824,1686,
  1471,824,1504,1363,1471,1686,1471,1471,1363,824,1557,474,1907,
  1907,2001,169,737,169,474,1599,1903,1903,1345,1344,1907,476,
  169,34,334,1903,1438,1438,334,474,1438,1903,1438,1344,169,476,
  34,474,1438,1903,1438,1345,169,34,476,1903,1645,1903,1907,737,
  169,169,474,334,34,1907,1345,1344,474,169,2001,1907,1907,476,
  1907,1344,1345,1903,1438,1438,474,474,334,1685,1292,1965,1227,
  787,328,165,1292,14,788,14,473,470,329,165,14,470,743,165,
  742,1226,1280,164,742,743,1282,1082,1082,1226,743,163,742,632,
  666,2001,1914,615,615,632,14,1889,163,632,163,617,617,163,
  164,2001,1889,1915,1951,1999,1531,1828,2001,2001,1828,1531,
  1871,1999,1871,1951,632,1697,1696,333,116,334,23,816,33,22,
  116,617,1397,164,1397,1789,1645,1325,1707,1654,1645,1325,1790,
  1597,1634,1380,1314,1790,1645,1325,1957,1957,615,164,633,14,
  931,163,633,615,617,164,163,617,1999,1436,1999,1990,1896,1436,
  1999,1999,1990,1896,1843,1843,1999,1436,1999,713,618,608,1426,
  162,713,14,728,1454,717,1848,163,1696,2001,1685,1957,1785,
  1932,1897,1960,2001,2001,1615,1615,1785,2001,1907,1955,346,115,
  1350,35,335,25,457,809,353,1312,237,816,1934,1352,1913,1952,
  1316,1695,1919,1992,1855,1905,848,812,1999,1773,1919,322,470,
  18,742,18,2,323,329,526,22,526,743,451,602,548,634,476,644,
  737,643,493,646,742,743,481,634,526,22,571,22,472,448,332,
  1292,114,1298,1130,770,949,35,347,1318,1340,1645,615,116,525,
  452,1645,1318,1340,23,1905,165,323,526,617,1397,164,1397,1848,
  1312,1744,1354,1428,1290,1347,1791,1430,1342,1645,1905,1868,
  1319,1505,246,4,18,22,20,52,6,52,169,164,119,35,119,169,
  119,167,163,34,169,237,167,167,119,25,742,1697,717,1744,122,
  1697,1934,1352,1913,812,1316,1695,1919,1992,1855,848,1905,1952,
  1999,1773,1919,18,22,23,116,14,116,76,28,53,25,8,28,53,80,
  14,23,23,25,80,28,53,473,323,632,22,633,742,457,728,563,
  676,493,736,646,736,493,646,742,742,563,676,464,1298,114,
  1292,1645,1284,1788,1307,1460,1286,1789,1645,852,824,1364,1655,
  1645,1286,1789,323,18,323,674,629,629,650,741,569,569,737,
  646,465,646,741,737,569,569,22,448,1905,1426,1350,1290,1791,
  1428,1354,1905,1868,1319,1505,1347,1645,1430,1342,22,237,163,
  122,247,119,163,115,167,163,167,115,122,247,119,122,1645,
  1325,1789,1314,1707,1325,1789,1645,1634,1380,1597,1654,1645,
  1325,1789,474,742,1999,1999,1341,859,2001,2001,1907,1907,1999,
  2001,1529,1734,457,1664,1901,1557,1313,1364,1907,1584,1584,
  1664,1364,1557,1313,1997,1993,1339,1993,1905,1995,1905,1905,
  1997,1905,1339,1993,460,1666,1997,1999,242,639,145,335,1999,
  1661,1997,1901,1993,1999,742,157,157,460,1999,1901,1993,457,
  474,1907,1622,1622,1666,167,476,35,742,1995,1901,1901,1997,
  247,35,359,2001,1907,1907,1999,737,167,247,632,632,242,2001,
  1907,1995,334,145,1907,1622,1901,639,1907,1622,1901,1999,1661,
  1997,474,742,457,334,473,1126,949,333,23,334,7,770,33,1298,
  22,333,23,33,22,608,115,571,974,1206,116,525,615,1206,974,
  1022,1022,347,35,452,472,768,975,333,7,334,23,768,33,114,22,
  615,116,163,525,346,170,451,1093,947,167,451,346,1027,1153,
  1027,947,346,167,451,787,1227,470,14,473,14,787,165,1292,328,
  470,14,165,329,742,164,743,1282,1082,163,743,742,1226,1280,
  1226,1082,742,164,743,333,339,20,770,28,333,6,949,339,340,
  73,28,340,408,71,408,757,919,77,414,414,919,757,757,757,414,
  77,414,339,6,949,28,333,20,770,339,340,28,73,340,408,71,
  408,919,757,77,414,414,757,919,757,757,414,77,414,18,470,18,
  410,18,323,2,328,22,22,322,328,22,322,378,378,23,325,327,
  378,378,441,441,327,23,325,23,4,20,4,165,18,23,14,7,23,20,
  6,20,6,20,7,23,23,20,6,20,20,23,7,23,23,1126,165,464,322,
  615,116,164,526,608,115,571,974,1022,35,452,347,1022,974,
  1206,1206,615,116,525,74,4,23,18,20,6,6,20,23,14,23,28,28,
  12,23,23,28,28,81,81,23,12,23,20,1126,410,410,53,53,408,
  408,72,408,757,757,77,414,414,757,757,919,919,414,77,414,23,
  18,23,7,14,23,20,6,20,20,6,6,20,20,6,20,20,20,20,6,20,
  470,526,163,116,615,571,115,608,1022,974,116,615,525,974,
  1022,1206,1206,452,35,347,322,22,22,328,322,22,328,378,378,
  23,327,325,378,378,441,441,325,23,327,18,18,2,330,25,326,
  395,395,25,324,327,388,388,441,436,327,25,324,4,18,25,13,
  25,28,80,8,25,25,80,28,53,53,23,14,23,18,25,13,25,80,28,
  14,23,23,28,80,53,53,25,8,25,326,25,330,395,395,25,327,
  324,388,388,441,436,324,25,327,18,2,441,441,23,323,329,441,
  441,441,441,329,23,323,18,80,80,14,22,22,80,80,80,80,22,
  14,22,441,441,23,329,323,441,441,441,441,323,23,329,333,99,
  441,441,27,344,27,333,441,99,441,99,441,441,344,27,27,333,
  441,99,441,18,18,99,99,99,99,4,4,4,2,441,441,441,441,18,
  4,320,441,441,441,441,320,4,18,333,333,27,441,99,441,333,
  27,441,99,441,344,441,99,441,441,99,441,18,2,18,320,742,
  728,334,18,320,18,457,334,22,4,632,323,633,22,728,742,457,
  676,742,646,493,736,646,736,493,563,676,742,563,742,728,334,
  18,320,4,457,334,448,18,334,18,334,18,728,457,742,736,646,
  493,646,736,742,676,563,493,676,563,742,742,1365,330,474,169,
  474,170,1789,169,1905,737,1645,248,2001,1934,1934,859,2001,
  1907,1907,2001,1991,1734,1529,1341,1999,1999,1999,807,25,335,
  119,457,346,1325,119,1350,644,1789,122,1957,1913,1913,1993,
  1905,1905,1905,1995,1905,1948,1339,1339,1993,1997,1997,322,473,
  22,1301,448,525,22,1292,332,1298,114,1677,1299,1299,808,1366,
  1319,1319,1868,1366,808,1302,1302,1791,1290,1290,2,18,326,323,
  470,18,526,329,525,22,409,340,340,25,327,507,507,646,327,25,
  324,324,644,576,576,18,474,473,323,18,632,323,632,22,666,
  450,450,335,474,599,599,736,474,335,474,474,736,599,599,164,
  22,23,4,52,20,52,6,163,246,35,119,167,169,34,163,167,119,
  169,167,119,237,35,451,1645,164,1426,644,1325,163,1685,1352,
  1352,1313,1364,1584,1584,1907,1364,1313,1504,1557,1901,1664,
  1664,526,22,1298,464,1292,114,975,768,768,346,167,1027,1027,
  1153,167,346,451,451,1093,947,947,165,1397,617,1397,164,1697,
  816,1696,1325,1789,1380,1634,1597,1789,1325,1645,1645,1654,
  1314,1707,116,23,116,14,163,35,246,119,167,34,169,163,167,
  119,169,167,119,35,237,323,448,22,1848,1744,1312,1354,1905,
  1505,1319,1868,1645,1342,1430,1428,1791,1347,1290,323,18,708,
  708,351,644,737,644,577,742,737,644,644,644,644,742,577,22,
  1696,1697,816,1789,1645,1597,1380,1634,1645,1789,1325,1325,
  1707,1654,1314,164,122,237,122,236,115,167,163,167,115,164,
  119,119,122,236,713,713,1960,2001,1615,1615,2001,2001,1955,
  1907,1897,1934,1785,1785,335,1919,1992,1830,848,1855,1999,1919,
  1773,1695,1316,1953,812,1919,1999,848,1830,1855,1992,1919,1695,
  1773,1316,812,1953,742,1901,1905,1995,236,359,35,457,1993,
  1997,1997,1907,1907,2001,737,236,167,474,1999,1999,1999,334,
  632,1907,1901,1622,1622,157,639,145,632,1907,1905,1623,1623,
  157,145,639,2001,1995,1907,1907,742,241,241,742,474,167,1999,
  1999,1999,457,35,1993,1997,1997,476,1901,1666,1661,1901,1661,
  1666,460,460,335,450,666,334,4,320,18,450,334,22,18,632,22,
  633,323,335,474,474,736,599,474,474,335,599,736,599,599,335,
  474,474,713,809,25,457,346,335,115,122,35,931,1905,1889,816,
  1913,1934,1352,1316,1953,1999,1773,1919,1830,1855,848,812,1919,
  1992,1695,1454,14,728,618,713,608,163,162,1957,1426,2001,1697,
  1957,2001,1685,1934,1785,2001,1907,1955,1615,2001,1615,1785,
  1960,2001,1898,22,473,323,1697,448,22,22,1685,1298,1334,1298,
  1788,1645,1284,1460,1307,1645,1286,1789,824,852,1364,1655,1789,
  1645,1286,18,18,25,22,14,4,164,165,163,33,53,81,28,8,25,
  167,34,115,23,14,23,25,115,167,34,2,742,473,18,18,667,448,
  666,448,728,742,457,676,563,742,563,676,493,736,646,742,736,
  646,493,742,323,18,18,410,338,409,338,602,743,451,634,548,
  743,481,634,493,643,646,742,644,737,476,571,237,246,1957,
  1350,1914,1696,1913,1934,1352,1316,812,1992,1695,1919,848,1855,
  1830,1953,1919,1999,1773,22,22,1334,1298,1685,1298,949,1126,
  770,347,35,1206,1022,974,116,615,525,452,974,1206,1022,14,
  164,164,164,163,122,248,163,119,122,167,163,115,115,163,167,
  236,122,236,119,164,33,163,165,119,169,164,119,35,167,167,
  119,34,163,169,237,119,167,169,632,666,632,1999,1999,1436,
  1997,1984,1999,1436,1999,1455,1907,1907,1997,1999,1999,1436,
  633,334,1744,1848,1312,1428,1905,1791,1290,1347,1645,1430,1342,
  1354,1505,1868,1319,633,1914,2001,1889,1999,1871,2001,1531,
  1828,1531,2001,1828,1951,1951,1999,1871,1325,1789,1645,1654,
  1314,1789,1645,1325,1380,1597,1634,1707,1325,1789,1645,742,457,
  1993,1997,1905,1339,1948,1905,1995,1905,1997,1993,1905,1339,
  474,1999,1999,1991,1529,1734,1907,2001,1907,1999,859,2001,1341,
  1901,1664,1364,1504,1313,1584,1907,1584,1664,1313,1364,1557,
  460,1999,1901,1993,157,742,157,460,1993,1999,1901,1999,1666,
  1997,639,242,145,335,1997,1999,1661,474,742,1907,2001,1907,
  1999,236,737,167,457,1622,1907,1623,1661,35,167,476,1901,1995,
  1905,1997,359,236,35,632,334,145,1901,1907,1622,632,242,1995,
  2001,1907,639,1905,1907,1623,1997,1999,1666,742,457,474,713,
  809,25,457,35,335,115,1350,346,816,248,1312,351,1913,1352,
  1934,1855,1905,1695,1992,1919,1952,1316,812,848,1919,1773,1999,
  1454,14,728,162,713,608,1426,618,1696,163,1848,708,1957,1685,
  2001,2001,1615,1897,2001,1960,1785,1932,1785,1615,1955,1907,
  2001,22,473,22,1697,448,526,322,1292,114,1298,332,1788,1284,
  1645,852,824,1286,1645,1789,1307,1460,1655,1364,1789,1286,1645,
  18,4,25,22,165,18,116,14,116,23,53,28,81,14,23,34,167,115,
  25,8,25,23,115,34,167,18,742,473,323,2,633,22,633,323,728,
  457,742,736,493,563,742,676,563,676,742,646,736,493,646,246,
  22,23,18,52,6,52,20,119,164,169,164,34,167,167,119,35,119,
  237,169,119,169,167,571,1905,742,1697,122,1744,708,1913,1352,
  1934,1855,848,1773,1999,1919,812,1316,1952,1905,1919,1695,1992,
  526,322,1298,114,1292,464,949,770,1126,615,116,1022,1206,974,
  35,347,452,525,974,1022,1206,470,1397,163,1397,617,1744,1312,
  1848,1430,1342,1319,1868,1505,1354,1428,1906,1645,1347,1290,
  1791,526,22,526,329,602,451,743,643,493,481,743,634,548,634,
  742,646,644,476,737,22,448,323,1789,1325,1645,1853,1443,1325,
  1645,1789,1308,1462,1647,1581,1789,1325,1645,22,18,122,163,
  237,163,167,119,236,122,236,119,122,115,115,163,167,323,1350,
  1426,1905,1868,1319,1430,1645,1342,1290,1791,1347,1505,1354,
  1428,1905,644,644,737,742,577,644,737,644,577,644,742,644,
  644,644,737,457,742,1995,1906,1339,1905,1948,1997,1993,1997,
  1906,1993,1339,1905,474,1907,1584,1504,1364,1313,1664,1901,
  1664,1584,1313,1557,1364,2001,1907,1529,1991,1734,1999,1999,
  1999,1907,859,1341,2001,632,1907,2001,1995,242,742,242,632,
  1995,1907,2001,1622,1907,1901,639,157,145,334,1901,1622,1907,
  474,457,1666,1901,1661,1623,35,476,167,742,1999,1999,1999,
  1907,236,167,737,1997,1993,1997,1905,359,35,236,460,335,145,
  1997,1661,1999,460,157,1993,1901,1999,639,1997,1666,1999,1905,
  1623,1907,457,742,474,334,18,457,334,320,18,457,334,335,474,
  474,335,666,666,666,473,473,737,737,737,473,473,334,334,737,
  737,737,322,1301,449,471,22,602,449,1673,1645,1284,1299,1685,
  1334,1334,824,1557,1536,1536,1859,1504,824,1363,1363,1859,1536,
  1536,326,322,2,18,742,322,571,743,451,571,408,408,408,23,
  329,646,646,646,329,23,323,323,646,646,646,451,474,165,644,
  451,1889,1645,1436,1312,1685,1352,1352,1313,1557,1664,1664,
  1902,1504,1313,1364,1364,1907,1584,1584,471,22,602,449,950,
  1130,769,950,1334,1685,1334,824,1557,1686,1471,1471,1557,824,
  1363,1363,1471,1686,1471,18,742,471,713,742,457,713,666,666,
  666,334,473,737,737,737,473,334,473,473,738,737,738,25,22,
  115,170,164,115,72,71,71,22,14,80,80,80,14,22,22,22,80,80,
  80,1697,1744,1999,1325,1914,1913,1913,1957,1339,1948,1905,1995,
  1905,1993,1339,1905,1905,1997,1997,1993,1299,1645,1284,1673,
  1334,1334,1685,824,1504,1536,1859,1536,1557,824,1363,1363,1536,
  1536,1859,742,457,450,1934,1913,1352,812,1953,1919,1773,1999,
  1905,848,1855,1316,1992,1919,1695,474,742,1934,2001,1934,1529,
  2001,1999,1999,1999,2001,1341,859,1734,1907,2001,1907,457,1352,
  1685,1352,1364,1557,1907,1584,1584,1557,1364,1313,1313,1664,
  1901,1664,1352,1913,1934,812,1962,1919,1999,1773,1767,848,1855,
  1316,1695,1919,1992,666,666,1732,2001,1732,1732,2001,2001,1732,
  1732,1732,2001,1732,1732,666,1732,2001,2001,1732,1732,2001,
  1732,1732,1732,1732,2001,1732,1732,2001,1732,2001,1732,2001,
  1732,1732,1732,1732,1732,2001,470,1903,1903,1903,165,448,33,
  333,1907,1907,1907,1997,1997,1997,668,165,165,470,2001,2001,
  2001,674,674,2001,1907,1907,1903,314,737,314,666,2001,1907,
  1907,1903,314,314,737,2001,1907,1907,1903,737,314,314,470,470,
  165,1997,1997,1997,333,33,1903,1903,1903,448,1903,1903,1903,
  1907,1907,1907,674,666,674,22,1697,449,471,322,451,449,1673,
  1284,1645,1299,1685,1334,1334,1557,824,1471,1471,1686,824,1504,
  1363,1363,1686,1471,1471,25,22,18,18,164,22,115,164,170,115,
  72,71,70,14,22,167,167,167,22,14,22,22,167,167,167,602,742,
  742,644,602,1914,1325,1999,1744,1957,1913,1913,1993,1339,1997,
  1997,1993,1339,1948,1905,1905,1995,1905,1905,471,322,451,449,
  950,769,1130,950,1334,1685,1334,1557,824,1859,1536,1536,824,
  1557,1363,1363,1536,1859,1536,2,474,471,713,457,742,713,666,
  666,666,473,334,674,674,674,334,473,473,473,674,674,674,326,
  322,571,451,743,571,408,408,408,329,23,441,441,441,23,329,
  323,323,441,441,441,1301,1312,1436,1645,1889,1352,1352,1685,
  1504,1313,1584,1907,1584,1313,1557,1364,1364,1664,1664,1901,
  1299,1284,1645,1673,1334,1334,1685,1504,824,1471,1686,1471,824,
  1557,1363,1363,1471,1471,1686,457,742,450,1934,1913,1352,1953,
  812,1919,1695,1992,848,1905,1855,1316,1999,1919,1773,474,457,
  1352,1685,1352,1557,1364,1901,1664,1664,1364,1557,1313,1313,
  1584,1907,1584,742,1934,2001,1934,2001,1529,2001,1907,1907,
  1341,2001,859,1734,1999,1999,1999,1352,1913,1934,1962,812,1919,
  1992,1695,848,1767,1855,1316,1773,1919,1999,666,666,2001,1732,
  1732,1732,2001,1732,2001,1732,1732,2001,1732,1732,666,2001,
  1732,2001,1732,1732,1732,2001,1732,1732,1732,2001,1732,2001,
  1732,1732,2001,1732,1732,2001,1732,1732,1732,1732,2001,470,
  2001,2001,2001,165,666,165,470,1997,1997,1997,1907,1907,1907,
  448,165,33,333,1903,1903,1903,674,674,1903,1997,1903,1907,314,
  737,314,666,1903,1997,1903,1907,314,314,737,1903,1997,1903,
  1907,737,314,314,470,333,33,1907,1907,1907,470,165,2001,2001,
  2001,448,1907,1907,1907,1903,1903,1903,674,666,674,328,320,
  328,320,328,320,470,470,333,333,411,339,339,23,325,463,463,
  646,325,23,327,327,646,463,463,329,2001,668,329,328,1334,
  1292,1685,1292,2001,1673,1673,1820,1333,1871,1871,1999,1506,
  1817,2001,2001,2001,1531,1531,666,320,320,320,411,338,338,338,
  468,468,333,455,455,474,334,474,455,455,737,737,474,474,334,
  328,743,666,2001,1788,1788,1677,1334,1685,1685,1504,1504,1907,
  1907,2001,1504,1504,2001,2001,2001,1907,1907,320,320,470,333,
  470,333,410,339,339,325,23,378,378,441,23,325,327,327,441,
  378,378,328,470,615,333,615,742,346,618,481,634,493,643,646,
  644,476,737,743,742,548,634,470,333,333,470,468,333,468,478,
  478,334,474,474,478,478,674,674,474,334,474,471,473,473,2001,
  1697,1301,1871,1871,1820,1333,2001,1531,1531,2001,1999,2001,
  1817,1506,334,334,1697,1454,809,1286,1645,1460,1307,1655,1645,
  1286,1789,1789,1364,852,824,334,1697,1454,809,1645,1286,852,
  824,1364,1286,1645,1789,1789,1655,1460,1307,1301,807,1365,1290,
  1290,808,1366,1302,1319,1319,1868,1791,1302,808,1366,471,471,
  1907,1907,1504,1504,2001,1907,1907,2001,2001,2001,1504,1504,
  334,1536,1536,1557,824,1363,1536,1536,1859,1859,1363,1504,824,
  1471,1471,824,1557,1363,1471,1471,1686,1686,1363,824,1504,334,
  1345,1344,1907,34,476,169,474,1903,1438,1438,1344,1345,1907,
  476,34,169,474,1903,1438,1438,334,474,1438,1438,1903,1907,169,
  476,34,474,1438,1438,1903,1907,169,34,476,1903,1903,1645,1344,
  737,169,169,334,474,169,1907,1344,1345,474,169,1907,1345,1344,
  737,1344,1907,1907,1645,1903,1903,474,474,334,320,330,329,329,
  320,615,470,615,333,410,340,340,25,324,576,576,644,324,25,
  327,327,646,507,507,328,320,328,320,338,411,338,338,339,410,
  339,23,325,646,463,463,325,23,327,327,463,646,463,320,743,
  328,608,742,346,608,408,408,408,23,323,646,646,646,323,23,
  329,329,646,646,646,328,320,333,470,470,333,337,337,337,18,
  18,387,387,387,18,18,320,320,387,387,387,668,1292,1334,1292,
  1685,787,787,1227,163,742,1421,1868,1421,742,164,743,743,1651,
  1651,1867,333,470,333,470,339,339,410,23,325,463,646,463,325,
  23,327,327,463,463,646,473,334,334,1130,949,770,35,452,1340,
  1318,1645,525,116,615,347,1645,1340,1318,473,473,787,1227,787,
  164,743,1867,1651,1651,743,163,742,742,1421,1868,1421,334,768,
  975,768,167,451,1508,1369,1369,451,167,346,346,1306,1461,1306,
  770,949,1130,35,452,1340,1645,1318,525,116,615,347,1318,1340,
  1645,333,333,91,438,773,773,1086,438,91,438,438,1127,773,773,
  333,91,438,1086,773,773,438,91,438,438,773,1127,773,91,438,
  773,1086,773,438,91,438,438,773,773,1127,18,182,182,182,4,4,
  4,18,182,182,182,646,646,646,320,4,18,2,646,646,646,334,
  334,646,182,646,646,114,496,114,334,646,182,646,646,114,114,
  496,646,182,646,646,496,114,114,18,2,18,646,646,646,18,4,
  182,182,182,320,646,646,646,646,646,646,334,334,334,743,329,
  320,320,411,338,409,338,618,742,346,634,481,742,548,634,476,
  644,737,743,643,646,493,743,737,743,2001,1789,1999,1848,2001,
  1934,1934,859,1341,1999,1999,1999,1529,1734,1991,2001,2001,
  1907,1907,329,328,1685,1292,1965,1292,1227,788,788,742,164,
  1226,1226,1280,164,742,743,743,1282,1082,1082,329,617,617,615,
  617,708,351,708,644,644,577,742,644,645,644,737,737,742,577,
  644,615,333,615,470,618,346,742,644,476,548,742,634,481,634,
  743,737,643,493,646,633,667,633,2001,1914,1889,1951,1871,1951,
  1871,1999,1531,1828,2001,1999,2001,1828,1531,632,334,1697,1696,
  816,1325,1645,1707,1314,1654,1645,1325,1789,1789,1597,1634,
  1380,633,1957,1958,931,1999,1436,1990,1843,1896,1436,1999,1999,
  1999,1990,1896,1843,1426,1350,1905,1347,1290,1354,1905,1428,
  1319,1505,1868,1791,1430,1342,1645,713,713,1955,1907,1785,1785,
  1932,1897,1960,2001,2001,2001,1615,1615,335,1919,1773,1952,812,
  1316,1695,1919,1992,1999,1855,1905,848,1919,1695,812,1952,1316,
  1773,1919,1999,1992,1855,848,1905,457,1997,1997,1993,35,359,
  236,742,1995,1901,1905,1661,1666,1901,476,35,167,474,1907,
  1622,1623,335,460,1666,1997,1999,1999,242,639,145,460,1661,
  1997,1999,1999,242,145,639,1901,1993,1999,1999,742,157,157,
  457,474,167,1907,1622,1623,742,236,1995,1901,1905,737,2001,
  1907,1907,2001,1907,1907,632,632,334,328,743,666,1227,787,787,
  1227,1685,1993,1685,1555,1555,2001,1907,1907,1555,1555,2001,
  2001,1907,2001,1907,320,320,338,338,411,338,339,410,339,325,
  23,441,378,378,23,325,327,327,378,441,378,329,338,411,338,
  409,346,742,618,476,644,646,643,493,634,481,743,737,548,742,
  634,338,338,338,411,333,468,468,455,455,474,474,334,455,455,
  737,737,334,474,474,333,333,333,1130,787,769,990,990,785,772,
  1130,963,963,1275,1271,1130,785,772,333,333,950,1227,950,772,
  1130,1271,990,990,1130,772,785,785,963,1275,963,333,950,1227,
  950,1130,772,1275,963,963,772,1130,785,785,990,1271,990,769,
  787,1130,990,990,785,1130,772,963,963,1275,1271,772,785,1130,
  471,334,1536,1536,1363,824,1557,1536,1536,1859,1859,1504,1363,
  824,471,1907,1907,2001,1504,1504,1907,1909,2001,2001,1504,2001,
  1504,1536,1536,1363,1557,824,1536,1536,1859,1859,824,1363,1504,
  334,1903,1438,1438,34,476,169,474,1345,1907,1345,1903,1438,
  1438,476,34,169,474,1344,1907,1344,474,474,1907,1907,2001,
  1645,169,737,169,334,1345,1344,1907,1903,34,169,476,1345,1344,
  1907,1903,476,169,34,334,474,169,1438,1903,1438,474,169,1438,
  1903,1438,737,1903,1645,1903,1907,1344,1907,474,334,474,330,
  328,608,346,742,608,408,408,408,323,23,441,441,441,23,323,
  329,329,441,441,441,2001,1848,1999,1789,2001,1934,1934,2001,
  1529,1734,1907,2001,1907,859,1341,2001,1991,1999,1999,1999,
  1677,1788,1788,2001,1685,1685,1993,1504,1504,1907,2001,1907,
  1504,1504,2001,2001,1907,1907,2001,728,728,666,2001,1957,1685,
  1785,1785,1955,1907,2001,1615,1615,2001,1934,2001,1960,1897,
  335,728,1913,1957,1913,1339,1905,1993,1997,1997,1905,1339,1993,
  1993,1905,1995,1905,728,1913,1957,1913,1905,1339,1995,1905,
  1905,1339,1905,1993,1993,1997,1993,1997,1685,1957,2001,1785,
  1785,1955,2001,1907,1615,1615,2001,1934,1897,1960,2001,666,666,
  1732,1732,1732,1732,2001,1732,1732,2001,2001,2001,1732,1732,
  666,1732,1732,2001,1732,1732,1732,1732,2001,2001,1732,2001,
  1732,1732,1732,1732,2001,1732,1732,1732,2001,2001,1732,1732,
  2001,333,1907,1907,1907,33,448,165,470,1903,1903,1903,1907,
  1907,1907,448,33,165,470,1903,1903,1903,674,674,1903,1903,
  1997,2001,314,737,314,666,1903,1903,1997,2001,314,314,737,
  1903,1903,1997,2001,737,314,314,333,470,165,1907,1907,1907,
  470,165,1907,1907,1907,668,2001,2001,2001,1997,1997,1997,674,
  666,674,328,333,615,470,615,340,340,408,324,25,388,441,388,
  25,324,327,327,395,395,436,333,333,469,469,339,339,408,325,
  23,378,441,378,23,325,327,327,378,378,441,334,473,334,1126,
  949,770,452,35,974,1022,1206,116,525,615,347,1206,974,1022,
  473,334,768,975,768,451,167,1093,947,947,167,451,346,346,
  1027,1153,1027,472,787,1227,787,743,164,1282,1082,1082,163,
  743,742,742,1226,1280,1226,770,949,1126,452,35,974,1206,1022,
  116,525,615,347,1022,974,1206,333,333,414,77,757,757,919,77,
  414,414,414,919,757,757,333,414,77,919,757,757,77,414,414,
  414,757,919,757,414,77,757,919,757,77,414,414,414,757,757,
  919,18,441,441,441,4,320,18,2,441,441,441,99,99,99,4,4,4,
  18,99,99,99,333,333,99,441,441,441,27,344,27,333,99,441,
  441,441,27,27,344,99,441,441,441,344,27,27,18,18,4,99,99,
  99,2,18,441,441,441,320,441,441,441,441,441,441,333,333,333,
  1292,1685,1292,1965,1673,1673,2003,1506,1817,1531,2001,1531,
  1820,1333,2001,2001,1871,1871,1999,632,334,633,1905,1350,1426,
  1290,1347,1342,1430,1645,1505,1319,1868,1791,1905,1354,1428,
  632,666,931,1957,1957,1436,1999,1896,1990,1843,1999,1436,1999,
  1999,1843,1990,1896,632,816,1696,1697,1645,1325,1634,1597,1380,
  1325,1645,1789,1789,1314,1707,1654,1889,1914,2001,1871,1951,
  1828,2001,1531,1828,1531,2001,1999,1871,1951,1999,335,713,1773,
  1919,848,1855,1767,1919,1695,1992,1999,1962,812,1316,713,1695,
  1919,1767,1855,848,1919,1773,1999,1992,812,1962,1316,1897,1960,
  1615,2001,1615,1955,1907,2001,2001,1785,1785,1934,457,1623,
  1907,1622,35,476,167,474,1661,1666,1901,1905,1943,1901,359,35,
  236,742,1997,1997,1993,632,334,1905,1623,1907,1907,145,639,
  157,632,1943,1907,2001,2001,242,242,742,1901,1622,1907,1907,
  639,145,157,457,742,236,1997,1997,1993,474,167,1666,1661,1901,
  737,1999,1999,1999,1999,1999,1999,335,460,460,334,334,473,
  1365,807,1301,1290,1290,808,1302,1366,1319,1319,1868,1791,1366,
  808,1302,334,473,809,1454,1698,1286,1645,1460,1655,1307,1645,
  1286,1789,1789,824,852,1364,472,809,1454,1697,1645,1286,852,
  1364,824,1286,1645,1789,1789,1307,1460,1655,1301,1697,2001,
  1871,1871,1820,2001,1333,1531,1531,2001,1999,1506,1817,2001,
  334,471,1471,1471,824,1363,1557,1471,1471,1686,1686,1504,824,
  1363,471,1536,1536,1557,1363,824,1536,1536,1859,1859,824,1504,
  1363,1907,1907,1504,2001,1504,1907,1907,2001,2001,1504,1504,
  2001,334,1344,1907,1345,34,476,169,474,1438,1438,1903,1345,
  1907,1344,476,34,169,474,1438,1438,1903,474,334,1438,1438,
  1903,1907,34,476,169,474,1903,1903,1599,2001,169,169,737,1438,
  1438,1903,1907,476,34,169,334,474,169,1344,1345,1907,474,169,
  1345,1344,1907,737,1907,1907,2001,1903,1903,1645,334,474,474,
  320,320,742,728,457,563,742,676,563,742,646,493,736,676,646,
  736,493,320,742,728,457,742,563,736,493,646,493,646,736,676,
  742,676,563,474,335,474,656,656,335,474,474,498,498,674,672,
  474,335,474,742,474,1999,1999,859,1341,2001,1907,1907,2001,
  1999,1991,1734,1529,457,1997,1997,1993,1339,1905,1905,1905,
  1995,1993,1905,1948,1339,1664,1664,1313,1557,1364,1584,1584,
  1907,1901,1364,1313,1504,335,1997,1661,1999,145,641,241,460,
  1999,1997,1666,1997,1666,1999,641,145,241,460,1999,1997,1661,
  457,742,1901,1905,1995,1993,236,359,35,474,1622,1623,1907,
  1901,167,35,476,1907,1907,2001,1999,737,236,167,334,632,157,
  1907,1901,1622,632,157,1907,1905,1623,742,2001,1995,1907,1999,
  1993,1901,742,474,457,320,450,666,450,474,474,736,599,599,
  474,474,335,335,599,736,599,457,728,742,563,742,676,742,563,
  646,493,736,676,493,736,646,713,335,1695,1992,1316,812,1953,
  1999,1773,1919,1919,1830,1855,848,713,1897,2001,1934,1785,1785,
  2001,1907,1955,1960,1615,2001,1615,1695,1992,1316,1953,812,
  1999,1773,1919,1919,848,1855,1830,474,1901,1661,1661,167,476,
  35,457,1622,1907,1622,1999,1999,1999,737,167,247,742,1907,
  2001,1907,460,460,1999,1901,1993,1993,157,742,157,335,1999,
  1666,1997,1997,145,242,639,1999,1666,1997,1997,639,242,145,
  474,742,247,1907,2001,1907,457,35,1622,1907,1622,359,1901,
  1995,1901,1901,1995,1901,632,334,632,457,728,742,742,563,736,
  646,493,493,646,736,676,563,676,742,713,335,1999,1773,1855,
  848,1905,1695,1992,1919,1919,1952,1316,812,713,2001,1907,2001,
  1615,1615,1898,2001,1961,1955,1785,1932,1785,1999,1773,1855,
  1905,848,1695,1992,1919,1919,812,1316,1952,474,2001,1907,1907,
  167,737,247,742,1999,1999,1999,1907,1622,1622,476,167,35,457,
  1661,1901,1661,632,632,1907,2001,1995,1995,242,742,242,334,
  1622,1907,1901,1901,145,157,639,1622,1907,1901,1901,639,157,
  145,474,457,35,1666,1901,1666,742,247,1999,1999,1999,359,1997,
  1993,1997,1997,1993,1997,460,335,460,457,474,1664,1664,1313,
  1364,1557,1584,1584,1907,1901,1504,1313,1364,742,1997,1997,
  1993,1905,1339,1905,1905,1995,1993,1339,1948,1905,1999,1999,
  859,2001,1341,1907,1907,2001,1999,1529,1734,1991,335,1997,1999,
  1666,145,639,241,460,1661,1997,1999,1997,1999,1661,639,145,
  241,460,1666,1997,1999,742,457,1905,1901,1943,1993,35,359,236,
  474,1907,1907,2001,1999,167,236,737,1623,1622,1907,1901,476,
  35,167,334,632,157,1623,1905,1907,632,157,1622,1901,1907,742,
  1907,1943,2001,1901,1993,1999,457,474,742,320,737,737,473,334,
  473,737,737,737,737,473,473,334,674,674,334,473,473,674,674,
  674,674,473,334,473,674,1907,1907,2001,314,737,314,666,1997,
  1903,1903,1907,1907,2001,737,314,314,674,1997,1903,1903,333,
  470,1903,1903,1903,1907,165,448,33,470,1903,1903,1903,1907,
  165,33,448,1997,1997,1997,2001,668,165,165,674,674,314,2001,
  1907,1907,666,314,2001,1907,1907,737,2001,1907,1907,1997,1903,
  1903,470,470,333,737,737,473,473,334,737,738,738,737,334,473,
  473,674,1997,1903,1903,314,737,314,666,1907,2001,1907,1997,
  1903,1903,737,314,314,674,1907,2001,1907,470,470,2001,2001,
  2001,1997,165,668,165,333,1907,1907,1907,1903,33,165,448,1907,
  1907,1907,1903,448,165,33,674,674,314,1903,1997,1903,666,314,
  1903,1997,1903,737,1903,1997,1903,1907,2001,1907,470,333,470,
  674,1907,2001,1907,314,737,314,666,1903,1903,1997,1907,2001,
  1907,737,314,314,674,1903,1903,1997,470,333,1903,1903,1903,
  1907,33,448,165,470,1997,1997,1997,2001,165,165,668,1903,1903,
  1903,1907,448,33,165,674,674,314,1907,1907,2001,666,314,1907,
  1907,2001,737,1907,1907,2001,1903,1903,1997,333,470,470,737,
  737,737,18,18,4,320,737,737,737,737,737,313,737,313,674,313,
  737,313,674,313,737,313,674,313,313,737,313,737,313,674,737,
  313,313,18,4,4,313,313,313,18,18,737,737,737,18,313,313,
  313,674,674,674,737,674,737,737,737,737,313,313,737,313,737,
  313,674,737,313,313,737,313,313,737,737,313,313,737,737,313,
  313,18,18,18,737,737,737,4,4,313,313,313,18,313,313,313,
  737,737,737,737,674,737,320,737,737,737,737,4,18,18,737,737,
  737,737,18,18,4,737,737,313,313,737,313,674,313,313,737,313,
  737,313,737,313,313,737,313,18,4,18,674,674,674,674,18,4,
  18,737,737,313,313,313,737,674,313,313,313,737,737,313,313,
  737,313,313,737,4,18,18,737,737,313,737,313,313,674,313,737,
  313,313,737,737,313,313,737,313,313,18,18,4,320,4,737,737,
  737,18,737,737,737,313,313,313,737,674,737,18,674,674,674,
  313,313,313,737,674,737,737,737,737,737,674,737,737,674,737,
  320 ];

growthsequences := growthset{growthpos};

return growthsequences;

#############################################################################
##
#E  growthsequences.g . . . . . . . . . . . . . . . . . . . . . . . ends here
